# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/distribution/v1beta1/distribution.proto, cosmos/distribution/v1beta1/genesis.proto, cosmos/distribution/v1beta1/query.proto, cosmos/distribution/v1beta1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...base import v1beta1 as __base_v1_beta1__
from ...base.query import v1beta1 as __base_query_v1_beta1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class MsgSetWithdrawAddress(betterproto.Message):
    """
    MsgSetWithdrawAddress sets the withdraw address for a delegator (or
    validator self-delegation).
    """

    delegator_address: str = betterproto.string_field(1)
    withdraw_address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgSetWithdrawAddressResponse(betterproto.Message):
    """
    MsgSetWithdrawAddressResponse defines the Msg/SetWithdrawAddress response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgWithdrawDelegatorReward(betterproto.Message):
    """
    MsgWithdrawDelegatorReward represents delegation withdrawal to a delegator
    from a single validator.
    """

    delegator_address: str = betterproto.string_field(1)
    validator_address: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgWithdrawDelegatorRewardResponse(betterproto.Message):
    """
    MsgWithdrawDelegatorRewardResponse defines the Msg/WithdrawDelegatorReward
    response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgWithdrawValidatorCommission(betterproto.Message):
    """
    MsgWithdrawValidatorCommission withdraws the full commission to the
    validator address.
    """

    validator_address: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class MsgWithdrawValidatorCommissionResponse(betterproto.Message):
    """
    MsgWithdrawValidatorCommissionResponse defines the
    Msg/WithdrawValidatorCommission response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgFundCommunityPool(betterproto.Message):
    """
    MsgFundCommunityPool allows an account to directly fund the community pool.
    """

    amount: List["__base_v1_beta1__.Coin"] = betterproto.message_field(1)
    depositor: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgFundCommunityPoolResponse(betterproto.Message):
    """
    MsgFundCommunityPoolResponse defines the Msg/FundCommunityPool response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the set of params for the distribution module."""

    community_tax: str = betterproto.string_field(1)
    base_proposer_reward: str = betterproto.string_field(2)
    bonus_proposer_reward: str = betterproto.string_field(3)
    withdraw_addr_enabled: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class ValidatorHistoricalRewards(betterproto.Message):
    """
    ValidatorHistoricalRewards represents historical rewards for a validator.
    Height is implicit within the store key. Cumulative reward ratio is the sum
    from the zeroeth period until this period of rewards / tokens, per the
    spec. The reference count indicates the number of objects which might need
    to reference this historical entry at any point. ReferenceCount =    number
    of outstanding delegations which ended the associated period (and    might
    need to read that record)  + number of slashes which ended the associated
    period (and might need to  read that record)  + one per validator for the
    zeroeth period, set on initialization
    """

    cumulative_reward_ratio: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)
    reference_count: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class ValidatorCurrentRewards(betterproto.Message):
    """
    ValidatorCurrentRewards represents current rewards and current period for a
    validator kept as a running counter and incremented each block as long as
    the validator's tokens remain constant.
    """

    rewards: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)
    period: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class ValidatorAccumulatedCommission(betterproto.Message):
    """
    ValidatorAccumulatedCommission represents accumulated commission for a
    validator kept as a running counter, can be withdrawn at any time.
    """

    commission: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ValidatorOutstandingRewards(betterproto.Message):
    """
    ValidatorOutstandingRewards represents outstanding (un-withdrawn) rewards
    for a validator inexpensive to track, allows simple sanity checks.
    """

    rewards: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ValidatorSlashEvent(betterproto.Message):
    """
    ValidatorSlashEvent represents a validator slash event. Height is implicit
    within the store key. This is needed to calculate appropriate amount of
    staking tokens for delegations which are withdrawn after a slash has
    occurred.
    """

    validator_period: int = betterproto.uint64_field(1)
    fraction: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ValidatorSlashEvents(betterproto.Message):
    """
    ValidatorSlashEvents is a collection of ValidatorSlashEvent messages.
    """

    validator_slash_events: List["ValidatorSlashEvent"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class FeePool(betterproto.Message):
    """FeePool is the global fee pool for distribution."""

    community_pool: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class CommunityPoolSpendProposal(betterproto.Message):
    """
    CommunityPoolSpendProposal details a proposal for use of community funds,
    together with how many coins are proposed to be spent, and to which
    recipient account.
    """

    title: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    recipient: str = betterproto.string_field(3)
    amount: List["__base_v1_beta1__.Coin"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class DelegatorStartingInfo(betterproto.Message):
    """
    DelegatorStartingInfo represents the starting info for a delegator reward
    period. It tracks the previous validator period, the delegation's amount of
    staking token, and the creation height (to check later on if any slashes
    have occurred). NOTE: Even though validators are slashed to whole staking
    tokens, the delegators within the validator may be left with less than a
    full token, thus sdk.Dec is used.
    """

    previous_period: int = betterproto.uint64_field(1)
    stake: str = betterproto.string_field(2)
    height: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class DelegationDelegatorReward(betterproto.Message):
    """
    DelegationDelegatorReward represents the properties of a delegator's
    delegation reward.
    """

    validator_address: str = betterproto.string_field(1)
    reward: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class CommunityPoolSpendProposalWithDeposit(betterproto.Message):
    """
    CommunityPoolSpendProposalWithDeposit defines a CommunityPoolSpendProposal
    with a deposit
    """

    title: str = betterproto.string_field(1)
    description: str = betterproto.string_field(2)
    recipient: str = betterproto.string_field(3)
    amount: str = betterproto.string_field(4)
    deposit: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """params defines the parameters of the module."""


@dataclass(eq=False, repr=False)
class QueryValidatorOutstandingRewardsRequest(betterproto.Message):
    """
    QueryValidatorOutstandingRewardsRequest is the request type for the
    Query/ValidatorOutstandingRewards RPC method.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryValidatorOutstandingRewardsResponse(betterproto.Message):
    """
    QueryValidatorOutstandingRewardsResponse is the response type for the
    Query/ValidatorOutstandingRewards RPC method.
    """

    rewards: "ValidatorOutstandingRewards" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class QueryValidatorCommissionRequest(betterproto.Message):
    """
    QueryValidatorCommissionRequest is the request type for the
    Query/ValidatorCommission RPC method
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryValidatorCommissionResponse(betterproto.Message):
    """
    QueryValidatorCommissionResponse is the response type for the
    Query/ValidatorCommission RPC method
    """

    commission: "ValidatorAccumulatedCommission" = betterproto.message_field(1)
    """commission defines the commision the validator received."""


@dataclass(eq=False, repr=False)
class QueryValidatorSlashesRequest(betterproto.Message):
    """
    QueryValidatorSlashesRequest is the request type for the
    Query/ValidatorSlashes RPC method
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address defines the validator address to query for."""

    starting_height: int = betterproto.uint64_field(2)
    """
    starting_height defines the optional starting height to query the slashes.
    """

    ending_height: int = betterproto.uint64_field(3)
    """
    starting_height defines the optional ending height to query the slashes.
    """

    pagination: "__base_query_v1_beta1__.PageRequest" = betterproto.message_field(4)
    """pagination defines an optional pagination for the request."""


@dataclass(eq=False, repr=False)
class QueryValidatorSlashesResponse(betterproto.Message):
    """
    QueryValidatorSlashesResponse is the response type for the
    Query/ValidatorSlashes RPC method.
    """

    slashes: List["ValidatorSlashEvent"] = betterproto.message_field(1)
    """slashes defines the slashes the validator received."""

    pagination: "__base_query_v1_beta1__.PageResponse" = betterproto.message_field(2)
    """pagination defines the pagination in the response."""


@dataclass(eq=False, repr=False)
class QueryDelegationRewardsRequest(betterproto.Message):
    """
    QueryDelegationRewardsRequest is the request type for the
    Query/DelegationRewards RPC method.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address defines the delegator address to query for."""

    validator_address: str = betterproto.string_field(2)
    """validator_address defines the validator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegationRewardsResponse(betterproto.Message):
    """
    QueryDelegationRewardsResponse is the response type for the
    Query/DelegationRewards RPC method.
    """

    rewards: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)
    """rewards defines the rewards accrued by a delegation."""


@dataclass(eq=False, repr=False)
class QueryDelegationTotalRewardsRequest(betterproto.Message):
    """
    QueryDelegationTotalRewardsRequest is the request type for the
    Query/DelegationTotalRewards RPC method.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address defines the delegator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegationTotalRewardsResponse(betterproto.Message):
    """
    QueryDelegationTotalRewardsResponse is the response type for the
    Query/DelegationTotalRewards RPC method.
    """

    rewards: List["DelegationDelegatorReward"] = betterproto.message_field(1)
    """rewards defines all the rewards accrued by a delegator."""

    total: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(2)
    """total defines the sum of all the rewards."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsRequest(betterproto.Message):
    """
    QueryDelegatorValidatorsRequest is the request type for the
    Query/DelegatorValidators RPC method.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address defines the delegator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegatorValidatorsResponse(betterproto.Message):
    """
    QueryDelegatorValidatorsResponse is the response type for the
    Query/DelegatorValidators RPC method.
    """

    validators: List[str] = betterproto.string_field(1)
    """validators defines the validators a delegator is delegating for."""


@dataclass(eq=False, repr=False)
class QueryDelegatorWithdrawAddressRequest(betterproto.Message):
    """
    QueryDelegatorWithdrawAddressRequest is the request type for the
    Query/DelegatorWithdrawAddress RPC method.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address defines the delegator address to query for."""


@dataclass(eq=False, repr=False)
class QueryDelegatorWithdrawAddressResponse(betterproto.Message):
    """
    QueryDelegatorWithdrawAddressResponse is the response type for the
    Query/DelegatorWithdrawAddress RPC method.
    """

    withdraw_address: str = betterproto.string_field(1)
    """withdraw_address defines the delegator address to query for."""


@dataclass(eq=False, repr=False)
class QueryCommunityPoolRequest(betterproto.Message):
    """
    QueryCommunityPoolRequest is the request type for the Query/CommunityPool
    RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryCommunityPoolResponse(betterproto.Message):
    """
    QueryCommunityPoolResponse is the response type for the Query/CommunityPool
    RPC method.
    """

    pool: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(1)
    """pool defines community pool's coins."""


@dataclass(eq=False, repr=False)
class DelegatorWithdrawInfo(betterproto.Message):
    """
    DelegatorWithdrawInfo is the address for where distributions rewards are
    withdrawn to by default this struct is only used at genesis to feed in
    default withdraw addresses.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address is the address of the delegator."""

    withdraw_address: str = betterproto.string_field(2)
    """
    withdraw_address is the address to withdraw the delegation rewards to.
    """


@dataclass(eq=False, repr=False)
class ValidatorOutstandingRewardsRecord(betterproto.Message):
    """
    ValidatorOutstandingRewardsRecord is used for import/export via genesis
    json.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address is the address of the validator."""

    outstanding_rewards: List["__base_v1_beta1__.DecCoin"] = betterproto.message_field(2)
    """
    outstanding_rewards represents the oustanding rewards of a validator.
    """


@dataclass(eq=False, repr=False)
class ValidatorAccumulatedCommissionRecord(betterproto.Message):
    """
    ValidatorAccumulatedCommissionRecord is used for import / export via
    genesis json.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address is the address of the validator."""

    accumulated: "ValidatorAccumulatedCommission" = betterproto.message_field(2)
    """accumulated is the accumulated commission of a validator."""


@dataclass(eq=False, repr=False)
class ValidatorHistoricalRewardsRecord(betterproto.Message):
    """
    ValidatorHistoricalRewardsRecord is used for import / export via genesis
    json.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address is the address of the validator."""

    period: int = betterproto.uint64_field(2)
    """period defines the period the historical rewards apply to."""

    rewards: "ValidatorHistoricalRewards" = betterproto.message_field(3)
    """rewards defines the historical rewards of a validator."""


@dataclass(eq=False, repr=False)
class ValidatorCurrentRewardsRecord(betterproto.Message):
    """
    ValidatorCurrentRewardsRecord is used for import / export via genesis json.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address is the address of the validator."""

    rewards: "ValidatorCurrentRewards" = betterproto.message_field(2)
    """rewards defines the current rewards of a validator."""


@dataclass(eq=False, repr=False)
class DelegatorStartingInfoRecord(betterproto.Message):
    """
    DelegatorStartingInfoRecord used for import / export via genesis json.
    """

    delegator_address: str = betterproto.string_field(1)
    """delegator_address is the address of the delegator."""

    validator_address: str = betterproto.string_field(2)
    """validator_address is the address of the validator."""

    starting_info: "DelegatorStartingInfo" = betterproto.message_field(3)
    """starting_info defines the starting info of a delegator."""


@dataclass(eq=False, repr=False)
class ValidatorSlashEventRecord(betterproto.Message):
    """
    ValidatorSlashEventRecord is used for import / export via genesis json.
    """

    validator_address: str = betterproto.string_field(1)
    """validator_address is the address of the validator."""

    height: int = betterproto.uint64_field(2)
    """height defines the block height at which the slash event occured."""

    period: int = betterproto.uint64_field(3)
    """period is the period of the slash event."""

    validator_slash_event: "ValidatorSlashEvent" = betterproto.message_field(4)
    """validator_slash_event describes the slash event."""


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the distribution module's genesis state."""

    params: "Params" = betterproto.message_field(1)
    """params defines all the paramaters of the module."""

    fee_pool: "FeePool" = betterproto.message_field(2)
    """fee_pool defines the fee pool at genesis."""

    delegator_withdraw_infos: List["DelegatorWithdrawInfo"] = betterproto.message_field(3)
    """fee_pool defines the delegator withdraw infos at genesis."""

    previous_proposer: str = betterproto.string_field(4)
    """fee_pool defines the previous proposer at genesis."""

    outstanding_rewards: List["ValidatorOutstandingRewardsRecord"] = betterproto.message_field(5)
    """
    fee_pool defines the outstanding rewards of all validators at genesis.
    """

    validator_accumulated_commissions: List["ValidatorAccumulatedCommissionRecord"] = betterproto.message_field(6)
    """
    fee_pool defines the accumulated commisions of all validators at genesis.
    """

    validator_historical_rewards: List["ValidatorHistoricalRewardsRecord"] = betterproto.message_field(7)
    """
    fee_pool defines the historical rewards of all validators at genesis.
    """

    validator_current_rewards: List["ValidatorCurrentRewardsRecord"] = betterproto.message_field(8)
    """fee_pool defines the current rewards of all validators at genesis."""

    delegator_starting_infos: List["DelegatorStartingInfoRecord"] = betterproto.message_field(9)
    """fee_pool defines the delegator starting infos at genesis."""

    validator_slash_events: List["ValidatorSlashEventRecord"] = betterproto.message_field(10)
    """fee_pool defines the validator slash events at genesis."""


class MsgStub(betterproto.ServiceStub):
    async def set_withdraw_address(
        self,
        msg_set_withdraw_address: "MsgSetWithdrawAddress",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgSetWithdrawAddressResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Msg/SetWithdrawAddress",
            msg_set_withdraw_address,
            MsgSetWithdrawAddressResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def withdraw_delegator_reward(
        self,
        msg_withdraw_delegator_reward: "MsgWithdrawDelegatorReward",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgWithdrawDelegatorRewardResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Msg/WithdrawDelegatorReward",
            msg_withdraw_delegator_reward,
            MsgWithdrawDelegatorRewardResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def withdraw_validator_commission(
        self,
        msg_withdraw_validator_commission: "MsgWithdrawValidatorCommission",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgWithdrawValidatorCommissionResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Msg/WithdrawValidatorCommission",
            msg_withdraw_validator_commission,
            MsgWithdrawValidatorCommissionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def fund_community_pool(
        self,
        msg_fund_community_pool: "MsgFundCommunityPool",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgFundCommunityPoolResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Msg/FundCommunityPool",
            msg_fund_community_pool,
            MsgFundCommunityPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_outstanding_rewards(
        self,
        query_validator_outstanding_rewards_request: "QueryValidatorOutstandingRewardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorOutstandingRewardsResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/ValidatorOutstandingRewards",
            query_validator_outstanding_rewards_request,
            QueryValidatorOutstandingRewardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_commission(
        self,
        query_validator_commission_request: "QueryValidatorCommissionRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorCommissionResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/ValidatorCommission",
            query_validator_commission_request,
            QueryValidatorCommissionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def validator_slashes(
        self,
        query_validator_slashes_request: "QueryValidatorSlashesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryValidatorSlashesResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/ValidatorSlashes",
            query_validator_slashes_request,
            QueryValidatorSlashesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegation_rewards(
        self,
        query_delegation_rewards_request: "QueryDelegationRewardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegationRewardsResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/DelegationRewards",
            query_delegation_rewards_request,
            QueryDelegationRewardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegation_total_rewards(
        self,
        query_delegation_total_rewards_request: "QueryDelegationTotalRewardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegationTotalRewardsResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/DelegationTotalRewards",
            query_delegation_total_rewards_request,
            QueryDelegationTotalRewardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_validators(
        self,
        query_delegator_validators_request: "QueryDelegatorValidatorsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorValidatorsResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/DelegatorValidators",
            query_delegator_validators_request,
            QueryDelegatorValidatorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delegator_withdraw_address(
        self,
        query_delegator_withdraw_address_request: "QueryDelegatorWithdrawAddressRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryDelegatorWithdrawAddressResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/DelegatorWithdrawAddress",
            query_delegator_withdraw_address_request,
            QueryDelegatorWithdrawAddressResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def community_pool(
        self,
        query_community_pool_request: "QueryCommunityPoolRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryCommunityPoolResponse":
        return await self._unary_unary(
            "/cosmos.distribution.v1beta1.Query/CommunityPool",
            query_community_pool_request,
            QueryCommunityPoolResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):
    async def set_withdraw_address(
        self, msg_set_withdraw_address: "MsgSetWithdrawAddress"
    ) -> "MsgSetWithdrawAddressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def withdraw_delegator_reward(
        self, msg_withdraw_delegator_reward: "MsgWithdrawDelegatorReward"
    ) -> "MsgWithdrawDelegatorRewardResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def withdraw_validator_commission(
        self, msg_withdraw_validator_commission: "MsgWithdrawValidatorCommission"
    ) -> "MsgWithdrawValidatorCommissionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def fund_community_pool(
        self, msg_fund_community_pool: "MsgFundCommunityPool"
    ) -> "MsgFundCommunityPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_set_withdraw_address(
        self,
        stream: "grpclib.server.Stream[MsgSetWithdrawAddress, MsgSetWithdrawAddressResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_withdraw_address(request)
        await stream.send_message(response)

    async def __rpc_withdraw_delegator_reward(
        self,
        stream: "grpclib.server.Stream[MsgWithdrawDelegatorReward, MsgWithdrawDelegatorRewardResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.withdraw_delegator_reward(request)
        await stream.send_message(response)

    async def __rpc_withdraw_validator_commission(
        self,
        stream: "grpclib.server.Stream[MsgWithdrawValidatorCommission, MsgWithdrawValidatorCommissionResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.withdraw_validator_commission(request)
        await stream.send_message(response)

    async def __rpc_fund_community_pool(
        self,
        stream: "grpclib.server.Stream[MsgFundCommunityPool, MsgFundCommunityPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.fund_community_pool(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.distribution.v1beta1.Msg/SetWithdrawAddress": grpclib.const.Handler(
                self.__rpc_set_withdraw_address,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgSetWithdrawAddress,
                MsgSetWithdrawAddressResponse,
            ),
            "/cosmos.distribution.v1beta1.Msg/WithdrawDelegatorReward": grpclib.const.Handler(
                self.__rpc_withdraw_delegator_reward,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgWithdrawDelegatorReward,
                MsgWithdrawDelegatorRewardResponse,
            ),
            "/cosmos.distribution.v1beta1.Msg/WithdrawValidatorCommission": grpclib.const.Handler(
                self.__rpc_withdraw_validator_commission,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgWithdrawValidatorCommission,
                MsgWithdrawValidatorCommissionResponse,
            ),
            "/cosmos.distribution.v1beta1.Msg/FundCommunityPool": grpclib.const.Handler(
                self.__rpc_fund_community_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgFundCommunityPool,
                MsgFundCommunityPoolResponse,
            ),
        }


class QueryBase(ServiceBase):
    async def params(self, query_params_request: "QueryParamsRequest") -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_outstanding_rewards(
        self,
        query_validator_outstanding_rewards_request: "QueryValidatorOutstandingRewardsRequest",
    ) -> "QueryValidatorOutstandingRewardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_commission(
        self, query_validator_commission_request: "QueryValidatorCommissionRequest"
    ) -> "QueryValidatorCommissionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def validator_slashes(
        self, query_validator_slashes_request: "QueryValidatorSlashesRequest"
    ) -> "QueryValidatorSlashesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegation_rewards(
        self, query_delegation_rewards_request: "QueryDelegationRewardsRequest"
    ) -> "QueryDelegationRewardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegation_total_rewards(
        self,
        query_delegation_total_rewards_request: "QueryDelegationTotalRewardsRequest",
    ) -> "QueryDelegationTotalRewardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_validators(
        self, query_delegator_validators_request: "QueryDelegatorValidatorsRequest"
    ) -> "QueryDelegatorValidatorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delegator_withdraw_address(
        self,
        query_delegator_withdraw_address_request: "QueryDelegatorWithdrawAddressRequest",
    ) -> "QueryDelegatorWithdrawAddressResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def community_pool(
        self, query_community_pool_request: "QueryCommunityPoolRequest"
    ) -> "QueryCommunityPoolResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]") -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    async def __rpc_validator_outstanding_rewards(
        self,
        stream: "grpclib.server.Stream[QueryValidatorOutstandingRewardsRequest, QueryValidatorOutstandingRewardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_outstanding_rewards(request)
        await stream.send_message(response)

    async def __rpc_validator_commission(
        self,
        stream: "grpclib.server.Stream[QueryValidatorCommissionRequest, QueryValidatorCommissionResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_commission(request)
        await stream.send_message(response)

    async def __rpc_validator_slashes(
        self,
        stream: "grpclib.server.Stream[QueryValidatorSlashesRequest, QueryValidatorSlashesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.validator_slashes(request)
        await stream.send_message(response)

    async def __rpc_delegation_rewards(
        self,
        stream: "grpclib.server.Stream[QueryDelegationRewardsRequest, QueryDelegationRewardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegation_rewards(request)
        await stream.send_message(response)

    async def __rpc_delegation_total_rewards(
        self,
        stream: "grpclib.server.Stream[QueryDelegationTotalRewardsRequest, QueryDelegationTotalRewardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegation_total_rewards(request)
        await stream.send_message(response)

    async def __rpc_delegator_validators(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorValidatorsRequest, QueryDelegatorValidatorsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_validators(request)
        await stream.send_message(response)

    async def __rpc_delegator_withdraw_address(
        self,
        stream: "grpclib.server.Stream[QueryDelegatorWithdrawAddressRequest, QueryDelegatorWithdrawAddressResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.delegator_withdraw_address(request)
        await stream.send_message(response)

    async def __rpc_community_pool(
        self,
        stream: "grpclib.server.Stream[QueryCommunityPoolRequest, QueryCommunityPoolResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.community_pool(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.distribution.v1beta1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/ValidatorOutstandingRewards": grpclib.const.Handler(
                self.__rpc_validator_outstanding_rewards,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorOutstandingRewardsRequest,
                QueryValidatorOutstandingRewardsResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/ValidatorCommission": grpclib.const.Handler(
                self.__rpc_validator_commission,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorCommissionRequest,
                QueryValidatorCommissionResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/ValidatorSlashes": grpclib.const.Handler(
                self.__rpc_validator_slashes,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryValidatorSlashesRequest,
                QueryValidatorSlashesResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/DelegationRewards": grpclib.const.Handler(
                self.__rpc_delegation_rewards,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegationRewardsRequest,
                QueryDelegationRewardsResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/DelegationTotalRewards": grpclib.const.Handler(
                self.__rpc_delegation_total_rewards,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegationTotalRewardsRequest,
                QueryDelegationTotalRewardsResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/DelegatorValidators": grpclib.const.Handler(
                self.__rpc_delegator_validators,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorValidatorsRequest,
                QueryDelegatorValidatorsResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/DelegatorWithdrawAddress": grpclib.const.Handler(
                self.__rpc_delegator_withdraw_address,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryDelegatorWithdrawAddressRequest,
                QueryDelegatorWithdrawAddressResponse,
            ),
            "/cosmos.distribution.v1beta1.Query/CommunityPool": grpclib.const.Handler(
                self.__rpc_community_pool,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryCommunityPoolRequest,
                QueryCommunityPoolResponse,
            ),
        }
