"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityConfiguration = exports.JobBookmarksEncryptionMode = exports.CloudWatchEncryptionMode = exports.S3EncryptionMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const glue_generated_1 = require("./glue.generated");
/**
 * (experimental) Encryption mode for S3.
 *
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_S3Encryption.html#Glue-Type-S3Encryption-S3EncryptionMode
 * @experimental
 */
var S3EncryptionMode;
(function (S3EncryptionMode) {
    S3EncryptionMode["S3_MANAGED"] = "SSE-S3";
    S3EncryptionMode["KMS"] = "SSE-KMS";
})(S3EncryptionMode = exports.S3EncryptionMode || (exports.S3EncryptionMode = {}));
/**
 * Encryption mode for CloudWatch Logs.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_CloudWatchEncryption.html#Glue-Type-CloudWatchEncryption-CloudWatchEncryptionMode
 */
var CloudWatchEncryptionMode;
(function (CloudWatchEncryptionMode) {
    CloudWatchEncryptionMode["KMS"] = "SSE-KMS";
})(CloudWatchEncryptionMode = exports.CloudWatchEncryptionMode || (exports.CloudWatchEncryptionMode = {}));
/**
 * Encryption mode for Job Bookmarks.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode
 */
var JobBookmarksEncryptionMode;
(function (JobBookmarksEncryptionMode) {
    JobBookmarksEncryptionMode["CLIENT_SIDE_KMS"] = "CSE-KMS";
})(JobBookmarksEncryptionMode = exports.JobBookmarksEncryptionMode || (exports.JobBookmarksEncryptionMode = {}));
/**
 * (experimental) A security configuration is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 *
 * The following scenarios show some of the ways that you can use a security configuration.
 * - Attach a security configuration to an AWS Glue crawler to write encrypted Amazon CloudWatch Logs.
 * - Attach a security configuration to an extract, transform, and load (ETL) job to write encrypted Amazon Simple Storage Service (Amazon S3) targets and encrypted CloudWatch Logs.
 * - Attach a security configuration to an ETL job to write its jobs bookmarks as encrypted Amazon S3 data.
 * - Attach a security configuration to a development endpoint to write encrypted Amazon S3 targets.
 *
 * @experimental
 */
class SecurityConfiguration extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id, {
            physicalName: props.securityConfigurationName,
        });
        if (!props.s3Encryption && !props.cloudWatchEncryption && !props.jobBookmarksEncryption) {
            throw new Error('One of cloudWatchEncryption, jobBookmarksEncryption or s3Encryption must be defined');
        }
        const kmsKeyCreationRequired = (props.s3Encryption && props.s3Encryption.mode === S3EncryptionMode.KMS && !props.s3Encryption.kmsKey) ||
            (props.cloudWatchEncryption && !props.cloudWatchEncryption.kmsKey) ||
            (props.jobBookmarksEncryption && !props.jobBookmarksEncryption.kmsKey);
        const autoCreatedKmsKey = kmsKeyCreationRequired ? new kms.Key(this, 'Key') : undefined;
        let cloudWatchEncryption;
        if (props.cloudWatchEncryption) {
            this.cloudWatchEncryptionKey = props.cloudWatchEncryption.kmsKey || autoCreatedKmsKey;
            cloudWatchEncryption = {
                cloudWatchEncryptionMode: props.cloudWatchEncryption.mode,
                kmsKeyArn: (_b = this.cloudWatchEncryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
            };
        }
        let jobBookmarksEncryption;
        if (props.jobBookmarksEncryption) {
            this.jobBookmarksEncryptionKey = props.jobBookmarksEncryption.kmsKey || autoCreatedKmsKey;
            jobBookmarksEncryption = {
                jobBookmarksEncryptionMode: props.jobBookmarksEncryption.mode,
                kmsKeyArn: (_c = this.jobBookmarksEncryptionKey) === null || _c === void 0 ? void 0 : _c.keyArn,
            };
        }
        let s3Encryptions;
        if (props.s3Encryption) {
            if (props.s3Encryption.mode === S3EncryptionMode.KMS) {
                this.s3EncryptionKey = props.s3Encryption.kmsKey || autoCreatedKmsKey;
            }
            // NOTE: CloudFormations errors out if array is of length > 1. That's why the props don't expose an array
            s3Encryptions = [{
                    s3EncryptionMode: props.s3Encryption.mode,
                    kmsKeyArn: (_d = this.s3EncryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
                }];
        }
        const resource = new glue_generated_1.CfnSecurityConfiguration(this, 'Resource', {
            name: props.securityConfigurationName,
            encryptionConfiguration: {
                cloudWatchEncryption,
                jobBookmarksEncryption,
                s3Encryptions,
            },
        });
        this.securityConfigurationName = this.getResourceNameAttribute(resource.ref);
    }
    /**
     * (experimental) Creates a Connection construct that represents an external security configuration.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param securityConfigurationName name of external security configuration.
     * @experimental
     */
    static fromSecurityConfigurationName(scope, id, securityConfigurationName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.securityConfigurationName = securityConfigurationName;
            }
        }
        return new Import(scope, id);
    }
}
exports.SecurityConfiguration = SecurityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
SecurityConfiguration[_a] = { fqn: "@aws-cdk/aws-glue.SecurityConfiguration", version: "1.93.0" };
//# sourceMappingURL=data:application/json;base64,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