# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['QueryDefinitionArgs', 'QueryDefinition']

@pulumi.input_type
class QueryDefinitionArgs:
    def __init__(__self__, *,
                 query_string: pulumi.Input[str],
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a QueryDefinition resource.
        :param pulumi.Input[str] query_string: The query string to use for this definition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_names: Optionally define specific log groups as part of your query definition
        :param pulumi.Input[str] name: A name for the saved query definition
        """
        pulumi.set(__self__, "query_string", query_string)
        if log_group_names is not None:
            pulumi.set(__self__, "log_group_names", log_group_names)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[str]:
        """
        The query string to use for this definition
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="logGroupNames")
    def log_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optionally define specific log groups as part of your query definition
        """
        return pulumi.get(self, "log_group_names")

    @log_group_names.setter
    def log_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_group_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the saved query definition
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class QueryDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The resource schema for AWSLogs QueryDefinition

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_group_names: Optionally define specific log groups as part of your query definition
        :param pulumi.Input[str] name: A name for the saved query definition
        :param pulumi.Input[str] query_string: The query string to use for this definition
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource schema for AWSLogs QueryDefinition

        :param str resource_name: The name of the resource.
        :param QueryDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryDefinitionArgs.__new__(QueryDefinitionArgs)

            __props__.__dict__["log_group_names"] = log_group_names
            __props__.__dict__["name"] = name
            if query_string is None and not opts.urn:
                raise TypeError("Missing required property 'query_string'")
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["query_definition_id"] = None
        super(QueryDefinition, __self__).__init__(
            'aws-native:logs:QueryDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'QueryDefinition':
        """
        Get an existing QueryDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueryDefinitionArgs.__new__(QueryDefinitionArgs)

        __props__.__dict__["log_group_names"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["query_definition_id"] = None
        __props__.__dict__["query_string"] = None
        return QueryDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="logGroupNames")
    def log_group_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Optionally define specific log groups as part of your query definition
        """
        return pulumi.get(self, "log_group_names")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the saved query definition
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryDefinitionId")
    def query_definition_id(self) -> pulumi.Output[str]:
        """
        Unique identifier of a query definition
        """
        return pulumi.get(self, "query_definition_id")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[str]:
        """
        The query string to use for this definition
        """
        return pulumi.get(self, "query_string")

