# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ModuleDefaultVersionArgs', 'ModuleDefaultVersion']

@pulumi.input_type
class ModuleDefaultVersionArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ModuleDefaultVersion resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the module version to set as the default version.
        :param pulumi.Input[str] module_name: The name of a module existing in the registry.
        :param pulumi.Input[str] version_id: The ID of an existing version of the named module to set as the default.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if module_name is not None:
            pulumi.set(__self__, "module_name", module_name)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the module version to set as the default version.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a module existing in the registry.
        """
        return pulumi.get(self, "module_name")

    @module_name.setter
    def module_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "module_name", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an existing version of the named module to set as the default.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class ModuleDefaultVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A module that has been registered in the CloudFormation registry as the default version

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the module version to set as the default version.
        :param pulumi.Input[str] module_name: The name of a module existing in the registry.
        :param pulumi.Input[str] version_id: The ID of an existing version of the named module to set as the default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ModuleDefaultVersionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A module that has been registered in the CloudFormation registry as the default version

        :param str resource_name: The name of the resource.
        :param ModuleDefaultVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModuleDefaultVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 module_name: Optional[pulumi.Input[str]] = None,
                 version_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModuleDefaultVersionArgs.__new__(ModuleDefaultVersionArgs)

            __props__.__dict__["arn"] = arn
            __props__.__dict__["module_name"] = module_name
            __props__.__dict__["version_id"] = version_id
        super(ModuleDefaultVersion, __self__).__init__(
            'aws-native:cloudformation:ModuleDefaultVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ModuleDefaultVersion':
        """
        Get an existing ModuleDefaultVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ModuleDefaultVersionArgs.__new__(ModuleDefaultVersionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["module_name"] = None
        __props__.__dict__["version_id"] = None
        return ModuleDefaultVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the module version to set as the default version.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of a module existing in the registry.
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of an existing version of the named module to set as the default.
        """
        return pulumi.get(self, "version_id")

