URL = "https://%s"
DEFAULT_DOMAIN = "qa.datomize.com"

MANAGEMENT = "/api"
ONBOARDING = "/onboarding"
IDENTITY = "/identity"
KEYCLOAK = "/auth"

VERSION = "/v1"
TENANT = "/tenant"


TOKEN_RESOLVER = "/tokenResolver"
REALM_NAME = "/realmName"

KEYCLOAK_GET_TOKEN_URL = URL + KEYCLOAK + "/realms/%s/protocol/openid-connect/token"


ONBOARDING_GET_USER_DOMAIN_DEFAULT = (URL % DEFAULT_DOMAIN) \
                                     + ONBOARDING + VERSION + TENANT + "/getDefaultTenantDomainByKey/%s"

IDENTITY_GET_REALM_BY_DOMAIN = URL + IDENTITY + TOKEN_RESOLVER + REALM_NAME

# Temp
FLOWS_FILTER = "/flowsFilter"
LATEST_FLOWS = "/latestFlows"
MANAGEMENT_GET_LATEST_FLOWS = URL + MANAGEMENT + FLOWS_FILTER + LATEST_FLOWS


DATASOURCE_URL = "/dataSourceConfigurations"
ORIGIN_DS = "/origin"
TARGET_DS = "/target"
PRIVATE = "/private"
PRESIGNED_URL = "/presignedUrl"
MANAGEMENT_POST_ADD_ORIGIN_PRIVATE_DATASOURCE = URL + MANAGEMENT + DATASOURCE_URL + ORIGIN_DS + PRIVATE
MANAGEMENT_POST_ADD_TARGET_PRIVATE_DATASOURCE = URL + MANAGEMENT + DATASOURCE_URL + TARGET_DS + PRIVATE
MANAGEMENT_GET_PUT_PRESIGNED_URL = URL + MANAGEMENT + DATASOURCE_URL + ORIGIN_DS + PRIVATE + "/%s" + PRESIGNED_URL + "/%s"

PROTO = "/proto"
BUSINESS_UNIT_URL = "/businessUnit"
PROJECT_URL = "/projects"
GENERATIVE_MODEL = "/generativeModelFlows"
SYNTH_FLOW = "/synthesizeFlows"
FLOWS_URL = "/flows"
AUTO_SCHEMA_DISCOVERY = "/autoSchemaDiscovery"
SAMPLE_DATA_CSV = "/sampleTableCSV"
TRAIN = "/train"
ENHANCE_ML = "/enhanceMLFlows"
ENHANCE_ML_EVALUATE = "/enhancedMLEvaluate"
ENHANCE_ML_TRAIN_GEN = "/enhancedMLTrainAndGenerate"
MODEL = "/models"
SAMPLE_TABLE = "/sampleTable"
GENERATED_DATA = "/generatedData"
SYNTHESIZE = "/synthesize"
MANAGEMENT_GET_ALL_BUSINESS_UNIT_URL = URL + MANAGEMENT + BUSINESS_UNIT_URL
MANAGEMENT_GET_GENERATIVE_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + GENERATIVE_MODEL + "/%s"
MANAGEMENT_GET_SYNTH_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + SYNTH_FLOW + "/%s"
MANAGEMENT_POST_ADD_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + GENERATIVE_MODEL
MANAGEMENT_GET_SCHEMA_DISCOVERY = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + FLOWS_URL + "/%s" + AUTO_SCHEMA_DISCOVERY
MANAGEMENT_PUT_TRAIN_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + GENERATIVE_MODEL + "/%s" + TRAIN
MANAGEMENT_PUT_ENHANCE_ML_EVALUATE_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + ENHANCE_ML + "/%s" + ENHANCE_ML_EVALUATE
MANAGEMENT_PUT_ENHANCE_ML_TRAIN_GEN_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + ENHANCE_ML + "/%s" + ENHANCE_ML_TRAIN_GEN
MANAGEMENT_GET_GENERATIVE_SAMPLE = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + GENERATIVE_MODEL + "/%s" + MODEL + "/%s" + SAMPLE_TABLE + "/%s"
MANAGEMENT_GET_GENERATED_DATA = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + SYNTH_FLOW + "/%s" + TRAIN + "/%s" + GENERATED_DATA
MANAGEMENT_GET_GENERATED_CSV = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + SYNTH_FLOW + "/%s" + SAMPLE_DATA_CSV + "/%s"
MANAGEMENT_PUT_SYNTH_FLOW = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s" + SYNTH_FLOW + "/%s" + SYNTHESIZE