# Data Reduction System of SPIAKID

This project contains the **Data Reduction System** (DRS) of SPIAKID.

The **SPIAKID** (SpectroPhotometric Imaging in Astronomy with Kinetic Inductance Detectors) project aims at designing, building and deploying on the sky a spectrophotometric imager based on Kinetic Inductance detectors. More information can be found on the [SPIAKID project homepage](https://www.observatoiredeparis.psl.eu/spiakid.html).

The SPIAKID DRS is composed by Python code. 

## User documentation

User documentation of the DRS can be found [here](https://spiakid.pages.obspm.fr/DRS/index.html).

## Installation

Stable versions of SPIAKID DRS are packaged and distributed via **pip**. Before installing the SPIAKID DRS, create a virtual environment like:
```
pip install virtualenv # Install virtualenv
virtualenv venv_DRS # Create a virtual environment for the DRS
source venv_DRS/bin/activate # Activate the virtual environment for the DRS
```
then, install the SPIAKID DRS ith pip:
```
pip install spiakid-drs
```

### Requirements
The SPIAKID DRS requires Python 3.8 or later.



## Authors
The DRS is developped by Pasquale Panuzzo


## Project status and roadmap
The DRS is in a prototyping stage

## Support


## License
To be decided

