"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Environment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("@robhan-cdk-lib/utils");
const aws_mwaa_1 = require("aws-cdk-lib/aws-mwaa");
const environment_base_1 = require("./environment-base");
const environment_base_2 = require("./validation/environment-base");
const IS_ENVIRONMENT = Symbol.for('@robhan-cdk-lib/aws_mwaa.Environment');
class Environment extends environment_base_1.EnvironmentBase {
    static isEnvironment(x) {
        return IS_ENVIRONMENT in x;
    }
    static fromEnvironmentAttributes(scope, id, attrs) {
        class Import extends environment_base_1.EnvironmentBase {
            constructor(attributes) {
                super(scope, id);
                this.airflowConfigurationOptions = attributes.airflowConfigurationOptions;
                this.airflowVersion = attributes.airflowVersion;
                this.dagS3Path = attributes.dagS3Path;
                this.endpointManagement = attributes.endpointManagement;
                this.environmentClass = attributes.environmentClass;
                this.executionRole = attributes.executionRole;
                this.kmsKey = attributes.kmsKey;
                this.loggingConfiguration = attributes.loggingConfiguration;
                this.maxWebservers = attributes.maxWebservers;
                this.maxWorkers = attributes.maxWorkers;
                this.minWebservers = attributes.minWebservers;
                this.minWorkers = attributes.minWorkers;
                this.name = attributes.name;
                this.networkConfiguration = attributes.networkConfiguration;
                this.pluginsS3ObjectVersion = attributes.pluginsS3ObjectVersion;
                this.pluginsS3Path = attributes.pluginsS3Path;
                this.requirementsS3ObjectVersion = attributes.requirementsS3ObjectVersion;
                this.requirementsS3Path = attributes.requirementsS3Path;
                this.schedulers = attributes.schedulers;
                this.sourceBucket = attributes.sourceBucket;
                this.startupScriptS3ObjectVersion = attributes.startupScriptS3ObjectVersion;
                this.startupScriptS3Path = attributes.startupScriptS3Path;
                this.webserverAccessMode = attributes.webserverAccessMode;
                this.weeklyMaintenanceWindowStart = attributes.weeklyMaintenanceWindowStart;
                this.environmentArn = attributes.environmentArn;
                this.celeryExecutorQueue = attributes.celeryExecutorQueue;
                this.databaseVpcEndpointService = attributes.databaseVpcEndpointService;
                this.loggingConfigurationDagProcessingLogsCloudWatchLogGroupArn = attributes.loggingConfigurationDagProcessingLogsCloudWatchLogGroupArn;
                this.loggingConfigurationSchedulerLogsCloudWatchLogGroupArn = attributes.loggingConfigurationSchedulerLogsCloudWatchLogGroupArn;
                this.loggingConfigurationTaskLogsCloudWatchLogGroupArn = attributes.loggingConfigurationTaskLogsCloudWatchLogGroupArn;
                this.loggingConfigurationWebserverLogsCloudWatchLogGroupArn = attributes.loggingConfigurationWebserverLogsCloudWatchLogGroupArn;
                this.loggingConfigurationWorkerLogsCloudWatchLogGroupArn = attributes.loggingConfigurationWorkerLogsCloudWatchLogGroupArn;
                this.webserverUrl = attributes.webserverUrl;
                this.webserverVpcEndpointService = attributes.webserverVpcEndpointService;
            }
        }
        return new Import(attrs);
    }
    /**
     * Validates all environment properties.
     *
     * @param props - The environment properties to validate
     * @returns An array of error messages if validation fails, or an empty array if valid
     *
     * This method aggregates validation results from all individual property validators.
     * It throws an error if props is not an object.
     */
    static validateProps(props) {
        const errors = [];
        if (!props || typeof props !== 'object') {
            throw new Error('Environment constructor properties must be an object');
        }
        errors.push(...(0, utils_1.validateObjectAttributes)({
            inputObject: props,
            mandatoryAttributes: ['airflowConfigurationOptions', 'name'],
            optionalAttributes: [
                'airflowVersion',
                'dagS3Path',
                'endpointManagement',
                'environmentClass',
                'executionRole',
                'kmsKey',
                'loggingConfiguration',
                'maxWebservers',
                'maxWorkers',
                'minWebservers',
                'minWorkers',
                'networkConfiguration',
                'pluginsS3ObjectVersion',
                'pluginsS3Path',
                'requirementsS3ObjectVersion',
                'requirementsS3Path',
                'schedulers',
                'sourceBucket',
                'startupScriptS3ObjectVersion',
                'startupScriptS3Path',
                'webserverAccessMode',
                'weeklyMaintenanceWindowStart',
            ],
        }));
        const environmentProps = props;
        if (environmentProps.airflowConfigurationOptions !== undefined) {
            errors.push(...(0, environment_base_2.validateAirflowConfigurationOptions)(environmentProps.airflowConfigurationOptions).map((error) => `airflowConfigurationOptions: ${error}`));
        }
        if (environmentProps.dagS3Path !== undefined) {
            errors.push(...(0, environment_base_2.validateDagS3Path)(environmentProps.dagS3Path).map((error) => `dagS3Path: ${error}`));
        }
        if (environmentProps.loggingConfiguration !== undefined) {
            errors.push(...(0, environment_base_2.validateLoggingConfiguration)(environmentProps.loggingConfiguration).map((error) => `loggingConfiguration: ${error}`));
        }
        if (environmentProps.maxWebservers !== undefined) {
            errors.push(...(0, environment_base_2.validateMaxWebservers)(environmentProps).map((error) => `maxWebservers: ${error}`));
        }
        if (environmentProps.maxWorkers !== undefined) {
            errors.push(...(0, environment_base_2.validateMaxWorkers)(environmentProps.maxWorkers).map((error) => `maxWorkers: ${error}`));
        }
        if (environmentProps.minWebservers !== undefined) {
            errors.push(...(0, environment_base_2.validateMinWebservers)(environmentProps).map((error) => `minWebservers: ${error}`));
        }
        if (environmentProps.minWorkers !== undefined) {
            errors.push(...(0, environment_base_2.validateMinWorkers)(environmentProps.minWorkers).map((error) => `minWorkers: ${error}`));
        }
        if (environmentProps.name !== undefined) {
            errors.push(...(0, environment_base_2.validateName)(environmentProps.name).map((error) => `name: ${error}`));
        }
        if (environmentProps.networkConfiguration !== undefined) {
            errors.push(...(0, environment_base_2.validateNetworkConfiguration)(environmentProps.networkConfiguration).map((error) => `networkConfiguration: ${error}`));
        }
        if (environmentProps.pluginsS3ObjectVersion !== undefined) {
            errors.push(...(0, environment_base_2.validatePluginsS3ObjectVersion)(environmentProps.pluginsS3ObjectVersion).map((error) => `pluginsS3ObjectVersion: ${error}`));
        }
        if (environmentProps.pluginsS3Path !== undefined) {
            errors.push(...(0, environment_base_2.validatePluginsS3Path)(environmentProps.pluginsS3Path).map((error) => `pluginsS3Path: ${error}`));
        }
        if (environmentProps.requirementsS3ObjectVersion !== undefined) {
            errors.push(...(0, environment_base_2.validateRequirementsS3ObjectVersion)(environmentProps.requirementsS3ObjectVersion).map((error) => `requirementsS3ObjectVersion: ${error}`));
        }
        if (environmentProps.requirementsS3Path !== undefined) {
            errors.push(...(0, environment_base_2.validateRequirementsS3Path)(environmentProps.requirementsS3Path).map((error) => `requirementsS3Path: ${error}`));
        }
        if (environmentProps.schedulers !== undefined) {
            errors.push(...(0, environment_base_2.validateSchedulers)(environmentProps.schedulers).map((error) => `schedulers: ${error}`));
        }
        if (environmentProps.startupScriptS3ObjectVersion !== undefined) {
            errors.push(...(0, environment_base_2.validateStartupScriptS3ObjectVersion)(environmentProps.startupScriptS3ObjectVersion).map((error) => `startupScriptS3ObjectVersion: ${error}`));
        }
        if (environmentProps.startupScriptS3Path !== undefined) {
            errors.push(...(0, environment_base_2.validateStartupScriptS3Path)(environmentProps.startupScriptS3Path).map((error) => `startupScriptS3Path: ${error}`));
        }
        if (environmentProps.weeklyMaintenanceWindowStart !== undefined) {
            errors.push(...(0, environment_base_2.validateWeeklyMaintenanceWindowStart)(environmentProps.weeklyMaintenanceWindowStart).map((error) => `weeklyMaintenanceWindowStart: ${error}`));
        }
        return errors;
    }
    constructor(scope, id, props) {
        super(scope, id);
        Object.defineProperty(this, IS_ENVIRONMENT, { value: true });
        const errors = Environment.validateProps(props);
        if (errors.length > 0) {
            throw new Error(`Invalid props:\n${errors.join('\n')}`);
        }
        this.airflowConfigurationOptions = props.airflowConfigurationOptions;
        this.airflowVersion = props.airflowVersion;
        this.dagS3Path = props.dagS3Path;
        this.endpointManagement = props.endpointManagement;
        this.environmentClass = props.environmentClass;
        this.executionRole = props.executionRole;
        this.kmsKey = props.kmsKey;
        this.loggingConfiguration = props.loggingConfiguration;
        this.maxWebservers = props.maxWebservers;
        this.maxWorkers = props.maxWorkers;
        this.minWebservers = props.minWebservers;
        this.minWorkers = props.minWorkers;
        this.name = props.name;
        this.networkConfiguration = props.networkConfiguration;
        this.pluginsS3ObjectVersion = props.pluginsS3ObjectVersion;
        this.pluginsS3Path = props.pluginsS3Path;
        this.requirementsS3ObjectVersion = props.requirementsS3ObjectVersion;
        this.requirementsS3Path = props.requirementsS3Path;
        this.schedulers = props.schedulers;
        this.sourceBucket = props.sourceBucket;
        this.startupScriptS3ObjectVersion = props.startupScriptS3ObjectVersion;
        this.startupScriptS3Path = props.startupScriptS3Path;
        this.webserverAccessMode = props.webserverAccessMode;
        this.weeklyMaintenanceWindowStart = props.weeklyMaintenanceWindowStart;
        let cfnEnvironmentProps = {
            name: this.name,
            airflowConfigurationOptions: this.airflowConfigurationOptions,
            airflowVersion: this.airflowVersion,
            dagS3Path: this.dagS3Path,
            endpointManagement: this.endpointManagement,
            environmentClass: this.environmentClass,
            executionRoleArn: this.executionRole?.roleArn,
            kmsKey: this.kmsKey?.keyArn,
            loggingConfiguration: this.loggingConfiguration,
            maxWebservers: this.maxWebservers,
            maxWorkers: this.maxWorkers,
            minWebservers: this.minWebservers,
            minWorkers: this.minWorkers,
            networkConfiguration: this.networkConfiguration ? {
                securityGroupIds: this.networkConfiguration.securityGroups?.map(sg => sg.securityGroupId),
                subnetIds: this.networkConfiguration.subnets?.map(subnet => subnet.subnetId),
            } : undefined,
            pluginsS3ObjectVersion: this.pluginsS3ObjectVersion,
            pluginsS3Path: this.pluginsS3Path,
            requirementsS3ObjectVersion: this.requirementsS3ObjectVersion,
            requirementsS3Path: this.requirementsS3Path,
            schedulers: this.schedulers,
            sourceBucketArn: this.sourceBucket?.bucketArn,
            startupScriptS3ObjectVersion: this.startupScriptS3ObjectVersion,
            startupScriptS3Path: this.startupScriptS3Path,
            webserverAccessMode: this.webserverAccessMode,
            weeklyMaintenanceWindowStart: this.weeklyMaintenanceWindowStart,
        };
        this.environment = new aws_mwaa_1.CfnEnvironment(this, 'Resource', cfnEnvironmentProps);
        this.node.defaultChild = this.environment;
        this.environmentArn = this.environment.attrArn;
        this.celeryExecutorQueue = this.environment.attrCeleryExecutorQueue;
        this.databaseVpcEndpointService = this.environment.attrDatabaseVpcEndpointService;
        this.loggingConfigurationDagProcessingLogsCloudWatchLogGroupArn = this.environment.attrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn;
        this.loggingConfigurationSchedulerLogsCloudWatchLogGroupArn = this.environment.attrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn;
        this.loggingConfigurationTaskLogsCloudWatchLogGroupArn = this.environment.attrLoggingConfigurationTaskLogsCloudWatchLogGroupArn;
        this.loggingConfigurationWebserverLogsCloudWatchLogGroupArn = this.environment.attrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn;
        this.loggingConfigurationWorkerLogsCloudWatchLogGroupArn = this.environment.attrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn;
        this.webserverUrl = this.environment.attrWebserverUrl;
        this.webserverVpcEndpointService = this.environment.attrWebserverVpcEndpointService;
    }
}
exports.Environment = Environment;
_a = JSII_RTTI_SYMBOL_1;
Environment[_a] = { fqn: "@robhan-cdk-lib/aws_mwaa.Environment", version: "0.0.23" };
//# sourceMappingURL=data:application/json;base64,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