/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.CodeEntity;
import AndroidProjectRepresentation.JSONSerializable;
import com.github.javaparser.ast.body.ModifierSet;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Variable
extends CodeEntity
implements Serializable,
JSONSerializable {
    public String type = "";
    public String varName = "";
    public boolean isStatic = false;
    public int arrayCount = 0;
    public boolean isFinal = false;
    public boolean isVolatile = false;
    public boolean isTransient = false;
    public int uuid = 0;
    public String accessModifier = "";
    public List<String> modifiers = new ArrayList<String>();

    public void setModifiers(int modifiers) {
        this.isStatic = ModifierSet.isStatic(modifiers);
        this.isTransient = ModifierSet.isTransient(modifiers);
        this.isFinal = ModifierSet.isFinal(modifiers);
        this.isVolatile = ModifierSet.isVolatile(modifiers);
        this.accessModifier = ModifierSet.isPublic(modifiers) ? "public" : (ModifierSet.isProtected(modifiers) ? "protected" : (ModifierSet.isPrivate(modifiers) ? "private" : ""));
    }

    public String toString() {
        return "Variable{type='" + this.type + '\'' + ", varName='" + this.varName + '\'' + ", isStatic=" + this.isStatic + ", arrayCount=" + this.arrayCount + ", isFinal=" + this.isFinal + ", isVolatile=" + this.isVolatile + ", isTransient=" + this.isTransient + ", accessModifier='" + this.accessModifier + '\'' + '}';
    }

    public Variable(String varName, String type) {
        this.type = type;
        this.varName = varName;
    }

    public Variable(String varName, String type, int arrayCount) {
        this.type = type;
        this.varName = varName;
        this.arrayCount = arrayCount;
    }

    public Variable(String type) {
        this.type = type;
        this.varName = "x";
        this.arrayCount = this.arrayCount;
    }

    public Variable() {
        this.type = "";
        this.varName = "";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Variable ne = (Variable)obj;
        return !(!this.varName.equals("") && !this.varName.equals(ne.varName) || !this.type.equals("") && !this.type.equals(ne.type));
    }

    public int hashCode() {
        return this.varName.hashCode() + new Integer(this.uuid).hashCode();
    }

    @Override
    public JSONObject toJSONObject(String requiredId) {
        JSONObject jo = new JSONObject();
        jo.put("var_type", this.type);
        jo.put("var_name", this.varName);
        jo.put("var_arraycount", this.arrayCount);
        return jo;
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        Variable v = new Variable();
        v.type = (String)jo.get("var_type");
        v.varName = (String)jo.get("var_name");
        v.arrayCount = jo.get("var_is_array") != null ? Integer.parseInt((String)jo.get("var_is_array")) : 0;
        return v;
    }

    public static Variable fromJSONString(String representation) {
        String[] x;
        Variable v = new Variable();
        for (String s : x = representation.split("--")) {
            v.type = s.replaceAll("\\[|\\]", "");
            v.arrayCount = s.contains("[") ? 1 : 0;
        }
        return v;
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(pathToJSONFile));
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject.containsKey("var_type")) {
                return jsonObject;
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return ja;
    }
}

