/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.Analyzer;

import AnaDroidAnalyzer.Analyzer.MainAnalyzer;
import AnaDroidAnalyzer.GreenSourceBridge.GreenSourceAPI;
import AnaDroidAnalyzer.Results.Metrics.TrepnCSVMetric;
import AnaDroidAnalyzer.Results.TestResults;
import AnaDroidAnalyzer.Results.TrepnResults;
import AnaDroidAnalyzer.Utils.Utils;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TestOrientedAnalyzer
extends MainAnalyzer {
    public static final String stopTag = "stopped";
    public static final String startTag = "started";
    List<TestResults> resultsList = new ArrayList<TestResults>();

    public TestOrientedAnalyzer() {
        super("Test");
        this.actualTestMethods = new HashSet();
        this.analyzerTag = "[MainAnalyzer] ";
    }

    @Override
    public void showFinalStatistics() {
    }

    @Override
    public void analyze(List<String> files) {
        if (GreenSourceAPI.operationalBackend) {
            this.grr.test = Utils.getTest(this.applicationID, this.testingFramework.name(), this.testOrientation.name());
            this.grr.test = GreenSourceAPI.sendTestToDB(this.grr.test.toJSONString());
        }
        this.testOriented(files);
    }

    private FileWriter createFile(String file) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            return new FileWriter(f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void testOriented(List<String> csvList) throws NullPointerException {
        this.view.show("Nr of tests: " + csvList.size() + " tests");
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        FileWriter fw = this.createFile(this.resultDirPath + "/" + "TestResults.csv");
        FileWriter fwApp = this.createFile(this.resultDirPath + "/" + "AppResults.csv");
        TestResults actualResult = new TestResults();
        for (int csvIndex = 0; csvIndex < csvList.size(); ++csvIndex) {
            String[] row;
            actualResult = new TestResults();
            if (!csvList.get(csvIndex).matches(".*.csv.*") || csvList.get(csvIndex).matches(".*Testresults.csv")) continue;
            System.out.println("--- " + csvList.get(csvIndex) + " ---");
            CsvParser parser = new CsvParser(settings);
            List<String[]> resolvedData = null;
            try {
                File f = new File(csvList.get(csvIndex));
                resolvedData = parser.parseAll(new FileReader(f.getAbsolutePath()));
            }
            catch (FileNotFoundException e) {
                System.out.println("[ANALYZER]: File Not Found: There is no " + csvList.get(csvIndex) + " csv file in directory! to generate results");
                continue;
            }
            Set<TrepnCSVMetric> columns = null;
            try {
                columns = Utils.fetchColumns(resolvedData);
                if (columns.isEmpty()) {
                    System.out.println("[ANALYZER] Empty csv file. Ignoring results file " + csvList.get(csvIndex));
                    continue;
                }
            }
            catch (Exception e) {
                System.out.println("[ANALYZER] Error fetching columns. Result csv might have an error");
            }
            String number = csvList.get(csvIndex).replaceAll(".+GreendroidResultTrace(.+)\\..+", "$1");
            for (int i2 = 3; i2 < resolvedData.size() && (row = resolvedData.get(i2)).length != 0 && row[0] != null; ++i2) {
                this.getSamplesFromRow(actualResult, columns, row);
            }
            Path p = TestOrientedAnalyzer.getRespectiveTracedMethodsFile(csvList.get(csvIndex));
            double totalconsumption = 0.0;
            try {
                totalconsumption = actualResult.getTotalConsumptionInterpolated(TestOrientedAnalyzer.getMetric("Battery\\ Power.*", columns).getSamplesMap(), TestOrientedAnalyzer.getMetric("Application\\ State.*", columns).getSamplesMap());
            }
            catch (IllegalArgumentException e) {
                System.out.println("[Analyzer] severe Error. The file " + csvList.get(csvIndex) + " is possibly corrupted. Ignoring test");
                continue;
            }
            actualResult.testName = this.getTestName(number);
            actualResult.testId = number;
            if (actualResult.time <= 0) {
                this.view.show("[MainAnalyzer] Warning: Ignoring test " + number + "; Missing start or stop tags in resultant .csv file");
                this.testNameNumber.put(this.getTestName(number), number);
                this.view.showHeadedString("Method Coverage of Test", "percentage: " + this.setInvokedMethodsAndmethodCoverageTestOriented(actualResult, p) * 100.0 + " %");
                continue;
            }
            try {
                this.alltests = this.loadTests(csvList.get(csvIndex));
            }
            catch (Exception e) {
                System.out.println("[ANALYZER] Error tracing tests... Assuming order of tests instead of names");
            }
            double testtotalcoverage = this.setInvokedMethodsAndmethodCoverageTestOriented(actualResult, p) * 100.0;
            this.view.showTestResume(this.getTestName(number), String.valueOf(totalconsumption), String.valueOf(actualResult.time), String.valueOf(testtotalcoverage));
            this.testNameNumber.put(this.getTestName(number), number);
            this.copyToAllTracedMethods(actualResult.invokedMethods, number);
            this.sendIndividualTestResults(actualResult, number, csvIndex, columns, testtotalcoverage);
            if (GreenSourceAPI.operationalBackend) continue;
            JSONArray test_metrics = new JSONArray();
            actualResult.getAllGSMetrics(testtotalcoverage, columns, this.loadBeginState(number), this.loadEndState(number)).stream().map(x -> x.toGSJSONFormatTestMetric(number.toString())).collect(Collectors.toSet()).forEach(x -> test_metrics.add(x));
            try {
                Utils.writeFile(new File(this.resultDirPath + "/test" + number + "resume.json"), test_metrics.toJSONString());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.view.showHeadedString("Total Coverage", "percentage: " + this.totalCoverage() * 100.0 + " %");
        try {
            Utils.writeFile(new File(this.resultDirPath + "/total_coverage.log"), String.valueOf(this.totalCoverage() * 100.0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONArray jas = new JSONArray();
        jas.addAll(this.grr.methodsInvoked.values());
        Utils.writeJSONMethodAPIS(jas, this.resultDirPath + "/methodsInvoked.json");
        this.grr.classMetrics = this.grr.getUniqueClassMetrics();
        this.sendGlobalTestResults();
    }

    public int getTracedMethodCount() {
        int i2 = 0;
        for (Map x : this.allTracedMethods.values()) {
            i2 += x.size();
        }
        return i2;
    }

    private static TrepnCSVMetric getMetric(String metricregex, Set<TrepnCSVMetric> m) {
        return m.stream().filter(x -> x.metricId.matches(metricregex)).findFirst().get();
    }

    public void sendGlobalTestResults() {
        this.view.showHeadedString("Total traced methods", String.valueOf(this.getTracedMethodCount()));
        try {
            Utils.writeFile(new File(this.resultDirPath + "/total_traced_methods.log"), String.valueOf(this.getTracedMethodCount()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (GreenSourceAPI.operationalBackend) {
            GreenSourceAPI.sendTestsMetricsToDB(this.grr.testMetrics.toJSONString());
            GreenSourceAPI.sendClassesToDB(GreenSourceAPI.jsonObjToArray(this.grr.classes).toJSONString());
            GreenSourceAPI.sendMethodsToDB(this.grr.methodsToJSONString());
            GreenSourceAPI.sendMethodsInvokedToDB(GreenSourceAPI.jsonObjToArray(this.grr.methodsInvoked).toJSONString());
            GreenSourceAPI.sendMethodsMetricsToDB(this.grr.methodMetrics.toJSONString());
            GreenSourceAPI.sendClassMetricsToDB(this.grr.classMetrics.toJSONString());
        }
    }

    public void sendIndividualTestResults(TrepnResults actualResult, String testNumber, int j, Set<TrepnCSVMetric> setMetrics, double cov) {
        if (GreenSourceAPI.operationalBackend) {
            JSONObject test_begin_state = this.loadBeginState(testNumber);
            JSONObject test_end_state = this.loadBeginState(testNumber);
            JSONObject test_global_state = this.loadDeviceState();
            try {
                int devState = GreenSourceAPI.sendDeviceState(test_global_state);
                this.grr.testResults = Utils.getTestResult(testNumber, "", this.grr.getActualTestID(), "trepn", String.valueOf(devState), test_begin_state);
                if (this.testingFramework == MainAnalyzer.TestingFramework.JUNIT) {
                    Integer x2 = Integer.parseInt((String)this.grr.testResults.get("test_results_unix_timestamp"));
                    this.grr.testResults.put("test_results_unix_timestamp", x2 + j);
                    this.grr.testResults = GreenSourceAPI.sendTestResultToDB(this.grr.testResults.toJSONString());
                } else {
                    this.grr.testResults = GreenSourceAPI.sendTestResultToDB(this.grr.testResults.toJSONString());
                }
                String actualTestResId = this.grr.testResults.get("test_results_id").toString();
                this.getMethodsInvokedAndClass(testNumber, actualTestResId);
                this.grr.allTestResults.put(this.grr.testResults, "");
                this.grr.testMetrics.addAll(actualResult.getAllGSMetrics(cov, setMetrics, test_begin_state, test_end_state).stream().map(x -> x.toGSJSONFormatTestMetric(this.grr.testResults.get("test_results_id").toString())).collect(Collectors.toList()));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\n[ANALYZER] An error occurred during the Communication withthe GreenSource. Not submitting  information regarding this test");
                System.out.println("\n[ANALYZER] Hint: you might be submitting an already existent test result");
            }
        }
    }

    public double setInvokedMethodsAndmethodCoverageTestOriented(TrepnResults actualResult, Path pathTraced) {
        this.actualTestMethods = new HashSet();
        if (pathTraced == null) {
            return 0.0;
        }
        HashMap<String, Integer> thisTest = new HashMap<String, Integer>();
        try (Stream<String> lines = Files.lines(pathTraced, StandardCharsets.UTF_8);){
            for (String line : lines::iterator) {
                if (!this.allmethods.getMerged().containsKey(line)) {
                    System.out.println("Warning: Unmatched method -> " + line);
                    System.out.println("This method was invoked during app execution, but the identifier doesn't match any ofidentifiers gathered during isntrumentation phase");
                    continue;
                }
                if (thisTest.containsKey(line)) {
                    int x = thisTest.get(line);
                    thisTest.put(line, ++x);
                    this.actualTestMethods.add(line);
                    continue;
                }
                thisTest.put(line, 1);
                this.actualTestMethods.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((TestResults)actualResult).invokedMethods = thisTest;
        double percentageCoverage = (double)thisTest.size() / (double)this.allmethods.getSourceCoverage();
        return percentageCoverage;
    }

    private void getMethodsInvokedAndClass(String testNumber, String testResID) {
        for (String method_id : this.actualTestMethods) {
            if (this.allmethods.getMerged().containsKey(method_id)) {
                JSONObject method = (JSONObject)this.allmethods.getMerged().get(method_id);
                JSONObject j = this.methodToGSourceJSONFormat(method);
                JSONObject classOfMethod_formatted = this.classToGSourceJSONFormat((JSONObject)this.allmethods.getApkMethods().get(method.get("method_class")));
                this.grr.classes.put(method.get("method_class"), classOfMethod_formatted);
                j.put("method_class", classOfMethod_formatted.get("class_id"));
                this.grr.methods.put((String)j.get("method_id"), j);
                this.grr.methodMetrics.addAll(this.getMethodMetrics((String)j.get("method_id"), method, Integer.parseInt(testResID)));
                this.grr.methodsInvoked.put(j.get("method_id"), Utils.getMethodsInvoked(testResID, (String)j.get("method_id"), ((Integer)((Map)this.allTracedMethods.get(testNumber)).get(method_id)).toString()));
                this.grr.classMetrics.addAll(this.getClassMetrics(classOfMethod_formatted, testResID));
                continue;
            }
            System.out.println(method_id + " not found");
        }
    }

    private JSONObject buildMethodMetric(String method, String metric, String value_text, int coef, int tesResId) {
        JSONObject o = new JSONObject();
        o.put("mm_method", method);
        o.put("mm_metric", metric);
        o.put("mm_value_text", value_text);
        o.put("mm_coeficient", coef);
        o.put("mm_test_result", tesResId);
        return o;
    }

    private JSONArray getMethodMetrics(String methodID, JSONObject jsonMethod, int testResId) {
        int nr_locals;
        int len;
        int nr_instructions;
        JSONArray jas = new JSONArray();
        JSONArray apis = (JSONArray)jsonMethod.get("method_apis");
        for (Object o : apis) {
            JSONObject api_json = (JSONObject)o;
            JSONArray args_of_api = (JSONArray)api_json.get("args");
            String args = "";
            if (args_of_api != null) {
                StringBuilder sb = new StringBuilder();
                args_of_api.forEach(x -> sb.append("," + x));
                args = sb.toString().replaceFirst(",", "");
            }
            String value = api_json.get("name") + "(" + args + ")|" + api_json.get("return");
            jas.add(this.buildMethodMetric(methodID, "api", value, 1, testResId));
        }
        if (jsonMethod.containsKey("method_nr_instructions") && (nr_instructions = Integer.parseInt(jsonMethod.get("method_nr_instructions").toString())) > 0) {
            jas.add(this.buildMethodMetric(methodID, "nr_instructions", String.valueOf(nr_instructions), 1, testResId));
        }
        if (jsonMethod.containsKey("method_length") && (len = Integer.parseInt(jsonMethod.get("method_length").toString())) > 0) {
            jas.add(this.buildMethodMetric(methodID, "length", String.valueOf(len), 1, testResId));
        }
        if (jsonMethod.containsKey("method_locals") && (nr_locals = Integer.parseInt(jsonMethod.get("method_locals").toString())) > 0) {
            jas.add(this.buildMethodMetric(methodID, "locals", String.valueOf(nr_locals), 1, testResId));
        }
        return jas;
    }

    private JSONObject classToGSourceJSONFormat(JSONObject classObj) {
        if (classObj == null) {
            return classObj;
        }
        JSONObject jo = new JSONObject();
        jo.putAll(classObj);
        jo.put("class_id", this.applicationID + "--" + ((String)jo.get("class_name")).replaceAll("\\.", "--"));
        jo.put("class_app", this.applicationID);
        return jo;
    }

    private JSONObject methodToGSourceJSONFormat(JSONObject methodObj) {
        JSONObject jo = new JSONObject();
        String cla = this.applicationID + "--" + ((String)methodObj.get("method_class")).replaceAll("\\.", "--");
        jo.put("method_class", cla);
        jo.put("method_id", ((String)jo.get("method_class")).hashCode() + "--" + (String)methodObj.get("method_name") + "--" + (String)methodObj.get("method_hash"));
        jo.put("method_modifiers", methodObj.get("method_modifiers"));
        jo.put("method_name", methodObj.get("method_name"));
        StringBuilder sb = new StringBuilder();
        if (!((JSONArray)methodObj.get("method_args")).isEmpty()) {
            for (Object o : (JSONArray)methodObj.get("method_args")) {
                sb.append("--" + o);
            }
            jo.put("method_args", sb.toString().replaceFirst("--", ""));
        } else {
            jo.put("method_args", null);
        }
        jo.put("method_return", methodObj.get("method_return"));
        return jo;
    }

    public static Path getRespectiveTracedMethodsFile(String csvFile) {
        String number = csvFile.replaceAll(".+GreendroidResultTrace(.+)\\..+", "$1");
        File f = new File(csvFile);
        Path path = Paths.get(f.getAbsoluteFile().getParent(), new String[0]);
        Path p = null;
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            for (Path entry : stream) {
                if (!entry.getFileName().toString().matches("TracedMethods" + number + ".txt")) continue;
                p = entry;
                break;
            }
            stream.close();
            if (p == null) {
                throw new IOException("TracedMethods" + number + ".txt not found");
            }
        }
        catch (IOException e) {
            System.out.println(" : File containing traced Methods of file (TracedMethods" + number + ".txt) not found! Assumed 0 traced methods");
        }
        return p;
    }

    public void getSamplesFromRow(TrepnResults actualResult, Set<TrepnCSVMetric> columns, String[] row) {
        for (TrepnCSVMetric tcv : columns) {
            if (tcv.getValue_csv_column() >= row.length || row[tcv.getValue_csv_column()] == null) continue;
            if (tcv.metricId.matches("Description.*")) {
                if (!actualResult.hasStartTime() && row[tcv.getValue_csv_column()].equals(startTag)) {
                    ((TestResults)actualResult).startTime = Integer.parseInt(row[tcv.getTime_csv_column()]);
                    continue;
                }
                if (actualResult.hasEndTime() || !row[tcv.getValue_csv_column()].equals(stopTag)) continue;
                ((TestResults)actualResult).stopTime = Integer.parseInt(row[tcv.getTime_csv_column()]);
                continue;
            }
            tcv.addSample(Integer.parseInt(row[tcv.getTime_csv_column()]), Long.valueOf(row[tcv.getValue_csv_column()]));
        }
    }

    @Override
    public void buildAnalysisJSONFile() {
        JSONObject mainJO = new JSONObject();
        mainJO.put("test_tool", this.testingFramework);
        mainJO.put("test_orientation", this.testOrientation);
        JSONObject joca = new JSONObject();
        this.resultsList.forEach(x -> joca.put(x.testId, x.toAnalysisJSONFile()));
        mainJO.put("results", joca);
    }
}

