/*
 * Decompiled with CFR 0.152.
 */
package AnaDroidAnalyzer.Analyzer;

import AnaDroidAnalyzer.Analyzer.ActivityOrientedAnalyzer;
import AnaDroidAnalyzer.Analyzer.MethodOrientedAnalyzer;
import AnaDroidAnalyzer.Analyzer.PowerLogAnalyzer;
import AnaDroidAnalyzer.Analyzer.TestOrientedAnalyzer;
import AnaDroidAnalyzer.Analyzer.Views.TerminalView;
import AnaDroidAnalyzer.Analyzer.Views.View;
import AnaDroidAnalyzer.GreenSourceBridge.GreenSourceAPI;
import AnaDroidAnalyzer.Results.JSONsMerger;
import AnaDroidAnalyzer.Utils.Utils;
import AndroidProjectRepresentation.APICallUtil;
import AndroidProjectRepresentation.ClassInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MainAnalyzer
implements PowerLogAnalyzer {
    public static final String appIssuesFile = "AppIssues.csv";
    public static final String testResultsFile = "TestResults.csv";
    public static final String appResultsFile = "AppResults.csv";
    private static boolean mergeOldRuns = true;
    public String analyzerTag = "[MainAnalyzer] ";
    public String folderPrefix = "Test";
    public String pathPermissions = "";
    public String pathApp = "";
    public String pathDevice = "";
    public String pathDeviceState = "";
    public String applicationID = "unknown";
    public String projectAppJSONFile = "";
    public String resultDirPath = "results/";
    public String appPackage = "?";
    private String pathLogin = null;
    public View view = new TerminalView();
    public TestingFramework testingFramework = TestingFramework.MONKEY;
    public TestOrientation testOrientation = TestOrientation.TESTORIENTED;
    public JSONsMerger allmethods = new JSONsMerger();
    public List<String> alltests = new ArrayList<String>();
    public GreenSourceAPI grr = new GreenSourceAPI();
    public APICallUtil acu = null;
    public HashMap<String, String> testNameNumber = new HashMap();
    public HashMap<String, Map<String, Integer>> allTracedMethods = new HashMap();
    public static int stoppedState = 0;
    public HashSet<String> actualTestMethods = new HashSet();
    public String stopTag = "stopped";
    public String startTag = "started";
    public JSONArray energyGreadyAPIS = new JSONArray();
    public Hashtable<String, String> deviceStatesFiles = new Hashtable();
    public Set<ClassInfo> classesSet = new HashSet<ClassInfo>();
    public Map<String, Integer> methodsSet = new HashMap<String, Integer>();

    public MainAnalyzer() {
    }

    public MainAnalyzer(String folderPrefix) {
        this.folderPrefix = folderPrefix;
    }

    public boolean isTestOriented() {
        return this instanceof TestOrientedAnalyzer;
    }

    protected List<String> loadTests(String csvFile) throws Exception {
        this.alltests = new ArrayList<String>();
        File f = new File(csvFile);
        Path path = Paths.get(f.getAbsoluteFile().getParent(), new String[0]);
        Path p = null;
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            for (Path entry : stream) {
                if (!entry.getFileName().toString().matches("TracedTests\\.txt")) continue;
                p = entry;
                break;
            }
            stream.close();
            if (p == null) {
                throw new IOException("TracedTests not found");
            }
        }
        catch (IOException e) {
            System.out.println("TracedTests not found");
            return this.alltests;
        }
        try (Stream<String> lines = Files.lines(p, StandardCharsets.UTF_8);){
            for (String line : lines::iterator) {
                this.alltests.add(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.alltests;
    }

    public JSONObject getClassMetric(String classID, String metric, String value_text, int coef, int testResId) {
        JSONObject jo = new JSONObject();
        jo.put("cm_class", classID);
        jo.put("cm_metric", metric);
        jo.put("cm_coeficient", coef);
        jo.put("cm_value_text", value_text);
        jo.put("cm_test_result", testResId);
        return jo;
    }

    public JSONArray getClassMetrics(JSONObject classObj, String testResId) {
        String s;
        JSONArray ifaces;
        JSONArray ja = new JSONArray();
        String classId = (String)classObj.get("class_id");
        ja.add(this.getClassMetric(classId, "nr_methods", String.valueOf(((JSONObject)classObj.get("class_methods")).size()), 1, Integer.parseInt(testResId)));
        JSONArray class_fields = (JSONArray)classObj.get("class_fields");
        if (!class_fields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object o : class_fields) {
                sb.append("," + o);
            }
            ja.add(this.getClassMetric(classId, "field", sb.toString().replaceFirst(",", ""), 1, Integer.parseInt(testResId)));
        }
        if (!(ifaces = (JSONArray)classObj.get("class_implemented_ifaces")).isEmpty()) {
            String value = ((JSONArray)classObj.get("class_implemented_ifaces")).stream().map(Object::toString).collect(Collectors.joining("--"));
            ja.add(this.getClassMetric(classId, "implements", value, 1, Integer.parseInt(testResId)));
        }
        if (!(s = classObj.get("class_superclass").toString()).isEmpty()) {
            ja.add(this.getClassMetric(classId, "superclass", s, 1, Integer.parseInt(testResId)));
        }
        return ja;
    }

    private void loadMethods() {
        this.allmethods = new JSONsMerger(this.resultDirPath + "/all/" + this.appPackage + ".json", this.resultDirPath + "/all/allMethods.json");
        this.allmethods.merge();
    }

    protected void copyToAllTracedMethods(Map<String, Integer> h, String testnumber) {
        if (this.allTracedMethods.containsKey(testnumber)) {
            for (String s : h.keySet()) {
                if (this.allTracedMethods.get(testnumber).containsKey(s)) {
                    int x = this.allTracedMethods.get(testnumber).get(s);
                    int y = h.get(s);
                    this.allTracedMethods.get(testnumber).put(s, y + x);
                    continue;
                }
                this.allTracedMethods.get(testnumber).put(s, h.get(s));
            }
        } else {
            HashMap<String, Integer> mm = new HashMap<String, Integer>();
            for (String s : h.keySet()) {
                if (mm.containsKey(s)) {
                    int x = (Integer)mm.get(s);
                    int y = h.get(s);
                    mm.put(s, y + x);
                    continue;
                }
                mm.put(s, h.get(s));
            }
            this.allTracedMethods.put(testnumber, mm);
        }
    }

    public JSONObject loadEndState(String number) {
        if (this.testingFramework == TestingFramework.JUNIT) {
            String key = this.deviceStatesFiles.keySet().stream().filter(x -> x.matches("end_state[0-9]*.json")).findFirst().get();
            return this.grr.loadDeviceState(this.deviceStatesFiles.get(key));
        }
        return this.grr.loadDeviceState(this.deviceStatesFiles.get("end_state" + number + ".json"));
    }

    public JSONObject loadBeginState(String number) {
        if (this.testingFramework == TestingFramework.JUNIT) {
            String key = this.deviceStatesFiles.keySet().stream().filter(x -> x.matches("begin_state[0-9]*.json")).findFirst().get();
            return this.grr.loadDeviceState(this.deviceStatesFiles.get(key));
        }
        return this.grr.loadDeviceState(this.deviceStatesFiles.get("end_state" + number + ".json"));
    }

    public JSONObject loadDeviceState() {
        return Utils.loadJSONObj(this.pathDeviceState);
    }

    public static JSONObject getAllImports(Collection<Object> jc) {
        JSONObject jco = new JSONObject();
        try {
            for (Object jj : jc) {
                JSONObject jo = (JSONObject)jj;
                JSONArray j = (JSONArray)jo.get("class_imports");
                for (Object obj : j) {
                    JSONObject jop = (JSONObject)obj;
                    jco.put(jop.get("import_name").toString() + jop.get("import_class").toString(), jop);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jco;
    }

    public double totalCoverage() {
        HashSet hashSet = new HashSet();
        this.allTracedMethods.values().stream().forEach(x -> hashSet.addAll(x.keySet()));
        double percentageCoverage = (double)hashSet.size() / (double)this.allmethods.getSourceCoverage();
        return percentageCoverage;
    }

    public String getTestName(String number) {
        if (!this.alltests.isEmpty() && Integer.parseInt(number) <= this.alltests.size()) {
            return this.alltests.get(Integer.parseInt(number));
        }
        return number;
    }

    public static String getAppPackage(String resultDirPath) {
        ArrayList l = new ArrayList();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(resultDirPath + "/all", new String[0]), "*.json");){
            dirStream.forEach(x -> l.add(x.getFileName().toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (l.size() <= 1) {
            System.out.println("Warning: incomplete \"all \" folder");
        }
        String s = ((String)l.stream().filter(x -> !x.contains("allMethods")).collect(Collectors.toList()).get(0)).replace(".json", "");
        return s;
    }

    public List<String> fetchAllCSVs() {
        ArrayList<String> list = new ArrayList<String>();
        Path path = Paths.get(this.resultDirPath, new String[0]);
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            for (Path entry : stream) {
                if (!entry.getFileName().toString().toLowerCase().startsWith(this.testingFramework.name().toLowerCase()) && this.testingFramework != TestingFramework.NONE) continue;
                if ((Files.isDirectory(entry, new LinkOption[0]) || Files.isSymbolicLink(entry)) && entry.getFileName().toString().toLowerCase().startsWith(this.testingFramework.name().toLowerCase() + "test") && this.testingFramework != TestingFramework.NONE) {
                    DirectoryStream<Path> streamChild = null;
                    try {
                        streamChild = Files.isSymbolicLink(entry) ? Files.newDirectoryStream(Files.readSymbolicLink(entry).toAbsolutePath()) : Files.newDirectoryStream(Paths.get(entry.toString(), new String[0]));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return list;
                    }
                    for (Path entry1 : streamChild) {
                        if (entry.equals(path)) continue;
                        if (entry1.getFileName().toString().matches("GreendroidResultTrace[0-9]+\\.csv")) {
                            list.add(entry1.toString());
                        }
                        if (entry1.getFileName().toString().matches("begin_state[0-9]*\\.json")) {
                            this.deviceStatesFiles.put(entry1.getFileName().toString(), entry1.toString());
                        }
                        if (entry1.getFileName().toString().matches("end_state[0-9]*\\.json")) {
                            this.deviceStatesFiles.put(entry1.getFileName().toString(), entry1.toString());
                        }
                        if (entry1.getFileName().toString().matches("appPermissions.json")) {
                            this.pathPermissions = entry1.toString();
                        }
                        if (entry1.getFileName().toString().contains("--") && entry1.getFileName().toString().contains(".json")) {
                            this.projectAppJSONFile = this.pathApp = entry1.toString();
                        }
                        if (entry1.getFileName().toString().matches("device.json")) {
                            this.pathDevice = entry1.toString();
                        }
                        if (entry1.getFileName().toString().matches("deviceState.json")) {
                            this.pathDeviceState = entry1.toString();
                        }
                        if (entry1.getFileName().toString().matches("GSlogin.json")) {
                            this.pathLogin = entry1.toString();
                        }
                        if (!entry1.getFileName().toString().matches(".json")) continue;
                        this.pathApp = entry1.toString();
                    }
                    continue;
                }
                if (entry.equals(path)) continue;
                if (entry.getFileName().toString().matches("GreendroidResultTrace[0-9]+\\.csv")) {
                    list.add(entry.toString());
                }
                if (entry.getFileName().toString().matches("begin_state[0-9]*\\.json")) {
                    this.deviceStatesFiles.put(entry.getFileName().toString(), entry.toString());
                }
                if (entry.getFileName().toString().matches("end_state[0-9]*\\.json")) {
                    this.deviceStatesFiles.put(entry.getFileName().toString(), entry.toString());
                }
                if (entry.getFileName().toString().matches("appPermissions.json")) {
                    this.pathPermissions = entry.getFileName().toString();
                }
                if (entry.getFileName().toString().contains("--") && entry.getFileName().toString().contains(".json")) {
                    this.projectAppJSONFile = this.pathApp = entry.toString();
                }
                if (entry.getFileName().toString().matches("device.json")) {
                    this.pathDevice = entry.getFileName().toString();
                }
                if (entry.getFileName().toString().matches("deviceState.json")) {
                    this.pathDeviceState = entry.getFileName().toString();
                }
                if (!entry.getFileName().toString().matches("GSlogin.json")) continue;
                this.pathLogin = entry.getFileName().toString();
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (mergeOldRuns) {
            this.resultDirPath = this.resultDirPath + "oldRuns/";
            mergeOldRuns = false;
            List<String> x = this.fetchAllCSVs();
            list.addAll(x);
            mergeOldRuns = true;
        }
        try {
            JSONObject jj = new APICallUtil().fromJSONFile(this.projectAppJSONFile);
            this.acu = (APICallUtil)new APICallUtil().fromJSONObject(jj);
            this.appPackage = APICallUtil.proj.getCurrentApp().appPackage;
            if (this.appPackage == "") {
                this.appPackage = MainAnalyzer.getAppPackage(this.resultDirPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return list;
    }

    public static String getSimpleProjectJSON(JSONObject jo) {
        JSONObject pro = new JSONObject();
        pro.put("project_id", jo.get("project_id"));
        pro.put("project_build_tool", jo.get("project_build_tool"));
        pro.put("project_description", jo.get("project_description"));
        return pro.toJSONString();
    }

    public void sendApplicationInformation() {
        if (GreenSourceAPI.operationalBackend) {
            this.grr.loginGreenSource(this.pathLogin);
            JSONObject jo = APICallUtil.proj.toJSONObject("");
            String projectToSend = MainAnalyzer.getSimpleProjectJSON(jo);
            this.grr.project = GreenSourceAPI.sendProjectToDB(projectToSend);
            this.applicationID = (String)APICallUtil.proj.apps.get(0).toJSONObject(APICallUtil.proj.projectID).get("app_id");
            this.grr.app = GreenSourceAPI.sendApplicationToDB(APICallUtil.proj.getCurrentApp().toJSONObject(APICallUtil.proj.projectID).toJSONString());
            JSONArray permissions = GreenSourceAPI.loadAppPermissions(this.pathPermissions);
            MainAnalyzer.modifyJSONPermissions(permissions, this.applicationID);
            GreenSourceAPI.sendAppPermissionsToDB(permissions.toJSONString());
            this.grr.device = Utils.loadJSONObj(this.pathDevice);
            GreenSourceAPI.sendDeviceToDB(this.grr.device);
            GreenSourceAPI.sendDeviceState(Utils.loadJSONObj(this.pathDeviceState));
        }
    }

    public static void modifyJSONPermissions(JSONArray permissions, String apid) {
        permissions.stream().forEach(x -> ((JSONObject)x).replace("application", apid));
    }

    public static MainAnalyzer initDefault(String testOrientat, String resultDirPath) {
        MainAnalyzer m = null;
        if (testOrientat.equals("-TestOriented")) {
            m = new TestOrientedAnalyzer();
            m.testOrientation = TestOrientation.TESTORIENTED;
        } else if (testOrientat.equals("-MethodOriented")) {
            m = new MethodOrientedAnalyzer();
            m.testOrientation = TestOrientation.METHODORIENTED;
        } else if (testOrientat.equals("-AppOriented")) {
            m = new MainAnalyzer();
            m.testOrientation = TestOrientation.APPLICATIONORIENTED;
        } else if (testOrientat.equals("-ActivityOriented")) {
            m = new ActivityOrientedAnalyzer();
            m.testOrientation = TestOrientation.ACTIVITYORIENTED;
        } else if (testOrientat.equals("-AnnotationOriented")) {
            m = new MethodOrientedAnalyzer();
            m.testOrientation = TestOrientation.ANNOTATIONORIENTED;
        }
        mergeOldRuns = false;
        m.grr = new GreenSourceAPI();
        m.grr.setGreenRepoUrl("http://localhost:8000");
        GreenSourceAPI cfr_ignored_0 = m.grr;
        GreenSourceAPI.operationalBackend = true;
        m.resultDirPath = resultDirPath;
        return m;
    }

    @Override
    public void showFinalStatistics() {
    }

    @Override
    public void analyze(List<String> files) {
        if (GreenSourceAPI.operationalBackend) {
            this.grr.test = Utils.getTest(this.applicationID, this.testingFramework.name(), this.testOrientation.name());
            this.grr.test = GreenSourceAPI.sendTestToDB(this.grr.test.toJSONString());
            System.out.println("sended");
        }
    }

    public void setTestingFramework(String framework) {
        if (framework.toLowerCase().equals("-monkey")) {
            this.testingFramework = TestingFramework.MONKEY;
            stoppedState = 2;
        } else if (framework.toLowerCase().equals("-monkeyrunner")) {
            this.testingFramework = TestingFramework.MONKEYRUNNER;
        } else if (framework.toLowerCase().equals("-junit")) {
            this.testingFramework = TestingFramework.JUNIT;
        } else if (framework.toLowerCase().equals("-reran")) {
            this.testingFramework = TestingFramework.RERAN;
        } else if (framework.toLowerCase().contains("crawler")) {
            this.testingFramework = TestingFramework.CRAWLER;
        } else if (framework.toLowerCase().equals("-none")) {
            this.testingFramework = TestingFramework.NONE;
        }
    }

    public void setGreenSourceServer(String greenSourceServer) {
        if (greenSourceServer.equals("localhost")) {
            this.grr.setGreenRepoUrl("http://localhost:8000/");
        } else if (greenSourceServer.equals("NONE")) {
            this.grr.setGreenRepoUrl("NONE");
            GreenSourceAPI.operationalBackend = false;
        } else if (!greenSourceServer.equals("")) {
            this.grr.setGreenRepoUrl(greenSourceServer);
        }
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Bad argument length for Greendroid MainAnalyzer! Usage ->  [-(Test|Method)Oriented] resultsdir [-Monkey|JUnit] url login_file");
            System.exit(0);
        }
        MainAnalyzer mainAnalyzer = MainAnalyzer.initDefault(args[0], args[1]);
        mainAnalyzer.setTestingFramework(args[2]);
        mainAnalyzer.setGreenSourceServer(args[3]);
        mainAnalyzer.pathLogin = args[4];
        System.out.println("Sending results to -> " + args[3]);
        try {
            List<String> allcsvs = mainAnalyzer.fetchAllCSVs();
            mainAnalyzer.loadMethods();
            mainAnalyzer.sendApplicationInformation();
            mainAnalyzer.analyze(allcsvs);
            mainAnalyzer.buildAnalysisJSONFile();
            mainAnalyzer.logCalledMethods(mainAnalyzer.resultDirPath + "/allTracedMethods.json");
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void buildAnalysisJSONFile() {
    }

    public void logCalledMethods(String filename) {
        JSONObject jo = new JSONObject();
        for (String testId : this.allTracedMethods.keySet()) {
            JSONObject singleTestcalledMethods = new JSONObject();
            if (this.allTracedMethods.get(testId).isEmpty()) continue;
            for (String methodId : this.allTracedMethods.get(testId).keySet()) {
                JSONObject correspondantMethod = (JSONObject)this.allmethods.getMerged().get(methodId);
                if (correspondantMethod == null) continue;
                singleTestcalledMethods.put(methodId, correspondantMethod);
            }
            jo.put(testId, singleTestcalledMethods);
        }
        Utils.writeJSONObject(jo, filename);
    }

    static enum TestingFramework {
        MONKEY,
        MONKEYRUNNER,
        JUNIT,
        RERAN,
        CRAWLER,
        NONE;

    }

    static enum TestOrientation {
        TESTORIENTED,
        METHODORIENTED,
        APPLICATIONORIENTED,
        ACTIVITYORIENTED,
        ANNOTATIONORIENTED;

    }
}

