/*
 * Decompiled with CFR 0.152.
 */
package soot.validation;

import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class UsesValidator
implements BodyValidator {
    public static UsesValidator INSTANCE;

    public static UsesValidator v() {
        if (INSTANCE == null) {
            INSTANCE = new UsesValidator();
        }
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exception) {
        PedanticThrowAnalysis throwAnalysis = PedanticThrowAnalysis.v();
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body, throwAnalysis, false);
        SmartLocalDefs ld = new SmartLocalDefs(g, new SimpleLiveLocals(g));
        Chain<Local> locals = body.getLocals();
        for (Unit u : body.getUnits()) {
            Iterator<ValueBox> useBoxIt = u.getUseBoxes().iterator();
            while (useBoxIt.hasNext()) {
                List<Unit> l;
                Value v = useBoxIt.next().getValue();
                if (!(v instanceof Local)) continue;
                if (!locals.contains(v)) {
                    String msg = "Local " + v + " is referenced here but not in body's local-chain. (" + body.getMethod() + ")";
                    exception.add(new ValidationException(u, msg, msg));
                }
                if ((l = ld.getDefsOfAt((Local)v, u)).size() != 0) continue;
                exception.add(new ValidationException(u, "There is no path from a definition of " + v + " to this statement.", "(" + body.getMethod() + ") no defs for value: " + v + "!"));
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return false;
    }
}

