/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.List;
import soot.EquivalentValue;
import soot.G;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.toolkits.infoflow.AbstractDataSource;
import soot.jimple.toolkits.infoflow.CachedEquivalentValue;
import soot.jimple.toolkits.infoflow.CallLocalityContext;
import soot.jimple.toolkits.infoflow.ClassLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SimpleMethodInfoFlowAnalysis;
import soot.toolkits.graph.UnitGraph;

public class SimpleMethodLocalObjectsAnalysis
extends SimpleMethodInfoFlowAnalysis {
    public static int mlocounter = 0;

    public SimpleMethodLocalObjectsAnalysis(UnitGraph g, ClassLocalObjectsAnalysis cloa, InfoFlowAnalysis dfa) {
        super(g, dfa, true, true);
        ++mlocounter;
        this.printMessages = false;
        SootMethod method = g.getBody().getMethod();
        AbstractDataSource sharedDataSource = new AbstractDataSource(new String("SHARED"));
        for (int i = 0; i < method.getParameterCount(); ++i) {
            EquivalentValue paramEqVal = InfoFlowAnalysis.getNodeForParameterRef(method, i);
            if (cloa.parameterIsLocal(method, paramEqVal)) continue;
            this.addToEntryInitialFlow(sharedDataSource, paramEqVal.getValue());
            this.addToNewInitialFlow(sharedDataSource, paramEqVal.getValue());
        }
        for (SootField sf : cloa.getSharedFields()) {
            EquivalentValue fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(method, sf);
            this.addToEntryInitialFlow(sharedDataSource, fieldRefEqVal.getValue());
            this.addToNewInitialFlow(sharedDataSource, fieldRefEqVal.getValue());
        }
        if (this.printMessages) {
            G.v().out.println("----- STARTING SHARED/LOCAL ANALYSIS FOR " + g.getBody().getMethod() + " -----");
        }
        this.doFlowInsensitiveAnalysis();
        if (this.printMessages) {
            G.v().out.println("----- ENDING   SHARED/LOCAL ANALYSIS FOR " + g.getBody().getMethod() + " -----");
        }
    }

    public SimpleMethodLocalObjectsAnalysis(UnitGraph g, CallLocalityContext context, InfoFlowAnalysis dfa) {
        super(g, dfa, true, true);
        ++mlocounter;
        this.printMessages = false;
        SootMethod method = g.getBody().getMethod();
        AbstractDataSource sharedDataSource = new AbstractDataSource(new String("SHARED"));
        List<Object> sharedRefs = context.getSharedRefs();
        for (EquivalentValue equivalentValue : sharedRefs) {
            this.addToEntryInitialFlow(sharedDataSource, equivalentValue.getValue());
            this.addToNewInitialFlow(sharedDataSource, equivalentValue.getValue());
        }
        if (this.printMessages) {
            G.v().out.println("----- STARTING SHARED/LOCAL ANALYSIS FOR " + g.getBody().getMethod() + " -----");
            G.v().out.print("      " + context.toString().replaceAll("\n", "\n      "));
            G.v().out.println("found " + sharedRefs.size() + " shared refs in context.");
        }
        this.doFlowInsensitiveAnalysis();
        if (this.printMessages) {
            G.v().out.println("----- ENDING   SHARED/LOCAL ANALYSIS FOR " + g.getBody().getMethod() + " -----");
        }
    }

    @Override
    public boolean isInterestingSource(Value source) {
        return source instanceof AbstractDataSource;
    }

    @Override
    public boolean isInterestingSink(Value sink) {
        return true;
    }

    public boolean isObjectLocal(Value local) {
        CachedEquivalentValue source = new CachedEquivalentValue(new AbstractDataSource(new String("SHARED")));
        if (this.infoFlowGraph.containsNode(source)) {
            List<CachedEquivalentValue> sinks = this.infoFlowGraph.getSuccsOf(source);
            if (this.printMessages) {
                G.v().out.println("      Requested value " + local + " is " + (!sinks.contains(new CachedEquivalentValue(local)) ? "Local" : "Shared") + " in " + this.sm + " ");
            }
            return !sinks.contains(new CachedEquivalentValue(local));
        }
        if (this.printMessages) {
            G.v().out.println("      Requested value " + local + " is Local (LIKE ALL VALUES) in " + this.sm + " ");
        }
        return true;
    }
}

