/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import soot.Body;
import soot.MethodOrMethodContext;
import soot.PatchingChain;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.EdgePredicate;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.ide.icfg.AbstractJimpleBasedICFG;
import soot.util.queue.QueueReader;

@ThreadSafe
public class JimpleBasedInterproceduralCFG
extends AbstractJimpleBasedICFG {
    @DontSynchronize(value="readonly")
    protected final CallGraph cg;
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Unit, Collection<SootMethod>> unitToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Unit, Collection<SootMethod>>(){

        @Override
        public Collection<SootMethod> load(Unit u) throws Exception {
            ArrayList<SootMethod> res = null;
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesOutOf(u));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                SootMethod m = edge.getTgt().method();
                if (m.hasActiveBody()) {
                    if (res == null) {
                        res = new ArrayList<SootMethod>();
                    }
                    res.add(m);
                    continue;
                }
                if (!IDESolver.DEBUG) continue;
                System.err.println("Method " + m.getSignature() + " is referenced but has no body!");
            }
            if (res != null) {
                res.trimToSize();
                return res;
            }
            return Collections.emptySet();
        }
    });
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Collection<Unit>> methodToCallers = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Collection<Unit>>(){

        @Override
        public Collection<Unit> load(SootMethod m) throws Exception {
            ArrayList<Unit> res = new ArrayList<Unit>();
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesInto(m));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                res.add(edge.srcUnit());
            }
            res.trimToSize();
            return res;
        }
    });

    public JimpleBasedInterproceduralCFG() {
        this.cg = Scene.v().getCallGraph();
        this.initializeUnitToOwner();
    }

    protected void initializeUnitToOwner() {
        QueueReader<MethodOrMethodContext> iter = Scene.v().getReachableMethods().listener();
        while (iter.hasNext()) {
            SootMethod m = ((MethodOrMethodContext)iter.next()).method();
            this.initializeUnitToOwner(m);
        }
    }

    public void initializeUnitToOwner(SootMethod m) {
        if (m.hasActiveBody()) {
            Body b = m.getActiveBody();
            PatchingChain<Unit> units = b.getUnits();
            for (Unit unit : units) {
                this.unitToOwner.put(unit, b);
            }
        }
    }

    @Override
    public Collection<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.unitToCallees.getUnchecked(u);
    }

    @Override
    public Collection<Unit> getCallersOf(SootMethod m) {
        return this.methodToCallers.getUnchecked(m);
    }

    public static class EdgeFilter
    extends Filter {
        protected EdgeFilter() {
            super(new EdgePredicate(){

                @Override
                public boolean want(Edge e) {
                    return e.kind().isExplicit() || e.kind().isThread() || e.kind().isExecutor() || e.kind().isAsyncTask() || e.kind().isClinit() || e.kind().isPrivileged();
                }
            });
        }
    }
}

