/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.PlaceholderInst;
import soot.baf.TableSwitchInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.StmtSwitch;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.AbstractSwitchStmt;
import soot.util.Switch;

public class JTableSwitchStmt
extends AbstractSwitchStmt
implements TableSwitchStmt {
    int lowIndex;
    int highIndex;

    private static UnitBox[] getTargetBoxesArray(List<? extends Unit> targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        for (int i = 0; i < targetBoxes.length; ++i) {
            targetBoxes[i] = Jimple.v().newStmtBox(targets.get(i));
        }
        return targetBoxes;
    }

    @Override
    public Object clone() {
        return new JTableSwitchStmt(Jimple.cloneIfNecessary(this.getKey()), this.lowIndex, this.highIndex, this.getTargets(), this.getDefaultTarget());
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List<? extends Unit> targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, JTableSwitchStmt.getTargetBoxesArray(targets), Jimple.v().newStmtBox(defaultTarget));
    }

    public JTableSwitchStmt(Value key, int lowIndex, int highIndex, List<? extends UnitBox> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lowIndex, highIndex, targets.toArray(new UnitBox[targets.size()]), defaultTarget);
    }

    protected JTableSwitchStmt(ValueBox keyBox, int lowIndex, int highIndex, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        super(keyBox, defaultTargetBox, targetBoxes);
        if (lowIndex > highIndex) {
            throw new RuntimeException("Error creating tableswitch: lowIndex(" + lowIndex + ") can't be greater than highIndex(" + highIndex + ").");
        }
        this.lowIndex = lowIndex;
        this.highIndex = highIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("tableswitch(" + this.keyBox.getValue().toString() + ")" + endOfLine);
        buffer.append("{" + endOfLine);
        for (int i = this.lowIndex; i < this.highIndex; ++i) {
            buffer.append("    case " + i + ": " + "goto" + " " + this.getTarget(i - this.lowIndex) + ";" + endOfLine);
        }
        buffer.append("    case " + this.highIndex + ": " + "goto" + " " + this.getTarget(this.highIndex - this.lowIndex) + ";" + endOfLine);
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("tableswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = this.lowIndex; i < this.highIndex; ++i) {
            this.printCaseTarget(up, i);
        }
        this.printCaseTarget(up, this.highIndex);
        up.literal("    ");
        up.literal("default");
        up.literal(": ");
        up.literal("goto");
        up.literal(" ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    private void printCaseTarget(UnitPrinter up, int targetIndex) {
        up.literal("    ");
        up.literal("case");
        up.literal(" ");
        up.literal(Integer.toString(targetIndex));
        up.literal(": ");
        up.literal("goto");
        up.literal(" ");
        this.targetBoxes[targetIndex - this.lowIndex].toString(up);
        up.literal(";");
        up.newline();
    }

    @Override
    public void setLowIndex(int lowIndex) {
        this.lowIndex = lowIndex;
    }

    @Override
    public void setHighIndex(int highIndex) {
        this.highIndex = highIndex;
    }

    @Override
    public int getLowIndex() {
        return this.lowIndex;
    }

    @Override
    public int getHighIndex() {
        return this.highIndex;
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseTableSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>();
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        for (Unit target : this.getTargets()) {
            targetPlaceholders.add(Baf.v().newPlaceholderInst(target));
        }
        TableSwitchInst u = Baf.v().newTableSwitchInst(Baf.v().newPlaceholderInst(this.getDefaultTarget()), this.lowIndex, this.highIndex, targetPlaceholders);
        u.addAllTagsOf(this);
        out.add(u);
    }
}

