/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.common.base;

import android.util.Log;
import java.util.EnumSet;
import java.util.Locale;

public abstract class Logger {
    private static final String TAG = "Robo";
    private static boolean consoleMode = false;
    private static EnumSet<VerbosityFlag> enabledFlags = VerbosityFlag.NONE;
    private static String packageName = "";

    public static void setConsoleMode(boolean consoleMode) {
        Logger.consoleMode = consoleMode;
    }

    public static LogApi atDebug() {
        return new LogApi(3);
    }

    public static LogApi atInfo() {
        return new LogApi(4);
    }

    public static LogApi atWarning() {
        return new LogApi(5);
    }

    public static LogApi atSevere() {
        return new LogApi(6);
    }

    public static LogApi atVerbose(VerbosityFlag flag) {
        return new LogApi(flag);
    }

    public static void setEnabledVerbosityFlag(String flag) {
        if (flag.equals("ALL")) {
            enabledFlags = VerbosityFlag.ALL;
        } else {
            try {
                enabledFlags.add(VerbosityFlag.valueOf(flag));
            }
            catch (IllegalArgumentException e) {
                Logger.atWarning().log("Unknown verbosity flag %s.", flag);
            }
        }
    }

    public static void setAppPackageName(String packageName) {
        Logger.packageName = packageName;
    }

    private static void printLog(int priority, String message) {
        if (consoleMode) {
            System.out.println(message);
        } else {
            Log.println((int)priority, (String)TAG, (String)message);
        }
    }

    public static class LogApi {
        private final int priority;
        private final VerbosityFlag flag;
        private boolean includePackageName = false;
        private Throwable cause = null;

        LogApi(int priority) {
            this.priority = priority;
            this.flag = VerbosityFlag.DEFAULT;
        }

        LogApi(VerbosityFlag flag) {
            this.priority = 2;
            this.flag = flag;
        }

        public LogApi withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public LogApi withPackageName() {
            this.includePackageName = true;
            return this;
        }

        public void log(String message, Object ... options) {
            if (this.priority == 2 && !enabledFlags.contains((Object)this.flag)) {
                return;
            }
            if (this.priority <= 3 && consoleMode) {
                return;
            }
            String outputMessage = options.length == 0 ? message : String.format(Locale.US, message, options);
            try {
                if (this.includePackageName && !packageName.isEmpty()) {
                    Logger.printLog(this.priority, packageName + ": " + outputMessage);
                } else {
                    Logger.printLog(this.priority, outputMessage);
                }
                if (this.cause != null) {
                    Logger.printLog(this.priority, Log.getStackTraceString((Throwable)this.cause));
                }
            }
            catch (NoClassDefFoundError ignored) {
                System.out.println("Robo: " + outputMessage);
            }
        }
    }

    public static enum VerbosityFlag {
        DEFAULT,
        PATH,
        MONKEY;

        public static final EnumSet<VerbosityFlag> ALL;
        public static final EnumSet<VerbosityFlag> NONE;

        static {
            ALL = EnumSet.allOf(VerbosityFlag.class);
            NONE = EnumSet.noneOf(VerbosityFlag.class);
        }
    }
}

