/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public abstract class AbstractTracingStrategy
implements TracingStrategy {
    protected final KtExpression reference;
    protected final Call call;

    protected AbstractTracingStrategy(@NotNull KtExpression reference, @NotNull Call call2) {
        this.reference = reference;
        this.call = call2;
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates2) {
        HashSet<D> descriptors = new HashSet<D>();
        for (ResolvedCall<D> candidate2 : candidates2) {
            descriptors.add(candidate2.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        KtElement reportOn = CallUtilKt.getValueArgumentListOrElement(this.call);
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
        KtExpression reportOn;
        KtExpression ktExpression = reportOn = receiverArgument instanceof ExpressionReceiver ? ((ExpressionReceiver)receiverArgument).getExpression() : this.reference;
        if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, reportOn, receiverParameter.getType(), receiverArgument.getType())) {
            trace.report(Errors.TYPE_MISMATCH.on(reportOn, receiverParameter.getType(), receiverArgument.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        trace.report(Errors.NO_RECEIVER_ALLOWED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
        KtTypeArgumentList typeArgumentList = this.call.getTypeArgumentList();
        trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList != null ? typeArgumentList : this.reference, expectedTypeArgumentCount, descriptor2));
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        trace.report(Errors.ABSTRACT_SUPER_CALL.on(this.reference));
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor2, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        DeclarationDescriptor importableDescriptor;
        if (explicitReceiverKind == ExplicitReceiverKind.NO_EXPLICIT_RECEIVER && DescriptorUtils.getFqName(importableDescriptor = DescriptorUtilsKt.getImportableDescriptor(classDescriptor2)).isSafe()) {
            FqName fqName2 = DescriptorUtils.getFqNameFromTopLevelClass(importableDescriptor);
            String qualifiedName2 = this.reference.getParent() instanceof KtCallableReferenceExpression ? fqName2.parent() + "::" + classDescriptor2.getName() : fqName2.asString();
            trace.report(Errors.NESTED_CLASS_SHOULD_BE_QUALIFIED.on(this.reference, classDescriptor2, qualifiedName2));
            return;
        }
        trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(this.reference, classDescriptor2));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        ASTNode callOperationNode2 = this.call.getCallOperationNode();
        if (callOperationNode2 != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode2.getPsi(), type2));
        } else {
            KtElement callElement = this.call.getCallElement();
            if (callElement instanceof KtBinaryExpression) {
                this.reportUnsafeCallOnBinaryExpression(trace, (KtBinaryExpression)callElement);
            } else if (isCallForImplicitInvoke) {
                trace.report(Errors.UNSAFE_IMPLICIT_INVOKE_CALL.on(this.reference, type2));
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type2));
            }
        }
    }

    private void reportUnsafeCallOnBinaryExpression(@NotNull BindingTrace trace, @NotNull KtBinaryExpression binaryExpression) {
        Name operationString;
        KtOperationReferenceExpression operationReference = binaryExpression.getOperationReference();
        boolean isInfixCall = operationReference.getReferencedNameElementType() == KtTokens.IDENTIFIER;
        Name name = operationString = isInfixCall ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((KtToken)operationReference.getReferencedNameElementType());
        if (operationString == null) {
            return;
        }
        KtExpression left = binaryExpression.getLeft();
        KtExpression right = binaryExpression.getRight();
        if (left == null || right == null) {
            return;
        }
        if (isInfixCall) {
            trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left, operationString.asString(), right));
        } else {
            boolean inOperation = KtPsiUtil.isInOrNotInOperation(binaryExpression);
            KtExpression receiver2 = inOperation ? right : left;
            KtExpression argument = inOperation ? left : right;
            trace.report(Errors.UNSAFE_OPERATOR_CALL.on(this.reference, receiver2, operationString.asString(), argument));
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor2, descriptor2.getVisibility(), descriptor2));
    }

    @Override
    public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data2) {
        Diagnostic diagnostic = AbstractTracingStrategy.typeInferenceFailedDiagnostic(context, data2, this.reference, this.call);
        if (diagnostic != null) {
            context.trace.report(diagnostic);
        }
    }

    @Nullable
    public static Diagnostic typeInferenceFailedDiagnostic(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data2, @NotNull KtExpression reference, @NotNull Call call2) {
        ConstraintSystem constraintSystem = data2.constraintSystem;
        ConstraintSystemStatus status2 = constraintSystem.getStatus();
        assert (!status2.isSuccessful()) : "Report error only for not successful constraint system";
        if (status2.hasErrorInConstrainingTypes()) {
            return null;
        }
        if (status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION)) {
            KotlinType declaredReturnType = data2.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return null;
            }
            ConstraintSystem systemWithoutExpectedTypeConstraint = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem, ConstraintPositionKind.EXPECTED_TYPE_POSITION);
            KotlinType substitutedReturnType = systemWithoutExpectedTypeConstraint.getResultingSubstitutor().substitute(declaredReturnType, Variance.OUT_VARIANCE);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data2.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            if (!DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(context, call2.getCallElement(), data2.expectedType, substitutedReturnType)) {
                return Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(call2.getCallElement(), data2.expectedType, substitutedReturnType);
            }
        } else {
            if (status2.hasCannotCaptureTypesError()) {
                return Errors.TYPE_INFERENCE_CANNOT_CAPTURE_TYPES.on(reference, data2);
            }
            if (status2.hasViolatedUpperBound()) {
                return Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(reference, data2);
            }
            if (status2.hasParameterConstraintError()) {
                return Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR.on(reference, data2);
            }
            if (status2.hasConflictingConstraints()) {
                return Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(reference, data2);
            }
            if (status2.hasTypeInferenceIncorporationError()) {
                return Errors.TYPE_INFERENCE_INCORPORATION_ERROR.on(reference);
            }
            if (status2.hasTypeParameterWithUnsatisfiedOnlyInputTypesError()) {
                return Errors.TYPE_INFERENCE_ONLY_INPUT_TYPES.on(reference, data2.descriptor.getTypeParameters().get(0));
            }
            assert (status2.hasUnknownParameters());
            return Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(reference, data2);
        }
        return null;
    }
}

