/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.internal.Utils;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.List;

public final class ASTHelper {
    public static final PrimitiveType BYTE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Byte);
    public static final PrimitiveType SHORT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Short);
    public static final PrimitiveType INT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Int);
    public static final PrimitiveType LONG_TYPE = new PrimitiveType(PrimitiveType.Primitive.Long);
    public static final PrimitiveType FLOAT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Float);
    public static final PrimitiveType DOUBLE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Double);
    public static final PrimitiveType BOOLEAN_TYPE = new PrimitiveType(PrimitiveType.Primitive.Boolean);
    public static final PrimitiveType CHAR_TYPE = new PrimitiveType(PrimitiveType.Primitive.Char);
    public static final VoidType VOID_TYPE = new VoidType();

    private ASTHelper() {
    }

    public static NameExpr createNameExpr(String qualifiedName2) {
        String[] split = qualifiedName2.split("\\.");
        NameExpr ret = new NameExpr(split[0]);
        for (int i = 1; i < split.length; ++i) {
            ret = new QualifiedNameExpr(ret, split[i]);
        }
        return ret;
    }

    public static Parameter createParameter(Type type2, String name) {
        return new Parameter(type2, new VariableDeclaratorId(name));
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers2, Type type2, VariableDeclarator variable2) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        variables.add(variable2);
        return new FieldDeclaration(modifiers2, type2, variables);
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers2, Type type2, String name) {
        VariableDeclaratorId id = new VariableDeclaratorId(name);
        VariableDeclarator variable2 = new VariableDeclarator(id);
        return ASTHelper.createFieldDeclaration(modifiers2, type2, variable2);
    }

    public static VariableDeclarationExpr createVariableDeclarationExpr(Type type2, String name) {
        ArrayList<VariableDeclarator> vars = new ArrayList<VariableDeclarator>();
        vars.add(new VariableDeclarator(new VariableDeclaratorId(name)));
        return new VariableDeclarationExpr(type2, vars);
    }

    public static void addParameter(MethodDeclaration method, Parameter parameter) {
        List<Parameter> parameters2 = method.getParameters();
        if (Utils.isNullOrEmpty(parameters2)) {
            parameters2 = new ArrayList<Parameter>();
            method.setParameters(parameters2);
        }
        parameters2.add(parameter);
    }

    public static void addArgument(MethodCallExpr call2, Expression arg) {
        List<Expression> args = call2.getArgs();
        if (Utils.isNullOrEmpty(args)) {
            args = new ArrayList<Expression>();
            call2.setArgs(args);
        }
        args.add(arg);
    }

    public static void addTypeDeclaration(CompilationUnit cu, TypeDeclaration type2) {
        List<TypeDeclaration> types = cu.getTypes();
        if (Utils.isNullOrEmpty(types)) {
            types = new ArrayList<TypeDeclaration>();
            cu.setTypes(types);
        }
        types.add(type2);
    }

    public static ReferenceType createReferenceType(String name, int arrayCount) {
        return new ReferenceType(new ClassOrInterfaceType(name), arrayCount);
    }

    public static ReferenceType createReferenceType(PrimitiveType type2, int arrayCount) {
        return new ReferenceType(type2, arrayCount);
    }

    public static void addStmt(BlockStmt block, Statement stmt) {
        List<Statement> stmts = block.getStmts();
        if (Utils.isNullOrEmpty(stmts)) {
            stmts = new ArrayList<Statement>();
            block.setStmts(stmts);
        }
        stmts.add(stmt);
    }

    public static void addStmt(BlockStmt block, Expression expr) {
        ASTHelper.addStmt(block, new ExpressionStmt(expr));
    }

    public static void addMember(TypeDeclaration type2, BodyDeclaration decl) {
        List<BodyDeclaration> members2 = type2.getMembers();
        if (Utils.isNullOrEmpty(members2)) {
            members2 = new ArrayList<BodyDeclaration>();
            type2.setMembers(members2);
        }
        members2.add(decl);
    }

    public static <N extends Node> List<N> getNodesByType(Node container2, Class<N> clazz) {
        ArrayList<N> nodes = new ArrayList<N>();
        for (Node child : container2.getChildrenNodes()) {
            if (clazz.isInstance(child)) {
                nodes.add(clazz.cast(child));
            }
            nodes.addAll(ASTHelper.getNodesByType(child, clazz));
        }
        return nodes;
    }
}

