/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.util;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.AppPackageNameExtractionException;
import androidx.test.tools.crawler.launcher.setup.CrawlSetup;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class AppPackageNameExtractor {
    private static final String PACKAGE_NAME_SIGNATURE = "package: name=";
    private final String apkFilePath;
    private final File aaptExecutable;

    public AppPackageNameExtractor(CrawlSetup crawlSetup) {
        this.apkFilePath = crawlSetup.getApkFilePath();
        this.aaptExecutable = crawlSetup.getExecutable(CrawlSetup.ExecutableType.AAPT);
    }

    public String extractAppPackageName() {
        try {
            Process dumpBadging = Runtime.getRuntime().exec(new String[]{this.aaptExecutable.getAbsolutePath(), "dump", "badging", this.apkFilePath}, null, this.aaptExecutable.getParentFile());
            Logger.atDebug().log("Dump badging for APK %s", this.apkFilePath);
            dumpBadging.waitFor();
            return this.extractAppPackageName(dumpBadging);
        }
        catch (Exception e) {
            throw new AppPackageNameExtractionException(this.apkFilePath, e);
        }
    }

    private String extractAppPackageName(Process process) throws IOException {
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line = inputReader.readLine();
            while (line != null) {
                int packageNameIndex = line.indexOf(PACKAGE_NAME_SIGNATURE);
                if (packageNameIndex != -1) {
                    String string = this.extractAppPackageName(line, packageNameIndex);
                    return string;
                }
                line = inputReader.readLine();
            }
        }
        throw new AppPackageNameExtractionException(this.apkFilePath);
    }

    private String extractAppPackageName(String line, int packageNameIndex) {
        String packageName;
        int firstSpaceIndex = line.indexOf(" ", packageNameIndex + PACKAGE_NAME_SIGNATURE.length());
        if (firstSpaceIndex != -1 && !(packageName = line.substring(packageNameIndex + PACKAGE_NAME_SIGNATURE.length() + 1, firstSpaceIndex - 1)).isEmpty()) {
            return packageName;
        }
        throw new AppPackageNameExtractionException(this.apkFilePath);
    }
}

