#  Copyright 2021-present, the Recognai S.L. team.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from .commons import records_status, text_length
from .text_classification import f1, f1_multilabel
from .token_classification import (
    entity_capitalness,
    entity_consistency,
    entity_density,
    entity_labels,
)
from .token_classification import f1 as ner_f1
from .token_classification import (
    mention_length,
    token_capitalness,
    token_frequency,
    token_length,
    tokens_length,
)

__all__ = [
    text_length,
    records_status,
    f1,
    f1_multilabel,
    entity_capitalness,
    entity_consistency,
    entity_density,
    entity_labels,
    ner_f1,
    mention_length,
    token_capitalness,
    token_frequency,
    token_length,
    tokens_length,
]
