# Performance Testing Report

<!-- AUTO-GENERATED: This file is regenerated by CI/CD pipeline on every run -->
<!-- See .github/workflows/performance.yml -->

Comprehensive performance and load testing results from the CI/CD pipeline.

## 📊 Performance Test Summary

| Metric | Value |
|--------|-------|
| **Load Test Status** | ✅ Passed |
| **Total Requests** | 334 |
| **Failed Requests** | 0 ❌ |
| **Success Rate** | 100% |
| **Average Response Time** | 22 ms |
| **Requests Per Second** | 5.61 req/s |
| **Test Duration** | 60 seconds |
| **Concurrent Users** | 20 |

## 🚀 Load Testing Results

### Test Configuration
- **Tool**: Locust 2.42.6
- **Users**: 20 concurrent users
- **Spawn Rate**: 5 users/second
- **Duration**: 1 minute
- **Target**: http://localhost:5000

### API Endpoint Performance

| Endpoint | Requests | Failures | Avg (ms) | Min (ms) | Max (ms) | Med (ms) | Req/s |
|----------|----------|----------|----------|----------|----------|----------|-------|
| `GET /api/v1/health` | 277 | 0 (0.00%) | 8 | 1 | 392 | 3 | 4.65 |
| `GET /api/v1/weather` (Chicago) | 5 | 0 (0.00%) | 94 | 3 | 273 | 4 | 0.08 |
| `GET /api/v1/weather` (Houston) | 9 | 0 (0.00%) | 60 | 2 | 389 | 3 | 0.15 |
| `GET /api/v1/weather` (London) | 12 | 0 (0.00%) | 60 | 2 | 378 | 4 | 0.20 |
| `GET /api/v1/weather` (Los Angeles) | 7 | 0 (0.00%) | 84 | 2 | 358 | 4 | 0.12 |
| `GET /api/v1/weather` (New York) | 6 | 0 (0.00%) | 211 | 2 | 892 | 4 | 0.10 |
| `GET /api/v1/weather` (Phoenix) | 4 | 0 (0.00%) | 96 | 3 | 206 | 4 | 0.07 |
| `GET /api/v1/weather` (Seattle) | 6 | 0 (0.00%) | 90 | 3 | 276 | 4 | 0.10 |
| `GET /api/v1/weather` (Tokyo) | 8 | 0 (0.00%) | 75 | 2 | 309 | 4 | 0.13 |

### Response Time Distribution

#### Health Endpoint (`/api/v1/health`)
| Percentile | Response Time (ms) |
|------------|-------------------|
| 50% | 3 |
| 66% | 3 |
| 75% | 3 |
| 80% | 4 |
| 90% | 5 |
| 95% | 190 |
| 98% | 360 |
| 99% | 380 |
| 99.9% | 890 |
| 100% (Max) | 890 |

#### Weather Endpoints (Aggregated)
| Percentile | Response Time (ms) |
|------------|-------------------|
| 50% | 4 |
| 66% | 4 |
| 75% | 58 |
| 80% | 190 |
| 90% | 270 |
| 95% | 360 |
| 98% | 380 |
| 99% | 390 |
| 99.9% | 890 |
| 100% (Max) | 892 |

### Task Weighting
The load test uses weighted tasks to simulate realistic user behavior:

- **Health Check**: Weight 5 (83% of requests) - Simulates monitoring and health checks
- **Weather Queries**: Weight 1 (17% of requests) - Simulates actual data fetching

## 🎯 Benchmark Results

### Current Benchmark Status
No benchmark tests are currently configured. The performance testing workflow includes support for pytest-benchmark when benchmark tests are added.

### Adding Benchmarks
To add performance benchmarks:

```python
# tests/test_benchmarks.py
import pytest
from msn_weather_wrapper.client import WeatherClient

@pytest.mark.benchmark(group="client")
def test_client_initialization_benchmark(benchmark):
    """Benchmark client initialization."""
    result = benchmark(WeatherClient)
    assert result is not None

@pytest.mark.benchmark(group="api")
def test_weather_fetch_benchmark(benchmark):
    """Benchmark weather data fetching."""
    client = WeatherClient()
    result = benchmark(client.get_weather, "Seattle", "USA")
    assert result is not None
```

Run benchmarks locally:
```bash
pytest tests/ --benchmark-only
```

## 🔧 Server Configuration

### Gunicorn Settings
- **Workers**: 2
- **Bind Address**: 0.0.0.0:5000
- **Timeout**: 300 seconds
- **Log Level**: debug
- **Process Status**: ✅ Stable (no crashes during test)

### Test Environment
- **OS**: Ubuntu Latest (GitHub Actions)
- **Python**: 3.12
- **Flask**: Latest
- **Gunicorn**: 23.0+

## 📈 Performance Metrics

### Throughput
- **Total Throughput**: 5.61 requests/second
- **Health Check Throughput**: 4.65 requests/second
- **Weather API Throughput**: 0.96 requests/second

### Reliability
- **Success Rate**: 100%
- **Error Rate**: 0%
- **Timeout Rate**: 0%
- **Server Stability**: ✅ No crashes

### Latency Analysis
- **Fastest Response**: 1 ms (health check)
- **Slowest Response**: 892 ms (weather API with external MSN call)
- **Average Response**: 22 ms (all endpoints)
- **P95 Latency**: 360 ms
- **P99 Latency**: 390 ms

## 🎯 Performance Standards

### Quality Gates
All performance quality gates passed:
- ✅ Zero failed requests (0/334)
- ✅ Average response time < 100ms for health endpoint
- ✅ Zero server crashes during load test
- ✅ Request success rate ≥ 99%
- ✅ Server remained responsive throughout test

### SLA Compliance
- **Availability**: 100% (no downtime)
- **Response Time SLA**: Met (P95 < 500ms)
- **Error Budget**: 100% remaining (0 errors)

## 📊 Load Test Visualization

### Request Distribution
```
Health Checks: ████████████████████████████████████████ 277 (82.9%)
Weather API:   ████████                                  57 (17.1%)
```

### Success Rate
```
Successful:    ████████████████████████████████████████ 334 (100%)
Failed:                                                    0 (0%)
```

## 🔄 Continuous Performance Testing

### CI/CD Integration
Performance tests are executed automatically on:
- Pull requests affecting API or backend code
- Manual workflow dispatch
- Changes to performance test configuration

### Test Artifacts
The following artifacts are generated:
- `locust-report.html` - Interactive HTML report with charts
- `locust-results.csv` - Raw test data for analysis
- `gunicorn.log` - Server logs for debugging

### Artifact Retention
- **Load Test Results**: 7 days
- **Benchmark Results**: 30 days (when available)

## 🚨 Performance Alerts

The performance workflow will alert if:
- Request failure rate exceeds 1%
- Average response time exceeds 1000ms
- Server crashes during load test
- Any requests timeout

### Alert Thresholds
- **Benchmark Regression**: 150% (when benchmarks are added)
- **Load Test Failure**: Any request failures
- **Server Instability**: Gunicorn process termination

## 🔍 Debugging Performance Issues

### Checking Load Test Results
1. Navigate to [GitHub Actions - Performance Testing](https://github.com/jim-wyatt/msn-weather-wrapper/actions/workflows/performance.yml)
2. Select a workflow run
3. Download `load-test-results` artifact
4. Open `locust-report.html` in a browser

### Analyzing Server Logs
Server logs are captured in the uploaded artifacts:
```bash
# Download artifact and extract
unzip load-test-results.zip
cat gunicorn.log
```

### Local Performance Testing
Run load tests locally:

```bash
# Start the API server
gunicorn -w 2 -b 0.0.0.0:5000 api:app

# In another terminal, run Locust
locust -f tests/locustfile.py --host=http://localhost:5000
```

Then open http://localhost:8089 to configure and run tests interactively.

## 📝 Test Configuration Details

### Locust Test File
The load test simulates realistic user behavior with:
- Random city selection from a predefined list
- Wait times between requests (2-5 seconds)
- Weighted task distribution (health checks more frequent)
- Proper error handling with `catch_response`

### Cities Tested
- New York, USA
- Los Angeles, USA
- Chicago, USA
- Houston, USA
- Phoenix, USA
- Seattle, USA
- London, UK
- Tokyo, Japan

## 🎯 Performance Optimization

### Current Optimizations
- **Gunicorn Workers**: 2 workers for concurrency
- **Connection Pooling**: Efficient request handling
- **Error Handling**: Graceful degradation on failures

### Future Improvements
- Add Redis caching for weather data
- Implement request rate limiting per user
- Add response compression
- Configure CDN for static assets
- Add connection pooling for external API calls

## 🔗 Related Documentation

- [Testing Methodology](../TESTING.md) - Overall testing strategy
- [API Reference](../API.md) - API endpoints and usage
- [Security Report](security-report.md) - Security test results
- [CI/CD Pipeline](ci-cd.md) - Pipeline execution details

## 📈 Historical Performance

| Date | Requests | Success Rate | Avg Response | P95 Latency | Errors |
|------|----------|--------------|--------------|-------------|--------|
| 2025-12-03 | 334 | 100% | 22ms | 360ms | 0 |
| Previous | - | - | - | - | - |

*Performance testing recently added to CI/CD pipeline.*

---

*Report generated automatically by Performance Testing workflow*
*Last Updated: December 3, 2025 16:53:00 UTC*
*Workflow Run: [View on GitHub Actions](https://github.com/jim-wyatt/msn-weather-wrapper/actions/workflows/performance.yml)*
