# CI/CD Pipeline Documentation

<!-- AUTO-GENERATED: This file is regenerated by CI/CD pipeline on every run -->
<!-- See tools/generate_reports.py and .github/workflows/ci.yml -->

Comprehensive documentation of our automated CI/CD pipeline infrastructure.

## 🔄 Pipeline Overview

| Metric | Value |
|--------|-------|
| **Pipeline Status** | ✅ Passing |
| **Jobs** | 11 |
| **Average Runtime** | ~8 minutes |
| **Success Rate** | 98.5% |
| **Last Run** | December 2, 2025 20:10:00 UTC |

![Pipeline](https://img.shields.io/badge/pipeline-passing-brightgreen)

## 🏗️ Pipeline Architecture

### Workflow Structure

```
┌─────────────────────────────────────────────────────────┐
│                    CI/CD Pipeline                        │
├─────────────────────────────────────────────────────────┤
│                                                           │
│  1. Code Quality ────────────┐                          │
│  2. Security Scanning ───────┤                          │
│  3. Unit Tests (3.10-3.12) ───├──→ 5. Container Build       │
│  4. Coverage Report ─────────┘       ↓                   │
│                                  6. Integration Tests    │
│                                      ↓                    │
│                                  7. SBOM Generation      │
│                                      ↓                    │
│                              8. Build Documentation      │
│                                      ↓                    │
│                          9. Generate Reports             │
│                                      ↓                    │
│                          10. Deploy Docs (main only)     │
│                                      ↓                    │
│                          11. Release (tags only)         │
└─────────────────────────────────────────────────────────┘
```

## 📋 Pipeline Jobs

### Job 1: Code Quality & Linting
**Purpose**: Ensure code meets quality standards

**Steps**:
- Checkout code
- Set up Python 3.12
- Install dependencies
- Run Ruff format check
- Run Ruff linting
- Run mypy type checking (strict mode)

**Duration**: ~45 seconds
**Fail Conditions**: Format violations, linting errors, type errors

### Job 2: Security Scanning
**Purpose**: Identify security vulnerabilities

**Steps**:
- Checkout code
- Set up Python 3.12
- Install security tools (bandit, safety, pip-audit, pip-licenses)
- Run Bandit static analysis
- Run Safety dependency check
- Run pip-audit CVE scanning
- Generate license report
- Upload security reports as artifacts

**Duration**: ~1 minute
**Fail Conditions**: Critical/high vulnerabilities (continues on medium/low)

**Artifacts Generated**:
- `bandit-report.json` / `bandit-report.txt`
- `safety-report.json` / `safety-report.txt`
- `pip-audit-report.json` / `pip-audit-report.md`
- `licenses.json` / `licenses.md` / `licenses.html`

### Job 3: Unit Tests
**Purpose**: Validate functionality across Python versions

**Matrix Strategy**: Python 3.10, 3.11, 3.12

**Steps**:
- Checkout code
- Set up Python (matrix version)
- Install dependencies
- Run unit tests (client, models, API)
- Run security tests
- Generate JUnit XML reports
- Upload test results

**Duration**: ~50 seconds per version
**Fail Conditions**: Any test failure

**Artifacts Generated**:
- `junit-{version}.xml`
- `junit-security-{version}.xml`

### Job 4: Coverage Report
**Purpose**: Measure test coverage

**Steps**:
- Checkout code
- Set up Python 3.12
- Install dependencies
- Run tests with coverage tracking
- Generate coverage badge
- Generate markdown coverage report
- Upload to Codecov
- Upload coverage reports

**Duration**: ~1 minute
**Fail Conditions**: Coverage below 85% (warning only)

**Artifacts Generated**:
- `htmlcov/` directory (HTML report)
- `coverage.xml` (Cobertura format)
- `coverage.json` (JSON format)
- `coverage.svg` (badge)
- `coverage-report.md` (markdown)

### Job 5: Container Build
**Purpose**: Build and test unified Podman container image

**Dependencies**: code-quality, unit-tests

**Steps**:
- Checkout code
- Set up container build tools
- Build unified container image (multi-stage: Node.js frontend + Python backend)
- Load image for testing
- Start container on port 8080
- Test health endpoint (/api/health)
- Test frontend accessibility (/)
- Stop container

**Duration**: ~2 minutes
**Fail Conditions**: Build failure, health check failure

### Job 6: Integration Tests
**Purpose**: Test complete system end-to-end

**Dependencies**: container-build

**Steps**:
- Checkout code
- Set up Python 3.12
- Install dependencies
- Start services with podman-compose
- Wait for API readiness
- Run integration tests
- Upload container logs on failure
- Stop services

**Duration**: ~1.5 minutes
**Fail Conditions**: Integration test failure

### Job 7: SBOM Generation
**Purpose**: Generate Software Bill of Materials

**Dependencies**: container-build

**Steps**:
- Checkout code
- Install Syft
- Set up Python 3.12
- Install dependencies
- Generate SPDX SBOM
- Generate CycloneDX SBOM
- Upload SBOM artifacts
- Scan for vulnerabilities with Grype

**Duration**: ~40 seconds
**Fail Conditions**: High/critical vulnerabilities (continues on lower)

**Artifacts Generated**:
- `source_sbom.json` (SPDX format)
- `source_cyclonedx.json` (CycloneDX format)

### Job 8: Build Documentation
**Purpose**: Build MkDocs documentation site

**Steps**:
- Checkout code
- Set up Python 3.12
- Install MkDocs Material
- Build documentation (strict mode)
- Upload documentation site

**Duration**: ~30 seconds
**Fail Conditions**: Build errors, broken links

**Artifacts Generated**:
- `site/` directory (HTML documentation)

### Job 9: Generate Reports
**Purpose**: Convert CI/CD artifacts to documentation

**Dependencies**: coverage, security, unit-tests

**Steps**:
- Checkout code
- Download coverage reports
- Download security reports
- Download test results
- Set up Python 3.12
- Install report generation tools
- Generate test report markdown
- Generate coverage report markdown
- Generate security report markdown
- Generate license report markdown
- Generate CI/CD summary
- Upload report documentation

**Duration**: ~1 minute
**Fail Conditions**: None (continues on error)

**Artifacts Generated**:
- `test-report.md`
- `coverage-report.md`
- `security-report.md`
- `license-report.md`
- `ci-cd.md`

### Job 10: Deploy Documentation
**Purpose**: Deploy docs to GitHub Pages

**Dependencies**: docs, integration-tests, generate-reports
**Conditions**: Only on main branch pushes

**Steps**:
- Checkout code (full history)
- Download report documentation
- Download coverage reports
- Set up Python 3.12
- Install MkDocs Material
- Configure Git user
- Deploy to GitHub Pages

**Duration**: ~45 seconds
**Fail Conditions**: Deployment failure

### Job 11: Create Release
**Purpose**: Create GitHub release with artifacts

**Dependencies**: integration-tests, sbom, generate-reports
**Conditions**: Only on version tags (v*)

**Steps**:
- Checkout code
- Download all artifacts
- Create GitHub release
- Attach SBOM files
- Attach coverage reports
- Attach security reports
- Generate release notes

**Duration**: ~30 seconds
**Fail Conditions**: Release creation failure

## 🎯 Pipeline Triggers

### Automatic Triggers

| Event | Branches | Jobs Run |
|-------|----------|----------|
| **Push** | main, develop | All 11 jobs |
| **Pull Request** | main, develop | Jobs 1-9 (no deploy) |
| **Tag Push** | v* | All jobs + release |
| **Manual Dispatch** | Any branch | All jobs |

### Scheduled Triggers

| Schedule | Action | Purpose |
|----------|--------|---------|
| Daily 00:00 UTC | Full pipeline | Catch dependency issues |
| Weekly Monday | Security scan | Comprehensive audit |

## 📊 Pipeline Metrics

### Performance Metrics

| Metric | Value | Target | Status |
|--------|-------|--------|--------|
| Total Runtime | ~8 min | < 10 min | ✅ |
| Code Quality | 45s | < 1 min | ✅ |
| Security Scan | 1 min | < 2 min | ✅ |
| Unit Tests | 50s | < 1 min | ✅ |
| Coverage | 1 min | < 2 min | ✅ |
| Container Build | 2 min | < 3 min | ✅ |
| Integration | 1.5 min | < 2 min | ✅ |
| SBOM | 40s | < 1 min | ✅ |
| Docs Build | 30s | < 1 min | ✅ |
| Report Gen | 1 min | < 2 min | ✅ |

### Reliability Metrics

| Metric | Value | Target | Status |
|--------|-------|--------|--------|
| Success Rate | 98.5% | > 95% | ✅ |
| Mean Time to Run | 8.2 min | < 10 min | ✅ |
| Failure Rate | 1.5% | < 5% | ✅ |
| Flaky Tests | 0 | 0 | ✅ |

### Historical Performance

| Date | Runtime | Success Rate | Failures |
|------|---------|--------------|----------|
| 2025-12-02 | 8.1 min | 100% | 0 |
| 2025-12-01 | 8.3 min | 100% | 0 |
| 2025-11-30 | 8.0 min | 97% | 1 |
| 2025-11-29 | 8.5 min | 100% | 0 |
| 2025-11-28 | 7.8 min | 100% | 0 |

## 🔧 Pipeline Configuration

### Environment Variables

```yaml
PYTHON_VERSION: '3.12'
NODE_VERSION: '20'
REPORTS_DIR: 'docs/reports'
```

### Matrix Strategies

**Python Version Matrix**:
```yaml
python-version: ['3.10', '3.11', '3.12']
```

### Caching Strategy

| Cache Type | Key | Paths |
|-----------|-----|-------|
| pip | OS + Python version + requirements | `~/.cache/pip` |
| npm | OS + package-lock.json | `~/.npm` |
| Podman layers | GitHub Actions cache | Build context |

## 📦 Artifact Management

### Artifact Retention

| Artifact Type | Retention | Size |
|--------------|-----------|------|
| Test results | 30 days | ~100 KB |
| Coverage reports | 30 days | ~2 MB |
| Security reports | 90 days | ~500 KB |
| SBOM files | 90 days | ~1 MB |
| Documentation | N/A (deployed) | ~15 MB |

### Artifact Access

**Download Artifacts**:
1. Navigate to [Actions page](https://github.com/yourusername/msn-weather-wrapper/actions)
2. Select workflow run
3. Scroll to "Artifacts" section
4. Click artifact name to download

## 🚨 Failure Handling

### Failure Modes

| Failure Type | Behavior | Notification |
|-------------|----------|------------|
| Code quality | Pipeline fails | ❌ Commit status |
| Unit tests | Pipeline fails | ❌ Commit status |
| Security (critical) | Pipeline fails | 🚨 Email + status |
| Security (medium) | Warning only | ⚠️ Status |
| Integration tests | Pipeline fails | ❌ Commit status |
| Container build | Pipeline fails | ❌ Commit status |

### Continue-on-Error Jobs

These jobs don't fail the pipeline:
- Security scanning (medium/low severity)
- SBOM vulnerability scanning
- Report generation
- Codecov upload

## 🔐 Secrets Management

### Required Secrets

| Secret | Purpose | Scope |
|--------|---------|-------|
| `GITHUB_TOKEN` | GitHub API access | Auto-generated |
| `CODECOV_TOKEN` | Coverage upload | Optional |

### No Additional Secrets Required
All operations use GitHub's built-in authentication.

## 📈 Quality Gates

Pipeline will fail if:

| Gate | Threshold | Action |
|------|-----------|--------|
| Tests failing | Any test | ❌ Fail |
| Coverage | < 85% | ⚠️ Warning |
| Type errors | Any error | ❌ Fail |
| Format violations | Any violation | ❌ Fail |
| Critical vulnerabilities | Any found | ❌ Fail |
| High vulnerabilities | Any found | ❌ Fail |
| Container build | Build failure | ❌ Fail |

## 🔗 Integration Points

### External Services

| Service | Purpose | Status |
|---------|---------|--------|
| GitHub Actions | CI/CD runtime | ✅ Active |
| GitHub Pages | Documentation hosting | ✅ Active |
| Codecov | Coverage tracking | ✅ Active |
| GHCR | Container registry (Podman) | ✅ Active |

### Webhooks & Notifications

- GitHub commit status checks
- PR comments (on failure)
- Release notifications

## 📝 Pipeline as Code

### Workflow Location
`.github/workflows/ci.yml`

### Additional Workflows
- `.github/workflows/podman.yml` - Podman container build & push
- `.github/workflows/dependencies.yml` - Dependency updates
- `.github/workflows/performance.yml` - Performance testing

## 🔗 Related Documentation

- [Test Report](test-report.md)
- [Coverage Report](coverage-report.md)
- [Security Report](security-report.md)
- [License Report](license-report.md)
- [SBOM Guide](../SYFT_GUIDE.md)

---

*Documentation generated from CI/CD pipeline configuration*
*Last Updated: December 2, 2025 20:10:00 UTC*
*Pipeline Version: 2.0*
*GitHub Actions Runner: ubuntu-latest*
