## Description

<!-- Provide a brief description of the changes in this PR -->

## Type of Change

<!-- Check all that apply -->

- [ ] 🐛 Bug fix (non-breaking change which fixes an issue)
- [ ] ✨ New feature (non-breaking change which adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📝 Documentation update
- [ ] 🎨 Code style update (formatting, renaming)
- [ ] ♻️ Code refactoring (no functional changes)
- [ ] ⚡ Performance improvement
- [ ] ✅ Test update
- [ ] 🔧 Build/CI configuration change
- [ ] 🔒 Security fix

## Related Issue

<!-- Link to related issue(s) -->
Fixes #(issue number)

## Changes Made

<!-- List the specific changes made in this PR -->

-
-
-

## Testing

<!-- Describe the tests you ran and how to reproduce -->

- [ ] All existing tests pass (`pytest`)
- [ ] Added new tests for new functionality
- [ ] Frontend tests pass (`npm test` in frontend/)
- [ ] Integration tests pass
- [ ] Manual testing performed

### Test Evidence

<!-- Paste test output or screenshots showing tests passing -->

```
# Paste relevant test output here
```

## Checklist

<!-- Check all that apply before requesting review -->

- [ ] My code follows the project's style guidelines (ruff, mypy)
- [ ] I have performed a self-review of my code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings or errors
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes
- [ ] Any dependent changes have been merged and published
- [ ] I have updated the CHANGELOG.md (if applicable)
- [ ] I have used conventional commit messages (`feat:`, `fix:`, etc.)

## Screenshots/Demo

<!-- If applicable, add screenshots or GIFs to demonstrate the changes -->

## Additional Context

<!-- Add any other context about the PR here -->

## Deployment Notes

<!-- Any special deployment considerations? -->

## Reviewer Notes

<!-- Any specific areas you'd like reviewers to focus on? -->
