"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DbVault = exports.DbVaultProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const hbr_generated_1 = require("./hbr.generated");
Object.defineProperty(exports, "DbVaultProperty", { enumerable: true, get: function () { return hbr_generated_1.RosDbVault; } });
/**
 * A ROS resource type:  `ALIYUN::HBR::DbVault`
 */
class DbVault extends ros.Resource {
    /**
     * Create a new `ALIYUN::HBR::DbVault`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDbVault = new hbr_generated_1.RosDbVault(this, id, {
            description: props.description,
            vaultName: props.vaultName,
            retentionDays: props.retentionDays,
            vaultRegionId: props.vaultRegionId,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDbVault;
        this.attrDescription = rosDbVault.attrDescription;
        this.attrRetentionDays = rosDbVault.attrRetentionDays;
        this.attrVaultId = rosDbVault.attrVaultId;
        this.attrVaultName = rosDbVault.attrVaultName;
        this.attrVaultRegionId = rosDbVault.attrVaultRegionId;
    }
}
exports.DbVault = DbVault;
//# sourceMappingURL=data:application/json;base64,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