window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"phml": {"fullname": "phml", "modulename": "phml", "kind": "module", "doc": "<p>Python Hypertext Markup Language (phml)</p>\n\n<p><img src=\"assets/badges/version.svg\" alt=\"version\" /> <a href=\"https://github.com/Tired-Fox/phml/blob/main/LICENSE\"><img src=\"https://img.shields.io/badge/License-MIT-9cf\" alt=\"License\" /></a> <a href=\"https://github.com/tired-fox/phml\" title=\"Go to GitHub repo\"><img src=\"https://img.shields.io/static/v1?label=tired-fox&amp;message=phml&amp;color=9cf&amp;logo=github\" alt=\"tired-fox - phml\" /></a>\n<a href=\"https://github.com/tired-fox/phml\"><img src=\"https://img.shields.io/github/stars/tired-fox/phml?style=social\" alt=\"stars - phml\" /></a>\n<a href=\"https://github.com/tired-fox/phml\"><img src=\"https://img.shields.io/github/forks/tired-fox/phml?style=social\" alt=\"forks - phml\" /></a></p>\n\n<h1 id=\"python-hypertext-markup-language-phml\">Python Hypertext Markup Language (phml)</h1>\n\n<p><a href=\"https://github.com/Tired-Fox/phml/actions/workflows/deploy_docs.yml\"><img src=\"https://github.com/Tired-Fox/phml/actions/workflows/deploy_docs.yml/badge.svg\" alt=\"Deploy Docs\" /></a> <a href=\"https://github.com/tired-fox/phml/releases/\"><img src=\"https://img.shields.io/github/release/tired-fox/phml?include_prereleases=&amp;sort=semver&amp;color=brightgreen\" alt=\"GitHub release\" /></a> \n<a href=\"https://github.com/tired-fox/phml/issues\"><img src=\"https://img.shields.io/github/issues/tired-fox/phml\" alt=\"issues - phml\" /></a> <img src=\"assets/badges/quality.svg\" alt=\"quality\" /> <img src=\"assets/badges/testing.svg\" alt=\"testing\" /> <img src=\"assets/badges/test_cov.svg\" alt=\"test coverage\" /></p>\n\n<p><strong>TOC</strong></p>\n\n<ul>\n<li><a href=\"#python-hypertext-markup-language-phml\">Python Hypertext Markup Language (phml)</a>\n<ul>\n<li><a href=\"#overview\">Overview</a></li>\n<li><a href=\"#how-to-use\">How to use</a></li>\n</ul></li>\n</ul>\n\n<div align=\"center\">\n\n[![view - Documentation](https://img.shields.io/badge/view-Documentation-blue?style=for-the-badge)](https://tired-fox.github.io/phml/phml.html \"Go to project documentation\")\n\n</div>\n\n<h2 id=\"overview\">Overview</h2>\n\n<p>The idea behind the creation of Python in Hypertext Markup Language (phml), is to allow for web page generation with direct access to python. This language pulls directly from frameworks like VueJS. There is conditional rendering, components, python elements, inline/embedded python blocks, and much more. Now let's dive into more about this language.</p>\n\n<p>Let's start with the new <code>python</code> element. Python is a whitespace language. As such phml\nhas the challenge of maintaining the indentation in an appropriate way. With phml, I have made the decision to allow you to have as much leading whitespace as you want as long as the indentation is consistent. This means that indentation is based on the first lines offset. Take this phml example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"o\">&lt;</span><span class=\"n\">python</span><span class=\"o\">&gt;</span>\n    <span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n<span class=\"o\">&lt;/</span><span class=\"n\">python</span><span class=\"o\">&gt;</span>\n</code></pre>\n</div>\n\n<p>This phml python block will adjust the offset so that the python is executed as seen below:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<p>So now we can write python code, now what? You can define functions and variables\nhow you normally would and they are now available to the scope of the entire file.\nTake, for instance, the example from above, the one with <code>py-src=\"urls('youtube')\"</code>.\nYou can define the <code>URL</code> function in the <code>python</code> element and it can be accessed in an element. So the code would look like this:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\ndef URL(link: str) -&gt; str:\n    links = {\n        &quot;youtube&quot;: &quot;https://youtube.com&quot;\n    }\n    if link in links:\n        return links[link]\n    else:\n        return &quot;&quot;\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n\n...\n\n<span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;{URL(&#39;youtube&#39;)}&quot;</span><span class=\"p\">&gt;</span>Youtube<span class=\"p\">&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n\nor\n\n<span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">:href</span><span class=\"o\">=</span><span class=\"s\">&quot;URL(&#39;youtube&#39;)&quot;</span><span class=\"p\">&gt;</span>Youtube<span class=\"p\">&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>phml combines all <code>python</code> elements and treats them as a python file. All local variables and imports are parsed and stored so that they may be accessed later. With that in mind that means you have the full power of the python programming language.</p>\n\n<p>Next up is inline python blocks. These are represented with <code>{}</code>. Any text in-between the brackets will be processed as python. This is mostly useful when you want to inject a value from python. Assume that there is a variable defined in the <code>python</code> element called <code>message</code>\nand it contains <code>Hello World!</code>. Now this variable can be used like this, <code>&lt;p&gt;{ message }&lt;/p&gt;</code>,\nwhich renders to, <code>&lt;p&gt;Hello World!&lt;/p&gt;</code>.</p>\n\n<blockquote>\n  <p>Note:  Inline python blocks are only rendered in a Text element or inside an html attribute.</p>\n</blockquote>\n\n<p>Multiline blocks are a lot like inline python blocks, but they also have some differences.\nYou can do whatever you like inside this block, however if you expect a value to come from the block you must have at least one local variable. The last local variable defined in this block is used at the result/value.</p>\n\n<p>Conditional rendering with <code>py-if</code>, <code>py-elif</code>, and <code>py-else</code> is an extremely helpful tool in phml.\n<code>py-if</code> can be used alone and that the python inside it's value must be truthy for the element to be rendered. <code>py-elif</code> requires an element with a <code>py-if</code> or <code>py-elif</code> attribute immediately before it, and it's condition is rendered the same as <code>py-if</code> but only rendered if a <code>py-if</code> or <code>py-elif</code> first\nfails. <code>py-else</code> requires there to be either a <code>py-if</code> or a <code>py-else</code> immediately before it. It only\nrenders if the previous element's condition fails. If <code>py-elif</code> or <code>py-else</code> is on an element, but\nthe previous element isn't a <code>py-if</code> or <code>py-elif</code> then an exception will occur. Most importantly, the first element in a chain of conditions must be a <code>py-if</code>. For ease of use, instead of writing <code>py-if</code>, <code>py-elif</code>, or <code>py-else</code> can be written as <code>@if</code>, <code>@elif</code>, or <code>@else</code> respectively.</p>\n\n<p>Other than conditions, there is also a built in <code>py-for</code> attribute. Any element with py-for will take a python for-loop expression that will be applied to that element. So if you did something like this:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span> <span class=\"err\">@</span><span class=\"na\">for</span><span class=\"o\">=</span><span class=\"s\">&#39;i in range(3)&#39;</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{i}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The compiled html will be:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>1<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>2<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n        <span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>3<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    <span class=\"p\">&lt;/</span><span class=\"nt\">li</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;/</span><span class=\"nt\">ul</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>The <code>for</code> and <code>:</code> in the for loops condition are optional. So you can combine <code>for</code>, <code>i in range(10)</code>, and <code>:</code> or leave out <code>for</code> and <code>:</code> at your discretion. <code>py-for</code> can also be written as <code>@for</code>.</p>\n\n<p>Python attributes are shortcuts for using inline python blocks in html attributes. Normally, in\nphml, you would inject python logic into an attribute similar to this: <code>src=\"{url('youtube')}\"</code>. If you would like to make the whole attribute value a python expression you may prefix any attribute with a <code>py-</code> or <code>:</code>. This keeps the attribute name the same after the prefix, but tells\nthe parser that the entire value should be processed as python. So the previous example can also be expressed as <code>py-src=\"URL('youtube')\"</code> or <code>:src=\"URL('youtube')\"</code>.</p>\n\n<p>This language also has the ability to convert back to html and json with converting to html having more features. Converting to json is just a json representation of a phml ast. However, converting to html is where the magic happens. The compiler executes python blocks, substitutes components, and processes conditions to create a final html string that is dynamic to its original ast. A user may pass additional kwargs to the compiler to expose additional data to the execution of python blocks. If you wish to compile to a non supported language the compiler can take a callable that returns the final string. It passes all the data; components, kwargs, ast, etc\u2026 So if a user wishes to extend the language thay may.</p>\n\n<blockquote>\n  <p>:warning: This language is in early planning and development stages. All forms of feedback are encouraged.</p>\n</blockquote>\n"}, "phml.builder": {"fullname": "phml.builder", "modulename": "phml.builder", "kind": "module", "doc": "<p>phml.utilities.builder</p>\n\n<p>This module serves as a utility to make building elements and ast's easier.</p>\n"}, "phml.builder.p": {"fullname": "phml.builder.p", "modulename": "phml.builder", "qualname": "p", "kind": "function", "doc": "<p>Generic factory for creating phml nodes.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">selector</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core": {"fullname": "phml.core", "modulename": "phml.core", "kind": "module", "doc": "<p></p>\n"}, "phml.core.compiler": {"fullname": "phml.core.compiler", "modulename": "phml.core.compiler", "kind": "module", "doc": "<p>phml.core.compile</p>\n\n<p>The heavy lifting module that compiles phml ast's to different string/file formats.</p>\n"}, "phml.core.compiler.Compiler": {"fullname": "phml.core.compiler.Compiler", "modulename": "phml.core.compiler", "qualname": "Compiler", "kind": "class", "doc": "<p>Used to compile phml into other formats. HTML, PHML,\nJSON, Markdown, etc...</p>\n"}, "phml.core.compiler.Compiler.__init__": {"fullname": "phml.core.compiler.Compiler.__init__", "modulename": "phml.core.compiler", "qualname": "Compiler.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.compiler.Compiler.ast": {"fullname": "phml.core.compiler.Compiler.ast", "modulename": "phml.core.compiler", "qualname": "Compiler.ast", "kind": "variable", "doc": "<p>phml ast used by the compiler to generate a new format.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.compiler.Compiler.add": {"fullname": "phml.core.compiler.Compiler.add", "modulename": "phml.core.compiler", "qualname": "Compiler.add", "kind": "function", "doc": "<p>Add a component to the compilers component list.</p>\n\n<p>Components passed in can be of a few types. It can also be a dictionary of str\nbeing the name of the element to be replaced. The name can be snake case, camel\ncase, or pascal cased. The value can either be the parsed result of the component\nfrom phml.utilities.parse_component() or the parsed ast of the component. Lastely,\nthe component can be a tuple. The first value is the name of the element to be\nreplaced; with the second value being either the parsed result of the component\nor the component's ast.</p>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.remove": {"fullname": "phml.core.compiler.Compiler.remove", "modulename": "phml.core.compiler", "qualname": "Compiler.remove", "kind": "function", "doc": "<p>Takes either component names or components and removes them\nfrom the dictionary.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>components (str | NODE):</strong>  Any str name of components or</li>\n<li>node value to remove from the components list in the compiler.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.compile": {"fullname": "phml.core.compiler.Compiler.compile", "modulename": "phml.core.compiler", "qualname": "Compiler.compile", "kind": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.compiler.Compiler.render": {"fullname": "phml.core.compiler.Compiler.render", "modulename": "phml.core.compiler", "qualname": "Compiler.render", "kind": "function", "doc": "<p>Execute compilation to a different format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">_ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\tto_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">safe_vars</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.core": {"fullname": "phml.core.core", "modulename": "phml.core.core", "kind": "module", "doc": "<p></p>\n"}, "phml.core.core.PHML": {"fullname": "phml.core.core.PHML", "modulename": "phml.core.core", "qualname": "PHML", "kind": "class", "doc": "<p>A helper class that bundles the functionality\nof the parser and compiler together. Allows for loading source files,\nparsing strings and dicts, rendering to a different format, and finally\nwriting the results of a render to a file.</p>\n"}, "phml.core.core.PHML.__init__": {"fullname": "phml.core.core.PHML.__init__", "modulename": "phml.core.core", "qualname": "PHML.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">contexts</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "phml.core.core.PHML.ast": {"fullname": "phml.core.core.PHML.ast", "modulename": "phml.core.core", "qualname": "PHML.ast", "kind": "variable", "doc": "<p>The parsed ast value.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.core.PHML.components": {"fullname": "phml.core.core.PHML.components", "modulename": "phml.core.core", "qualname": "PHML.components", "kind": "variable", "doc": "<p>The components currently stored in the compiler.</p>\n", "annotation": ": dict"}, "phml.core.core.PHML.expose": {"fullname": "phml.core.core.PHML.expose", "modulename": "phml.core.core", "qualname": "PHML.expose", "kind": "function", "doc": "<p>Add additional data to the compilers global values. These values are exposed for every\ncall to render or write.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.redact": {"fullname": "phml.core.core.PHML.redact", "modulename": "phml.core.core", "qualname": "PHML.redact", "kind": "function", "doc": "<p>Remove a value from the compilers globally exposed values.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.expand": {"fullname": "phml.core.core.PHML.expand", "modulename": "phml.core.core", "qualname": "PHML.expand", "kind": "function", "doc": "<p>Add relative paths to a directory, that you want added to the python path\nfor every time render or write is called.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.restrict": {"fullname": "phml.core.core.PHML.restrict", "modulename": "phml.core.core", "qualname": "PHML.restrict", "kind": "function", "doc": "<p>Remove relative paths to a directory, that are in the compilers globally added scopes.\nThis prevents them from being added to the python path.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.add": {"fullname": "phml.core.core.PHML.add", "modulename": "phml.core.core", "qualname": "PHML.add", "kind": "function", "doc": "<p>Add a component to the compiler's component list.</p>\n\n<p>Components passed in can be of a few types. The first type it can be is a\npathlib.Path type. This will allow for automatic parsing of the file at the\npath and then the filename and parsed ast are passed to the compiler. It can\nalso be a dictionary of str being the name of the element to be replaced.\nThe name can be snake case, camel case, or pascal cased. The value can either\nbe the parsed result of the component from phml.utilities.parse_component() or the\nparsed ast of the component. Lastely, the component can be a tuple. The first\nvalue is the name of the element to be replaced; with the second value being\neither the parsed result of the component or the component's ast.</p>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>Any duplicate components will be replaced.</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>components:</strong>  Any number values indicating</li>\n<li>name of the component and the the component. The name is used</li>\n<li>to replace a element with the tag==name.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.remove": {"fullname": "phml.core.core.PHML.remove", "modulename": "phml.core.core", "qualname": "PHML.remove", "kind": "function", "doc": "<p>Remove an element from the list of element replacements.</p>\n\n<p>Takes any number of strings or node objects. If a string is passed\nit is used as the key that will be removed. If a node object is passed\nit will attempt to find a matching node and remove it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.load": {"fullname": "phml.core.core.PHML.load", "modulename": "phml.core.core", "qualname": "PHML.load", "kind": "function", "doc": "<p>Load a source files data and parse it to phml.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_path (str | Path):</strong>  The file path to the source file.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">from_format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">formats</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"o\">.</span><span class=\"n\">Format</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.parse": {"fullname": "phml.core.core.PHML.parse", "modulename": "phml.core.core", "qualname": "PHML.parse", "kind": "function", "doc": "<p>Parse a str or dict object into phml.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Object to parse to phml</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\tfrom_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.core.PHML.compile": {"fullname": "phml.core.core.PHML.compile", "modulename": "phml.core.core", "qualname": "PHML.compile", "kind": "function", "doc": "<p>Compile the parsed ast into it's fully processed form.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_type (str):</strong>  The format to render to. Currently support html, phml, and json.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>AST: The processed ast. Ast is in the final format of the passed in file_type</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.core.PHML.render": {"fullname": "phml.core.core.PHML.render", "modulename": "phml.core.core", "qualname": "PHML.render", "kind": "function", "doc": "<p>Render the parsed ast to a different format. Defaults to rendering to html.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file_type (str):</strong>  The format to render to. Currently support html, phml, and json.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: The rendered content in the appropriate format.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.core.PHML.write": {"fullname": "phml.core.core.PHML.write", "modulename": "phml.core.core", "qualname": "PHML.write", "kind": "function", "doc": "<p>Renders the parsed ast to a different format, then writes\nit to a given file. Defaults to rendering and writing out as html.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>file (str | Path | TextIOWrapper):</strong>  The path to the file to be written to, or the opened</li>\n<li>file to write to.</li>\n<li><strong>file_type (str):</strong>  The format to render the ast as.</li>\n<li><strong>indent (Optional[int], optional):</strong>  The number of spaces per indent. By default it will</li>\n<li>use the standard for the given format. HTML has 4 spaces, phml has 4 spaces, and json</li>\n<li>has 2 spaces.</li>\n<li><strong>scopes (list[str], None):</strong>  The relative paths from the cwd to the directory that will</li>\n<li>be inserted into the python path.</li>\n<li><strong>replace_suffix (bool):</strong>  Override to use the preferred file suffix no matter what.</li>\n<li>Defaults to False, as the preferred suffix will only be used if no suffix is provided.</li>\n<li><strong>kwargs:</strong>  Any additional data to pass to the compiler that will be exposed to the</li>\n<li>phml files.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"n\">_io</span><span class=\"o\">.</span><span class=\"n\">TextIOWrapper</span>,</span><span class=\"param\">\tfile_type: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">scopes</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">replace_suffix</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats": {"fullname": "phml.core.formats", "modulename": "phml.core.formats", "kind": "module", "doc": "<p>phml.core.formats</p>\n\n<p>A collection of Formats which represent supported file formats. Each format can\nparse data, either string or dict, into a phml.core.nodes.AST along with compiling\na phml.core.nodes.ast into it's corresponding file formats string representation.</p>\n"}, "phml.core.formats.Formats": {"fullname": "phml.core.formats.Formats", "modulename": "phml.core.formats", "qualname": "Formats", "kind": "class", "doc": "<p>Collection of all built-in file formats.</p>\n"}, "phml.core.formats.Formats.__init__": {"fullname": "phml.core.formats.Formats.__init__", "modulename": "phml.core.formats", "qualname": "Formats.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\tPHML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\tHTML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.html_format.HTMLFormat&#x27;&gt;,</span><span class=\"param\">\tJSON: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.json_format.JSONFormat&#x27;&gt;,</span><span class=\"param\">\tXML: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.xml_format.XMLFormat&#x27;&gt;</span>)</span>"}, "phml.core.formats.compile": {"fullname": "phml.core.formats.compile", "modulename": "phml.core.formats.compile", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.compile.compile": {"fullname": "phml.core.formats.compile.compile", "modulename": "phml.core.formats.compile.compile", "kind": "module", "doc": "<p>Helper methods for processing dynamic python attributes and blocks.</p>\n"}, "phml.core.formats.compile.compile.process_reserved_attrs": {"fullname": "phml.core.formats.compile.compile.process_reserved_attrs", "modulename": "phml.core.formats.compile.compile", "qualname": "process_reserved_attrs", "kind": "function", "doc": "<p>Based on the props name, process/translate the props value.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">prop</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_props": {"fullname": "phml.core.formats.compile.compile.process_props", "modulename": "phml.core.formats.compile.compile", "qualname": "process_props", "kind": "function", "doc": "<p>Process props inline python and reserved value translations.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"n\">local_vars</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.apply_conditions": {"fullname": "phml.core.formats.compile.compile.apply_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "apply_conditions", "kind": "function", "doc": "<p>Applys all <code>py-if</code>, <code>py-elif</code>, and <code>py-else</code> to the node\nrecursively.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (Root | Element):</strong>  The node to recursively apply <code>py-</code> attributes too.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  All of the data from the python elements.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_reserved_elements": {"fullname": "phml.core.formats.compile.compile.process_reserved_elements", "modulename": "phml.core.formats.compile.compile", "qualname": "process_reserved_elements", "kind": "function", "doc": "<p>Process all reserved elements and replace them with the results.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.apply_python": {"fullname": "phml.core.formats.compile.compile.apply_python", "modulename": "phml.core.formats.compile.compile", "qualname": "apply_python", "kind": "function", "doc": "<p>Recursively travers the node and search for python blocks. When found\nprocess them and apply the results.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>current (Root | Element):</strong>  The node to traverse</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The python elements data</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">current</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.py_condition": {"fullname": "phml.core.formats.compile.compile.py_condition", "modulename": "phml.core.formats.compile.compile", "qualname": "py_condition", "kind": "function", "doc": "<p>Return all python condition attributes on an element.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.process_conditions": {"fullname": "phml.core.formats.compile.compile.process_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "process_conditions", "kind": "function", "doc": "<p>Process all python condition attributes in the phml tree.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The tree to process conditions on.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The collection of information from the python blocks.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.execute_conditions": {"fullname": "phml.core.formats.compile.compile.execute_conditions", "modulename": "phml.core.formats.compile.compile", "qualname": "execute_conditions", "kind": "function", "doc": "<p>Execute all the conditions. If the condition is a <code>for</code> then generate more nodes.\nAll other conditions determine if the node stays or is removed.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>cond (list[tuple]):</strong>  The list of conditions to apply. Holds tuples of (condition, node).</li>\n<li><strong>children (list):</strong>  List of current nodes children.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The collection of information from the python blocks.</li>\n</ul>\n\n<h6 id=\"raises\">Raises:</h6>\n\n<ul>\n<li><strong>Exception:</strong>  An unkown conditional attribute is being parsed.</li>\n<li><strong>Exception:</strong>  Condition requirements are not met.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list: The newly generated/modified list of children.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">cond</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.build_locals": {"fullname": "phml.core.formats.compile.compile.build_locals", "modulename": "phml.core.formats.compile.compile", "qualname": "build_locals", "kind": "function", "doc": "<p>Build a dictionary of local variables from a nodes inherited locals and\nthe passed kwargs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">child</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_if": {"fullname": "phml.core.formats.compile.compile.run_phml_if", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_if", "kind": "function", "doc": "<p>Run the logic for manipulating the children on a <code>if</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_elif": {"fullname": "phml.core.formats.compile.compile.run_phml_elif", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_elif", "kind": "function", "doc": "<p>Run the logic for manipulating the children on a <code>elif</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.run_phml_else": {"fullname": "phml.core.formats.compile.compile.run_phml_else", "modulename": "phml.core.formats.compile.compile", "qualname": "run_phml_else", "kind": "function", "doc": "<p>Run the logic for manipulating the children on a <code>else</code> condition.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">child</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">variables</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.compile.ASTRenderer": {"fullname": "phml.core.formats.compile.compile.ASTRenderer", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer", "kind": "class", "doc": "<p>Compiles an ast to a hypertext markup language. Compiles to a tag based string.</p>\n"}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"fullname": "phml.core.formats.compile.compile.ASTRenderer.__init__", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">_offset</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span></span>)</span>"}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"fullname": "phml.core.formats.compile.compile.ASTRenderer.compile", "modulename": "phml.core.formats.compile.compile", "qualname": "ASTRenderer.compile", "kind": "function", "doc": "<p>Compile an ast to html.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ast (AST):</strong>  The phml ast to compile.</li>\n<li><strong>offset (int | None):</strong>  The amount to offset for each nested element</li>\n<li><strong>include_doctype (bool):</strong>  Whether to validate for doctype and auto insert if it is</li>\n<li>missing.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">include_doctype</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component": {"fullname": "phml.core.formats.compile.component", "modulename": "phml.core.formats.compile.component", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.compile.component.substitute_component": {"fullname": "phml.core.formats.compile.component.substitute_component", "modulename": "phml.core.formats.compile.component", "qualname": "substitute_component", "kind": "function", "doc": "<p>Replace the first occurance of a component.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (Root | Element | AST):</strong>  The starting point.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  The python state to use while evaluating prop values</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">component</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component.replace_components": {"fullname": "phml.core.formats.compile.component.replace_components", "modulename": "phml.core.formats.compile.component", "qualname": "replace_components", "kind": "function", "doc": "<p>Iterate through components and replace all of each component in the nodes children.\nNon-recursive.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (Root | Element | AST):</strong>  The starting point.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  Temp</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.compile.component.combine_component_elements": {"fullname": "phml.core.formats.compile.component.combine_component_elements", "modulename": "phml.core.formats.compile.component", "qualname": "combine_component_elements", "kind": "function", "doc": "<p>Combine text from elements like python, script, and style.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Element: With tag of element list but with combined text content</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">elements</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.compile.reserved": {"fullname": "phml.core.formats.compile.reserved", "modulename": "phml.core.formats.compile.reserved", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.format": {"fullname": "phml.core.formats.format", "modulename": "phml.core.formats.format", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.format.Format": {"fullname": "phml.core.formats.format.Format", "modulename": "phml.core.formats.format", "qualname": "Format", "kind": "class", "doc": "<p>Base class for built-in file formats. Each sub class contains a <code>parse</code> and\n<code>compile</code> method. The parse method should take a string or dict and return</p>\n"}, "phml.core.formats.format.Format.__init__": {"fullname": "phml.core.formats.format.Format.__init__", "modulename": "phml.core.formats.format", "qualname": "Format.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.format.Format.extension": {"fullname": "phml.core.formats.format.Format.extension", "modulename": "phml.core.formats.format", "qualname": "Format.extension", "kind": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str | list[str]", "default_value": " = &#x27;txt&#x27;"}, "phml.core.formats.format.Format.suffix": {"fullname": "phml.core.formats.format.Format.suffix", "modulename": "phml.core.formats.format", "qualname": "Format.suffix", "kind": "function", "doc": "<p>The prefered extension/suffix for the file format.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.is_format": {"fullname": "phml.core.formats.format.Format.is_format", "modulename": "phml.core.formats.format", "qualname": "Format.is_format", "kind": "function", "doc": "<p>Determine if an extension is of the current format.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">_extension</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.parse": {"fullname": "phml.core.formats.format.Format.parse", "modulename": "phml.core.formats.format", "qualname": "Format.parse", "kind": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"bp\">Ellipsis</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.compile": {"fullname": "phml.core.formats.format.Format.compile", "modulename": "phml.core.formats.format", "qualname": "Format.compile", "kind": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.format.Format.render": {"fullname": "phml.core.formats.format.Format.render", "modulename": "phml.core.formats.format", "qualname": "Format.render", "kind": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format": {"fullname": "phml.core.formats.html_format", "modulename": "phml.core.formats.html_format", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.html_format.parse_markup": {"fullname": "phml.core.formats.html_format.parse_markup", "modulename": "phml.core.formats.html_format", "qualname": "parse_markup", "kind": "function", "doc": "<p>Parse a string as a markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat": {"fullname": "phml.core.formats.html_format.HTMLFormat", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat", "kind": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.html_format.HTMLFormat.__init__": {"fullname": "phml.core.formats.html_format.HTMLFormat.__init__", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.html_format.HTMLFormat.extension": {"fullname": "phml.core.formats.html_format.HTMLFormat.extension", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.extension", "kind": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": list[str]", "default_value": " = [&#x27;html&#x27;, &#x27;htm&#x27;]"}, "phml.core.formats.html_format.HTMLFormat.parse": {"fullname": "phml.core.formats.html_format.HTMLFormat.parse", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.parse", "kind": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat.compile": {"fullname": "phml.core.formats.html_format.HTMLFormat.compile", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.compile", "kind": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.html_format.HTMLFormat.render": {"fullname": "phml.core.formats.html_format.HTMLFormat.render", "modulename": "phml.core.formats.html_format", "qualname": "HTMLFormat.render", "kind": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.json_format": {"fullname": "phml.core.formats.json_format", "modulename": "phml.core.formats.json_format", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.json_format.construct_tree": {"fullname": "phml.core.formats.json_format.construct_tree", "modulename": "phml.core.formats.json_format", "qualname": "construct_tree", "kind": "function", "doc": "<p>Recursivly construct ast from json.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">obj</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.formats.json_format.JSONFormat": {"fullname": "phml.core.formats.json_format.JSONFormat", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat", "kind": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.json_format.JSONFormat.__init__": {"fullname": "phml.core.formats.json_format.JSONFormat.__init__", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.json_format.JSONFormat.extension": {"fullname": "phml.core.formats.json_format.JSONFormat.extension", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.extension", "kind": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;json&#x27;"}, "phml.core.formats.json_format.JSONFormat.parse": {"fullname": "phml.core.formats.json_format.JSONFormat.parse", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.parse", "kind": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.json_format.JSONFormat.render": {"fullname": "phml.core.formats.json_format.JSONFormat.render", "modulename": "phml.core.formats.json_format", "qualname": "JSONFormat.render", "kind": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse": {"fullname": "phml.core.formats.parse", "modulename": "phml.core.formats.parse", "kind": "module", "doc": "<p>Pythonic Hypertext Markup Language (phml) parser.</p>\n"}, "phml.core.formats.parse.parse_hypertest_markup": {"fullname": "phml.core.formats.parse.parse_hypertest_markup", "modulename": "phml.core.formats.parse", "qualname": "parse_hypertest_markup", "kind": "function", "doc": "<p>Parse a string as a hypertest markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.strip_blank_lines": {"fullname": "phml.core.formats.parse.strip_blank_lines", "modulename": "phml.core.formats.parse", "qualname": "strip_blank_lines", "kind": "function", "doc": "<p>Strip the blank lines at the start and end of a list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data_lines</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.strip": {"fullname": "phml.core.formats.parse.strip", "modulename": "phml.core.formats.parse", "qualname": "strip", "kind": "function", "doc": "<p>This function takes a possibly mutliline string and strips leading and trailing\nblank lines. Given the current position it will also calculate the line and column\ntaht the data ends at.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">cur_tags</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.RE": {"fullname": "phml.core.formats.parse.RE", "modulename": "phml.core.formats.parse", "qualname": "RE", "kind": "class", "doc": "<p></p>\n"}, "phml.core.formats.parse.RE.__init__": {"fullname": "phml.core.formats.parse.RE.__init__", "modulename": "phml.core.formats.parse", "qualname": "RE.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.parse.RE.tag_start": {"fullname": "phml.core.formats.parse.RE.tag_start", "modulename": "phml.core.formats.parse", "qualname": "RE.tag_start", "kind": "variable", "doc": "<p>Matches the start of a tag <code>&lt;!name|&lt;/name|&lt;name</code></p>\n", "default_value": " = re.compile(&#x27;&lt;(?!!--)(?P&lt;opening&gt;!|\\\\/)?(?P&lt;name&gt;([\\\\w:\\\\.]+\\\\-?)+)|&lt;(?P&lt;opening2&gt;/)?(?=\\\\s+&gt;|&gt;)&#x27;)"}, "phml.core.formats.parse.RE.tag_end": {"fullname": "phml.core.formats.parse.RE.tag_end", "modulename": "phml.core.formats.parse", "qualname": "RE.tag_end", "kind": "variable", "doc": "<p>Matches the end of a tag <code>/&gt;|&gt;</code>.</p>\n", "default_value": " = re.compile(&#x27;(?P&lt;closing&gt;/?)&gt;&#x27;)"}, "phml.core.formats.parse.RE.comment": {"fullname": "phml.core.formats.parse.RE.comment", "modulename": "phml.core.formats.parse", "qualname": "RE.comment", "kind": "variable", "doc": "<p>Matches all html style comments <code>&lt;!--Comment--&gt;</code>.</p>\n", "default_value": " = re.compile(&#x27;&lt;!--((?:.|\\\\s)*)--&gt;&#x27;)"}, "phml.core.formats.parse.RE.attribute": {"fullname": "phml.core.formats.parse.RE.attribute", "modulename": "phml.core.formats.parse", "qualname": "RE.attribute", "kind": "variable", "doc": "<p>Matches a tags attributes <code>attr|attr=value|attr='value'|attr=\"value\"</code>.</p>\n", "default_value": " = re.compile(&#x27;(?P&lt;name&gt;[\\\\w:\\\\-@]+)(?:=(?P&lt;value&gt;\\\\{(?P&lt;curly&gt;[^\\\\}]*)\\\\/\\\\}|\\\\&quot;(?P&lt;double&gt;[^\\\\&quot;]*)\\\\&quot;|\\&#x27;(?P&lt;single&gt;[^\\&#x27;]*)\\&#x27;|(?P&lt;open&gt;[^&gt;\\&#x27;\\\\&quot;]+)))?&#x27;)"}, "phml.core.formats.parse.HypertextMarkupParser": {"fullname": "phml.core.formats.parse.HypertextMarkupParser", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser", "kind": "class", "doc": "<p>Parse html/xml like source code strings.</p>\n"}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.__init__", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.tag_stack", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.tag_stack", "kind": "variable", "doc": "<p>Current stack of tags in order of when they are opened.</p>\n", "default_value": " = []"}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.is_self_closing", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.is_self_closing", "kind": "function", "doc": "<p>Check if the tag is self closing. Only check if auto_closing is toggled on.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_closing</span><span class=\"p\">:</span> <span class=\"nb\">bool</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"fullname": "phml.core.formats.parse.HypertextMarkupParser.parse", "modulename": "phml.core.formats.parse", "qualname": "HypertextMarkupParser.parse", "kind": "function", "doc": "<p>Parse a given html or phml string into it's corresponding phml ast.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>source (str):</strong>  The html or phml source to parse.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>AST: A phml AST representing the parsed code source.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format": {"fullname": "phml.core.formats.phml_format", "modulename": "phml.core.formats.phml_format", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.phml_format.parse_markup": {"fullname": "phml.core.formats.phml_format.parse_markup", "modulename": "phml.core.formats.phml_format", "qualname": "parse_markup", "kind": "function", "doc": "<p>Parse a string as a markup document.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">class_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat": {"fullname": "phml.core.formats.phml_format.PHMLFormat", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat", "kind": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"fullname": "phml.core.formats.phml_format.PHMLFormat.__init__", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.phml_format.PHMLFormat.extension": {"fullname": "phml.core.formats.phml_format.PHMLFormat.extension", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.extension", "kind": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;phml&#x27;"}, "phml.core.formats.phml_format.PHMLFormat.parse": {"fullname": "phml.core.formats.phml_format.PHMLFormat.parse", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.parse", "kind": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat.compile": {"fullname": "phml.core.formats.phml_format.PHMLFormat.compile", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.compile", "kind": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.phml_format.PHMLFormat.render": {"fullname": "phml.core.formats.phml_format.PHMLFormat.render", "modulename": "phml.core.formats.phml_format", "qualname": "PHMLFormat.render", "kind": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">4</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format": {"fullname": "phml.core.formats.xml_format", "modulename": "phml.core.formats.xml_format", "kind": "module", "doc": "<p></p>\n"}, "phml.core.formats.xml_format.XMLFormat": {"fullname": "phml.core.formats.xml_format.XMLFormat", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat", "kind": "class", "doc": "<p>Logic for parsing and compiling html files.</p>\n", "bases": "phml.core.formats.format.Format"}, "phml.core.formats.xml_format.XMLFormat.__init__": {"fullname": "phml.core.formats.xml_format.XMLFormat.__init__", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.formats.xml_format.XMLFormat.extension": {"fullname": "phml.core.formats.xml_format.XMLFormat.extension", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.extension", "kind": "variable", "doc": "<p>The extension or extensions for the file format. When writing to a file and\nextensions is a list then the first extensions in the list is used for the file\nextension.</p>\n", "annotation": ": str", "default_value": " = &#x27;xml&#x27;"}, "phml.core.formats.xml_format.XMLFormat.parse": {"fullname": "phml.core.formats.xml_format.XMLFormat.parse", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.parse", "kind": "function", "doc": "<p>Parse the given data into a phml.core.nodes.AST.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format.XMLFormat.compile": {"fullname": "phml.core.formats.xml_format.XMLFormat.compile", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.compile", "kind": "function", "doc": "<p>Compile and process the given ast and return the resulting ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>:</span></span>", "funcdef": "def"}, "phml.core.formats.xml_format.XMLFormat.render": {"fullname": "phml.core.formats.xml_format.XMLFormat.render", "modulename": "phml.core.formats.xml_format", "qualname": "XMLFormat.render", "kind": "function", "doc": "<p>Compile the given phml.core.nodes.AST into string of a given format.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">cls</span>,</span><span class=\"param\">\t<span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">components</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes": {"fullname": "phml.core.nodes", "modulename": "phml.core.nodes", "kind": "module", "doc": "<p>phml.nodes</p>\n\n<p>All things related to phml node data objects.</p>\n"}, "phml.core.nodes.AST": {"fullname": "phml.core.nodes.AST", "modulename": "phml.core.nodes.AST", "kind": "module", "doc": "<p>Basic node that holds a root node and has basic utilties.</p>\n\n<p>You can check the size of the tree, iterate over the tree, and directly access\nthe children of the root node.</p>\n"}, "phml.core.nodes.AST.AST": {"fullname": "phml.core.nodes.AST.AST", "modulename": "phml.core.nodes.AST", "qualname": "AST", "kind": "class", "doc": "<p>PHML ast.</p>\n\n<p>Contains utility functions that can manipulate the ast.</p>\n"}, "phml.core.nodes.AST.AST.__init__": {"fullname": "phml.core.nodes.AST.AST.__init__", "modulename": "phml.core.nodes.AST", "qualname": "AST.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">tree</span></span>)</span>"}, "phml.core.nodes.AST.AST.size": {"fullname": "phml.core.nodes.AST.AST.size", "modulename": "phml.core.nodes.AST", "qualname": "AST.size", "kind": "variable", "doc": "<p>Get the number of nodes in the ast tree.</p>\n", "annotation": ": int"}, "phml.core.nodes.AST.AST.children": {"fullname": "phml.core.nodes.AST.AST.children", "modulename": "phml.core.nodes.AST", "qualname": "AST.children", "kind": "variable", "doc": "<p>Get access to the ast roots children.\nIs none if there is no root.</p>\n", "annotation": ": list"}, "phml.core.nodes.nodes": {"fullname": "phml.core.nodes.nodes", "modulename": "phml.core.nodes.nodes", "kind": "module", "doc": "<p></p>\n"}, "phml.core.nodes.nodes.Element": {"fullname": "phml.core.nodes.nodes.Element", "modulename": "phml.core.nodes.nodes", "qualname": "Element", "kind": "class", "doc": "<p>Element (Parent) represents an Element ([DOM]).</p>\n\n<p>A tagName field must be present. It represents the element's local name ([DOM]).</p>\n\n<p>The properties field represents information associated with the element.\nThe value of the properties field implements the Properties interface.</p>\n\n<p>If the tagName field is 'template', a content field can be present. The value\nof the content field implements the Root interface.</p>\n\n<p>If the tagName field is 'template', the element must be a leaf.</p>\n\n<p>If the tagName field is 'noscript', its children should be represented as if\nscripting is disabled ([HTML]).</p>\n\n<p>For example, the following HTML:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">a</span> <span class=\"na\">href</span><span class=\"o\">=</span><span class=\"s\">&quot;https://alpha.com&quot;</span> <span class=\"na\">class</span><span class=\"o\">=</span><span class=\"s\">&quot;bravo&quot;</span> <span class=\"na\">download</span><span class=\"p\">&gt;&lt;/</span><span class=\"nt\">a</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">href</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;https://alpha.com&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">className</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[</span><span class=\"s1\">&#39;bravo&#39;</span><span class=\"p\">],</span><span class=\"w\"></span>\n<span class=\"w\">        </span><span class=\"nx\">download</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"kc\">true</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"p\">},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Parent"}, "phml.core.nodes.nodes.Element.__init__": {"fullname": "phml.core.nodes.nodes.Element.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Element.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;element&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">startend</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span>)</span>"}, "phml.core.nodes.nodes.Element.start_tag": {"fullname": "phml.core.nodes.nodes.Element.start_tag", "modulename": "phml.core.nodes.nodes", "qualname": "Element.start_tag", "kind": "function", "doc": "<p>Builds the open/start tag for the element.</p>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>It will return <code>/&gt;</code> if the tag is self closing.</p>\n</blockquote>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: Built element start tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Element.end_tag": {"fullname": "phml.core.nodes.nodes.Element.end_tag", "modulename": "phml.core.nodes.nodes", "qualname": "Element.end_tag", "kind": "function", "doc": "<p>Build the elements end tag.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: Built element end tag.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Root": {"fullname": "phml.core.nodes.nodes.Root", "modulename": "phml.core.nodes.nodes", "qualname": "Root", "kind": "class", "doc": "<p>Root (Parent) represents a document.</p>\n\n<p>Root can be used as the root of a tree, or as a value\nof the content field on a 'template' Element, never as a child.</p>\n", "bases": "Parent"}, "phml.core.nodes.nodes.Root.__init__": {"fullname": "phml.core.nodes.nodes.Root.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Root.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Node": {"fullname": "phml.core.nodes.nodes.Node", "modulename": "phml.core.nodes.nodes", "qualname": "Node", "kind": "class", "doc": "<p>All node values can be expressed in JSON as: string, number,\nobject, array, true, false, or null. This means that the syntax tree should\nbe able to be converted to and from JSON and produce the same tree.\nFor example, in JavaScript, a tree can be passed through JSON.parse(JSON.phml(tree))\nand result in the same tree.</p>\n"}, "phml.core.nodes.nodes.Node.__init__": {"fullname": "phml.core.nodes.nodes.Node.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Node.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Node.position": {"fullname": "phml.core.nodes.nodes.Node.position", "modulename": "phml.core.nodes.nodes", "qualname": "Node.position", "kind": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.core.nodes.nodes.Position"}, "phml.core.nodes.nodes.Node.type": {"fullname": "phml.core.nodes.nodes.Node.type", "modulename": "phml.core.nodes.nodes", "qualname": "Node.type", "kind": "variable", "doc": "<p>Non-empty string representing the variant of a node.\nThis field can be used to determine the type a node implements.</p>\n", "annotation": ": str"}, "phml.core.nodes.nodes.DocType": {"fullname": "phml.core.nodes.nodes.DocType", "modulename": "phml.core.nodes.nodes", "qualname": "DocType", "kind": "class", "doc": "<p>Doctype (Node) represents a DocumentType ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cp\">&lt;!doctype html&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;doctype&#39;</span><span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Node"}, "phml.core.nodes.nodes.DocType.__init__": {"fullname": "phml.core.nodes.nodes.DocType.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "DocType.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">lang</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.DocType.stringify": {"fullname": "phml.core.nodes.nodes.DocType.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "DocType.stringify", "kind": "function", "doc": "<p>Build indented html string of html doctype element.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: Built html of doctype element</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent": {"fullname": "phml.core.nodes.nodes.Parent", "modulename": "phml.core.nodes.nodes", "qualname": "Parent", "kind": "class", "doc": "<p>Parent (UnistParent) represents a node in hast containing other nodes (said to be children).</p>\n\n<p>Its content is limited to only other hast content.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.Parent.__init__": {"fullname": "phml.core.nodes.nodes.Parent.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">children</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Parent.append": {"fullname": "phml.core.nodes.nodes.Parent.append", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.append", "kind": "function", "doc": "<p>Add a node to the nested children of the current parent node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.extend": {"fullname": "phml.core.nodes.nodes.Parent.extend", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.extend", "kind": "function", "doc": "<p>Add a node to the nested children of the current parent node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">nodes</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.insert": {"fullname": "phml.core.nodes.nodes.Parent.insert", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.insert", "kind": "function", "doc": "<p>Insert a node into a specific position in the current parent node's children.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Parent.remove": {"fullname": "phml.core.nodes.nodes.Parent.remove", "modulename": "phml.core.nodes.nodes", "qualname": "Parent.remove", "kind": "function", "doc": "<p>Remove a specific node from the current parent node's children.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.PI": {"fullname": "phml.core.nodes.nodes.PI", "modulename": "phml.core.nodes.nodes", "qualname": "PI", "kind": "class", "doc": "<p>A processing instruction node. Mainly used for XML.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.PI.__init__": {"fullname": "phml.core.nodes.nodes.PI.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "PI.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tag</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">properties</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.PI.stringify": {"fullname": "phml.core.nodes.nodes.PI.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "PI.stringify", "kind": "function", "doc": "<p>Construct the string representation of the processing instruction node.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Comment": {"fullname": "phml.core.nodes.nodes.Comment", "modulename": "phml.core.nodes.nodes", "qualname": "Comment", "kind": "class", "doc": "<p>Comment (Literal) represents a Comment ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"cm\">&lt;!--Charlie--&gt;</span>\n</code></pre>\n</div>\n", "bases": "Literal"}, "phml.core.nodes.nodes.Comment.stringify": {"fullname": "phml.core.nodes.nodes.Comment.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "Comment.stringify", "kind": "function", "doc": "<p>Build indented html string of html comment.</p>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: Built html of comment</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal": {"fullname": "phml.core.nodes.nodes.Literal", "modulename": "phml.core.nodes.nodes", "qualname": "Literal", "kind": "class", "doc": "<p>Literal (UnistLiteral) represents a node in hast containing a value.</p>\n", "bases": "Node"}, "phml.core.nodes.nodes.Literal.__init__": {"fullname": "phml.core.nodes.nodes.Literal.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">position</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Position</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Literal.position": {"fullname": "phml.core.nodes.nodes.Literal.position", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.position", "kind": "variable", "doc": "<p>The location of a node in a source document.\nThe value of the position field implements the Position interface.\nThe position field must not be present if a node is generated.</p>\n", "annotation": ": phml.core.nodes.nodes.Position"}, "phml.core.nodes.nodes.Literal.value": {"fullname": "phml.core.nodes.nodes.Literal.value", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.value", "kind": "variable", "doc": "<p>The Literal nodes value. All literal values must be strings</p>\n", "annotation": ": str"}, "phml.core.nodes.nodes.Literal.normalized": {"fullname": "phml.core.nodes.nodes.Literal.normalized", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.normalized", "kind": "function", "doc": "<p>Get the normalized indented value with leading and trailing blank lines stripped.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal.stringify": {"fullname": "phml.core.nodes.nodes.Literal.stringify", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.stringify", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Literal.get_ancestry": {"fullname": "phml.core.nodes.nodes.Literal.get_ancestry", "modulename": "phml.core.nodes.nodes", "qualname": "Literal.get_ancestry", "kind": "function", "doc": "<p>Get the ancestry of the literal node.</p>\n\n<p>Used to validate whether there is a <code>pre</code> element in the ancestry.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Point": {"fullname": "phml.core.nodes.nodes.Point", "modulename": "phml.core.nodes.nodes", "qualname": "Point", "kind": "class", "doc": "<p>Represents one place in a source file.</p>\n\n<p>The line field (1-indexed integer) represents a line in a source file. The column field\n(1-indexed integer) represents a column in a source file. The offset field (0-indexed integer)\nrepresents a character in a source file.</p>\n"}, "phml.core.nodes.nodes.Point.__init__": {"fullname": "phml.core.nodes.nodes.Point.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Point.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">int</span>, </span><span class=\"param\"><span class=\"n\">offset</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Position": {"fullname": "phml.core.nodes.nodes.Position", "modulename": "phml.core.nodes.nodes", "qualname": "Position", "kind": "class", "doc": "<p>Position represents the location of a node in a source file.</p>\n\n<p>The <code>start</code> field of <code>Position</code> represents the place of the first character\nof the parsed source region. The <code>end</code> field of Position represents the place\nof the first character after the parsed source region, whether it exists or not.\nThe value of the <code>start</code> and <code>end</code> fields implement the <code>Point</code> interface.</p>\n\n<p>The <code>indent</code> field of <code>Position</code> represents the start column at each index\n(plus start line) in the source region, for elements that span multiple lines.</p>\n\n<p>If the syntactic unit represented by a node is not present in the source file at\nthe time of parsing, the node is said to be <code>generated</code> and it must not have positional\ninformation.</p>\n"}, "phml.core.nodes.nodes.Position.__init__": {"fullname": "phml.core.nodes.nodes.Position.__init__", "modulename": "phml.core.nodes.nodes", "qualname": "Position.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (Point):</strong>  Starting point of the position.</li>\n<li><strong>end (Point):</strong>  End point of the position.</li>\n<li><strong>indent (int | None):</strong>  The indent amount for the start of the position.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Point</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.nodes.nodes.Position.as_dict": {"fullname": "phml.core.nodes.nodes.Position.as_dict", "modulename": "phml.core.nodes.nodes", "qualname": "Position.as_dict", "kind": "function", "doc": "<p>Convert the position object to a dict.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.core.nodes.nodes.Text": {"fullname": "phml.core.nodes.nodes.Text", "modulename": "phml.core.nodes.nodes", "qualname": "Text", "kind": "class", "doc": "<p>Text (Literal) represents a Text ([DOM]).</p>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>Foxtrot<span class=\"p\">&lt;/</span><span class=\"nt\">span</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<p>Yields:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">{</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;element&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">tagName</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">properties</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">{},</span><span class=\"w\"></span>\n<span class=\"w\">    </span><span class=\"nx\">children</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"p\">[{</span><span class=\"nx\">type</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;text&#39;</span><span class=\"p\">,</span><span class=\"w\"> </span><span class=\"nx\">value</span><span class=\"o\">:</span><span class=\"w\"> </span><span class=\"s1\">&#39;Foxtrot&#39;</span><span class=\"p\">}]</span><span class=\"w\"></span>\n<span class=\"p\">}</span><span class=\"w\"></span>\n</code></pre>\n</div>\n", "bases": "Literal"}, "phml.core.nodes.nodes.Text.num_lines": {"fullname": "phml.core.nodes.nodes.Text.num_lines", "modulename": "phml.core.nodes.nodes", "qualname": "Text.num_lines", "kind": "variable", "doc": "<p>Determine the number of lines the text has.</p>\n", "annotation": ": int"}, "phml.core.nodes.types": {"fullname": "phml.core.nodes.types", "modulename": "phml.core.nodes.types", "kind": "module", "doc": "<p>Here is a collection of type annotations</p>\n"}, "phml.core.nodes.types.Properties": {"fullname": "phml.core.nodes.types.Properties", "modulename": "phml.core.nodes.types", "qualname": "Properties", "kind": "variable", "doc": "<p>Properties represents information associated with an element.</p>\n\n<p>Every field must be a PropertyName and every value a PropertyValue.</p>\n", "default_value": " = dict[str, typing.Any]"}, "phml.core.parser": {"fullname": "phml.core.parser", "modulename": "phml.core.parser", "kind": "module", "doc": "<p>phml.core.parser</p>\n\n<p>The core parsing module for phml. Handles parsing html and phmls strings\nalong with json.</p>\n\n<p>Exposes phml.core.parser.Parser which handles all parsing functionality.</p>\n"}, "phml.core.parser.Parser": {"fullname": "phml.core.parser.Parser", "modulename": "phml.core.parser", "qualname": "Parser", "kind": "class", "doc": "<p>Primary logic to handle everything with a phml file.</p>\n\n<p>This class can parse files as phml files and create an ast.\nThe ast and the nodes themselfs can translate themselves to;\nhtml, phml, and json. The ast can recursively return itself as\nan html string. However, only this class can process the python\nblocks inside of the phml file.</p>\n\n<p>Call Parser.convert() and pass any kwargs you wish to be exposed to\nthe process that processes the python. You may also use Parser.util to\npass extensions to convert and manipulate the html along with the python\nprocessing.</p>\n"}, "phml.core.parser.Parser.__init__": {"fullname": "phml.core.parser.Parser.__init__", "modulename": "phml.core.parser", "qualname": "Parser.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">()</span>"}, "phml.core.parser.Parser.ast": {"fullname": "phml.core.parser.Parser.ast", "modulename": "phml.core.parser", "qualname": "Parser.ast", "kind": "variable", "doc": "<p>The recursive node tree of the phml ast.</p>\n", "annotation": ": phml.core.nodes.AST.AST"}, "phml.core.parser.Parser.load": {"fullname": "phml.core.parser.Parser.load", "modulename": "phml.core.parser", "qualname": "Parser.load", "kind": "function", "doc": "<p>Parse a given phml file to AST following hast and unist.</p>\n\n<p>When finished the PHML.ast variable will be populated with the\nresulting ast.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>path (str | Path):</strong>  The path to the file that should be parsed.</li>\n<li><strong>from_format (Format):</strong>  phml.core.formats.Format class that will parse the given source.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span>,</span><span class=\"param\">\t<span class=\"n\">from_format</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">formats</span><span class=\"o\">.</span><span class=\"n\">format</span><span class=\"o\">.</span><span class=\"n\">Format</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.parser.Parser.parse": {"fullname": "phml.core.parser.Parser.parse", "modulename": "phml.core.parser", "qualname": "Parser.parse", "kind": "function", "doc": "<p>Parse data from a phml/html string or from a dict to a phml ast.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>data (str | dict):</strong>  Data to parse in to a ast</li>\n<li><strong>data_type (str):</strong>  Can be <code>HTML</code>, <code>PHML</code>, <code>MARKDOWN</code>, or <code>JSON</code> which</li>\n<li>tells parser how to parse the data. Otherwise it will assume</li>\n<li>str data to be html/phml and dict as <code>json</code>.</li>\n<li><strong>from_format (Format):</strong>  phml.core.formats.Format class that will parse the given source.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\tfrom_format: phml.core.formats.format.Format = &lt;class &#x27;phml.core.formats.phml_format.PHMLFormat&#x27;&gt;,</span><span class=\"param\">\t<span class=\"n\">auto_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.core.virtual_python": {"fullname": "phml.core.virtual_python", "modulename": "phml.core.virtual_python", "kind": "module", "doc": "<p>Virtual Python</p>\n\n<p>This module serves to solve the problem of processing python\nin scopes and to evaluate python expressions.</p>\n\n<p>These expressions and scopes are python \"blocks\" that are injected\ninto html which then creates my language phml.</p>\n\n<p>Here are examples of the python blocks:</p>\n\n<ol>\n<li>Python element. This is treated as python files similarly to how\n<code>&lt;script&gt;</code> elements are treated as javascript files.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n    from datetime import datetime\n\n    current_time = datetime.now().strftime(&#39;%H:%M:%S&#39;)\n<span class=\"p\">&lt;/</span><span class=\"nt\">python</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Inline python block. Mainly used for retreiving values\nor creating conditions. The local variables in the blocks are given\nfrom the python elements and from kwargs passed to the parser</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>{current_time}<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n\n<ol>\n<li>Multiline python blocks. Same as inline python blocks just that they\ntake up multiple lines. You can write more logic in these blocks, but\nthere local variables are not retained. By default phml will return the last\nlocal variable similar to how Jupyter or the python in cli works.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    Hello, everyone my name is {firstname}. I\n    am a {work_position}.\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>Here is a list of people and what they like<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n<span class=\"p\">&lt;</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n    {\n        result = []\n        for i, person, like in enumerate(zip(people, likes)):\n            result.append(f&quot;{i}. {person} likes {like}&quot;)\n        result = &quot;\\n&quot;.join(result)\n    }\n<span class=\"p\">&lt;/</span><span class=\"nt\">p</span><span class=\"p\">&gt;</span>\n</code></pre>\n</div>\n"}, "phml.core.virtual_python.VirtualPython": {"fullname": "phml.core.virtual_python.VirtualPython", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython", "kind": "class", "doc": "<p>Represents a python string. Extracts the imports along\nwith the locals.</p>\n"}, "phml.core.virtual_python.VirtualPython.__init__": {"fullname": "phml.core.virtual_python.VirtualPython.__init__", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">imports</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">context</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span>,</span><span class=\"param\">\t<span class=\"n\">file_name</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.core.virtual_python.VirtualPython.get_python_context": {"fullname": "phml.core.virtual_python.VirtualPython.get_python_context", "modulename": "phml.core.virtual_python", "qualname": "VirtualPython.get_python_context", "kind": "function", "doc": "<p>Get the locals built from the python source code string.\nSplits the def's and classes into their own chunks and passes in\nall other local context to allow for outer scope to be seen in inner scope.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">source</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">context</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.get_python_result": {"fullname": "phml.core.virtual_python.get_python_result", "modulename": "phml.core.virtual_python", "qualname": "get_python_result", "kind": "function", "doc": "<p>Execute the given python expression, while using\nthe kwargs as the global variables.</p>\n\n<p>This will collect the result of the expression and return it.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">expr</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.process_python_blocks": {"fullname": "phml.core.virtual_python.process_python_blocks", "modulename": "phml.core.virtual_python", "qualname": "process_python_blocks", "kind": "function", "doc": "<p>Process a lines python blocks. Use the VirtualPython locals,\nand kwargs as local variables for each python block. Import\nVirtualPython imports in this methods scope.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (str):</strong>  The line to process.</li>\n<li><strong>virtual_python (VirtualPython):</strong>  Parsed locals and imports from all python blocks.</li>\n<li><strong>**kwargs (Any):</strong>  The extra data to pass to the exec function.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: The processed line as str.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">python_value</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">virtual_python</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">vp</span><span class=\"o\">.</span><span class=\"n\">VirtualPython</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">kwargs</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.Import": {"fullname": "phml.core.virtual_python.Import", "modulename": "phml.core.virtual_python", "qualname": "Import", "kind": "class", "doc": "<p>Helper object that stringifies the python ast Import.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.core.virtual_python.import_objects.PythonImport"}, "phml.core.virtual_python.Import.__init__": {"fullname": "phml.core.virtual_python.Import.__init__", "modulename": "phml.core.virtual_python", "qualname": "Import.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">modules</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.core.virtual_python.Import.from_node": {"fullname": "phml.core.virtual_python.Import.from_node", "modulename": "phml.core.virtual_python", "qualname": "Import.from_node", "kind": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}, "phml.core.virtual_python.ImportFrom": {"fullname": "phml.core.virtual_python.ImportFrom", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom", "kind": "class", "doc": "<p>Helper object that stringifies the python ast ImportFrom.\nThis is mainly to locally import things dynamically.</p>\n", "bases": "phml.core.virtual_python.import_objects.PythonImport"}, "phml.core.virtual_python.ImportFrom.__init__": {"fullname": "phml.core.virtual_python.ImportFrom.__init__", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">module</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span>)</span>"}, "phml.core.virtual_python.ImportFrom.from_node": {"fullname": "phml.core.virtual_python.ImportFrom.from_node", "modulename": "phml.core.virtual_python", "qualname": "ImportFrom.from_node", "kind": "function", "doc": "<p>Generates a new import object from a python ast Import.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>imp (ast.Import):</strong>  Python ast object</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Import: A new import object.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">imp</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">virtual_python</span><span class=\"o\">.</span><span class=\"n\">import_objects</span><span class=\"o\">.</span><span class=\"n\">Import</span>:</span></span>", "funcdef": "def"}, "phml.utilities": {"fullname": "phml.utilities", "modulename": "phml.utilities", "kind": "module", "doc": "<p>phml.utilities</p>\n\n<p>This is a collection of utility functions that allow for manipulation, traversal,\nand discovery inside a phml.ast.AST.</p>\n"}, "phml.utilities.locate": {"fullname": "phml.utilities.locate", "modulename": "phml.utilities.locate", "kind": "module", "doc": "<p>utilities.find</p>\n\n<p>Collection of utilities centered around finding nodes in an ast.</p>\n"}, "phml.utilities.locate.find": {"fullname": "phml.utilities.locate.find", "modulename": "phml.utilities.locate.find", "kind": "module", "doc": "<p>phml.utilities.locate.find</p>\n\n<p>Collection of utility methods to find one or many of a specific node.</p>\n"}, "phml.utilities.locate.find.ancestor": {"fullname": "phml.utilities.locate.find.ancestor", "modulename": "phml.utilities.locate.find", "qualname": "ancestor", "kind": "function", "doc": "<p>Get the common ancestor between two nodes.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>*nodes (NODE):</strong>  A list of any number of nodes</li>\n<li>to find the common ancestor form. Worst case it will</li>\n<li>return the root.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Optional[NODE]: The node that is the common\n  ancestor or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">nodes</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find": {"fullname": "phml.utilities.locate.find.find", "modulename": "phml.utilities.locate.find", "qualname": "find", "kind": "function", "doc": "<p>Walk the nodes children and return the desired node.</p>\n\n<p>Returns the first node that matches the condition.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Optional[NODE]: Returns the found node or None if not found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all": {"fullname": "phml.utilities.locate.find.find_all", "modulename": "phml.utilities.locate.find", "qualname": "find_all", "kind": "function", "doc": "<p>Find all nodes that match the condition.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  Starting node.</li>\n<li><strong>condition (Test):</strong>  Condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[NODE]: List of found nodes. Empty if no nodes are found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_after": {"fullname": "phml.utilities.locate.find.find_after", "modulename": "phml.utilities.locate.find", "qualname": "find_after", "kind": "function", "doc": "<p>Get the first sibling node following the provided node that matches\nthe condition.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  Node to get sibling from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Optional[NODE]: Returns the first sibling or None if there\n  are no siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_after": {"fullname": "phml.utilities.locate.find.find_all_after", "modulename": "phml.utilities.locate.find", "qualname": "find_all_after", "kind": "function", "doc": "<p>Get all sibling nodes that match the condition.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  Node to get siblings from.</li>\n<li><strong>condition (Test):</strong>  Condition to check against each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[NODE]: Returns the all siblings that match the\n  condition or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_before": {"fullname": "phml.utilities.locate.find.find_all_before", "modulename": "phml.utilities.locate.find", "qualname": "find_all_before", "kind": "function", "doc": "<p>Find all nodes that come before the given node.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  The node to find all previous siblings from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[NODE]: A list of nodes that come before the given node.\n  Empty list if no nodes were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_before": {"fullname": "phml.utilities.locate.find.find_before", "modulename": "phml.utilities.locate.find", "qualname": "find_before", "kind": "function", "doc": "<p>Find the first sibling node before the given node. If a condition is applied\nthen it will be the first sibling node that passes that condition.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (NODE):</strong>  The node to find the previous sibling from.</li>\n<li><strong>condition (Optional[Test]):</strong>  The test that is applied to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Optional[NODE]: The first node before the given node\n  or None if no prior siblings.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.find.find_all_between": {"fullname": "phml.utilities.locate.find.find_all_between", "modulename": "phml.utilities.locate.find", "qualname": "find_all_between", "kind": "function", "doc": "<p>Find all sibling nodes in parent that meet the provided condition from start index\nto end index.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>parent (Root | Element):</strong>  The parent element to get nodes from.</li>\n<li><strong>start (int, optional):</strong>  The starting index, inclusive. Defaults to 0.</li>\n<li><strong>end (int, optional):</strong>  The ending index, exclusive. Defaults to 0.</li>\n<li><strong>condition (Test, optional):</strong>  Condition to apply to each node. Defaults to None.</li>\n<li><strong>_range (slice, optional):</strong>  Slice to apply to the parent nodes children instead of start and</li>\n<li>end indecies. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[NODE]: List of all matching nodes or an empty list if none were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">end</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"mi\">0</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">_range</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">slice</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index": {"fullname": "phml.utilities.locate.index", "modulename": "phml.utilities.locate.index", "kind": "module", "doc": "<p></p>\n"}, "phml.utilities.locate.index.Index": {"fullname": "phml.utilities.locate.index.Index", "modulename": "phml.utilities.locate.index", "qualname": "Index", "kind": "class", "doc": "<p>Uses the given key or key generator and creates a mutable dict of key value pairs\nthat can be easily indexed.</p>\n\n<p>Nodes that don't match the condition or don't have a valid key are not indexed.</p>\n"}, "phml.utilities.locate.index.Index.__init__": {"fullname": "phml.utilities.locate.index.Index.__init__", "modulename": "phml.utilities.locate.index", "qualname": "Index.__init__", "kind": "function", "doc": "<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong><code>key</code> (str | Callable):</strong>  Str represents the property to use as an index. Callable</li>\n<li>represents a function to call on each element to generate a key. The returned key</li>\n<li>must be able to be converted to a string. If none then element is skipped.</li>\n<li><strong><code>start</code> (AST | Root | Element):</strong>  The root or node to start at while indexing</li>\n<li><strong><code>test</code> (Test):</strong>  The test to apply to each node. Only valid/passing nodes</li>\n<li>will be indexed</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">key</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "phml.utilities.locate.index.Index.indexed_tree": {"fullname": "phml.utilities.locate.index.Index.indexed_tree", "modulename": "phml.utilities.locate.index", "qualname": "Index.indexed_tree", "kind": "variable", "doc": "<p>The indexed collection of elements</p>\n", "annotation": ": dict[str, list[phml.core.nodes.nodes.Element]]"}, "phml.utilities.locate.index.Index.items": {"fullname": "phml.utilities.locate.index.Index.items", "modulename": "phml.utilities.locate.index", "qualname": "Index.items", "kind": "function", "doc": "<p>Get the key value pairs of all indexes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.values": {"fullname": "phml.utilities.locate.index.Index.values", "modulename": "phml.utilities.locate.index", "qualname": "Index.values", "kind": "function", "doc": "<p>Get all the values in the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.keys": {"fullname": "phml.utilities.locate.index.Index.keys", "modulename": "phml.utilities.locate.index", "qualname": "Index.keys", "kind": "function", "doc": "<p>Get all the keys in the collection.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.add": {"fullname": "phml.utilities.locate.index.Index.add", "modulename": "phml.utilities.locate.index", "qualname": "Index.add", "kind": "function", "doc": "<p>Adds element to indexed collection if not already there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.remove": {"fullname": "phml.utilities.locate.index.Index.remove", "modulename": "phml.utilities.locate.index", "qualname": "Index.remove", "kind": "function", "doc": "<p>Removes element from indexed collection if there.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.get": {"fullname": "phml.utilities.locate.index.Index.get", "modulename": "phml.utilities.locate.index", "qualname": "Index.get", "kind": "function", "doc": "<p>Get a specific index from the indexed tree.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_key</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.index.Index.key_by_tag": {"fullname": "phml.utilities.locate.index.Index.key_by_tag", "modulename": "phml.utilities.locate.index", "qualname": "Index.key_by_tag", "kind": "function", "doc": "<p>Builds the key from an elements tag. If the node is not an element\nthen the node's type is returned.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select": {"fullname": "phml.utilities.locate.select", "modulename": "phml.utilities.locate.select", "kind": "module", "doc": "<p>utilities.select</p>\n\n<p>A collection of utilities around querying for specific\ntypes of data.</p>\n"}, "phml.utilities.locate.select.query": {"fullname": "phml.utilities.locate.select.query", "modulename": "phml.utilities.locate.select", "qualname": "query", "kind": "function", "doc": "<p>Same as javascripts querySelector. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return:</h6>\n\n<blockquote>\n  <p>Element | None: The first element matching the specifier or None if no element was\n  found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.query_all": {"fullname": "phml.utilities.locate.select.query_all", "modulename": "phml.utilities.locate.select", "qualname": "query_all", "kind": "function", "doc": "<p>Same as javascripts querySelectorAll. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are accepted are allowed meaning you can\nhave space seperated specifiers indicating nesting or a parent child\nrelationship.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n<li><code>div.form-control input[type=\"checkbox\"]</code> matches the first <code>input</code> with the\nattribute <code>type=\"checked\"</code> that has a parent <code>div</code> with the class <code>form-control</code>.</li>\n</ul>\n\n<h6 id=\"return\">Return:</h6>\n\n<blockquote>\n  <p>list[Element] | None: The all elements matching the specifier or and empty list if no\n  elements were found.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.matches": {"fullname": "phml.utilities.locate.select.matches", "modulename": "phml.utilities.locate.select", "qualname": "matches", "kind": "function", "doc": "<p>Works the same as the Javascript matches. <code>#</code> indicates an id and <code>.</code>\nindicates a class. If they are used alone they match anything.\nAny tag can be used by itself or with <code>#</code> and/or <code>.</code>. You may use\nany number of class specifiers, but may only use one id specifier per\ntag name. Complex specifiers are not supported. Everything in the specifier\nmust relate to one element/tag.</p>\n\n<p>Examles:</p>\n\n<ul>\n<li><code>.some-example</code> matches the first element with the class <code>some-example</code></li>\n<li><code>#some-example</code> matches the first element with the id <code>some-example</code></li>\n<li><code>li</code> matches the first <code>li</code> element</li>\n<li><code>li.red</code> matches the first <code>li</code> with the class <code>red</code></li>\n<li><code>li#red</code> matches the first <code>li</code> with the id <code>red</code></li>\n<li><code>input[type=\"checkbox\"]</code> matches the first <code>input</code> with the attribute <code>type=\"checkbox\"</code></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.locate.select.parse_specifiers": {"fullname": "phml.utilities.locate.select.parse_specifiers", "modulename": "phml.utilities.locate.select", "qualname": "parse_specifiers", "kind": "function", "doc": "<p>Rules:</p>\n\n<ul>\n<li><code>*</code> = any element</li>\n<li><code>&gt;</code> = Everything with certain parent child relationship</li>\n<li><code>+</code> = first sibling</li>\n<li><code>~</code> = All after</li>\n<li><code>.</code> = class</li>\n<li><code>#</code> = id</li>\n<li><code>[attribute]</code> = all elements with attribute</li>\n<li><code>[attribute=value]</code> = all elements with attribute=value</li>\n<li><code>[attribute~=value]</code> = all elements with attribute containing value</li>\n<li><code>[attribute|=value]</code> = all elements with attribute=value or attribute starting with value-</li>\n<li><code>node[attribute^=value]</code> = all elements with attribute starting with value</li>\n<li><code>node[attribute$=value]</code> = all elements with attribute ending with value</li>\n<li><code>node[attribute*=value]</code> = all elements with attribute containing value</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">specifier</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc": {"fullname": "phml.utilities.misc", "modulename": "phml.utilities.misc", "kind": "module", "doc": "<p>phml.utilities.misc</p>\n\n<p>Helpful utilities for different tasks that doesn't have a place in the other categories.</p>\n"}, "phml.utilities.misc.depth": {"fullname": "phml.utilities.misc.depth", "modulename": "phml.utilities.misc", "qualname": "depth", "kind": "function", "doc": "<p>Get the depth in the tree for a given node.</p>\n\n<p>-1 means that you passed in the tree itself and you are at the\nast's root.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.size": {"fullname": "phml.utilities.misc.size", "modulename": "phml.utilities.misc", "qualname": "size", "kind": "function", "doc": "<p>Get the number of nodes recursively.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.offset": {"fullname": "phml.utilities.misc.offset", "modulename": "phml.utilities.misc", "qualname": "offset", "kind": "function", "doc": "<p>Get the leading offset of the first line of the string.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes": {"fullname": "phml.utilities.misc.classes", "modulename": "phml.utilities.misc.classes", "kind": "module", "doc": "<p>utilities.misc</p>\n\n<p>A collection of utilities that don't fit in with finding, selecting, testing,\ntransforming, traveling, or validating nodes.</p>\n"}, "phml.utilities.misc.classes.classnames": {"fullname": "phml.utilities.misc.classes.classnames", "modulename": "phml.utilities.misc.classes", "qualname": "classnames", "kind": "function", "doc": "<p>Concat a bunch of class names. Can take a str as a class,\nint which is cast to a str to be a class, a dict of conditional classes,\nand a list of all the previous conditions including itself.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p>Assume that the current class on node is <code>bold</code></p>\n</blockquote>\n\n<ul>\n<li><code>classnames(node, 'flex')</code> yields <code>'bold flex'</code></li>\n<li><code>classnames(node, 13)</code> yields <code>'bold 13'</code></li>\n<li><code>classnames(node, {'shadow': True, 'border': 0})</code> yields <code>'bold shadow'</code></li>\n<li><code>classnames('a', 13, {'b': True}, ['c', {'d': False}])</code> yields <code>'a b c'</code></li>\n</ul>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (Element | None):</strong>  Node to apply the classes too. If no node is given</li>\n<li>then the function returns a string.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: The concat string of classes after processing.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">conditionals</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">list</span> <span class=\"o\">|</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">bool</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList": {"fullname": "phml.utilities.misc.classes.ClassList", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList", "kind": "class", "doc": "<p>Utility class to manipulate the class list on a node.</p>\n\n<p>Based on the hast-util-class-list:\n<a href=\"https://github.com/brechtcs/hast-util-class-list\">https://github.com/brechtcs/hast-util-class-list</a></p>\n"}, "phml.utilities.misc.classes.ClassList.__init__": {"fullname": "phml.utilities.misc.classes.ClassList.__init__", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span>)</span>"}, "phml.utilities.misc.classes.ClassList.contains": {"fullname": "phml.utilities.misc.classes.ClassList.contains", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.contains", "kind": "function", "doc": "<p>Check if <code>class</code> contains a certain class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">klass</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.toggle": {"fullname": "phml.utilities.misc.classes.ClassList.toggle", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.toggle", "kind": "function", "doc": "<p>Toggle a class in <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.add": {"fullname": "phml.utilities.misc.classes.ClassList.add", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.add", "kind": "function", "doc": "<p>Add one or more classes to <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.replace": {"fullname": "phml.utilities.misc.classes.ClassList.replace", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.replace", "kind": "function", "doc": "<p>Replace a certain class in <code>class</code> with\nanother class.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">old_class</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_class</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.remove": {"fullname": "phml.utilities.misc.classes.ClassList.remove", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.remove", "kind": "function", "doc": "<p>Remove one or more classes from <code>class</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">klasses</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.classes.ClassList.class_list": {"fullname": "phml.utilities.misc.classes.ClassList.class_list", "modulename": "phml.utilities.misc.classes", "qualname": "ClassList.class_list", "kind": "function", "doc": "<p>Return the formatted string of classes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component": {"fullname": "phml.utilities.misc.component", "modulename": "phml.utilities.misc.component", "kind": "module", "doc": "<p></p>\n"}, "phml.utilities.misc.component.tokanize_name": {"fullname": "phml.utilities.misc.component.tokanize_name", "modulename": "phml.utilities.misc.component", "qualname": "tokanize_name", "kind": "function", "doc": "<p>Generates name tokens <code>some name tokanized</code> from a filename.\nAssumes filenames is one of:</p>\n\n<ul>\n<li>snakecase - some_file_name</li>\n<li>camel case - someFileName</li>\n<li>pascal case - SomeFileName</li>\n</ul>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  File name without extension</li>\n<li><strong>normalize (bool):</strong>  Make all tokens fully lowercase. Defaults to True</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[str]: List of word tokens.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">normalize</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.tag_from_file": {"fullname": "phml.utilities.misc.component.tag_from_file", "modulename": "phml.utilities.misc.component", "qualname": "tag_from_file", "kind": "function", "doc": "<p>Generates a tag name some-tag-name from a filename.\nAssumes filenames of:</p>\n\n<ul>\n<li>snakecase - some_file_name</li>\n<li>camel case - someFileName</li>\n<li>pascal case - SomeFileName</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">filename</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.filename_from_path": {"fullname": "phml.utilities.misc.component.filename_from_path", "modulename": "phml.utilities.misc.component", "qualname": "filename_from_path", "kind": "function", "doc": "<p>Get the filename without the suffix from a pathlib.Path.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.parse_component": {"fullname": "phml.utilities.misc.component.parse_component", "modulename": "phml.utilities.misc.component", "qualname": "parse_component", "kind": "function", "doc": "<p>Helper function to parse the components elements.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ast</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.valid_component_dict": {"fullname": "phml.utilities.misc.component.valid_component_dict", "modulename": "phml.utilities.misc.component", "qualname": "valid_component_dict", "kind": "function", "doc": "<p>Check if a component dict is valid.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cmpt</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.component.cmpt_name_from_path": {"fullname": "phml.utilities.misc.component.cmpt_name_from_path", "modulename": "phml.utilities.misc.component", "qualname": "cmpt_name_from_path", "kind": "function", "doc": "<p>Construct a component name given a path. This will include parent directories.\nit will also strip the root directory as this is most commonly not wanted.</p>\n\n<h6 id=\"examples\">Examples:</h6>\n\n<blockquote>\n  <p><code>components/blog/header.phml</code></p>\n  \n  <p>yields</p>\n  \n  <p><code>blog-header</code></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.heading": {"fullname": "phml.utilities.misc.heading", "modulename": "phml.utilities.misc.heading", "kind": "module", "doc": "<p>Utility functions that do something with heading tags.</p>\n"}, "phml.utilities.misc.heading.heading_rank": {"fullname": "phml.utilities.misc.heading.heading_rank", "modulename": "phml.utilities.misc.heading", "qualname": "heading_rank", "kind": "function", "doc": "<p>Get the rank of the heading element.</p>\n\n<h6 id=\"example\">Example:</h6>\n\n<blockquote>\n  <p><code>h2</code> yields <code>2</code></p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.misc.inspect": {"fullname": "phml.utilities.misc.inspect", "modulename": "phml.utilities.misc.inspect", "kind": "module", "doc": "<p>phml.utilities.misc.inspect</p>\n\n<p>Logic to inspect any phml node. Outputs a tree representation\nof the node as a string.</p>\n"}, "phml.utilities.misc.inspect.inspect": {"fullname": "phml.utilities.misc.inspect.inspect", "modulename": "phml.utilities.misc.inspect", "qualname": "inspect", "kind": "function", "doc": "<p>Recursively inspect the passed node or ast.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">2</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.misc.inspect.normalize_indent": {"fullname": "phml.utilities.misc.inspect.normalize_indent", "modulename": "phml.utilities.misc.inspect", "qualname": "normalize_indent", "kind": "function", "doc": "<p>Remove extra prefix whitespace while preserving relative indenting.</p>\n\n<p>Example:\n    <div class=\"pdoc-code codehilite\">\n    <pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n        <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n    </code></pre>\n    </div></p>\n\n<p>becomes</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">if</span> <span class=\"kc\">True</span><span class=\"p\">:</span>\n    <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"s2\">&quot;Hello World&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">text</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform": {"fullname": "phml.utilities.transform", "modulename": "phml.utilities.transform", "kind": "module", "doc": "<p>utilities.transform</p>\n\n<p>A collection of utilities focused around transforming an\nast or a specific nodes.</p>\n"}, "phml.utilities.transform.normalize_indent": {"fullname": "phml.utilities.transform.normalize_indent", "modulename": "phml.utilities.transform", "qualname": "normalize_indent", "kind": "function", "doc": "<p>Normalize the indent between all lines.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>content (str):</strong>  The content to normalize the indent for</li>\n<li><strong>indent (bool):</strong>  The amount of offset to add to each line after normalization.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: The normalized string</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">content</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">indent</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">0</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.extract": {"fullname": "phml.utilities.transform.extract", "modulename": "phml.utilities.transform.extract", "kind": "module", "doc": "<p></p>\n"}, "phml.utilities.transform.extract.to_string": {"fullname": "phml.utilities.transform.extract.to_string", "modulename": "phml.utilities.transform.extract", "qualname": "to_string", "kind": "function", "doc": "<p>Get the raw text content of the element. Works similar to\nthe DOMs Node#textContent getter.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (Root | Element | Text):</strong>  Node to get the text content from</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>str: Raw inner text without formatting.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.sanitize": {"fullname": "phml.utilities.transform.sanitize", "modulename": "phml.utilities.transform.sanitize", "kind": "module", "doc": "<p>phml.utilities.transform.sanatize</p>\n\n<p>Logic for sanatizing a phml ast.</p>\n"}, "phml.utilities.transform.sanitize.sanatize": {"fullname": "phml.utilities.transform.sanitize.sanatize", "modulename": "phml.utilities.transform.sanitize", "qualname": "sanatize", "kind": "function", "doc": "<p>Sanatize elements and attributes in the phml tree. Should be used when using\ndata from an unkown source. It should be used with an AST that has already been\ncompiled to html to no unkown values are unchecked.</p>\n\n<p>By default the sanatization schema uses the github schema and follows the hast\nsanatize utility.</p>\n\n<ul>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize/blob/main/lib/schema.js\">github schema</a></li>\n<li><a href=\"https://github.com/syntax-tree/hast-util-sanitize\">hast sanatize</a></li>\n</ul>\n\n<h6 id=\"note\">Note:</h6>\n\n<blockquote>\n  <p>This utility will edit the tree in place.</p>\n</blockquote>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>tree (AST | Root | Element):</strong>  The root of the tree that will be sanatized.</li>\n<li><strong>schema (Optional[Schema], optional):</strong>  User defined schema. Defaults to github schema.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">schema</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">utilities</span><span class=\"o\">.</span><span class=\"n\">transform</span><span class=\"o\">.</span><span class=\"n\">sanitize</span><span class=\"o\">.</span><span class=\"n\">schema</span><span class=\"o\">.</span><span class=\"n\">Schema</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"n\">Schema</span><span class=\"p\">(</span><span class=\"n\">strip</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;script&#39;</span><span class=\"p\">],</span> <span class=\"n\">ancestors</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;table&#39;</span><span class=\"p\">]},</span> <span class=\"n\">protocols</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mailto&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;xmpp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;irc&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ircs&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;src&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;http&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;https&#39;</span><span class=\"p\">]},</span> <span class=\"n\">tag_names</span><span class=\"o\">=</span><span class=\"p\">[</span><span class=\"s1\">&#39;h1&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h2&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h3&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h4&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h5&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;h6&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;br&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;b&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;i&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strong&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;em&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;a&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;pre&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;code&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sup&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;sub&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;p&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ol&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ul&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;table&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;thead&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tbody&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tfoot&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dl&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;kbd&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;samp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;var&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ruby&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rp&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;td&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;th&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;s&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;strike&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;details&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;caption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figure&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;figcaption&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;bdo&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dfn&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;mark&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;small&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;time&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;wbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">],</span> <span class=\"n\">attributes</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;a&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;href&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;img&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;src&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;longDesc&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">],</span> <span class=\"p\">[</span><span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"kc\">True</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;li&#39;</span><span class=\"p\">:</span> <span class=\"p\">[[</span><span class=\"s1\">&#39;class&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;task-list-item&#39;</span><span class=\"p\">]],</span> <span class=\"s1\">&#39;div&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;itemScope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemType&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;blockquote&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;del&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;ins&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;q&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;cite&#39;</span><span class=\"p\">],</span> <span class=\"s1\">&#39;*&#39;</span><span class=\"p\">:</span> <span class=\"p\">[</span><span class=\"s1\">&#39;abbr&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accept&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;acceptCharset&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;accessKey&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;action&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;align&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;alt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaDescribedBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaHidden&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;ariaLabelledBy&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;axis&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;border&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellPadding&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cellSpacing&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;char&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charOff&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;charSet&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;checked&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;clear&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;cols&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;colSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;color&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;compact&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;coords&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dateTime&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;dir&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;encType&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;htmlFor&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;frame&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;headers&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;height&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hrefLang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;hSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;isMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;id&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;label&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;lang&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;maxLength&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;media&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;method&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;multiple&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;name&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noHref&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noShade&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;noWrap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;open&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;prompt&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;readOnly&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rel&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rev&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rows&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rowSpan&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;rules&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;scope&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;selected&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;shape&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;size&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;span&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;start&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;summary&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;tabIndex&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;target&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;title&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;type&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;useMap&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vAlign&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;value&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;vSpace&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;width&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;itemProp&#39;</span><span class=\"p\">]},</span> <span class=\"n\">required</span><span class=\"o\">=</span><span class=\"p\">{</span><span class=\"s1\">&#39;input&#39;</span><span class=\"p\">:</span> <span class=\"p\">{</span><span class=\"s1\">&#39;type&#39;</span><span class=\"p\">:</span> <span class=\"s1\">&#39;checkbox&#39;</span><span class=\"p\">,</span> <span class=\"s1\">&#39;disabled&#39;</span><span class=\"p\">:</span> <span class=\"kc\">True</span><span class=\"p\">}})</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.sanitize.Schema": {"fullname": "phml.utilities.transform.sanitize.Schema", "modulename": "phml.utilities.transform.sanitize", "qualname": "Schema", "kind": "class", "doc": "<p>Dataclass of information on how to sanatize a phml tree.</p>\n\n<p><code>strip (list[str])</code>: The elements to strip from the tree.\n<code>protocols (dict[str, list])</code>: Collection of element name and allowed protocal value list\n<code>tag_names (list[str])</code>: List of allowed tag names.\n<code>attributes (dict[str, list[str | list[str]]])</code>: Collection of element name and allowed property\nnames.\n<code>required (dict[str, str | list[str]])</code>: Collection of element names and their required\nproperties and required property values.</p>\n"}, "phml.utilities.transform.sanitize.Schema.__init__": {"fullname": "phml.utilities.transform.sanitize.Schema.__init__", "modulename": "phml.utilities.transform.sanitize", "qualname": "Schema.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">strip</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">ancestors</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">protocols</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">tag_names</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">attributes</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span>,</span><span class=\"param\">\t<span class=\"n\">required</span><span class=\"p\">:</span> <span class=\"nb\">dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]]</span> <span class=\"o\">=</span> <span class=\"o\">&lt;</span><span class=\"n\">factory</span><span class=\"o\">&gt;</span></span>)</span>"}, "phml.utilities.transform.transform": {"fullname": "phml.utilities.transform.transform", "modulename": "phml.utilities.transform.transform", "kind": "module", "doc": "<p>phml.utilities.transform.transform</p>\n\n<p>Utility methods that revolve around transforming or manipulating the ast.</p>\n"}, "phml.utilities.transform.transform.filter_nodes": {"fullname": "phml.utilities.transform.transform.filter_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "filter_nodes", "kind": "function", "doc": "<p>Take a given tree and filter the nodes with the condition.\nOnly nodes passing the condition stay. If the parent node fails,\nall children are moved up in scope. Depth first</p>\n\n<p>Same as remove_nodes but keeps the nodes that match.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The tree node to filter.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>Root | Element: The given tree after being filtered.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.remove_nodes": {"fullname": "phml.utilities.transform.transform.remove_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "remove_nodes", "kind": "function", "doc": "<p>Take a given tree and remove the nodes that match the condition.\nIf a parent node is removed so is all the children.</p>\n\n<p>Same as filter_nodes except removes nodes that match.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  The parent node to start recursively removing from.</li>\n<li><strong>condition (Test):</strong>  The condition to apply to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.map_nodes": {"fullname": "phml.utilities.transform.transform.map_nodes", "modulename": "phml.utilities.transform.transform", "qualname": "map_nodes", "kind": "function", "doc": "<p>Takes a tree and a callable that returns a node and maps each node.</p>\n\n<p>Signature for the transform function should be as follows:</p>\n\n<ol>\n<li>Takes a single argument that is the node.</li>\n<li>Returns any type of node that is assigned to the original node.</li>\n</ol>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">def</span> <span class=\"nf\">to_links</span><span class=\"p\">(</span><span class=\"n\">node</span><span class=\"p\">):</span>\n    <span class=\"k\">return</span> <span class=\"n\">Element</span><span class=\"p\">(</span><span class=\"s2\">&quot;a&quot;</span><span class=\"p\">,</span> <span class=\"p\">{},</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">parent</span><span class=\"p\">,</span> <span class=\"n\">children</span><span class=\"o\">=</span><span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">children</span><span class=\"p\">)</span>\n        <span class=\"k\">if</span> <span class=\"n\">node</span><span class=\"o\">.</span><span class=\"n\">type</span> <span class=\"o\">==</span> <span class=\"s2\">&quot;element&quot;</span>\n        <span class=\"k\">else</span> <span class=\"n\">node</span>\n</code></pre>\n</div>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>tree (Root | Element):</strong>  Tree to transform.</li>\n<li><strong>transform (Callable):</strong>  The Callable that returns a node that is assigned</li>\n<li>to each node.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">tree</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">AST</span><span class=\"o\">.</span><span class=\"n\">AST</span>,</span><span class=\"param\">\t<span class=\"n\">transform</span><span class=\"p\">:</span> <span class=\"n\">Callable</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.find_and_replace": {"fullname": "phml.utilities.transform.transform.find_and_replace", "modulename": "phml.utilities.transform.transform", "qualname": "find_and_replace", "kind": "function", "doc": "<p>Takes a ast, root, or any node and replaces text in <code>text</code>\nnodes with matching replacements.</p>\n\n<p>First value in each replacement tuple is the regex to match and\nthe second value is what to replace it with. This can either be\na string or a callable that returns a string or a new node. If\na new node is returned then the text element will be split.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">replacements</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Callable</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.shift_heading": {"fullname": "phml.utilities.transform.transform.shift_heading", "modulename": "phml.utilities.transform.transform", "qualname": "shift_heading", "kind": "function", "doc": "<p>Shift the heading by the amount specified.</p>\n\n<p>value is clamped between 1 and 6.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>, </span><span class=\"param\"><span class=\"n\">amount</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.replace_node": {"fullname": "phml.utilities.transform.transform.replace_node", "modulename": "phml.utilities.transform.transform", "qualname": "replace_node", "kind": "function", "doc": "<p>Search for a specific node in the tree and replace it with either\na node or list of nodes. If replacement is None the found node is just removed.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>start (Root | Element):</strong>  The starting point.</li>\n<li><strong>condition (test):</strong>  Test condition to find the correct node.</li>\n<li><strong>replacement (NODE | list[NODE] | None):</strong>  What to replace the node with.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">replacement</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">],</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">all_nodes</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.transform.transform.modify_children": {"fullname": "phml.utilities.transform.transform.modify_children", "modulename": "phml.utilities.transform.transform", "qualname": "modify_children", "kind": "function", "doc": "<p>Function wrapper that when called and passed an\nAST, Root, or Element will apply the wrapped function\nto each child. This means that whatever is returned\nfrom the wrapped function will be assigned to the child.</p>\n\n<p>The wrapped function will be passed the child node,\nthe index in the parents children, and the parent node</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">func</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "phml.utilities.travel": {"fullname": "phml.utilities.travel", "modulename": "phml.utilities.travel", "kind": "module", "doc": "<p></p>\n"}, "phml.utilities.travel.travel": {"fullname": "phml.utilities.travel.travel", "modulename": "phml.utilities.travel.travel", "kind": "module", "doc": "<p>utilities.travel</p>\n\n<p>Collection of utilities that hep with traversing an ast or node tree.</p>\n"}, "phml.utilities.travel.travel.path": {"fullname": "phml.utilities.travel.travel.path", "modulename": "phml.utilities.travel.travel", "qualname": "path", "kind": "function", "doc": "<p>Get a list of nodes where each one is a child of\nthe other leading to the node passed in. This gives a\npath to the node.</p>\n\n<p>Does not include given node.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to find ancestors of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[NODE]: List of nodes leading to the given node\n  starting from the root.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.path_names": {"fullname": "phml.utilities.travel.travel.path_names", "modulename": "phml.utilities.travel.travel", "qualname": "path_names", "kind": "function", "doc": "<p>Get a list of nodes where each one is a child of\nthe other leading to the node passed in. This gives a\npath to the node.</p>\n\n<p>Does not include given node.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to find ancestors of.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>list[str]: List of nodes leading to the given node\n  starting from the root.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.walk": {"fullname": "phml.utilities.travel.travel.walk", "modulename": "phml.utilities.travel.travel", "qualname": "walk", "kind": "function", "doc": "<p>Recursively traverse the node and it's chidlren as an iterator.\nLeft to right depth first.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.visit_children": {"fullname": "phml.utilities.travel.travel.visit_children", "modulename": "phml.utilities.travel.travel", "qualname": "visit_children", "kind": "function", "doc": "<p>Traverse the children of a Root or Element as an iterator.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.travel.travel.visit_all_after": {"fullname": "phml.utilities.travel.travel.visit_all_after", "modulename": "phml.utilities.travel.travel", "qualname": "visit_all_after", "kind": "function", "doc": "<p>Recursively traverse the tree starting at given node.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">start</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Iterator</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate": {"fullname": "phml.utilities.validate", "modulename": "phml.utilities.validate", "kind": "module", "doc": "<p>utilities.validate</p>\n\n<p>A collection of utilities centered around validating nodes, types,\nvalues on nodes, and any other condition you want to apply to a node\nor ast.</p>\n"}, "phml.utilities.validate.check": {"fullname": "phml.utilities.validate.check", "modulename": "phml.utilities.validate.check", "kind": "module", "doc": "<p>phml.utilities.validate.test</p>\n\n<p>Logic that allows nodes to be tested against a series of conditions.</p>\n"}, "phml.utilities.validate.check.check": {"fullname": "phml.utilities.validate.check.check", "modulename": "phml.utilities.validate.check", "qualname": "check", "kind": "function", "doc": "<p>Test if a node passes the given test(s).</p>\n\n<h6 id=\"test-types\">Test Types:</h6>\n\n<blockquote>\n  <ul>\n  <li><code>None</code>: Just checks that the node is a valid node.</li>\n  <li><code>str</code>: Checks that the test value is == the <code>node.type</code>.</li>\n  <li><code>dict</code>: Checks all items are valid attributes on the node.\n  and that the values are strictly equal.</li>\n  <li><code>Callable</code>: Passes the given function the node and it's index, if provided,\n  and checks if the callable returned true.</li>\n  <li><code>list[Test]</code>: Apply all the rules above for each Test in the list.</li>\n  </ul>\n</blockquote>\n\n<p>If the <code>parent</code> arg is passed so should the <code>index</code> arg.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to test. Can be any phml node.</li>\n<li><strong>test (Test):</strong>  Test to apply to the node. See previous section</li>\n<li>for more info.</li>\n<li><strong>index (Optional[int], optional):</strong>  Index in the parent where the</li>\n<li>node exists. Defaults to None.</li>\n<li><strong>parent (Optional[Root | Element], optional):</strong>  The nodes parent. Defaults to None.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if all tests pass.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span>,</span><span class=\"param\">\t<span class=\"n\">_test</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">NoneType</span><span class=\"p\">,</span> <span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"nb\">list</span><span class=\"p\">,</span> <span class=\"nb\">dict</span><span class=\"p\">,</span> <span class=\"n\">Callable</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">index</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">parent</span><span class=\"p\">:</span> <span class=\"n\">Union</span><span class=\"p\">[</span><span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span><span class=\"p\">,</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span><span class=\"p\">,</span> <span class=\"n\">NoneType</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">strict</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate": {"fullname": "phml.utilities.validate.validate", "modulename": "phml.utilities.validate.validate", "kind": "module", "doc": "<p></p>\n"}, "phml.utilities.validate.validate.validate": {"fullname": "phml.utilities.validate.validate.validate", "modulename": "phml.utilities.validate.validate", "qualname": "validate", "kind": "function", "doc": "<p>Validate a node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.parent": {"fullname": "phml.utilities.validate.validate.parent", "modulename": "phml.utilities.validate.validate", "qualname": "parent", "kind": "function", "doc": "<p>Validate a parent node based on attributes and type.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.literal": {"fullname": "phml.utilities.validate.validate.literal", "modulename": "phml.utilities.validate.validate", "qualname": "literal", "kind": "function", "doc": "<p>Validate a literal node based on attributes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.generated": {"fullname": "phml.utilities.validate.validate.generated", "modulename": "phml.utilities.validate.validate", "qualname": "generated", "kind": "function", "doc": "<p>Checks if a node has been generated. A node is concidered\ngenerated if it does not have a position.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>node (NODE):</strong>  Node to check for position with.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: Whether a node has a position or not.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Root</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Text</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Comment</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">DocType</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Parent</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Node</span> <span class=\"o\">|</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Literal</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.has_property": {"fullname": "phml.utilities.validate.validate.has_property", "modulename": "phml.utilities.validate.validate", "qualname": "has_property", "kind": "function", "doc": "<p>Check to see if an element has a certain property in properties.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_heading": {"fullname": "phml.utilities.validate.validate.is_heading", "modulename": "phml.utilities.validate.validate", "qualname": "is_heading", "kind": "function", "doc": "<p>Check if an element is a heading.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_css_link": {"fullname": "phml.utilities.validate.validate.is_css_link", "modulename": "phml.utilities.validate.validate", "qualname": "is_css_link", "kind": "function", "doc": "<p>Check if an element is a <code>link</code> to a css file.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;link&gt;</code> element with a <code>rel</code> list that\ncontains <code>'stylesheet'</code> and has no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code>\nas its <code>type</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_css_style": {"fullname": "phml.utilities.validate.validate.is_css_style", "modulename": "phml.utilities.validate.validate", "qualname": "is_css_style", "kind": "function", "doc": "<p>Check if an element is a css <code>style</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;style&gt;</code> element that\nhas no <code>type</code>, an empty <code>type</code>, or <code>'text/css'</code> as its <code>type</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_javascript": {"fullname": "phml.utilities.validate.validate.is_javascript", "modulename": "phml.utilities.validate.validate", "qualname": "is_javascript", "kind": "function", "doc": "<p>Check if an element is a javascript <code>script</code> element.</p>\n\n<p>Returns <code>true</code> if <code>node</code> is a <code>&lt;script&gt;</code> element that has a valid JavaScript <code>type</code>, has no\n<code>type</code> and a valid JavaScript <code>language</code>, or has neither.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_element": {"fullname": "phml.utilities.validate.validate.is_element", "modulename": "phml.utilities.validate.validate", "qualname": "is_element", "kind": "function", "doc": "<p>Checks if the given node is a certain element.</p>\n\n<p>When providing a str it will check that the elements tag matches.\nIf a list is provided it checks that one of the conditions in the list\npasses.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">conditions</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_embedded": {"fullname": "phml.utilities.validate.validate.is_embedded", "modulename": "phml.utilities.validate.validate", "qualname": "is_embedded", "kind": "function", "doc": "<p>Check to see if an element is an embedded element.</p>\n\n<p>Embedded Elements:</p>\n\n<ul>\n<li>audio</li>\n<li>canvas</li>\n<li>embed</li>\n<li>iframe</li>\n<li>img</li>\n<li>MathML math</li>\n<li>object</li>\n<li>picture</li>\n<li>SVG svg</li>\n<li>video</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if emedded</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_interactive": {"fullname": "phml.utilities.validate.validate.is_interactive", "modulename": "phml.utilities.validate.validate", "qualname": "is_interactive", "kind": "function", "doc": "<p>Check if the element is intended for user interaction.</p>\n\n<p>Conditions:</p>\n\n<ul>\n<li>a (if the href attribute is present)</li>\n<li>audio (if the controls attribute is present)</li>\n<li>button, details, embed, iframe, img (if the usemap attribute is present)</li>\n<li>input (if the type attribute is not in the Hidden state)</li>\n<li>label, select, text, area, video (if the controls attribute is present)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if element is interactive</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_phrasing": {"fullname": "phml.utilities.validate.validate.is_phrasing", "modulename": "phml.utilities.validate.validate", "qualname": "is_phrasing", "kind": "function", "doc": "<p>Check if a node is phrasing text according to\n<a href=\"https://html.spec.whatwg.org/#phrasing-content-2\">https://html.spec.whatwg.org/#phrasing-content-2</a>.</p>\n\n<p>Phrasing content is the text of the document, as well as elements that mark up that text at the\nintra-paragraph level. Runs of phrasing content form paragraphs.</p>\n\n<ul>\n<li>area (if it is a descendant of a map element)</li>\n<li>link (if it is allowed in the body)</li>\n<li>meta (if the itemprop attribute is present)</li>\n<li>map, mark, math, audio, b, bdi, bdo, br, button, canvas, cite, code, data, datalist, del, dfn,\nem, embed, i, iframe, img, input, ins, kbd, label, a, abbr, meter, noscript, object, output,\npicture, progress, q, ruby, s, samp, script, select, slot, small, span, strong, sub, sup, svg,\ntemplate, textarea, time, u, var, video, wbr, text (true)</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>True if the element is phrasing text</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">node</span><span class=\"p\">:</span> <span class=\"n\">phml</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">nodes</span><span class=\"o\">.</span><span class=\"n\">Element</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.is_event_handler": {"fullname": "phml.utilities.validate.validate.is_event_handler", "modulename": "phml.utilities.validate.validate", "qualname": "is_event_handler", "kind": "function", "doc": "<p>Takes a attribute name and returns true if\nit starts with <code>on</code> and its length is <code>5</code> or more.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">attribute</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "phml.utilities.validate.validate.blank": {"fullname": "phml.utilities.validate.validate.blank", "modulename": "phml.utilities.validate.validate", "qualname": "blank", "kind": "function", "doc": "<p>Takes any value type and returns whether it is blank/None.\nFor strings if the value is stripped and is equal to '' then it is blank.\nOtherwise if len &gt; 0 and is not None then not blank.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>value (Any):</strong>  The value to check if it is blank.</li>\n</ul>\n\n<h6 id=\"returns\">Returns:</h6>\n\n<blockquote>\n  <p>bool: True if value is blank</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"phml": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1649}, "phml.builder": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.builder.p": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 269, "bases": 0, "doc": 9}, "phml.core": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.compiler": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "phml.core.compiler.Compiler": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.compiler.Compiler.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 301, "bases": 0, "doc": 3}, "phml.core.compiler.Compiler.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.compiler.Compiler.add": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 547, "bases": 0, "doc": 167}, "phml.core.compiler.Compiler.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 233, "bases": 0, "doc": 51}, "phml.core.compiler.Compiler.compile": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 185, "bases": 0, "doc": 9}, "phml.core.compiler.Compiler.render": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 189, "bases": 0, "doc": 9}, "phml.core.core": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.core.PHML": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 41}, "phml.core.core.PHML.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 297, "bases": 0, "doc": 3}, "phml.core.core.PHML.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "phml.core.core.PHML.components": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "phml.core.core.PHML.expose": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 22}, "phml.core.core.PHML.redact": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "phml.core.core.PHML.expand": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 25}, "phml.core.core.PHML.restrict": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 27}, "phml.core.core.PHML.add": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 642, "bases": 0, "doc": 203}, "phml.core.core.PHML.remove": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 233, "bases": 0, "doc": 55}, "phml.core.core.PHML.load": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 99, "bases": 0, "doc": 38}, "phml.core.core.PHML.parse": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 32}, "phml.core.core.PHML.compile": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 116, "bases": 0, "doc": 108}, "phml.core.core.PHML.render": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 120, "bases": 0, "doc": 104}, "phml.core.core.PHML.write": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 170, "bases": 0, "doc": 212}, "phml.core.formats": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 48}, "phml.core.formats.Formats": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "phml.core.formats.Formats.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 3}, "phml.core.formats.compile": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.compile.compile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.formats.compile.compile.process_reserved_attrs": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 12}, "phml.core.formats.compile.compile.process_props": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 85, "bases": 0, "doc": 11}, "phml.core.formats.compile.compile.apply_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 141, "bases": 0, "doc": 67}, "phml.core.formats.compile.compile.process_reserved_elements": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 104, "bases": 0, "doc": 13}, "phml.core.formats.compile.compile.apply_python": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 130, "bases": 0, "doc": 52}, "phml.core.formats.compile.compile.py_condition": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 11}, "phml.core.formats.compile.compile.process_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 104, "bases": 0, "doc": 52}, "phml.core.formats.compile.compile.execute_conditions": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 78, "bases": 0, "doc": 134}, "phml.core.formats.compile.compile.build_locals": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 18}, "phml.core.formats.compile.compile.run_phml_if": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.run_phml_elif": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 78, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.run_phml_else": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 16}, "phml.core.formats.compile.compile.ASTRenderer": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 3}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 103, "bases": 0, "doc": 68}, "phml.core.formats.compile.component": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.compile.component.substitute_component": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 153, "bases": 0, "doc": 49}, "phml.core.formats.compile.component.replace_components": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 153, "bases": 0, "doc": 49}, "phml.core.formats.compile.component.combine_component_elements": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 77, "bases": 0, "doc": 32}, "phml.core.formats.compile.reserved": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.format": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.format.Format": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 33}, "phml.core.formats.format.Format.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.format.Format.extension": {"qualname": 2, "fullname": 6, "annotation": 4, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.format.Format.suffix": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.core.formats.format.Format.is_format": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 12}, "phml.core.formats.format.Format.parse": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.format.Format.compile": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.format.Format.render": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.html_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.html_format.parse_markup": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.core.formats.html_format.HTMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.html_format.HTMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.html_format.HTMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 9, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.html_format.HTMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.html_format.HTMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.html_format.HTMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.json_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.json_format.construct_tree": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 8}, "phml.core.formats.json_format.JSONFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.json_format.JSONFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.json_format.JSONFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.json_format.JSONFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 13}, "phml.core.formats.json_format.JSONFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.parse": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.formats.parse.parse_hypertest_markup": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 11}, "phml.core.formats.parse.strip_blank_lines": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 15}, "phml.core.formats.parse.strip": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 54, "bases": 0, "doc": 34}, "phml.core.formats.parse.RE": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.parse.RE.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.parse.RE.tag_start": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 35, "signature": 0, "bases": 0, "doc": 17}, "phml.core.formats.parse.RE.tag_end": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 16}, "phml.core.formats.parse.RE.comment": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 16}, "phml.core.formats.parse.RE.attribute": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 58, "signature": 0, "bases": 0, "doc": 15}, "phml.core.formats.parse.HypertextMarkupParser": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 2, "signature": 0, "bases": 0, "doc": 14}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 18}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 57}, "phml.core.formats.phml_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.phml_format.parse_markup": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.core.formats.phml_format.PHMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.phml_format.PHMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.phml_format.PHMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 13}, "phml.core.formats.phml_format.PHMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.phml_format.PHMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.formats.xml_format": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.formats.xml_format.XMLFormat": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 10}, "phml.core.formats.xml_format.XMLFormat.__init__": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.formats.xml_format.XMLFormat.extension": {"qualname": 2, "fullname": 7, "annotation": 2, "default_value": 5, "signature": 0, "bases": 0, "doc": 34}, "phml.core.formats.xml_format.XMLFormat.parse": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 13}, "phml.core.formats.xml_format.XMLFormat.compile": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 326, "bases": 0, "doc": 14}, "phml.core.formats.xml_format.XMLFormat.render": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 324, "bases": 0, "doc": 16}, "phml.core.nodes": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.core.nodes.AST": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 38}, "phml.core.nodes.AST.AST": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "phml.core.nodes.AST.AST.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "phml.core.nodes.AST.AST.size": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.nodes.AST.AST.children": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.core.nodes.nodes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Element": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 341}, "phml.core.nodes.nodes.Element.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 162, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Element.start_tag": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 49}, "phml.core.nodes.nodes.Element.end_tag": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "phml.core.nodes.nodes.Root": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 37}, "phml.core.nodes.nodes.Root.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Node": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 62}, "phml.core.nodes.nodes.Node.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Node.position": {"qualname": 2, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.core.nodes.nodes.Node.type": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 24}, "phml.core.nodes.nodes.DocType": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 65}, "phml.core.nodes.nodes.DocType.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 148, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.DocType.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 26}, "phml.core.nodes.nodes.Parent": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 29}, "phml.core.nodes.nodes.Parent.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 72, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Parent.append": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 225, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Parent.extend": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 231, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Parent.insert": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 236, "bases": 0, "doc": 17}, "phml.core.nodes.nodes.Parent.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 225, "bases": 0, "doc": 14}, "phml.core.nodes.nodes.PI": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 11}, "phml.core.nodes.nodes.PI.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 70, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.PI.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 12}, "phml.core.nodes.nodes.Comment": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 31}, "phml.core.nodes.nodes.Comment.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 24}, "phml.core.nodes.nodes.Literal": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 13}, "phml.core.nodes.nodes.Literal.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 145, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Literal.position": {"qualname": 2, "fullname": 6, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 34}, "phml.core.nodes.nodes.Literal.value": {"qualname": 2, "fullname": 6, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "phml.core.nodes.nodes.Literal.normalized": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 15}, "phml.core.nodes.nodes.Literal.stringify": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Literal.get_ancestry": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 27}, "phml.core.nodes.nodes.Point": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 52}, "phml.core.nodes.nodes.Point.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 3}, "phml.core.nodes.nodes.Position": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 151}, "phml.core.nodes.nodes.Position.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 90, "bases": 0, "doc": 52}, "phml.core.nodes.nodes.Position.as_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.core.nodes.nodes.Text": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 1, "doc": 177}, "phml.core.nodes.nodes.Text.num_lines": {"qualname": 3, "fullname": 7, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.core.nodes.types": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "phml.core.nodes.types.Properties": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 4, "signature": 0, "bases": 0, "doc": 24}, "phml.core.parser": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 36}, "phml.core.parser.Parser": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 107}, "phml.core.parser.Parser.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 4, "bases": 0, "doc": 3}, "phml.core.parser.Parser.ast": {"qualname": 2, "fullname": 5, "annotation": 6, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.core.parser.Parser.load": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 98, "bases": 0, "doc": 76}, "phml.core.parser.Parser.parse": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 69, "bases": 0, "doc": 111}, "phml.core.virtual_python": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 380}, "phml.core.virtual_python.VirtualPython": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 14}, "phml.core.virtual_python.VirtualPython.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 107, "bases": 0, "doc": 3}, "phml.core.virtual_python.VirtualPython.get_python_context": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 51, "bases": 0, "doc": 41}, "phml.core.virtual_python.get_python_result": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "phml.core.virtual_python.process_python_blocks": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 62, "bases": 0, "doc": 97}, "phml.core.virtual_python.Import": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 7, "doc": 19}, "phml.core.virtual_python.Import.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 3}, "phml.core.virtual_python.Import.from_node": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 46}, "phml.core.virtual_python.ImportFrom": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 7, "doc": 19}, "phml.core.virtual_python.ImportFrom.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 3}, "phml.core.virtual_python.ImportFrom.from_node": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 46}, "phml.utilities": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 26}, "phml.utilities.locate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "phml.utilities.locate.find": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 22}, "phml.utilities.locate.find.ancestor": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 438, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 573, "bases": 0, "doc": 76}, "phml.utilities.locate.find.find_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 567, "bases": 0, "doc": 64}, "phml.utilities.locate.find.find_after": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 710, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find_all_after": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 522, "bases": 0, "doc": 72}, "phml.utilities.locate.find.find_all_before": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 522, "bases": 0, "doc": 78}, "phml.utilities.locate.find.find_before": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 710, "bases": 0, "doc": 92}, "phml.utilities.locate.find.find_all_between": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 647, "bases": 0, "doc": 147}, "phml.utilities.locate.index": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.locate.index.Index": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 44}, "phml.utilities.locate.index.Index.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 366, "bases": 0, "doc": 109}, "phml.utilities.locate.index.Index.indexed_tree": {"qualname": 3, "fullname": 7, "annotation": 7, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "phml.utilities.locate.index.Index.items": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 11}, "phml.utilities.locate.index.Index.values": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.keys": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 12}, "phml.utilities.locate.index.Index.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 10}, "phml.utilities.locate.index.Index.get": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 55, "bases": 0, "doc": 11}, "phml.utilities.locate.index.Index.key_by_tag": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 24}, "phml.utilities.locate.select": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 18}, "phml.utilities.locate.select.query": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 123, "bases": 0, "doc": 259}, "phml.utilities.locate.select.query_all": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 129, "bases": 0, "doc": 261}, "phml.utilities.locate.select.matches": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 191}, "phml.utilities.locate.select.parse_specifiers": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 141}, "phml.utilities.misc": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 23}, "phml.utilities.misc.depth": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 34}, "phml.utilities.misc.size": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 9}, "phml.utilities.misc.offset": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 14}, "phml.utilities.misc.classes": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utilities.misc.classes.classnames": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 96, "bases": 0, "doc": 197}, "phml.utilities.misc.classes.ClassList": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 29}, "phml.utilities.misc.classes.ClassList.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 3}, "phml.utilities.misc.classes.ClassList.contains": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.toggle": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 10}, "phml.utilities.misc.classes.ClassList.add": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.replace": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 14}, "phml.utilities.misc.classes.ClassList.remove": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 12}, "phml.utilities.misc.classes.ClassList.class_list": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "phml.utilities.misc.component": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.misc.component.tokanize_name": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 42, "bases": 0, "doc": 86}, "phml.utilities.misc.component.tag_from_file": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 35}, "phml.utilities.misc.component.filename_from_path": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 13}, "phml.utilities.misc.component.parse_component": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 10}, "phml.utilities.misc.component.valid_component_dict": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 10}, "phml.utilities.misc.component.cmpt_name_from_path": {"qualname": 4, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 51}, "phml.utilities.misc.heading": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "phml.utilities.misc.heading.heading_rank": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 26}, "phml.utilities.misc.inspect": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 25}, "phml.utilities.misc.inspect.inspect": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 263, "bases": 0, "doc": 10}, "phml.utilities.misc.inspect.normalize_indent": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 87}, "phml.utilities.transform": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 20}, "phml.utilities.transform.normalize_indent": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 62}, "phml.utilities.transform.extract": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.transform.extract.to_string": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 248, "bases": 0, "doc": 59}, "phml.utilities.transform.sanitize": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 15}, "phml.utilities.transform.sanitize.sanatize": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 2118, "bases": 0, "doc": 137}, "phml.utilities.transform.sanitize.Schema": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 90}, "phml.utilities.transform.sanitize.Schema.__init__": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 245, "bases": 0, "doc": 3}, "phml.utilities.transform.transform": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utilities.transform.transform.filter_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 356, "bases": 0, "doc": 102}, "phml.utilities.transform.transform.remove_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 356, "bases": 0, "doc": 78}, "phml.utilities.transform.transform.map_nodes": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 100, "bases": 0, "doc": 203}, "phml.utilities.transform.transform.find_and_replace": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 111, "bases": 0, "doc": 75}, "phml.utilities.transform.transform.shift_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 46, "bases": 0, "doc": 20}, "phml.utilities.transform.transform.replace_node": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 786, "bases": 0, "doc": 85}, "phml.utilities.transform.transform.modify_children": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 60}, "phml.utilities.travel": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.travel.travel": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 19}, "phml.utilities.travel.travel.path": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 430, "bases": 0, "doc": 81}, "phml.utilities.travel.travel.path_names": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 228, "bases": 0, "doc": 81}, "phml.utilities.travel.travel.walk": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 19}, "phml.utilities.travel.travel.visit_children": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 66, "bases": 0, "doc": 14}, "phml.utilities.travel.travel.visit_all_after": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 11}, "phml.utilities.validate": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 32}, "phml.utilities.validate.check": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 21}, "phml.utilities.validate.check.check": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 590, "bases": 0, "doc": 237}, "phml.utilities.validate.validate": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "phml.utilities.validate.validate.validate": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 11}, "phml.utilities.validate.validate.parent": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 12}, "phml.utilities.validate.validate.literal": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 65, "bases": 0, "doc": 10}, "phml.utilities.validate.validate.generated": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 222, "bases": 0, "doc": 62}, "phml.utilities.validate.validate.has_property": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 15}, "phml.utilities.validate.validate.is_heading": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 10}, "phml.utilities.validate.validate.is_css_link": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 71}, "phml.utilities.validate.validate.is_css_style": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 57}, "phml.utilities.validate.validate.is_javascript": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 58}, "phml.utilities.validate.validate.is_element": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 43}, "phml.utilities.validate.validate.is_embedded": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 65}, "phml.utilities.validate.validate.is_interactive": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 95}, "phml.utilities.validate.validate.is_phrasing": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 39, "bases": 0, "doc": 163}, "phml.utilities.validate.validate.is_event_handler": {"qualname": 3, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 26}, "phml.utilities.validate.validate.blank": {"qualname": 1, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 78}}, "length": 267, "save": true}, "index": {"qualname": {"root": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 28, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 18, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 13, "r": {"docs": {"phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 7}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 3}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}}, "df": 7, "r": {"docs": {"phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}}, "df": 7}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.core.core.PHML.components": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 8}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 28}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 10, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 1, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 7, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 3}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}}, "df": 4}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent.append": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 6}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 7}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.expose": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {"phml.core.nodes.nodes.Parent.extend": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}, "k": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}}, "df": 8, "s": {"docs": {"phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 8}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.matches": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 3}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 7}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "o": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 5}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.values": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.validate": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 3}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.keys": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.offset": {"tf": 1}}, "df": 1}}}}}}}}, "fullname": {"root": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 28, "p": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 267, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 26, "r": {"docs": {"phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 7}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 13}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 5}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 3}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core": {"tf": 1.4142135623730951}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 169}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.build_locals": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}}, "df": 28, "r": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}}, "df": 8}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 11, "s": {"docs": {"phml.core.core.PHML.components": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 2}}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.py_condition": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 10}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 8}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 28}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 3}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.4142135623730951}}, "df": 11, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}}}}}, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}}, "df": 1}, "s": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 11}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 3}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}}, "df": 1, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 3}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}}, "df": 4}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent.append": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 6}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 6, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 6}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 7}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}}, "df": 3}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.expose": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {"phml.core.nodes.nodes.Parent.extend": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 26}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}, "k": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 8}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.suffix": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.is_format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.parse": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.4142135623730951}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 39, "s": {"docs": {"phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}, "phml.core.formats.compile": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.compile.reserved": {"tf": 1}, "phml.core.formats.format": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.__init__": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.RE": {"tf": 1}, "phml.core.formats.parse.RE.__init__": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 79}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 10}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 5}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.html_format": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 8, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 1}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.matches": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 26}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.json_format": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 7, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}}, "df": 5}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}}, "df": 16}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1.4142135623730951}}, "df": 7}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 7}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "o": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.xml_format": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 7, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 6}}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Comment": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.4142135623730951}, "phml.core.nodes.types": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 50}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 2, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}}, "df": 3}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.values": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_heading": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 19}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 12, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 3}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 4}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 95}}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.locate.index.Index.keys": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.offset": {"tf": 1}}, "df": 1}}}}}}}}, "annotation": {"root": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 17, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 6}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1.4142135623730951}, "phml.core.core.PHML.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}}, "df": 3}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.components": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}}, "df": 6}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.AST.AST.children": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}}, "df": 1}}}}}}}}}, "default_value": {"root": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_start": {"tf": 3.605551275463989}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.comment": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.attribute": {"tf": 4.47213595499958}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.nodes.types.Properties": {"tf": 1}}, "df": 11, "x": {"2": {"7": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 2}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_start": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.comment": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}}, "df": 9}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.format.Format.extension": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 1, "l": {"docs": {"phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 4}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 4}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.RE.tag_end": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}}, "df": 4}}, "p": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}}, "df": 3, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"2": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}}, "df": 1}, "docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 2.6457513110645907}}, "df": 4}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 2}}}}, "w": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 2}, "s": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 2}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}, "signature": {"root": {"0": {"docs": {"phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 8}, "2": {"docs": {"phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 3}, "3": {"9": {"docs": {"phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 19.493588689617926}}, "df": 5}, "docs": {}, "df": 0}, "4": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}}, "df": 3}, "docs": {"phml.builder.p": {"tf": 14.832396974191326}, "phml.core.compiler.Compiler.__init__": {"tf": 15.652475842498529}, "phml.core.compiler.Compiler.add": {"tf": 21.095023109728988}, "phml.core.compiler.Compiler.remove": {"tf": 13.784048752090222}, "phml.core.compiler.Compiler.compile": {"tf": 11.74734012447073}, "phml.core.compiler.Compiler.render": {"tf": 11.916375287812984}, "phml.core.core.PHML.__init__": {"tf": 15.556349186104045}, "phml.core.core.PHML.expose": {"tf": 4.47213595499958}, "phml.core.core.PHML.redact": {"tf": 4.242640687119285}, "phml.core.core.PHML.expand": {"tf": 4.47213595499958}, "phml.core.core.PHML.restrict": {"tf": 4.47213595499958}, "phml.core.core.PHML.add": {"tf": 22.869193252058544}, "phml.core.core.PHML.remove": {"tf": 13.784048752090222}, "phml.core.core.PHML.load": {"tf": 8.94427190999916}, "phml.core.core.PHML.parse": {"tf": 6.557438524302}, "phml.core.core.PHML.compile": {"tf": 9.055385138137417}, "phml.core.core.PHML.render": {"tf": 9.273618495495704}, "phml.core.core.PHML.write": {"tf": 11.269427669584644}, "phml.core.formats.Formats.__init__": {"tf": 4.123105625617661}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 6.164414002968976}, "phml.core.formats.compile.compile.process_props": {"tf": 8.18535277187245}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 10.677078252031311}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 9.16515138991168}, "phml.core.formats.compile.compile.apply_python": {"tf": 10.246950765959598}, "phml.core.formats.compile.compile.py_condition": {"tf": 5.656854249492381}, "phml.core.formats.compile.compile.process_conditions": {"tf": 9.16515138991168}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 7.937253933193772}, "phml.core.formats.compile.compile.build_locals": {"tf": 4.242640687119285}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 7.483314773547883}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 8.06225774829855}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 7.615773105863909}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 7.3484692283495345}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 9.219544457292887}, "phml.core.formats.compile.component.substitute_component": {"tf": 11.135528725660043}, "phml.core.formats.compile.component.replace_components": {"tf": 11.135528725660043}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 7.937253933193772}, "phml.core.formats.format.Format.__init__": {"tf": 2}, "phml.core.formats.format.Format.suffix": {"tf": 3.4641016151377544}, "phml.core.formats.format.Format.is_format": {"tf": 4.58257569495584}, "phml.core.formats.format.Format.parse": {"tf": 5.830951894845301}, "phml.core.formats.format.Format.compile": {"tf": 16.278820596099706}, "phml.core.formats.format.Format.render": {"tf": 16.24807680927192}, "phml.core.formats.html_format.parse_markup": {"tf": 7.54983443527075}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 2}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 5.830951894845301}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 16.278820596099706}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 16.24807680927192}, "phml.core.formats.json_format.construct_tree": {"tf": 3.7416573867739413}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 2}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 5}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 16.24807680927192}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 7.54983443527075}, "phml.core.formats.parse.strip_blank_lines": {"tf": 5.0990195135927845}, "phml.core.formats.parse.strip": {"tf": 6.6332495807108}, "phml.core.formats.parse.RE.__init__": {"tf": 2}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 2}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 5.291502622129181}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 7.0710678118654755}, "phml.core.formats.phml_format.parse_markup": {"tf": 7.54983443527075}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 2}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 5.830951894845301}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 16.278820596099706}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 16.24807680927192}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 2}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 4.47213595499958}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 16.278820596099706}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 16.24807680927192}, "phml.core.nodes.AST.AST.__init__": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Element.__init__": {"tf": 11.532562594670797}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 3.4641016151377544}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.core.nodes.nodes.Root.__init__": {"tf": 7.745966692414834}, "phml.core.nodes.nodes.Node.__init__": {"tf": 6.244997998398398}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 11.045361017187261}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 7.745966692414834}, "phml.core.nodes.nodes.Parent.append": {"tf": 13.527749258468683}, "phml.core.nodes.nodes.Parent.extend": {"tf": 13.711309200802088}, "phml.core.nodes.nodes.Parent.insert": {"tf": 13.856406460551018}, "phml.core.nodes.nodes.Parent.remove": {"tf": 13.527749258468683}, "phml.core.nodes.nodes.PI.__init__": {"tf": 7.615773105863909}, "phml.core.nodes.nodes.PI.stringify": {"tf": 4.898979485566356}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 10.908712114635714}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 5.0990195135927845}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Point.__init__": {"tf": 6.244997998398398}, "phml.core.nodes.nodes.Position.__init__": {"tf": 8.602325267042627}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 3.4641016151377544}, "phml.core.parser.Parser.__init__": {"tf": 2}, "phml.core.parser.Parser.load": {"tf": 8.94427190999916}, "phml.core.parser.Parser.parse": {"tf": 6.557438524302}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 9.486832980505138}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 6.48074069840786}, "phml.core.virtual_python.get_python_result": {"tf": 4.69041575982343}, "phml.core.virtual_python.process_python_blocks": {"tf": 7}, "phml.core.virtual_python.Import.__init__": {"tf": 4.123105625617661}, "phml.core.virtual_python.Import.from_node": {"tf": 5.656854249492381}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 5}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 5.656854249492381}, "phml.utilities.locate.find.ancestor": {"tf": 18.841443681416774}, "phml.utilities.locate.find.find": {"tf": 21.563858652847824}, "phml.utilities.locate.find.find_all": {"tf": 21.447610589527216}, "phml.utilities.locate.find.find_after": {"tf": 24}, "phml.utilities.locate.find.find_all_after": {"tf": 20.591260281974}, "phml.utilities.locate.find.find_all_before": {"tf": 20.591260281974}, "phml.utilities.locate.find.find_before": {"tf": 24}, "phml.utilities.locate.find.find_all_between": {"tf": 22.956480566497994}, "phml.utilities.locate.index.Index.__init__": {"tf": 17.26267650163207}, "phml.utilities.locate.index.Index.items": {"tf": 4.69041575982343}, "phml.utilities.locate.index.Index.values": {"tf": 4.123105625617661}, "phml.utilities.locate.index.Index.keys": {"tf": 4.123105625617661}, "phml.utilities.locate.index.Index.add": {"tf": 5.830951894845301}, "phml.utilities.locate.index.Index.remove": {"tf": 5.830951894845301}, "phml.utilities.locate.index.Index.get": {"tf": 6.708203932499369}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 6}, "phml.utilities.locate.select.query": {"tf": 10}, "phml.utilities.locate.select.query_all": {"tf": 10.246950765959598}, "phml.utilities.locate.select.matches": {"tf": 6.324555320336759}, "phml.utilities.locate.select.parse_specifiers": {"tf": 4}, "phml.utilities.misc.depth": {"tf": 3.4641016151377544}, "phml.utilities.misc.size": {"tf": 7.280109889280518}, "phml.utilities.misc.offset": {"tf": 5.0990195135927845}, "phml.utilities.misc.classes.classnames": {"tf": 8.94427190999916}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 5.291502622129181}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 4.242640687119285}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.add": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 5.0990195135927845}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 4.47213595499958}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 3.4641016151377544}, "phml.utilities.misc.component.tokanize_name": {"tf": 5.916079783099616}, "phml.utilities.misc.component.tag_from_file": {"tf": 5}, "phml.utilities.misc.component.filename_from_path": {"tf": 4.47213595499958}, "phml.utilities.misc.component.parse_component": {"tf": 7.615773105863909}, "phml.utilities.misc.component.valid_component_dict": {"tf": 4}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 6.4031242374328485}, "phml.utilities.misc.heading.heading_rank": {"tf": 5.656854249492381}, "phml.utilities.misc.inspect.inspect": {"tf": 14.628738838327793}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 4}, "phml.utilities.transform.normalize_indent": {"tf": 5.477225575051661}, "phml.utilities.transform.extract.to_string": {"tf": 14.177446878757825}, "phml.utilities.transform.sanitize.sanatize": {"tf": 38.897300677553446}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 14.106735979665885}, "phml.utilities.transform.transform.filter_nodes": {"tf": 17.029386365926403}, "phml.utilities.transform.transform.remove_nodes": {"tf": 17.029386365926403}, "phml.utilities.transform.transform.map_nodes": {"tf": 9.055385138137417}, "phml.utilities.transform.transform.find_and_replace": {"tf": 9.539392014169456}, "phml.utilities.transform.transform.shift_heading": {"tf": 6.164414002968976}, "phml.utilities.transform.transform.replace_node": {"tf": 25.238858928247925}, "phml.utilities.transform.transform.modify_children": {"tf": 3.1622776601683795}, "phml.utilities.travel.travel.path": {"tf": 18.65475810617763}, "phml.utilities.travel.travel.path_names": {"tf": 13.601470508735444}, "phml.utilities.travel.travel.walk": {"tf": 7.3484692283495345}, "phml.utilities.travel.travel.visit_children": {"tf": 7.3484692283495345}, "phml.utilities.travel.travel.visit_all_after": {"tf": 13.416407864998739}, "phml.utilities.validate.check.check": {"tf": 21.908902300206645}, "phml.utilities.validate.validate.validate": {"tf": 13.416407864998739}, "phml.utilities.validate.validate.parent": {"tf": 7.280109889280518}, "phml.utilities.validate.validate.literal": {"tf": 7.280109889280518}, "phml.utilities.validate.validate.generated": {"tf": 13.416407864998739}, "phml.utilities.validate.validate.has_property": {"tf": 4.47213595499958}, "phml.utilities.validate.validate.is_heading": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_css_link": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_css_style": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_javascript": {"tf": 3.4641016151377544}, "phml.utilities.validate.validate.is_element": {"tf": 5.196152422706632}, "phml.utilities.validate.validate.is_embedded": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_interactive": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_phrasing": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_event_handler": {"tf": 4}, "phml.utilities.validate.validate.blank": {"tf": 4}}, "df": 173, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 46}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder.p": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.__init__": {"tf": 1.7320508075688772}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 3.1622776601683795}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 109, "i": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 4}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 11}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 14, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 6}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "b": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 4}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 2}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 36}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 3}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.utilities.misc.classes.ClassList.replace": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 2}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 39, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 16}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 67, "s": {"docs": {"phml.builder.p": {"tf": 4}, "phml.core.compiler.Compiler.__init__": {"tf": 4.123105625617661}, "phml.core.compiler.Compiler.add": {"tf": 5.830951894845301}, "phml.core.compiler.Compiler.remove": {"tf": 4}, "phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 4}, "phml.core.core.PHML.add": {"tf": 5.830951894845301}, "phml.core.core.PHML.remove": {"tf": 4}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 2}, "phml.core.formats.compile.compile.apply_python": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 2}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.replace_components": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 2}, "phml.core.formats.format.Format.compile": {"tf": 4.242640687119285}, "phml.core.formats.format.Format.render": {"tf": 4.123105625617661}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 4.123105625617661}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 4.242640687119285}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Element.__init__": {"tf": 2}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 4}, "phml.core.nodes.nodes.Parent.extend": {"tf": 4.123105625617661}, "phml.core.nodes.nodes.Parent.insert": {"tf": 4}, "phml.core.nodes.nodes.Parent.remove": {"tf": 4}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2}, "phml.utilities.locate.find.ancestor": {"tf": 5.744562646538029}, "phml.utilities.locate.find.find": {"tf": 6.082762530298219}, "phml.utilities.locate.find.find_all": {"tf": 6.082762530298219}, "phml.utilities.locate.find.find_after": {"tf": 6.928203230275509}, "phml.utilities.locate.find.find_all_after": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_all_before": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_before": {"tf": 6.928203230275509}, "phml.utilities.locate.find.find_all_between": {"tf": 6.082762530298219}, "phml.utilities.locate.index.Index.__init__": {"tf": 4.58257569495584}, "phml.utilities.locate.index.Index.add": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.remove": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.size": {"tf": 2}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.inspect": {"tf": 4.123105625617661}, "phml.utilities.transform.extract.to_string": {"tf": 4.123105625617661}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.filter_nodes": {"tf": 4.58257569495584}, "phml.utilities.transform.transform.remove_nodes": {"tf": 4.58257569495584}, "phml.utilities.transform.transform.map_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.find_and_replace": {"tf": 2}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 7.280109889280518}, "phml.utilities.travel.travel.path": {"tf": 5.656854249492381}, "phml.utilities.travel.travel.path_names": {"tf": 4}, "phml.utilities.travel.travel.walk": {"tf": 2}, "phml.utilities.travel.travel.visit_children": {"tf": 2}, "phml.utilities.travel.travel.visit_all_after": {"tf": 4}, "phml.utilities.validate.check.check": {"tf": 6}, "phml.utilities.validate.validate.validate": {"tf": 4}, "phml.utilities.validate.validate.parent": {"tf": 2}, "phml.utilities.validate.validate.literal": {"tf": 2}, "phml.utilities.validate.validate.generated": {"tf": 4}, "phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 92}}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml.utilities.misc.classes.ClassList.replace": {"tf": 1}}, "df": 1}}}, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.compile": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.add": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 2.23606797749979}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 2.23606797749979}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.inspect": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}}, "df": 37}}, "n": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 8}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 12}}}, "b": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "l": {"docs": {"phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.Import.__init__": {"tf": 1}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.6457513110645907}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 58}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 40}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 9}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 52}}, "v": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 41}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 12}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "f": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 31}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 16}}, "x": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 1}}}}, "o": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.__init__": {"tf": 3}, "phml.core.compiler.Compiler.add": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 2.8284271247461903}, "phml.core.core.PHML.add": {"tf": 4.242640687119285}, "phml.core.core.PHML.remove": {"tf": 2.8284271247461903}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 3.1622776601683795}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2}, "phml.core.formats.compile.component.replace_components": {"tf": 2}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 3.1622776601683795}, "phml.core.formats.format.Format.render": {"tf": 3}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 3}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 3}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 3}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 3}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.extend": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.insert": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.remove": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 4}, "phml.utilities.locate.find.find": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_all": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_after": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_after": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_all_before": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_before": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_between": {"tf": 4.358898943540674}, "phml.utilities.locate.index.Index.__init__": {"tf": 3.3166247903554}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 3}, "phml.utilities.transform.extract.to_string": {"tf": 3}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2}, "phml.utilities.transform.transform.filter_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.remove_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 5.0990195135927845}, "phml.utilities.travel.travel.path": {"tf": 4}, "phml.utilities.travel.travel.path_names": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utilities.validate.check.check": {"tf": 4.242640687119285}, "phml.utilities.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 103, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 3}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 44}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.core.PHML.add": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 7, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.core.core.PHML.add": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 7}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Root.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder.p": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.__init__": {"tf": 3}, "phml.core.compiler.Compiler.add": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.remove": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 2.8284271247461903}, "phml.core.core.PHML.add": {"tf": 4.242640687119285}, "phml.core.core.PHML.remove": {"tf": 2.8284271247461903}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 2}, "phml.core.formats.compile.component.replace_components": {"tf": 2}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 3.1622776601683795}, "phml.core.formats.format.Format.render": {"tf": 3}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 3}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 3}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 3}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 3.1622776601683795}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 3}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.extend": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.insert": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Parent.remove": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 4}, "phml.utilities.locate.find.find": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_all": {"tf": 4.358898943540674}, "phml.utilities.locate.find.find_after": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_after": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_all_before": {"tf": 4.123105625617661}, "phml.utilities.locate.find.find_before": {"tf": 4.898979485566356}, "phml.utilities.locate.find.find_all_between": {"tf": 4.358898943540674}, "phml.utilities.locate.index.Index.__init__": {"tf": 3.3166247903554}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1.4142135623730951}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 3}, "phml.utilities.transform.extract.to_string": {"tf": 3}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.filter_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.remove_nodes": {"tf": 3.3166247903554}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 5.0990195135927845}, "phml.utilities.travel.travel.path": {"tf": 4}, "phml.utilities.travel.travel.path_names": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.walk": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 2.8284271247461903}, "phml.utilities.validate.check.check": {"tf": 4.242640687119285}, "phml.utilities.validate.validate.validate": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.parent": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.literal": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 2.8284271247461903}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 103}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 41}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 22}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.core.core.PHML.__init__": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 14, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Point.__init__": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 13}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 11}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 19}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 5, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1}}, "df": 6}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 14}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.component.valid_component_dict": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 2}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 59}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "v": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 2}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 2}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 77, "s": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.format.Format.parse": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.format.Format.is_format": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 2}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.compiler.Compiler.__init__": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.__init__": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 42, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 8}}}}, "o": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}}, "df": 2}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 25}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.nodes.AST.AST.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 8}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.6457513110645907}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 2}, "phml.core.compiler.Compiler.render": {"tf": 2}, "phml.core.core.PHML.load": {"tf": 1.7320508075688772}, "phml.core.core.PHML.parse": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.__init__": {"tf": 3.4641016151377544}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 2}}, "df": 10, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 10}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 5}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 7, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 4}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}, "x": {"2": {"7": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.Formats.__init__": {"tf": 2.8284271247461903}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}}, "df": 8}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "h": {"1": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "2": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "3": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "4": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "5": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}}, "df": 6, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 6}}}}}}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2}}, "df": 1}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.Formats.__init__": {"tf": 2}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 2.449489742783178}}, "df": 9}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 11, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 9}}}}}}}}}}}}, "p": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 9}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 49}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 28}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.contains": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}}, "df": 3}}}}}}, "b": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1.4142135623730951}}, "df": 1, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.Formats.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Element.__init__": {"tf": 1}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 17}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python.ImportFrom.__init__": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.virtual_python.Import.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "x": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}, "q": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 1}, "w": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}}, "df": 2}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 6}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}}, "df": 4}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}}, "df": 4}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 2}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}, "doc": {"root": {"0": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 4}, "1": {"0": {"docs": {"phml": {"tf": 1}}, "df": 1}, "3": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}}, "df": 1}, "docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 4}, "2": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 6}, "3": {"9": {"docs": {"phml": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Element": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.DocType": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 2.8284271247461903}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 5}, "docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "4": {"docs": {"phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}}, "df": 3}, "5": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}, "6": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}, "docs": {"phml": {"tf": 23.979157616563597}, "phml.builder": {"tf": 2.23606797749979}, "phml.builder.p": {"tf": 1.7320508075688772}, "phml.core": {"tf": 1.7320508075688772}, "phml.core.compiler": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.__init__": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.ast": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 5.477225575051661}, "phml.core.compiler.Compiler.remove": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.compile": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.render": {"tf": 1.7320508075688772}, "phml.core.core": {"tf": 1.7320508075688772}, "phml.core.core.PHML": {"tf": 1.7320508075688772}, "phml.core.core.PHML.__init__": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1.7320508075688772}, "phml.core.core.PHML.components": {"tf": 1.7320508075688772}, "phml.core.core.PHML.expose": {"tf": 1.7320508075688772}, "phml.core.core.PHML.redact": {"tf": 1.7320508075688772}, "phml.core.core.PHML.expand": {"tf": 1.7320508075688772}, "phml.core.core.PHML.restrict": {"tf": 1.7320508075688772}, "phml.core.core.PHML.add": {"tf": 5.477225575051661}, "phml.core.core.PHML.remove": {"tf": 2.449489742783178}, "phml.core.core.PHML.load": {"tf": 4}, "phml.core.core.PHML.parse": {"tf": 3.872983346207417}, "phml.core.core.PHML.compile": {"tf": 5.744562646538029}, "phml.core.core.PHML.render": {"tf": 5.830951894845301}, "phml.core.core.PHML.write": {"tf": 7.681145747868608}, "phml.core.formats": {"tf": 2.23606797749979}, "phml.core.formats.Formats": {"tf": 1.7320508075688772}, "phml.core.formats.Formats.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_props": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 5.5677643628300215}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.apply_python": {"tf": 4.47213595499958}, "phml.core.formats.compile.compile.py_condition": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_conditions": {"tf": 4.69041575982343}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 7.3484692283495345}, "phml.core.formats.compile.compile.build_locals": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 5.385164807134504}, "phml.core.formats.compile.component": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.substitute_component": {"tf": 4.69041575982343}, "phml.core.formats.compile.component.replace_components": {"tf": 4.69041575982343}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 3.3166247903554}, "phml.core.formats.compile.reserved": {"tf": 1.7320508075688772}, "phml.core.formats.format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format": {"tf": 2.449489742783178}, "phml.core.formats.format.Format.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.extension": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.suffix": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.is_format": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.parse": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.compile": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.render": {"tf": 1.7320508075688772}, "phml.core.formats.html_format": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.parse_markup": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.json_format": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.construct_tree": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.parse": {"tf": 1.7320508075688772}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1.7320508075688772}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.7320508075688772}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.tag_start": {"tf": 2.23606797749979}, "phml.core.formats.parse.RE.tag_end": {"tf": 2.8284271247461903}, "phml.core.formats.parse.RE.comment": {"tf": 2.8284271247461903}, "phml.core.formats.parse.RE.attribute": {"tf": 2.449489742783178}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 4.898979485566356}, "phml.core.formats.phml_format": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.parse_markup": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.__init__": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.7320508075688772}, "phml.core.nodes": {"tf": 2.23606797749979}, "phml.core.nodes.AST": {"tf": 2.449489742783178}, "phml.core.nodes.AST.AST": {"tf": 2.449489742783178}, "phml.core.nodes.AST.AST.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.AST.AST.size": {"tf": 1.7320508075688772}, "phml.core.nodes.AST.AST.children": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element": {"tf": 14.422205101855956}, "phml.core.nodes.nodes.Element.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 5}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 3.4641016151377544}, "phml.core.nodes.nodes.Root": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Root.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.type": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType": {"tf": 7}, "phml.core.nodes.nodes.DocType.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 3.3166247903554}, "phml.core.nodes.nodes.Parent": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Parent.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Comment": {"tf": 4.58257569495584}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 3.3166247903554}, "phml.core.nodes.nodes.Literal": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Point": {"tf": 2.449489742783178}, "phml.core.nodes.nodes.Point.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 5.477225575051661}, "phml.core.nodes.nodes.Position.__init__": {"tf": 5}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text": {"tf": 12}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.7320508075688772}, "phml.core.nodes.types": {"tf": 1.4142135623730951}, "phml.core.nodes.types.Properties": {"tf": 2.449489742783178}, "phml.core.parser": {"tf": 2.8284271247461903}, "phml.core.parser.Parser": {"tf": 3}, "phml.core.parser.Parser.__init__": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.ast": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.load": {"tf": 5}, "phml.core.parser.Parser.parse": {"tf": 6.4031242374328485}, "phml.core.virtual_python": {"tf": 12.12435565298214}, "phml.core.virtual_python.VirtualPython": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 2.449489742783178}, "phml.core.virtual_python.process_python_blocks": {"tf": 6}, "phml.core.virtual_python.Import": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import.from_node": {"tf": 4.795831523312719}, "phml.core.virtual_python.ImportFrom": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom.__init__": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 4.795831523312719}, "phml.utilities": {"tf": 2.23606797749979}, "phml.utilities.locate": {"tf": 2.23606797749979}, "phml.utilities.locate.find": {"tf": 2.23606797749979}, "phml.utilities.locate.find.ancestor": {"tf": 5.291502622129181}, "phml.utilities.locate.find.find": {"tf": 5.830951894845301}, "phml.utilities.locate.find.find_all": {"tf": 5.5677643628300215}, "phml.utilities.locate.find.find_after": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_after": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_before": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_before": {"tf": 5.477225575051661}, "phml.utilities.locate.find.find_all_between": {"tf": 7.211102550927978}, "phml.utilities.locate.index": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 2.449489742783178}, "phml.utilities.locate.index.Index.__init__": {"tf": 6.082762530298219}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.items": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.values": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.keys": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.add": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.remove": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.get": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.7320508075688772}, "phml.utilities.locate.select": {"tf": 2.23606797749979}, "phml.utilities.locate.select.query": {"tf": 9.643650760992955}, "phml.utilities.locate.select.query_all": {"tf": 9.643650760992955}, "phml.utilities.locate.select.matches": {"tf": 8.246211251235321}, "phml.utilities.locate.select.parse_specifiers": {"tf": 8.18535277187245}, "phml.utilities.misc": {"tf": 2.23606797749979}, "phml.utilities.misc.depth": {"tf": 2.6457513110645907}, "phml.utilities.misc.size": {"tf": 1.7320508075688772}, "phml.utilities.misc.offset": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.classnames": {"tf": 9.219544457292887}, "phml.utilities.misc.classes.ClassList": {"tf": 2.6457513110645907}, "phml.utilities.misc.classes.ClassList.__init__": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.add": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1.7320508075688772}, "phml.utilities.misc.component": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 6.244997998398398}, "phml.utilities.misc.component.tag_from_file": {"tf": 3.4641016151377544}, "phml.utilities.misc.component.filename_from_path": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.parse_component": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 4.358898943540674}, "phml.utilities.misc.heading": {"tf": 1.7320508075688772}, "phml.utilities.misc.heading.heading_rank": {"tf": 3.872983346207417}, "phml.utilities.misc.inspect": {"tf": 2.23606797749979}, "phml.utilities.misc.inspect.inspect": {"tf": 1.7320508075688772}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 7.937253933193772}, "phml.utilities.transform": {"tf": 2.23606797749979}, "phml.utilities.transform.normalize_indent": {"tf": 5.291502622129181}, "phml.utilities.transform.extract": {"tf": 1.7320508075688772}, "phml.utilities.transform.extract.to_string": {"tf": 5}, "phml.utilities.transform.sanitize": {"tf": 2.23606797749979}, "phml.utilities.transform.sanitize.sanatize": {"tf": 6.855654600401044}, "phml.utilities.transform.sanitize.Schema": {"tf": 4.795831523312719}, "phml.utilities.transform.sanitize.Schema.__init__": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.filter_nodes": {"tf": 5.830951894845301}, "phml.utilities.transform.transform.remove_nodes": {"tf": 5}, "phml.utilities.transform.transform.map_nodes": {"tf": 10.816653826391969}, "phml.utilities.transform.transform.find_and_replace": {"tf": 2.8284271247461903}, "phml.utilities.transform.transform.shift_heading": {"tf": 2.449489742783178}, "phml.utilities.transform.transform.replace_node": {"tf": 5.477225575051661}, "phml.utilities.transform.transform.modify_children": {"tf": 2.23606797749979}, "phml.utilities.travel": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path": {"tf": 5.196152422706632}, "phml.utilities.travel.travel.path_names": {"tf": 5.196152422706632}, "phml.utilities.travel.travel.walk": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.visit_children": {"tf": 1.7320508075688772}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1.7320508075688772}, "phml.utilities.validate": {"tf": 2.23606797749979}, "phml.utilities.validate.check": {"tf": 2.23606797749979}, "phml.utilities.validate.check.check": {"tf": 9.539392014169456}, "phml.utilities.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.validate": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.parent": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.literal": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.generated": {"tf": 4.898979485566356}, "phml.utilities.validate.validate.has_property": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_heading": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_link": {"tf": 5.5677643628300215}, "phml.utilities.validate.validate.is_css_style": {"tf": 5.0990195135927845}, "phml.utilities.validate.validate.is_javascript": {"tf": 4.69041575982343}, "phml.utilities.validate.validate.is_element": {"tf": 2.449489742783178}, "phml.utilities.validate.validate.is_embedded": {"tf": 6.082762530298219}, "phml.utilities.validate.validate.is_interactive": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_phrasing": {"tf": 5.656854249492381}, "phml.utilities.validate.validate.is_event_handler": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.blank": {"tf": 4.795831523312719}}, "df": 267, "p": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.core.virtual_python": {"tf": 2.8284271247461903}}, "df": 2, "y": {"docs": {"phml": {"tf": 5.196152422706632}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}}, "df": 2, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 5.916079783099616}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 3.7416573867739413}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 2}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1.4142135623730951}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.4142135623730951}}, "df": 24, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.formats.parse": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.builder": {"tf": 1}, "phml.builder.p": {"tf": 1}, "phml.core.compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 2}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser": {"tf": 2}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 48, "s": {"docs": {"phml.core.parser": {"tf": 1}}, "df": 1}, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 2}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 10, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 3}, "s": {"docs": {"phml": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 6}}}, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 5}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 2}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 5}}}, "y": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.types.Properties": {"tf": 1}}, "df": 1}}}}}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 2}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 5}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1.4142135623730951}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.format.Format.suffix": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 2}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 6}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 2}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 21, "d": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 2}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 12}, "r": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 7}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}}, "df": 8}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2}, "phml.utilities.validate.validate.parent": {"tf": 1}}, "df": 18, "s": {"docs": {"phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 5}, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 13}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 10, "s": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 3}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 5}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 2}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.7320508075688772}}, "df": 9, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.parser.Parser.load": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 6, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}}}}}}, "h": {"2": {"docs": {"phml.utilities.misc.heading.heading_rank": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 2}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}}, "df": 3}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.parser.Parser": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.7320508075688772}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 21, "/": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.7320508075688772}}, "df": 14, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 5}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.parser": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {"phml": {"tf": 2}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}}, "df": 3}}, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.utilities.misc": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}}, "df": 4}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.types": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 2}}, "p": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 3}}}, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "%": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {"phml": {"tf": 2}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}}, "df": 6}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.compiler.Compiler": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 4}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "y": {"docs": {"phml": {"tf": 2}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 5}, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.builder": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 3}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.matches": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 10}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}, "h": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}}, "df": 3}}}}}}}, "y": {"docs": {"phml.utilities.locate.find": {"tf": 1}}, "df": 1}}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 7}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 4}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.format.Format": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {"phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}}, "df": 3}}}, "y": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 5}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.utilities.locate.select.query": {"tf": 2.23606797749979}, "phml.utilities.locate.select.query_all": {"tf": 2.23606797749979}, "phml.utilities.locate.select.matches": {"tf": 2.23606797749979}}, "df": 4, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.6457513110645907}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}}, "df": 4, "s": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 6, "s": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 9}}, "k": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2, "[": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}}, "df": 29, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}}, "df": 6}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 6}}}}}, "#": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}}, "df": 6}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "f": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}, "p": {"docs": {"phml": {"tf": 1}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 6, "s": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 4}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"phml.utilities.locate.find": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}}, "df": 13}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.load": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {"phml": {"tf": 5.656854249492381}, "phml.core.formats.parse.RE.tag_start": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 3.3166247903554}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}}, "df": 11}}, "t": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}}, "df": 4, "o": {"docs": {"phml": {"tf": 5.291502622129181}, "phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 2}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 2.23606797749979}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 2.23606797749979}, "phml.core.core.PHML.write": {"tf": 3.872983346207417}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 2}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser": {"tf": 2.449489742783178}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 2.23606797749979}, "phml.core.virtual_python": {"tf": 2.23606797749979}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 3.1622776601683795}, "phml.utilities.locate.index.Index.__init__": {"tf": 2.8284271247461903}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1.7320508075688772}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.map_nodes": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 2}, "phml.utilities.travel.travel.path_names": {"tf": 2}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2.23606797749979}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 91, "c": {"docs": {"phml": {"tf": 1}}, "df": 1}, "o": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 2, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}}, "df": 1, "d": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1.7320508075688772}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 7.0710678118654755}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 4.69041575982343}, "phml.core.compiler.Compiler.remove": {"tf": 1.7320508075688772}, "phml.core.core.PHML": {"tf": 1.7320508075688772}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 5.196152422706632}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 2.8284271247461903}, "phml.core.core.PHML.render": {"tf": 2.6457513110645907}, "phml.core.core.PHML.write": {"tf": 4.123105625617661}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 2}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 2}, "phml.core.formats.compile.compile.process_conditions": {"tf": 2}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.6457513110645907}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.replace_components": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 2.23606797749979}, "phml.core.formats.format.Format.suffix": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1.7320508075688772}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 2.23606797749979}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.AST": {"tf": 2.23606797749979}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 3.7416573867739413}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Node.type": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Point": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 4.358898943540674}, "phml.core.nodes.nodes.Position.__init__": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1.4142135623730951}, "phml.core.parser": {"tf": 1}, "phml.core.parser.Parser": {"tf": 3}, "phml.core.parser.Parser.ast": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 2.23606797749979}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 2.8284271247461903}, "phml.core.virtual_python.VirtualPython": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 2.23606797749979}, "phml.core.virtual_python.process_python_blocks": {"tf": 2.23606797749979}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 2.23606797749979}, "phml.utilities.locate.find.find": {"tf": 2.23606797749979}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 2}, "phml.utilities.locate.find.find_all_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_before": {"tf": 2}, "phml.utilities.locate.find.find_before": {"tf": 2.8284271247461903}, "phml.utilities.locate.find.find_all_between": {"tf": 2.23606797749979}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 2}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.keys": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query": {"tf": 4}, "phml.utilities.locate.select.query_all": {"tf": 4}, "phml.utilities.locate.select.matches": {"tf": 3.7416573867739413}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 2}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.7320508075688772}, "phml.utilities.misc.classes.classnames": {"tf": 2.23606797749979}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 2.23606797749979}, "phml.utilities.transform.extract.to_string": {"tf": 2}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2.6457513110645907}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 2.8284271247461903}, "phml.utilities.transform.transform.remove_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.map_nodes": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.shift_heading": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.modify_children": {"tf": 2.8284271247461903}, "phml.utilities.travel.travel.path": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.path_names": {"tf": 2.23606797749979}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 4.123105625617661}, "phml.utilities.validate.validate.is_element": {"tf": 2}, "phml.utilities.validate.validate.is_interactive": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.449489742783178}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 150, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}}, "df": 7}}, "y": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 6}, "m": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_elements": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 5, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3}}, "n": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1.4142135623730951}}, "df": 16}, "i": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 4}, "phml.builder": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 20}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.core.compiler": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.nodes.AST": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}}, "df": 49}, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 6, "s": {"docs": {"phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 7}}}, "g": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 16, "s": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 3}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 2.23606797749979}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 15}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {"phml.core.formats.compile.compile.process_conditions": {"tf": 1.7320508075688772}, "phml.core.nodes.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 2.23606797749979}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 2}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 2}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 17}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.process_props": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"phml.core.parser.Parser": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 3}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}}, "df": 1, "e": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 4}, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {"phml.utilities.travel.travel": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Text": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 2}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.23606797749979}}, "df": 8, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}}}, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 3}}, "df": 12, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.check": {"tf": 1}}, "df": 1}}, "s": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.nodes.types": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.4142135623730951}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 23, "s": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 5}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 3, "s": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 4}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {"phml": {"tf": 3.1622776601683795}, "phml.core.compiler.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 2.23606797749979}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.formats.parse.RE.tag_end": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Parent.append": {"tf": 1}, "phml.core.nodes.nodes.Parent.extend": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 3}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}, "phml.core.nodes.types": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.ast": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.ancestor": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 2}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 2.23606797749979}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 2}, "phml.utilities.travel.travel.path_names": {"tf": 2}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.7320508075688772}}, "df": 87, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}}, "df": 5}}}}}, "n": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 19, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 12}, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 10}}}, "r": {"docs": {"phml": {"tf": 3.4641016151377544}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.ClassList.add": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.inspect.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 53, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "#": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate": {"tf": 1}}, "df": 9, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.parser.Parser.parse": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 7, "[": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 4}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 4}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 2}}, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.utilities.misc.inspect": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1.7320508075688772}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 10, "s": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.core.nodes": {"tf": 1}}, "df": 2}}}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "u": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 11, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "d": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 21}, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 3}, "s": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 2.6457513110645907}}, "df": 1, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "p": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 4}, "l": {"docs": {"phml": {"tf": 2}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.parser.Parser": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate": {"tf": 1.4142135623730951}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1.4142135623730951}, "phml.utilities.misc": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.transform": {"tf": 1}, "phml.utilities.travel.travel": {"tf": 1.4142135623730951}, "phml.utilities.validate": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}}, "df": 16}}}, "y": {"docs": {"phml.builder": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform": {"tf": 1}}, "df": 8}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.parser.Parser.load": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.nodes.nodes.Literal": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 8, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}}, "df": 7}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 5}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Node.type": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.ast": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.formats.parse.RE.attribute": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 3.605551275463989}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 2.23606797749979}}, "df": 28, "s": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 13}, "|": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.formats.parse.RE.attribute": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}}, "df": 4, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.utilities.validate": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 7}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.validate": {"tf": 1}}, "df": 2}}}}}, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "d": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1, "o": {"docs": {"phml": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.DocType": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "m": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1}}, "w": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "n": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 3, "n": {"docs": {"phml.utilities.misc": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.utilities.misc": {"tf": 1}}, "df": 7}}}}}}}, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 9, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Text.num_lines": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.find.find": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 3}}}, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.nodes": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 2.449489742783178}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 20, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}}, "df": 2}}}}}}}}, "f": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml": {"tf": 2.23606797749979}, "phml.builder": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 17, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 8}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.RE.tag_start": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 2}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 16, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}}, "df": 11}}}, "s": {"docs": {"phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 3}}}}}, "y": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 2}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}}, "df": 1}}}, "r": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 25, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.parse_markup": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.parse_hypertest_markup": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.parse_markup": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}, "phml.utilities.misc.inspect": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}}, "df": 31, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.core.formats.parse.strip": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "b": {"docs": {"phml.core.formats.format.Format": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.core.formats": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 3}}}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.core.PHML.write": {"tf": 2}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 2}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 6, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 2}, "phml.core.nodes.nodes.Position": {"tf": 2.23606797749979}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 12}}}}, "l": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}}, "df": 3, "n": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.builder": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.check": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 3}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 2.449489742783178}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {"phml": {"tf": 2}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 8}, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.sanitize": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 1}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.AST": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 5, "s": {"docs": {"phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}}, "df": 4}}}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}}, "df": 2, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.core.core.PHML.compile": {"tf": 2}, "phml.core.core.PHML.render": {"tf": 2}, "phml.core.core.PHML.write": {"tf": 2}}, "df": 3}}}, "n": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "c": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.transform": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 7}, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}, "d": {"docs": {"phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.transform.transform.find_and_replace": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {"phml": {"tf": 2}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {"phml.utilities.locate.select.query": {"tf": 2}, "phml.utilities.locate.select.query_all": {"tf": 2}, "phml.utilities.locate.select.matches": {"tf": 2}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "a": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"phml": {"tf": 4.358898943540674}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.tag_stack": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Point": {"tf": 2}, "phml.core.nodes.nodes.Position": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 2.23606797749979}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1.4142135623730951}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes": {"tf": 1}, "phml.utilities.misc.classes.ClassList.toggle": {"tf": 1}, "phml.utilities.misc.classes.ClassList.replace": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 54, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 2}, "phml.core.formats.compile.compile.process_props": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 3, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 4, "o": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.PHML.parse": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 20}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1.7320508075688772}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1.7320508075688772}}, "df": 6, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 2}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2}}, "df": 6, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Point": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.indexed_tree": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}}, "df": 7}, "s": {"docs": {"phml.utilities.locate.index.Index.items": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}}, "df": 4}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "s": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.parser.Parser": {"tf": 1}, "phml.utilities": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.nodes.nodes.Parent.insert": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.core.PHML.write": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.inspect": {"tf": 1.4142135623730951}, "phml.utilities.misc.inspect.inspect": {"tf": 1}}, "df": 2}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}}, "df": 6}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.find.find_all_between": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 5, "[": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {"phml": {"tf": 4.242640687119285}, "phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.core.PHML.remove": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 2}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.nodes.types": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.Import": {"tf": 1}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1.4142135623730951}, "phml.utilities.misc.classes.classnames": {"tf": 1.7320508075688772}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.map_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.7320508075688772}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.449489742783178}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 2.6457513110645907}}, "df": 57, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "f": {"docs": {"phml": {"tf": 4.58257569495584}, "phml.core.core.PHML.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.is_self_closing": {"tf": 1.4142135623730951}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 2}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.locate.index.Index.add": {"tf": 1}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.inspect.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 2.23606797749979}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.has_property": {"tf": 1}, "phml.utilities.validate.validate.is_heading": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_css_style": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_javascript": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_embedded": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_interactive": {"tf": 2.6457513110645907}, "phml.utilities.validate.validate.is_phrasing": {"tf": 2.23606797749979}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 2}}, "df": 52, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.remove": {"tf": 1.7320508075688772}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1.7320508075688772}}, "df": 30, "s": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_event_handler": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"phml.core.parser.Parser": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 6}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.core.nodes.AST": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.travel.travel.walk": {"tf": 1}, "phml.utilities.travel.travel.visit_children": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.validate.check.check": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}}, "df": 2, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import": {"tf": 1.4142135623730951}, "phml.core.virtual_python.Import.from_node": {"tf": 2.23606797749979}, "phml.core.virtual_python.ImportFrom": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 2.23606797749979}}, "df": 6, "s": {"docs": {"phml": {"tf": 1}, "phml.core.virtual_python.VirtualPython": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 3}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml.core.virtual_python.ImportFrom": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1, "s": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}}, "df": 4}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "g": {"docs": {"phml.utilities.validate.validate.is_embedded": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 3}}}, "b": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "?": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 2}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}}, "df": 3, "s": {"docs": {"phml": {"tf": 2.8284271247461903}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 2.449489742783178}, "phml.core.virtual_python.process_python_blocks": {"tf": 1.4142135623730951}}, "df": 8}}}, "g": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"phml.core.formats.parse.strip_blank_lines": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 2}}, "df": 4, "/": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.formats.format.Format": {"tf": 1}}, "df": 1, "d": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.compile.process_reserved_attrs": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1}, "phml.utilities.misc.classes.ClassList": {"tf": 1}, "phml.utilities.validate.validate.validate": {"tf": 1}, "phml.utilities.validate.validate.parent": {"tf": 1}, "phml.utilities.validate.validate.literal": {"tf": 1}}, "df": 7}}, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.core.nodes.AST": {"tf": 1.4142135623730951}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml": {"tf": 3.872983346207417}, "phml.core.compiler.Compiler.add": {"tf": 2.8284271247461903}, "phml.core.core.PHML.add": {"tf": 3}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 2}, "phml.core.nodes.nodes.Element": {"tf": 2}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 2}, "phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.value": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.types.Properties": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.modify_children": {"tf": 1.4142135623730951}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 32, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 4}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}}, "df": 3}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 5}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.utilities.misc.inspect.normalize_indent": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 2}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 7, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 8}, "d": {"docs": {"phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.nodes.nodes.Element.end_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType.stringify": {"tf": 1}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.builder": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.builder": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.shift_heading": {"tf": 1}}, "df": 11}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 6}}, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 2}}, "df": 1}}, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}, "o": {"docs": {"phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 1}}}, "f": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml": {"tf": 4}, "phml.builder.p": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.expand": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile": {"tf": 1}, "phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.PI": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.core.nodes.nodes.Position.__init__": {"tf": 1}, "phml.core.parser": {"tf": 1}, "phml.core.virtual_python": {"tf": 1.4142135623730951}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.locate.select": {"tf": 1}, "phml.utilities.misc": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.transform.normalize_indent": {"tf": 1}, "phml.utilities.transform.sanitize": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.generated": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 49, "m": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 5, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1.7320508075688772}, "phml.core.core.PHML.render": {"tf": 2}, "phml.core.core.PHML.write": {"tf": 1.7320508075688772}, "phml.core.formats": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.format.Format.is_format": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}}, "df": 22, "s": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.formats": {"tf": 2}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 7}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.misc.classes.ClassList.class_list": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}}}}}, "x": {"docs": {"phml": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.apply_python": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}}, "df": 10}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}}, "df": 3}}}, "s": {"docs": {"phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"phml": {"tf": 2}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1.4142135623730951}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.remove": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.compile.compile.apply_conditions": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.core.formats.compile.compile.build_locals": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.core.nodes.nodes.Parent.remove": {"tf": 1}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 1.7320508075688772}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1}, "phml.utilities.locate.find.find_all_after": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1}, "phml.utilities.locate.find.find_before": {"tf": 1}, "phml.utilities.locate.find.find_all_between": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index.remove": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.locate.index.Index.key_by_tag": {"tf": 1}, "phml.utilities.misc.classes.ClassList.remove": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}, "phml.utilities.transform.sanitize.Schema": {"tf": 1}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 42}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.select.query": {"tf": 2.8284271247461903}, "phml.utilities.locate.select.query_all": {"tf": 2.6457513110645907}, "phml.utilities.locate.select.matches": {"tf": 2.449489742783178}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}, "phml.utilities.transform.transform.find_and_replace": {"tf": 1}, "phml.utilities.travel.travel.walk": {"tf": 1}}, "df": 21, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.virtual_python": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1.7320508075688772}, "phml.core.core.PHML.compile": {"tf": 1.4142135623730951}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 2.449489742783178}, "phml.core.formats": {"tf": 1.4142135623730951}, "phml.core.formats.Formats": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.extension": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.suffix": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.json_format.JSONFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.phml_format.PHMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.formats.xml_format.XMLFormat.extension": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Point": {"tf": 2}, "phml.core.nodes.nodes.Position": {"tf": 1.4142135623730951}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tokanize_name": {"tf": 1.4142135623730951}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 23, "s": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.load": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 1.4142135623730951}}, "df": 9}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.add": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}}, "df": 4, "s": {"docs": {"phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.core.PHML.compile": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {"phml.core.core.PHML.remove": {"tf": 1}, "phml.utilities.locate": {"tf": 1}, "phml.utilities.locate.find": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_all": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.transform.transform.replace_node": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 11, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.utilities.locate": {"tf": 1}, "phml.utilities.misc.classes": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.parser.Parser.load": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Element": {"tf": 2.8284271247461903}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Node.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Node.type": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Point": {"tf": 1.7320508075688772}, "phml.core.nodes.nodes.Position": {"tf": 1.7320508075688772}, "phml.core.nodes.types.Properties": {"tf": 1}}, "df": 8, "s": {"docs": {"phml.core.nodes.nodes.Position": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"phml.utilities.misc.classes": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.virtual_python.process_python_blocks": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}, "phml.utilities.transform.transform.map_nodes": {"tf": 1}, "phml.utilities.transform.transform.modify_children": {"tf": 2}, "phml.utilities.validate.check.check": {"tf": 1}}, "df": 9, "s": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.utilities": {"tf": 1}, "phml.utilities.misc.heading": {"tf": 1}}, "df": 4}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML": {"tf": 1}, "phml.core.parser": {"tf": 1}}, "df": 2}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1}}, "df": 1, "y": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.core.PHML.write": {"tf": 1}, "phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"phml": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1.7320508075688772}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.core.PHML.compile": {"tf": 1}, "phml.core.core.PHML.render": {"tf": 1}, "phml.core.core.PHML.write": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1.4142135623730951}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.parse.strip": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.load": {"tf": 1.4142135623730951}, "phml.core.parser.Parser.parse": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 1.4142135623730951}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1}, "phml.utilities.travel.travel.path": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path_names": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.visit_all_after": {"tf": 1}, "phml.utilities.validate.check.check": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_element": {"tf": 1}}, "df": 36}, "s": {"docs": {"phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {"phml": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 3, "d": {"docs": {"phml.core.nodes.nodes.Node.position": {"tf": 1}, "phml.core.nodes.nodes.Literal.position": {"tf": 1}, "phml.core.nodes.nodes.Position": {"tf": 1}, "phml.utilities.validate.validate.generated": {"tf": 1.4142135623730951}}, "df": 4, "/": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {"phml.core.virtual_python.Import.from_node": {"tf": 1}, "phml.core.virtual_python.ImportFrom.from_node": {"tf": 1}, "phml.utilities.misc.component.tokanize_name": {"tf": 1}, "phml.utilities.misc.component.tag_from_file": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.locate.index.Index": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {"phml.builder.p": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"phml.core.nodes.AST.AST.size": {"tf": 1}, "phml.core.nodes.AST.AST.children": {"tf": 1}, "phml.core.nodes.nodes.Literal.normalized": {"tf": 1}, "phml.core.nodes.nodes.Literal.get_ancestry": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.locate.find.ancestor": {"tf": 1}, "phml.utilities.locate.find.find_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_after": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_all_between": {"tf": 1}, "phml.utilities.locate.index.Index.items": {"tf": 1}, "phml.utilities.locate.index.Index.values": {"tf": 1}, "phml.utilities.locate.index.Index.keys": {"tf": 1}, "phml.utilities.locate.index.Index.get": {"tf": 1}, "phml.utilities.misc.depth": {"tf": 1}, "phml.utilities.misc.size": {"tf": 1}, "phml.utilities.misc.offset": {"tf": 1}, "phml.utilities.misc.component.filename_from_path": {"tf": 1}, "phml.utilities.misc.heading.heading_rank": {"tf": 1}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.travel.travel.path": {"tf": 1}, "phml.utilities.travel.travel.path_names": {"tf": 1}}, "df": 21, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.transform.extract.to_string": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"phml": {"tf": 5.744562646538029}, "phml.core.formats.parse.RE.tag_end": {"tf": 1.4142135623730951}, "phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Element.start_tag": {"tf": 1}, "phml.core.nodes.nodes.DocType": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1}, "phml.core.nodes.nodes.Text": {"tf": 1.4142135623730951}, "phml.core.virtual_python": {"tf": 3.3166247903554}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}, "phml.utilities.validate.validate.is_css_style": {"tf": 1}, "phml.utilities.validate.validate.is_javascript": {"tf": 1}, "phml.utilities.validate.validate.blank": {"tf": 1}}, "df": 14}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml.core.core.PHML.expose": {"tf": 1}, "phml.core.virtual_python.get_python_result": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}}, "df": 2}}}}}}}}, "c": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.builder.p": {"tf": 1}, "phml.core.virtual_python": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"phml": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1}}, "df": 2, "s": {"docs": {"phml.core.virtual_python": {"tf": 1}, "phml.utilities.locate.index.Index": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.formats.compile.compile.execute_conditions": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.py_condition": {"tf": 1}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.run_phml_if": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_elif": {"tf": 1}, "phml.core.formats.compile.compile.run_phml_else": {"tf": 1}, "phml.utilities.locate.find.find": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_after": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_after": {"tf": 2}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}, "phml.utilities.locate.find.find_before": {"tf": 1.7320508075688772}, "phml.utilities.locate.find.find_all_between": {"tf": 1.7320508075688772}, "phml.utilities.locate.index.Index": {"tf": 1}, "phml.utilities.transform.transform.filter_nodes": {"tf": 2}, "phml.utilities.transform.transform.remove_nodes": {"tf": 1.7320508075688772}, "phml.utilities.transform.transform.replace_node": {"tf": 1.4142135623730951}, "phml.utilities.validate": {"tf": 1}}, "df": 19, "a": {"docs": {}, "df": 0, "l": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}}, "df": 3}}, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.formats.compile.compile.process_conditions": {"tf": 1}, "phml.core.formats.compile.compile.execute_conditions": {"tf": 1.7320508075688772}, "phml.core.virtual_python": {"tf": 1}, "phml.utilities.misc.classes.classnames": {"tf": 1}, "phml.utilities.validate.check": {"tf": 1}, "phml.utilities.validate.validate.is_element": {"tf": 1}, "phml.utilities.validate.validate.is_interactive": {"tf": 1}}, "df": 8}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.json_format.construct_tree": {"tf": 1}, "phml.core.nodes.nodes.PI.stringify": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"phml": {"tf": 1}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.nodes.AST.AST": {"tf": 1}, "phml.utilities.misc.classes.ClassList.contains": {"tf": 1}, "phml.utilities.validate.validate.is_css_link": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.nodes.nodes.Parent": {"tf": 1}, "phml.core.nodes.nodes.Literal": {"tf": 1}, "phml.utilities.locate.select.parse_specifiers": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.core.PHML.render": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Root": {"tf": 1}, "phml.core.nodes.nodes.Parent": {"tf": 1.4142135623730951}, "phml.utilities.transform.normalize_indent": {"tf": 1.4142135623730951}, "phml.utilities.transform.extract.to_string": {"tf": 1.4142135623730951}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1.7320508075688772}}, "df": 8}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"phml.utilities.locate.select.query": {"tf": 1.4142135623730951}, "phml.utilities.locate.select.query_all": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"phml.utilities.validate.validate.is_interactive": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Position.as_dict": {"tf": 1}, "phml.core.parser.Parser": {"tf": 1.4142135623730951}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.core.nodes.nodes.Node": {"tf": 1}, "phml.utilities.locate.index.Index.__init__": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.classnames": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"phml.utilities.validate.validate.generated": {"tf": 1}}, "df": 1}}}}}}}}, "m": {"docs": {"phml": {"tf": 1}, "phml.core.nodes.nodes.Element": {"tf": 1.4142135623730951}}, "df": 2, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 3.1622776601683795}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 3.1622776601683795}, "phml.core.formats.compile.component.substitute_component": {"tf": 1}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.component.valid_component_dict": {"tf": 1}, "phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 7, "s": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.add": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.remove": {"tf": 2}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.7320508075688772}, "phml.core.formats.compile.component.replace_components": {"tf": 1}, "phml.utilities.misc.component.parse_component": {"tf": 1}}, "df": 7, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.compiler": {"tf": 1}, "phml.core.compiler.Compiler": {"tf": 1}, "phml.core.core.PHML.compile": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer.compile": {"tf": 1.4142135623730951}, "phml.core.formats.format.Format": {"tf": 1}, "phml.core.formats.format.Format.compile": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.compile": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.compile": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.compile": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}}, "df": 15, "d": {"docs": {"phml": {"tf": 1}, "phml.utilities.transform.sanitize.sanatize": {"tf": 1}}, "df": 2}, "r": {"docs": {"phml": {"tf": 1.7320508075688772}, "phml.core.compiler.Compiler.ast": {"tf": 1}, "phml.core.compiler.Compiler.remove": {"tf": 1}, "phml.core.core.PHML": {"tf": 1}, "phml.core.core.PHML.components": {"tf": 1}, "phml.core.core.PHML.add": {"tf": 1.4142135623730951}, "phml.core.core.PHML.write": {"tf": 1}}, "df": 7, "s": {"docs": {"phml.core.compiler.Compiler.add": {"tf": 1}, "phml.core.core.PHML.expose": {"tf": 1}, "phml.core.core.PHML.redact": {"tf": 1}, "phml.core.core.PHML.restrict": {"tf": 1}}, "df": 4}}, "s": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.formats.compile.compile.ASTRenderer": {"tf": 1.4142135623730951}}, "df": 2}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.core.compiler.Compiler.compile": {"tf": 1}, "phml.core.compiler.Compiler.render": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"phml.core.formats": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat": {"tf": 1}, "phml.core.formats.json_format.JSONFormat": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat": {"tf": 1}}, "df": 5}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {"phml.utilities.locate.select.query": {"tf": 1}, "phml.utilities.locate.select.query_all": {"tf": 1}, "phml.utilities.locate.select.matches": {"tf": 1}}, "df": 3}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1}, "phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 2, "s": {"docs": {"phml": {"tf": 1}}, "df": 1}, "d": {"docs": {"phml.core.formats.compile.component.combine_component_elements": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"phml": {"tf": 1}, "phml.utilities.locate.find.find_all_before": {"tf": 1.4142135623730951}}, "df": 2}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}, "phml.core.nodes.nodes.Comment": {"tf": 1.4142135623730951}, "phml.core.nodes.nodes.Comment.stringify": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"phml.core.formats.parse.RE.comment": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"phml.utilities.locate.find.ancestor": {"tf": 1.7320508075688772}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"phml.utilities.misc.component.cmpt_name_from_path": {"tf": 1}}, "df": 1}}}}}, "/": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"phml.utilities.misc.classes.ClassList": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"phml": {"tf": 1.4142135623730951}, "phml.core.formats.parse.HypertextMarkupParser": {"tf": 1}, "phml.core.formats.parse.HypertextMarkupParser.parse": {"tf": 1}, "phml.core.virtual_python.VirtualPython.get_python_context": {"tf": 1}, "phml.utilities.validate.validate.is_phrasing": {"tf": 1}}, "df": 5}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"phml.core.compiler": {"tf": 1}, "phml.core.formats": {"tf": 1.7320508075688772}, "phml.core.formats.format.Format.parse": {"tf": 1}, "phml.core.formats.format.Format.render": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.parse": {"tf": 1}, "phml.core.formats.html_format.HTMLFormat.render": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.parse": {"tf": 1}, "phml.core.formats.json_format.JSONFormat.render": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.parse": {"tf": 1}, "phml.core.formats.phml_format.PHMLFormat.render": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.parse": {"tf": 1}, "phml.core.formats.xml_format.XMLFormat.render": {"tf": 1}, "phml.core.parser": {"tf": 1.7320508075688772}, "phml.core.parser.Parser.load": {"tf": 1}, "phml.core.parser.Parser.parse": {"tf": 1}}, "df": 15}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p"