/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;

public class AbsoluteIRIHelper {
    public static IRI verifyAbsolute(IRI iri, @Nullable OWLDocumentFormat f, OWLOntology o) {
        Optional<IRI> defaultDocumentIRI;
        Optional<IRI> ontologyIRI;
        if (iri.isAbsolute()) {
            return iri;
        }
        if (f == null || f.supportsRelativeIRIs()) {
            return iri;
        }
        String defaultPrefix = null;
        if (f.isPrefixOWLOntologyFormat()) {
            defaultPrefix = f.asPrefixOWLOntologyFormat().getDefaultPrefix();
        }
        if (defaultPrefix == null && (ontologyIRI = o.getOntologyID().getOntologyIRI()).isPresent()) {
            defaultPrefix = ((IRI)ontologyIRI.get()).toString();
        }
        if (defaultPrefix == null && (defaultDocumentIRI = o.getOntologyID().getDefaultDocumentIRI()).isPresent()) {
            defaultPrefix = ((IRI)defaultDocumentIRI.get()).toString();
        }
        if (defaultPrefix == null) {
            return IRI.create("urn:absoluteiri:defaultvalue#" + iri);
        }
        return IRI.create(defaultPrefix + iri);
    }
}

