/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.CharCollection;
import com.carrotsearch.hppcrt.CharLookupContainer;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import java.util.Arrays;

public abstract class AbstractCharCollection
implements CharCollection {
    protected CharLookupContainer testContainer;
    protected CharPredicate testPredicate;
    protected CharPredicate containsTestPredicate = new CharPredicate(){

        public final boolean apply(char k) {
            return AbstractCharCollection.this.testContainer.contains(k);
        }
    };
    protected CharPredicate containsNegateTestPredicate = new CharPredicate(){

        public final boolean apply(char k) {
            return !AbstractCharCollection.this.testContainer.contains(k);
        }
    };
    protected CharPredicate negatePredicate = new CharPredicate(){

        public final boolean apply(char k) {
            return !AbstractCharCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(CharLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(CharLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(CharPredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public char[] toArray(char[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (CharCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public char[] toArray() {
        try {
            return this.toArray(new char[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

