/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLIndividualVisitorEx;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLIndividualImpl;

public class OWLAnonymousIndividualImpl
extends OWLIndividualImpl
implements OWLAnonymousIndividual {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final NodeID nodeId;

    @Override
    protected int index() {
        return 1007;
    }

    public OWLAnonymousIndividualImpl(@Nonnull NodeID nodeID) {
        this.nodeId = (NodeID)OWLAPIPreconditions.checkNotNull((Object)nodeID, (String)"nodeID cannot be null");
    }

    public NodeID getID() {
        return this.nodeId;
    }

    public String toStringID() {
        return this.nodeId.getID();
    }

    @Nonnull
    public OWLAnonymousIndividual asOWLAnonymousIndividual() {
        return this;
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not a named individual! This method should only be called on named individuals");
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnonymousIndividual other = (OWLAnonymousIndividual)object;
        return this.nodeId.compareTo(other.getID());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnonymousIndividual)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnonymousIndividual)this);
    }

    public void accept(OWLIndividualVisitor visitor) {
        visitor.visit((OWLAnonymousIndividual)this);
    }

    public <O> O accept(OWLIndividualVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnonymousIndividual)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLAnonymousIndividual)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnonymousIndividual)this);
    }

    public void accept(OWLAnnotationSubjectVisitor visitor) {
        visitor.visit((OWLAnonymousIndividual)this);
    }

    public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
        return (E)visitor.visit((OWLAnonymousIndividual)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.of((Object)this);
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.absent();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLAnonymousIndividual)) {
            return false;
        }
        return this.nodeId.equals((Object)((OWLAnonymousIndividual)obj).getID());
    }

    @Override
    public int hashCode() {
        return this.nodeId.hashCode();
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        anons.add(this);
    }
}

