/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorExAdapter;

public class InitVisitorFactory {
    static final InitVisitor<OWLClass> CLASSSUBNAMED = new InitVisitor(true, true);
    static final InitVisitor<OWLClassExpression> CLASSEXPRESSIONS = new InitVisitor(true, true);
    static final InitVisitor<OWLClass> CLASSSUPERNAMED = new InitVisitor(false, true);
    static final InitCollectionVisitor<OWLClass> CLASSCOLLECTIONS = new InitCollectionVisitor(true);
    static final InitCollectionVisitor<OWLObjectPropertyExpression> OPCOLLECTIONS = new InitCollectionVisitor(true);
    static final InitCollectionVisitor<OWLDataPropertyExpression> DPCOLLECTIONS = new InitCollectionVisitor(true);
    static final InitCollectionVisitor<OWLIndividual> ICOLLECTIONS = new InitCollectionVisitor(true);
    static final InitVisitor<OWLObjectPropertyExpression> OPSUBNAMED = new InitVisitor(true, true);
    static final InitVisitor<OWLObjectPropertyExpression> OPSUPERNAMED = new InitVisitor(false, true);
    static final InitVisitor<OWLDataPropertyExpression> DPSUBNAMED = new InitVisitor(true, true);
    static final InitVisitor<OWLDataPropertyExpression> DPSUPERNAMED = new InitVisitor(false, true);
    static final InitVisitor<OWLIndividual> INDIVIDUALSUBNAMED = new InitIndividualVisitor<OWLIndividual>(true, true);
    static final InitVisitor<OWLAnnotationSubject> ANNOTSUPERNAMED = new InitVisitor(true, true);

    private InitVisitorFactory() {
    }

    public static class InitCollectionVisitor<K>
    extends OWLAxiomVisitorExAdapter<Collection<K>> {
        private final boolean named;

        public InitCollectionVisitor(boolean named) {
            super((Object)CollectionFactory.emptySet());
            this.named = named;
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLDisjointClassesAxiom axiom) {
            ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>(axiom.getClassExpressions());
            if (this.named) {
                InitCollectionVisitor.deleteAnonymousClasses(list);
            }
            return list;
        }

        private static void deleteAnonymousClasses(@Nonnull List<OWLClassExpression> list) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).isAnonymous()) {
                    list.remove(i);
                    continue;
                }
                ++i;
            }
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
            return axiom.getProperties();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
            return axiom.getIndividuals();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
            return axiom.getProperties();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
            return axiom.getProperties();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLDisjointUnionAxiom axiom) {
            return CollectionFactory.createSet((Object)axiom.getOWLClass());
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
            return axiom.getProperties();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
            ArrayList<OWLClassExpression> list = new ArrayList<OWLClassExpression>(axiom.getClassExpressions());
            if (this.named) {
                InitCollectionVisitor.deleteAnonymousClasses(list);
            }
            return list;
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLSameIndividualAxiom axiom) {
            return axiom.getIndividuals();
        }

        @Nonnull
        public Collection<K> visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
            return axiom.getProperties();
        }
    }

    public static class InitIndividualVisitor<K extends OWLObject>
    extends InitVisitor<K> {
        public InitIndividualVisitor(boolean sub, boolean named) {
            super(sub, named);
        }

        @Override
        @Nonnull
        public K visit(@Nonnull OWLClassAssertionAxiom axiom) {
            return (K)axiom.getIndividual();
        }
    }

    public static class InitVisitor<K>
    extends OWLAxiomVisitorExAdapter<K> {
        private final boolean sub;
        private final boolean named;

        public InitVisitor(boolean sub, boolean named) {
            super(null);
            this.sub = sub;
            this.named = named;
        }

        public K visit(@Nonnull OWLSubClassOfAxiom axiom) {
            OWLClassExpression c;
            OWLClassExpression oWLClassExpression = c = this.sub ? axiom.getSubClass() : axiom.getSuperClass();
            if (this.named && c.isAnonymous()) {
                return (K)this.doDefault(axiom);
            }
            return (K)c;
        }

        @Nonnull
        public K visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return (K)axiom.getSubject();
        }

        @Nonnull
        public K visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
            return (K)axiom.getSubject();
        }

        @Nonnull
        public K visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
            return (K)axiom.getSubject();
        }

        @Nonnull
        public K visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            if (this.sub) {
                return (K)axiom.getSubProperty();
            }
            return (K)axiom.getSuperProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            return (K)axiom.getSubject();
        }

        @Nonnull
        public K visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        public K visit(@Nonnull OWLClassAssertionAxiom axiom) {
            OWLClassExpression c = axiom.getClassExpression();
            if (this.named && c.isAnonymous()) {
                return (K)this.doDefault(axiom);
            }
            return (K)c;
        }

        @Nonnull
        public K visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
            return (K)axiom.getSubject();
        }

        @Nonnull
        public K visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            if (this.sub) {
                return (K)axiom.getSubProperty();
            }
            return (K)axiom.getSuperProperty();
        }

        @Nonnull
        public K visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return (K)axiom.getProperty();
        }

        public K visit(@Nonnull OWLHasKeyAxiom axiom) {
            if (this.named && axiom.getClassExpression().isAnonymous()) {
                return (K)this.doDefault(axiom);
            }
            return (K)axiom.getClassExpression().asOWLClass();
        }
    }
}

