"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 */
class TopicPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUFrRDtBQUNsRCx3Q0FBeUM7QUFFekMsbURBQWlEO0FBYWpEOztHQUVHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsZUFBUTtJQVl2QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFabkI7O1dBRUc7UUFDYSxhQUFRLEdBQUcsSUFBSSx3QkFBYyxDQUFDO1lBQzVDLDREQUE0RDtZQUM1RCwyRUFBMkU7WUFDM0UsK0NBQStDO1lBQy9DLGtGQUFrRjtZQUNsRixVQUFVLEVBQUUsSUFBSTtTQUNqQixDQUFDLENBQUM7UUFLRCxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDN0IsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztTQUMxQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFwQkQsa0NBb0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUG9saWN5RG9jdW1lbnQgfSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCB7IFJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmblRvcGljUG9saWN5IH0gZnJvbSAnLi9zbnMuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElUb3BpYyB9IGZyb20gJy4vdG9waWMtYmFzZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBhc3NvY2lhdGUgU05TIHRvcGljcyB3aXRoIGEgcG9saWN5XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVG9waWNQb2xpY3lQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgc2V0IG9mIHRvcGljcyB0aGlzIHBvbGljeSBhcHBsaWVzIHRvLlxuICAgKi9cbiAgcmVhZG9ubHkgdG9waWNzOiBJVG9waWNbXTtcbn1cblxuLyoqXG4gKiBBcHBsaWVzIGEgcG9saWN5IHRvIFNOUyB0b3BpY3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBUb3BpY1BvbGljeSBleHRlbmRzIFJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBJQU0gcG9saWN5IGRvY3VtZW50IGZvciB0aGlzIHBvbGljeS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBkb2N1bWVudCA9IG5ldyBQb2xpY3lEb2N1bWVudCh7XG4gICAgLy8gc3RhdGVtZW50cyBtdXN0IGJlIHVuaXF1ZSwgc28gd2UgdXNlIHRoZSBzdGF0ZW1lbnQgaW5kZXguXG4gICAgLy8gcG90YW50aWFsbHkgU0lEcyBjYW4gY2hhbmdlIGFzIGEgcmVzdWx0IG9mIG9yZGVyIGNoYW5nZSwgYnV0IHRoaXMgc2hvdWxkXG4gICAgLy8gbm90IGhhdmUgYW4gaW1wYWN0IG9uIHRoZSBwb2xpY3kgZXZhbHVhdGlvbi5cbiAgICAvLyBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc25zL2xhdGVzdC9kZy9BY2Nlc3NQb2xpY3lMYW5ndWFnZV9TcGVjaWFsSW5mby5odG1sXG4gICAgYXNzaWduU2lkczogdHJ1ZSxcbiAgfSk7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFRvcGljUG9saWN5UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgbmV3IENmblRvcGljUG9saWN5KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIHBvbGljeURvY3VtZW50OiB0aGlzLmRvY3VtZW50LFxuICAgICAgdG9waWNzOiBwcm9wcy50b3BpY3MubWFwKHQgPT4gdC50b3BpY0FybiksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==