"""added fields from mdm

Peek Plugin Database Migration Script

Revision ID: b3f41d4bc7c2
Revises: de24e18d0e6e
Create Date: 2023-10-06 14:37:17.736457

"""

# revision identifiers, used by Alembic.
revision = "b3f41d4bc7c2"
down_revision = "de24e18d0e6e"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


__affectedTableName = "DeviceInfo"
__affectedSchemaName = "core_device"
__affectedColumnNames = [
    "mdmDeviceName",
    "mdmDeviceSerialNumber",
    "mdmDeviceAssetId",
    "mdmDeviceAllocatedTo",
]


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    for columnName in __affectedColumnNames:
        column = sa.Column(
            columnName,
            sa.String(),
            server_default="",
            nullable=True,
        )
        op.add_column(
            __affectedTableName, column=column, schema=__affectedSchemaName
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    for columnName in __affectedColumnNames:
        op.drop_column(
            __affectedTableName, columnName, schema=__affectedSchemaName
        )
    # ### end Alembic commands ###
