# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:19 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.iaud_search import iAudSearch
from bs_audit.db.tables.tran import tTran
from bs_audit.db.tables.aud import tAud
from bs_audit.db.tables.col import tCol
from bs_audit.db.tables.oaud_search import oAudSearch

class dAudSearch:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iAudSearch()
        self.orec     = oAudSearch()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        date_from: datetime.datetime,
                        date_to: datetime.datetime,
                        criteria: str) -> "dAudSearch":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param date_from: datetime.datetime
        :param date_to: datetime.datetime
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.date_from = date_from
        self.irec.date_to = date_to
        self.irec.criteria = criteria

        return await self.exec()

    async def exec(self, irec: iAudSearch = None) -> "dAudSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("AudSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  t.*,
  a.*,
  c.*
from
  audit.tran t
    join
  audit.aud a
    on t.id = a.tran_id
    join
  audit.col c
    on a.id = c.aud_id
where
  t.site_id = :siteId   and
  ( cast(:dateFrom as timestamp) is null or t.tm_stamp >= :dateFrom ) and
  ( cast(:dateTo as timestamp) is null or t.tm_stamp <= :dateTo )
  [criteria]
order by
  t.id desc,
  a.tbl_id,
  c.name""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("dateFrom", self.irec.date_from, datetime.datetime)
        self._dbstmnt.bind_in("dateTo", self.irec.date_to, datetime.datetime)

        self._dbstmnt.bind_out("tran_id", int, 8)
        self._dbstmnt.bind_out("tran_site_id", int, 4)
        self._dbstmnt.bind_out("tran_who", str, 128)
        self._dbstmnt.bind_out("tran_src", str, 128)
        self._dbstmnt.bind_out("tran_tm_stamp", datetime.datetime)
        self._dbstmnt.bind_out("aud_id", int, 8)
        self._dbstmnt.bind_out("aud_tran_id", int, 8)
        self._dbstmnt.bind_out("aud_action", str, 1)
        self._dbstmnt.bind_out("aud_tbl_id", str, 64)
        self._dbstmnt.bind_out("aud_tbl_key", str, 128)
        self._dbstmnt.bind_out("aud_par_tbl_id", str, 64)
        self._dbstmnt.bind_out("aud_par_tbl_key", str, 128)
        self._dbstmnt.bind_out("col_aud_id", int, 8)
        self._dbstmnt.bind_out("col_name", str, 64)
        self._dbstmnt.bind_out("col_before", str, 128)
        self._dbstmnt.bind_out("col_after", str, 128)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.tran.id = self._dbstmnt.result[0]
        self.orec.tran.site_id = self._dbstmnt.result[1]
        self.orec.tran.who = self._dbstmnt.result[2]
        self.orec.tran.src = self._dbstmnt.result[3]
        self.orec.tran.tm_stamp = self._dbstmnt.result[4]
        self.orec.aud.id = self._dbstmnt.result[5]
        self.orec.aud.tran_id = self._dbstmnt.result[6]
        self.orec.aud.action = self._dbstmnt.result[7]
        self.orec.aud.tbl_id = self._dbstmnt.result[8]
        self.orec.aud.tbl_key = self._dbstmnt.result[9]
        self.orec.aud.par_tbl_id = self._dbstmnt.result[10]
        self.orec.aud.par_tbl_key = self._dbstmnt.result[11]
        self.orec.col.aud_id = self._dbstmnt.result[12]
        self.orec.col.name = self._dbstmnt.result[13]
        self.orec.col.before = self._dbstmnt.result[14]
        self.orec.col.after = self._dbstmnt.result[15]

        return True

    async def fetch_all(self, outList: oAudSearch.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

