"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpUserPoolAuthorizer {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_UserPoolAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        if (!this.authorizer) {
            const id = this.props.authorizerName && !aws_cdk_lib_1.Token.isUnresolved(this.props.authorizerName) ?
                this.props.authorizerName : 'UserPoolAuthorizer';
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Stack.of(options.scope).region;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : ['$request.header.Authorization'],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName,
                jwtAudience: this.props.userPoolClients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.props.userPool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpUserPoolAuthorizer", version: "2.0.0-alpha.8" };
//# sourceMappingURL=data:application/json;base64,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