# coding: utf-8

# (C) Copyright IBM Corp. 2023.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# IBM OpenAPI SDK Code Generator Version: 3.54.0-af6d2126-20220803-151219
 
"""
No description provided (generated by Openapi Generator
https://github.com/openapitools/openapi-generator)

API Version: 1.0
"""

from datetime import datetime
from enum import Enum
from typing import BinaryIO, Dict, List
import json

from ibm_cloud_sdk_core import BaseService, DetailedResponse, get_query_param
from ibm_cloud_sdk_core.authenticators.authenticator import Authenticator
from ibm_cloud_sdk_core.get_authenticator import get_authenticator_from_environment
from ibm_cloud_sdk_core.utils import convert_model, datetime_to_string, string_to_datetime

from .common import get_sdk_headers

##############################################################################
# Service
##############################################################################

class EventNotificationsV1(BaseService):
    """The Event Notifications V1 service."""

    DEFAULT_SERVICE_URL = 'https://us-south.event-notifications.cloud.ibm.com/event-notifications'
    DEFAULT_SERVICE_NAME = 'event_notifications'

    @classmethod
    def new_instance(cls,
                     service_name: str = DEFAULT_SERVICE_NAME,
                    ) -> 'EventNotificationsV1':
        """
        Return a new client for the Event Notifications service using the specified
               parameters and external configuration.
        """
        authenticator = get_authenticator_from_environment(service_name)
        service = cls(
            authenticator
            )
        service.configure_service(service_name)
        return service

    def __init__(self,
                 authenticator: Authenticator = None,
                ) -> None:
        """
        Construct a new client for the Event Notifications service.

        :param Authenticator authenticator: The authenticator specifies the authentication mechanism.
               Get up to date information from https://github.com/IBM/python-sdk-core/blob/main/README.md
               about initializing the authenticator of your choice.
        """
        BaseService.__init__(self,
                             service_url=self.DEFAULT_SERVICE_URL,
                             authenticator=authenticator)


    #########################
    # Send Notifications
    #########################


    def send_notifications(self,
        instance_id: str,
        *,
        body: 'NotificationCreate' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Send a notification.

        Send Notifications body from the instance. For more information about Event
        Notifications payload, see
        [here](https://cloud.ibm.com/docs/event-notifications?topic=event-notifications-en-spec-payload).

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param NotificationCreate body: (optional)
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `NotificationResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if  body is not None and isinstance(body, NotificationCreate):
            body = convert_model(body)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='send_notifications')
        headers.update(sdk_headers)

        data = json.dumps(body)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/notifications'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def send_bulk_notifications(self,
        instance_id: str,
        *,
        bulk_messages: List['NotificationCreate'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Send Bulk notification.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param List[NotificationCreate] bulk_messages: (optional) List of
               notifications body.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `BulkNotificationResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if bulk_messages is not None:
            bulk_messages = [convert_model(x) for x in bulk_messages]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='send_bulk_notifications')
        headers.update(sdk_headers)

        data = {
            'bulk_messages': bulk_messages
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/notifications/bulk'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Sources
    #########################


    def create_sources(self,
        instance_id: str,
        name: str,
        description: str,
        *,
        enabled: bool = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new API Source.

        Create a new API Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param bool enabled: (optional) Whether the source is enabled or not.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SourceResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if description is None:
            raise ValueError('description must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_sources')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'enabled': enabled
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_sources(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Sources.

        List all Sources.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SourceList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_sources')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_source(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get a Source.

        Get a Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Source` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_source')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def delete_source(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Source.

        Delete a Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_source')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_source(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        enabled: bool = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Source.

        Update details of a Source.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Source.
        :param str name: (optional) Name of the source.
        :param str description: (optional) Description of the source.
        :param bool enabled: (optional) Whether the source is enabled or not.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Source` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_source')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'enabled': enabled
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/sources/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Topics
    #########################


    def create_topic(self,
        instance_id: str,
        name: str,
        *,
        description: str = None,
        sources: List['SourcesItems'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Topic.

        Create a new Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Name of the topic.
        :param str description: (optional) Description of the topic.
        :param List[SourcesItems] sources: (optional) List of sources.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TopicResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if sources is not None:
            sources = [convert_model(x) for x in sources]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_topic')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'sources': sources
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_topics(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Topics.

        List all Topics.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TopicList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_topics')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_topic(self,
        instance_id: str,
        id: str,
        *,
        include: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Topic.

        Get details of a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param str include: (optional) Include sub topics.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Topic` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_topic')
        headers.update(sdk_headers)

        params = {
            'include': include
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def replace_topic(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        sources: List['SourcesItems'] = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Topic.

        Update details of a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param str name: (optional) Name of the topic.
        :param str description: (optional) Description of the topic.
        :param List[SourcesItems] sources: (optional) List of sources.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Topic` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if sources is not None:
            sources = [convert_model(x) for x in sources]
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='replace_topic')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'sources': sources
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def delete_topic(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Topic.

        Delete a Topic.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Topic.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_topic')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/topics/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Destinations
    #########################


    def create_destination(self,
        instance_id: str,
        name: str,
        type: str,
        *,
        description: str = None,
        config: 'DestinationConfig' = None,
        certificate: BinaryIO = None,
        certificate_content_type: str = None,
        icon_16x16: BinaryIO = None,
        icon_16x16_content_type: str = None,
        icon_16x16_2x: BinaryIO = None,
        icon_16x16_2x_content_type: str = None,
        icon_32x32: BinaryIO = None,
        icon_32x32_content_type: str = None,
        icon_32x32_2x: BinaryIO = None,
        icon_32x32_2x_content_type: str = None,
        icon_128x128: BinaryIO = None,
        icon_128x128_content_type: str = None,
        icon_128x128_2x: BinaryIO = None,
        icon_128x128_2x_content_type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Destination.

        Create a new Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: The Destination name.
        :param str type: The type of Destination Webhook.
        :param str description: (optional) The Destination description.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        :param BinaryIO certificate: (optional) Certificate for APNS.
        :param str certificate_content_type: (optional) The content type of
               certificate.
        :param BinaryIO icon_16x16: (optional) Safari icon 16x16.
        :param str icon_16x16_content_type: (optional) The content type of
               icon_16x16.
        :param BinaryIO icon_16x16_2x: (optional) Safari icon 16x16@2x.
        :param str icon_16x16_2x_content_type: (optional) The content type of
               icon_16x16_2x.
        :param BinaryIO icon_32x32: (optional) Safari icon 32x32.
        :param str icon_32x32_content_type: (optional) The content type of
               icon_32x32.
        :param BinaryIO icon_32x32_2x: (optional) Safari icon 32x32@2x.
        :param str icon_32x32_2x_content_type: (optional) The content type of
               icon_32x32_2x.
        :param BinaryIO icon_128x128: (optional) Safari icon 128x128.
        :param str icon_128x128_content_type: (optional) The content type of
               icon_128x128.
        :param BinaryIO icon_128x128_2x: (optional) Safari icon 128x128@2x.
        :param str icon_128x128_2x_content_type: (optional) The content type of
               icon_128x128_2x.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if type is None:
            raise ValueError('type must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_destination')
        headers.update(sdk_headers)

        form_data = []
        form_data.append(('name', (None, name, 'text/plain')))
        form_data.append(('type', (None, type, 'text/plain')))
        if description:
            form_data.append(('description', (None, description, 'text/plain')))
        if config:
            form_data.append(('config', (None, json.dumps(config), 'application/json')))
        if certificate:
            form_data.append(('certificate', (None, certificate, certificate_content_type or 'application/octet-stream')))
        if icon_16x16:
            form_data.append(('icon_16x16', (None, icon_16x16, icon_16x16_content_type or 'application/octet-stream')))
        if icon_16x16_2x:
            form_data.append(('icon_16x16_2x', (None, icon_16x16_2x, icon_16x16_2x_content_type or 'application/octet-stream')))
        if icon_32x32:
            form_data.append(('icon_32x32', (None, icon_32x32, icon_32x32_content_type or 'application/octet-stream')))
        if icon_32x32_2x:
            form_data.append(('icon_32x32_2x', (None, icon_32x32_2x, icon_32x32_2x_content_type or 'application/octet-stream')))
        if icon_128x128:
            form_data.append(('icon_128x128', (None, icon_128x128, icon_128x128_content_type or 'application/octet-stream')))
        if icon_128x128_2x:
            form_data.append(('icon_128x128_2x', (None, icon_128x128_2x, icon_128x128_2x_content_type or 'application/octet-stream')))

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       files=form_data)

        response = self.send(request, **kwargs)
        return response


    def list_destinations(self,
        instance_id: str,
        *,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Destinations.

        List all Destinations.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_destinations')
        headers.update(sdk_headers)

        params = {
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_destination(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Destination.

        Get details of a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Destination` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_destination')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_destination(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        config: 'DestinationConfig' = None,
        certificate: BinaryIO = None,
        certificate_content_type: str = None,
        icon_16x16: BinaryIO = None,
        icon_16x16_content_type: str = None,
        icon_16x16_2x: BinaryIO = None,
        icon_16x16_2x_content_type: str = None,
        icon_32x32: BinaryIO = None,
        icon_32x32_content_type: str = None,
        icon_32x32_2x: BinaryIO = None,
        icon_32x32_2x_content_type: str = None,
        icon_128x128: BinaryIO = None,
        icon_128x128_content_type: str = None,
        icon_128x128_2x: BinaryIO = None,
        icon_128x128_2x_content_type: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Destination.

        Update details of a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str name: (optional) Destination name.
        :param str description: (optional) Destination description.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        :param BinaryIO certificate: (optional) Certificate for APNS.
        :param str certificate_content_type: (optional) The content type of
               certificate.
        :param BinaryIO icon_16x16: (optional) Safari icon 16x16.
        :param str icon_16x16_content_type: (optional) The content type of
               icon_16x16.
        :param BinaryIO icon_16x16_2x: (optional) Safari icon 16x16@2x.
        :param str icon_16x16_2x_content_type: (optional) The content type of
               icon_16x16_2x.
        :param BinaryIO icon_32x32: (optional) Safari icon 32x32.
        :param str icon_32x32_content_type: (optional) The content type of
               icon_32x32.
        :param BinaryIO icon_32x32_2x: (optional) Safari icon 32x32@2x.
        :param str icon_32x32_2x_content_type: (optional) The content type of
               icon_32x32_2x.
        :param BinaryIO icon_128x128: (optional) Safari icon 128x128.
        :param str icon_128x128_content_type: (optional) The content type of
               icon_128x128.
        :param BinaryIO icon_128x128_2x: (optional) Safari icon 128x128@2x.
        :param str icon_128x128_2x_content_type: (optional) The content type of
               icon_128x128_2x.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Destination` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_destination')
        headers.update(sdk_headers)

        form_data = []
        if name:
            form_data.append(('name', (None, name, 'text/plain')))
        if description:
            form_data.append(('description', (None, description, 'text/plain')))
        if config:
            form_data.append(('config', (None, json.dumps(config), 'application/json')))
        if certificate:
            form_data.append(('certificate', (None, certificate, certificate_content_type or 'application/octet-stream')))
        if icon_16x16:
            form_data.append(('icon_16x16', (None, icon_16x16, icon_16x16_content_type or 'application/octet-stream')))
        if icon_16x16_2x:
            form_data.append(('icon_16x16_2x', (None, icon_16x16_2x, icon_16x16_2x_content_type or 'application/octet-stream')))
        if icon_32x32:
            form_data.append(('icon_32x32', (None, icon_32x32, icon_32x32_content_type or 'application/octet-stream')))
        if icon_32x32_2x:
            form_data.append(('icon_32x32_2x', (None, icon_32x32_2x, icon_32x32_2x_content_type or 'application/octet-stream')))
        if icon_128x128:
            form_data.append(('icon_128x128', (None, icon_128x128, icon_128x128_content_type or 'application/octet-stream')))
        if icon_128x128_2x:
            form_data.append(('icon_128x128_2x', (None, icon_128x128_2x, icon_128x128_2x_content_type or 'application/octet-stream')))

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       files=form_data)

        response = self.send(request, **kwargs)
        return response


    def delete_destination(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Destination.

        Delete a Destination.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_destination')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Push Destination APIs
    #########################


    def create_tags_subscription(self,
        instance_id: str,
        id: str,
        device_id: str,
        tag_name: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new tag subscription.

        Create a new tag subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `DestinationTagsSubscriptionResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if device_id is None:
            raise ValueError('device_id must be provided')
        if tag_name is None:
            raise ValueError('tag_name must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_tags_subscription')
        headers.update(sdk_headers)

        data = {
            'device_id': device_id,
            'tag_name': tag_name
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_tags_subscription(self,
        instance_id: str,
        id: str,
        *,
        device_id: str = None,
        user_id: str = None,
        tag_name: str = None,
        limit: int = None,
        offset: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all tag subscriptions.

        List all tag subscriptions.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: (optional) Device ID of the destination
               tagsubscription.
        :param str user_id: (optional) UserID of the destination.
        :param str tag_name: (optional) TagName of the subscription.
        :param int limit: (optional) Page limit for paginated results.
        :param int offset: (optional) offset for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `TagsSubscriptionList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_tags_subscription')
        headers.update(sdk_headers)

        params = {
            'device_id': device_id,
            'user_id': user_id,
            'tag_name': tag_name,
            'limit': limit,
            'offset': offset,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def delete_tags_subscription(self,
        instance_id: str,
        id: str,
        *,
        device_id: str = None,
        tag_name: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a tag subscription.

        Delete a tag subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: (optional) Device ID of the destination
               tagsubscription.
        :param str tag_name: (optional) TagName of the subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_tags_subscription')
        headers.update(sdk_headers)

        params = {
            'device_id': device_id,
            'tag_name': tag_name
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/destinations/{id}/tag_subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response

    #########################
    # Subscriptions
    #########################


    def create_subscription(self,
        instance_id: str,
        name: str,
        destination_id: str,
        topic_id: str,
        *,
        description: str = None,
        attributes: 'SubscriptionCreateAttributes' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Create a new Subscription.

        Create a new Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str name: Subscription name.
        :param str destination_id: Destination ID.
        :param str topic_id: Topic ID.
        :param str description: (optional) Subscription description.
        :param SubscriptionCreateAttributes attributes: (optional)
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if name is None:
            raise ValueError('name must be provided')
        if destination_id is None:
            raise ValueError('destination_id must be provided')
        if topic_id is None:
            raise ValueError('topic_id must be provided')
        if attributes is not None:
            attributes = convert_model(attributes)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='create_subscription')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'destination_id': destination_id,
            'topic_id': topic_id,
            'description': description,
            'attributes': attributes
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='POST',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


    def list_subscriptions(self,
        instance_id: str,
        *,
        offset: int = None,
        limit: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Subscriptions.

        List all Subscriptions.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int offset: (optional) offset for paginated results.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `SubscriptionList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_subscriptions')
        headers.update(sdk_headers)

        params = {
            'offset': offset,
            'limit': limit,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_subscription(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get details of a Subscription.

        Get details of a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_subscription')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def delete_subscription(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Delete a Subscription.

        Delete a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='delete_subscription')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='DELETE',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def update_subscription(self,
        instance_id: str,
        id: str,
        *,
        name: str = None,
        description: str = None,
        attributes: 'SubscriptionUpdateAttributes' = None,
        **kwargs
    ) -> DetailedResponse:
        """
        Update details of a Subscription.

        Update details of a Subscription.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Subscription.
        :param str name: (optional) Name of the subscription.
        :param str description: (optional) Description of the subscription.
        :param SubscriptionUpdateAttributes attributes: (optional)
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `Subscription` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if attributes is not None:
            attributes = convert_model(attributes)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='update_subscription')
        headers.update(sdk_headers)

        data = {
            'name': name,
            'description': description,
            'attributes': attributes
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/subscriptions/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PATCH',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response

    #########################
    # KMS Integrations
    #########################


    def list_integrations(self,
        instance_id: str,
        *,
        offset: int = None,
        limit: int = None,
        search: str = None,
        **kwargs
    ) -> DetailedResponse:
        """
        List all Integrations.

        List of all KMS Integrations.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int offset: (optional) offset for paginated results.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `IntegrationList` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='list_integrations')
        headers.update(sdk_headers)

        params = {
            'offset': offset,
            'limit': limit,
            'search': search
        }

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id']
        path_param_values = self.encode_path_vars(instance_id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/integrations'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers,
                                       params=params)

        response = self.send(request, **kwargs)
        return response


    def get_integration(self,
        instance_id: str,
        id: str,
        **kwargs
    ) -> DetailedResponse:
        """
        Get a single Integration.

        Get a single KMS Integration.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for integration.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `IntegrationGetResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='get_integration')
        headers.update(sdk_headers)

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/integrations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='GET',
                                       url=url,
                                       headers=headers)

        response = self.send(request, **kwargs)
        return response


    def replace_integration(self,
        instance_id: str,
        id: str,
        type: str,
        metadata: 'IntegrationMetadata',
        **kwargs
    ) -> DetailedResponse:
        """
        Update an existing Integration.

        Update an existing KMS Integration.

        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for integration.
        :param str type: Integration type. Allowed values are kms and hs-crypto.
        :param IntegrationMetadata metadata: Integration Metadata object.
        :param dict headers: A `dict` containing the request headers
        :return: A `DetailedResponse` containing the result, headers and HTTP status code.
        :rtype: DetailedResponse with `dict` result representing a `IntegrationGetResponse` object
        """

        if instance_id is None:
            raise ValueError('instance_id must be provided')
        if id is None:
            raise ValueError('id must be provided')
        if type is None:
            raise ValueError('type must be provided')
        if metadata is None:
            raise ValueError('metadata must be provided')
        metadata = convert_model(metadata)
        headers = {}
        sdk_headers = get_sdk_headers(service_name=self.DEFAULT_SERVICE_NAME,
                                      service_version='V1',
                                      operation_id='replace_integration')
        headers.update(sdk_headers)

        data = {
            'type': type,
            'metadata': metadata
        }
        data = {k: v for (k, v) in data.items() if v is not None}
        data = json.dumps(data)
        headers['content-type'] = 'application/json'

        if 'headers' in kwargs:
            headers.update(kwargs.get('headers'))
            del kwargs['headers']
        headers['Accept'] = 'application/json'

        path_param_keys = ['instance_id', 'id']
        path_param_values = self.encode_path_vars(instance_id, id)
        path_param_dict = dict(zip(path_param_keys, path_param_values))
        url = '/v1/instances/{instance_id}/integrations/{id}'.format(**path_param_dict)
        request = self.prepare_request(method='PUT',
                                       url=url,
                                       headers=headers,
                                       data=data)

        response = self.send(request, **kwargs)
        return response


class CreateDestinationEnums:
    """
    Enums for create_destination parameters.
    """

    class Type(str, Enum):
        """
        The type of Destination Webhook.
        """
        WEBHOOK = 'webhook'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        PUSH_CHROME = 'push_chrome'
        PUSH_FIREFOX = 'push_firefox'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


##############################################################################
# Models
##############################################################################


class BulkNotificationResponse():
    """
    Payload describing a notifications response.

    :attr str bulk_notification_id: (optional) Bulk Notification ID.
    :attr List[object] bulk_messages: (optional) List of Notifications.
    """

    def __init__(self,
                 *,
                 bulk_notification_id: str = None,
                 bulk_messages: List[object] = None) -> None:
        """
        Initialize a BulkNotificationResponse object.

        :param str bulk_notification_id: (optional) Bulk Notification ID.
        :param List[object] bulk_messages: (optional) List of Notifications.
        """
        self.bulk_notification_id = bulk_notification_id
        self.bulk_messages = bulk_messages

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'BulkNotificationResponse':
        """Initialize a BulkNotificationResponse object from a json dictionary."""
        args = {}
        if 'bulk_notification_id' in _dict:
            args['bulk_notification_id'] = _dict.get('bulk_notification_id')
        if 'bulk_messages' in _dict:
            args['bulk_messages'] = _dict.get('bulk_messages')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a BulkNotificationResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'bulk_notification_id') and self.bulk_notification_id is not None:
            _dict['bulk_notification_id'] = self.bulk_notification_id
        if hasattr(self, 'bulk_messages') and self.bulk_messages is not None:
            _dict['bulk_messages'] = self.bulk_messages
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this BulkNotificationResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'BulkNotificationResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'BulkNotificationResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Destination():
    """
    Payload describing a destination get request.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type
          Email/SMS/Webhook/FCM/Slack/MSTeams/PagerDuty/IBMCloudFunctions/ServiceNow.
    :attr DestinationConfig config: (optional) Payload describing a destination
          configuration.
    :attr datetime updated_at: Last updated time.
    :attr int subscription_count: Number of subscriptions.
    :attr List[str] subscription_names: List of subscriptions.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 updated_at: datetime,
                 subscription_count: int,
                 subscription_names: List[str],
                 *,
                 config: 'DestinationConfig' = None) -> None:
        """
        Initialize a Destination object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type
               Email/SMS/Webhook/FCM/Slack/MSTeams/PagerDuty/IBMCloudFunctions/ServiceNow.
        :param datetime updated_at: Last updated time.
        :param int subscription_count: Number of subscriptions.
        :param List[str] subscription_names: List of subscriptions.
        :param DestinationConfig config: (optional) Payload describing a
               destination configuration.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.config = config
        self.updated_at = updated_at
        self.subscription_count = subscription_count
        self.subscription_names = subscription_names

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Destination':
        """Initialize a Destination object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Destination JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Destination JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Destination JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in Destination JSON')
        if 'config' in _dict:
            args['config'] = DestinationConfig.from_dict(_dict.get('config'))
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in Destination JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in Destination JSON')
        if 'subscription_names' in _dict:
            args['subscription_names'] = _dict.get('subscription_names')
        else:
            raise ValueError('Required property \'subscription_names\' not present in Destination JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Destination object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'config') and self.config is not None:
            _dict['config'] = self.config.to_dict()
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscription_names') and self.subscription_names is not None:
            _dict['subscription_names'] = self.subscription_names
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Destination object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Destination') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Destination') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type
        Email/SMS/Webhook/FCM/Slack/MSTeams/PagerDuty/IBMCloudFunctions/ServiceNow.
        """
        WEBHOOK = 'webhook'
        SMTP_IBM = 'smtp_ibm'
        SMS_IBM = 'sms_ibm'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


class DestinationConfig():
    """
    Payload describing a destination configuration.

    :attr DestinationConfigOneOf params:
    """

    def __init__(self,
                 params: 'DestinationConfigOneOf') -> None:
        """
        Initialize a DestinationConfig object.

        :param DestinationConfigOneOf params:
        """
        self.params = params

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfig':
        """Initialize a DestinationConfig object from a json dictionary."""
        args = {}
        if 'params' in _dict:
            args['params'] = _dict.get('params')
        else:
            raise ValueError('Required property \'params\' not present in DestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'params') and self.params is not None:
            if isinstance(self.params, dict):
                _dict['params'] = self.params
            else:
                _dict['params'] = self.params.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOf():
    """
    DestinationConfigOneOf.

    """

    def __init__(self) -> None:
        """
        Initialize a DestinationConfigOneOf object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['DestinationConfigOneOfWebhookDestinationConfig', 'DestinationConfigOneOfFCMDestinationConfig', 'DestinationConfigOneOfIOSDestinationConfig', 'DestinationConfigOneOfChromeDestinationConfig', 'DestinationConfigOneOfFirefoxDestinationConfig', 'DestinationConfigOneOfSlackDestinationConfig', 'DestinationConfigOneOfSafariDestinationConfig', 'DestinationConfigOneOfMSTeamsDestinationConfig', 'DestinationConfigOneOfIBMCloudFunctionsDestinationConfig', 'DestinationConfigOneOfPagerDutyDestinationConfig', 'DestinationConfigOneOfServiceNowDestinationConfig']))
        raise Exception(msg)

class DestinationList():
    """
    Payload describing a destination list request.

    :attr int total_count: Total number of destinations.
    :attr int offset: Current offset.
    :attr int limit: limit to show destinations.
    :attr List[DestinationListItem] destinations: List of destinations.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 destinations: List['DestinationListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a DestinationList object.

        :param int total_count: Total number of destinations.
        :param int offset: Current offset.
        :param int limit: limit to show destinations.
        :param List[DestinationListItem] destinations: List of destinations.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.destinations = destinations
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationList':
        """Initialize a DestinationList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in DestinationList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in DestinationList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in DestinationList JSON')
        if 'destinations' in _dict:
            args['destinations'] = [DestinationListItem.from_dict(x) for x in _dict.get('destinations')]
        else:
            raise ValueError('Required property \'destinations\' not present in DestinationList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'destinations') and self.destinations is not None:
            _dict['destinations'] = [x.to_dict() for x in self.destinations]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationListItem():
    """
    Destination object.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type.
    :attr int subscription_count: Subscription count.
    :attr List[str] subscription_names: Names of subscriptions.
    :attr datetime updated_at: Updated at.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 subscription_count: int,
                 subscription_names: List[str],
                 updated_at: datetime) -> None:
        """
        Initialize a DestinationListItem object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type.
        :param int subscription_count: Subscription count.
        :param List[str] subscription_names: Names of subscriptions.
        :param datetime updated_at: Updated at.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.subscription_count = subscription_count
        self.subscription_names = subscription_names
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationListItem':
        """Initialize a DestinationListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in DestinationListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in DestinationListItem JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in DestinationListItem JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in DestinationListItem JSON')
        if 'subscription_names' in _dict:
            args['subscription_names'] = _dict.get('subscription_names')
        else:
            raise ValueError('Required property \'subscription_names\' not present in DestinationListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in DestinationListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscription_names') and self.subscription_names is not None:
            _dict['subscription_names'] = self.subscription_names
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type.
        """
        WEBHOOK = 'webhook'
        SMTP_IBM = 'smtp_ibm'
        SMS_IBM = 'sms_ibm'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


class DestinationResponse():
    """
    Payload describing a destination get request.

    :attr str id: Destination ID.
    :attr str name: Destination name.
    :attr str description: Destination description.
    :attr str type: Destination type.
    :attr DestinationConfig config: Payload describing a destination configuration.
    :attr datetime created_at: Last updated time.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 config: 'DestinationConfig',
                 created_at: datetime) -> None:
        """
        Initialize a DestinationResponse object.

        :param str id: Destination ID.
        :param str name: Destination name.
        :param str description: Destination description.
        :param str type: Destination type.
        :param DestinationConfig config: Payload describing a destination
               configuration.
        :param datetime created_at: Last updated time.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.config = config
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationResponse':
        """Initialize a DestinationResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in DestinationResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in DestinationResponse JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in DestinationResponse JSON')
        if 'config' in _dict:
            args['config'] = DestinationConfig.from_dict(_dict.get('config'))
        else:
            raise ValueError('Required property \'config\' not present in DestinationResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in DestinationResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'config') and self.config is not None:
            _dict['config'] = self.config.to_dict()
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class TypeEnum(str, Enum):
        """
        Destination type.
        """
        WEBHOOK = 'webhook'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        PUSH_CHROME = 'push_chrome'
        PUSH_FIREFOX = 'push_firefox'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


class DestinationTagsSubscriptionResponse():
    """
    Payload describing a destination get request.

    :attr str id: Subscription Tag ID.
    :attr str device_id: Unique identifier of the device.
    :attr str tag_name: The name of the tag its subscribed.
    :attr str user_id: (optional) The user identifier for the device registration.
    :attr datetime created_at: Last updated time.
    """

    def __init__(self,
                 id: str,
                 device_id: str,
                 tag_name: str,
                 created_at: datetime,
                 *,
                 user_id: str = None) -> None:
        """
        Initialize a DestinationTagsSubscriptionResponse object.

        :param str id: Subscription Tag ID.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param datetime created_at: Last updated time.
        :param str user_id: (optional) The user identifier for the device
               registration.
        """
        self.id = id
        self.device_id = device_id
        self.tag_name = tag_name
        self.user_id = user_id
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationTagsSubscriptionResponse':
        """Initialize a DestinationTagsSubscriptionResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'device_id' in _dict:
            args['device_id'] = _dict.get('device_id')
        else:
            raise ValueError('Required property \'device_id\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'tag_name' in _dict:
            args['tag_name'] = _dict.get('tag_name')
        else:
            raise ValueError('Required property \'tag_name\' not present in DestinationTagsSubscriptionResponse JSON')
        if 'user_id' in _dict:
            args['user_id'] = _dict.get('user_id')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in DestinationTagsSubscriptionResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationTagsSubscriptionResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'device_id') and self.device_id is not None:
            _dict['device_id'] = self.device_id
        if hasattr(self, 'tag_name') and self.tag_name is not None:
            _dict['tag_name'] = self.tag_name
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationTagsSubscriptionResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationTagsSubscriptionResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationTagsSubscriptionResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class EmailAttributesResponseInvitedItems():
    """
    EmailAttributesResponseInvitedItems.

    :attr str email: (optional) email address.
    :attr datetime updated_at: (optional) last updated time.
    :attr datetime expires_at: (optional) time of expiration.
    """

    def __init__(self,
                 *,
                 email: str = None,
                 updated_at: datetime = None,
                 expires_at: datetime = None) -> None:
        """
        Initialize a EmailAttributesResponseInvitedItems object.

        :param str email: (optional) email address.
        :param datetime updated_at: (optional) last updated time.
        :param datetime expires_at: (optional) time of expiration.
        """
        self.email = email
        self.updated_at = updated_at
        self.expires_at = expires_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EmailAttributesResponseInvitedItems':
        """Initialize a EmailAttributesResponseInvitedItems object from a json dictionary."""
        args = {}
        if 'email' in _dict:
            args['email'] = _dict.get('email')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        if 'expires_at' in _dict:
            args['expires_at'] = string_to_datetime(_dict.get('expires_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EmailAttributesResponseInvitedItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'email') and self.email is not None:
            _dict['email'] = self.email
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'expires_at') and self.expires_at is not None:
            _dict['expires_at'] = datetime_to_string(self.expires_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EmailAttributesResponseInvitedItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EmailAttributesResponseInvitedItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EmailAttributesResponseInvitedItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class EmailAttributesResponseSubscribedUnsubscribedItems():
    """
    EmailAttributesResponseSubscribedUnsubscribedItems.

    :attr str email: (optional) email address.
    :attr datetime updated_at: (optional) last updated time.
    """

    def __init__(self,
                 *,
                 email: str = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a EmailAttributesResponseSubscribedUnsubscribedItems object.

        :param str email: (optional) email address.
        :param datetime updated_at: (optional) last updated time.
        """
        self.email = email
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'EmailAttributesResponseSubscribedUnsubscribedItems':
        """Initialize a EmailAttributesResponseSubscribedUnsubscribedItems object from a json dictionary."""
        args = {}
        if 'email' in _dict:
            args['email'] = _dict.get('email')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a EmailAttributesResponseSubscribedUnsubscribedItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'email') and self.email is not None:
            _dict['email'] = self.email
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this EmailAttributesResponseSubscribedUnsubscribedItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'EmailAttributesResponseSubscribedUnsubscribedItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'EmailAttributesResponseSubscribedUnsubscribedItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class IntegrationGetResponse():
    """
    Integration response object.

    :attr str id: ID of the integration.
    :attr str type: Integration type. Allowed values are kms and hs-crypto.
    :attr IntegrationMetadata metadata: Integration Metadata object.
    :attr datetime created_at: Creation time of an integration.
    :attr datetime updated_at: Last update time of an integration.
    """

    def __init__(self,
                 id: str,
                 type: str,
                 metadata: 'IntegrationMetadata',
                 created_at: datetime,
                 updated_at: datetime) -> None:
        """
        Initialize a IntegrationGetResponse object.

        :param str id: ID of the integration.
        :param str type: Integration type. Allowed values are kms and hs-crypto.
        :param IntegrationMetadata metadata: Integration Metadata object.
        :param datetime created_at: Creation time of an integration.
        :param datetime updated_at: Last update time of an integration.
        """
        self.id = id
        self.type = type
        self.metadata = metadata
        self.created_at = created_at
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'IntegrationGetResponse':
        """Initialize a IntegrationGetResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in IntegrationGetResponse JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in IntegrationGetResponse JSON')
        if 'metadata' in _dict:
            args['metadata'] = IntegrationMetadata.from_dict(_dict.get('metadata'))
        else:
            raise ValueError('Required property \'metadata\' not present in IntegrationGetResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in IntegrationGetResponse JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in IntegrationGetResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a IntegrationGetResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'metadata') and self.metadata is not None:
            _dict['metadata'] = self.metadata.to_dict()
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this IntegrationGetResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'IntegrationGetResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'IntegrationGetResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class IntegrationList():
    """
    all Integrations response object.

    :attr int total_count: Number of integrations.
    :attr int offset: Current offset.
    :attr int limit: limit to show integrations.
    :attr List[IntegrationListItem] integrations: List of integrations.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 integrations: List['IntegrationListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a IntegrationList object.

        :param int total_count: Number of integrations.
        :param int offset: Current offset.
        :param int limit: limit to show integrations.
        :param List[IntegrationListItem] integrations: List of integrations.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.integrations = integrations
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'IntegrationList':
        """Initialize a IntegrationList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in IntegrationList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in IntegrationList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in IntegrationList JSON')
        if 'integrations' in _dict:
            args['integrations'] = [IntegrationListItem.from_dict(x) for x in _dict.get('integrations')]
        else:
            raise ValueError('Required property \'integrations\' not present in IntegrationList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a IntegrationList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'integrations') and self.integrations is not None:
            _dict['integrations'] = [x.to_dict() for x in self.integrations]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this IntegrationList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'IntegrationList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'IntegrationList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class IntegrationListItem():
    """
    all Integrations response object.

    :attr str id: ID of the integration.
    :attr str type: Integration type. Allowed values are kms and hs-crypto.
    :attr IntegrationMetadata metadata: Integration Metadata object.
    :attr datetime created_at: Creation time of an integration.
    :attr datetime updated_at: Update time of an integration.
    """

    def __init__(self,
                 id: str,
                 type: str,
                 metadata: 'IntegrationMetadata',
                 created_at: datetime,
                 updated_at: datetime) -> None:
        """
        Initialize a IntegrationListItem object.

        :param str id: ID of the integration.
        :param str type: Integration type. Allowed values are kms and hs-crypto.
        :param IntegrationMetadata metadata: Integration Metadata object.
        :param datetime created_at: Creation time of an integration.
        :param datetime updated_at: Update time of an integration.
        """
        self.id = id
        self.type = type
        self.metadata = metadata
        self.created_at = created_at
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'IntegrationListItem':
        """Initialize a IntegrationListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in IntegrationListItem JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in IntegrationListItem JSON')
        if 'metadata' in _dict:
            args['metadata'] = IntegrationMetadata.from_dict(_dict.get('metadata'))
        else:
            raise ValueError('Required property \'metadata\' not present in IntegrationListItem JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in IntegrationListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in IntegrationListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a IntegrationListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'metadata') and self.metadata is not None:
            _dict['metadata'] = self.metadata.to_dict()
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this IntegrationListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'IntegrationListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'IntegrationListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class IntegrationMetadata():
    """
    Integration Metadata object.

    :attr str endpoint: KMS url for key management.
    :attr str crn: CRN of the KMS instance.
    :attr str root_key_id: Root Key ID of KMS.
    """

    def __init__(self,
                 endpoint: str,
                 crn: str,
                 root_key_id: str) -> None:
        """
        Initialize a IntegrationMetadata object.

        :param str endpoint: KMS url for key management.
        :param str crn: CRN of the KMS instance.
        :param str root_key_id: Root Key ID of KMS.
        """
        self.endpoint = endpoint
        self.crn = crn
        self.root_key_id = root_key_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'IntegrationMetadata':
        """Initialize a IntegrationMetadata object from a json dictionary."""
        args = {}
        if 'endpoint' in _dict:
            args['endpoint'] = _dict.get('endpoint')
        else:
            raise ValueError('Required property \'endpoint\' not present in IntegrationMetadata JSON')
        if 'crn' in _dict:
            args['crn'] = _dict.get('crn')
        else:
            raise ValueError('Required property \'crn\' not present in IntegrationMetadata JSON')
        if 'root_key_id' in _dict:
            args['root_key_id'] = _dict.get('root_key_id')
        else:
            raise ValueError('Required property \'root_key_id\' not present in IntegrationMetadata JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a IntegrationMetadata object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'endpoint') and self.endpoint is not None:
            _dict['endpoint'] = self.endpoint
        if hasattr(self, 'crn') and self.crn is not None:
            _dict['crn'] = self.crn
        if hasattr(self, 'root_key_id') and self.root_key_id is not None:
            _dict['root_key_id'] = self.root_key_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this IntegrationMetadata object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'IntegrationMetadata') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'IntegrationMetadata') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class NotificationCreate():
    """
    Payload describing a notification create request.

    :attr str specversion: The version of the notification specification.
    :attr datetime time: (optional) The time notification was created.
    :attr str id: The unique identifier of the notification.
    :attr str source: The source of notifications.
    :attr str type: The notifications type.
    :attr str ibmenseverity: (optional) The severity of the notification.
    :attr str ibmensourceid: The source id of the notification.
    :attr str ibmendefaultshort: Default short text for the message.
    :attr str ibmendefaultlong: Default long text for the message.
    :attr str subject: (optional) The subject of the notification.
    :attr dict data: (optional) The payload for webhook notification.
    :attr str datacontenttype: (optional) The notification content type.
    :attr str ibmenpushto: (optional) If platforms or tags or user_ids is used then
          do not use fcm_devices / apns_devices / chrome_devices / firefox_devices /
          safari_devices with it. Value should be stringified.
    :attr str ibmenfcmbody: (optional) Payload describing a notification FCM body.
          Value should be stringified.
    :attr str ibmenapnsbody: (optional) Payload describing a notification APNs body.
          Value should be stringified.
    :attr str ibmenapnsheaders: (optional) Headers for iOS notification. Value
          should be stringified.
    :attr str ibmenchromebody: (optional) Notification payload for Chrome. Value
          should be stringified.
    :attr str ibmenchromeheaders: (optional) Headers for a Chrome notification.
          Value should be stringified.
    :attr str ibmenfirefoxbody: (optional) Notification payload for Firefox. Value
          should be stringified.
    :attr str ibmenfirefoxheaders: (optional) Headers for a Firefox notification.
          Value should be stringified.
    :attr str ibmensafaribody: (optional) Payload describing a notification Safari
          body. Value should be stringified.
    """

    # The set of defined properties for the class
    _properties = frozenset(['specversion', 'time', 'id', 'source', 'type', 'ibmenseverity', 'ibmensourceid', 'ibmendefaultshort', 'ibmendefaultlong', 'subject', 'data', 'datacontenttype', 'ibmenpushto', 'ibmenfcmbody', 'ibmenapnsbody', 'ibmenapnsheaders', 'ibmenchromebody', 'ibmenchromeheaders', 'ibmenfirefoxbody', 'ibmenfirefoxheaders', 'ibmensafaribody'])

    def __init__(self,
                 specversion: str,
                 id: str,
                 source: str,
                 type: str,
                 ibmensourceid: str,
                 ibmendefaultshort: str,
                 ibmendefaultlong: str,
                 *,
                 time: datetime = None,
                 ibmenseverity: str = None,
                 subject: str = None,
                 data: dict = None,
                 datacontenttype: str = None,
                 ibmenpushto: str = None,
                 ibmenfcmbody: str = None,
                 ibmenapnsbody: str = None,
                 ibmenapnsheaders: str = None,
                 ibmenchromebody: str = None,
                 ibmenchromeheaders: str = None,
                 ibmenfirefoxbody: str = None,
                 ibmenfirefoxheaders: str = None,
                 ibmensafaribody: str = None,
                 **kwargs) -> None:
        """
        Initialize a NotificationCreate object.

        :param str specversion: The version of the notification specification.
        :param str id: The unique identifier of the notification.
        :param str source: The source of notifications.
        :param str type: The notifications type.
        :param str ibmensourceid: The source id of the notification.
        :param str ibmendefaultshort: Default short text for the message.
        :param str ibmendefaultlong: Default long text for the message.
        :param datetime time: (optional) The time notification was created.
        :param str ibmenseverity: (optional) The severity of the notification.
        :param str subject: (optional) The subject of the notification.
        :param dict data: (optional) The payload for webhook notification.
        :param str datacontenttype: (optional) The notification content type.
        :param str ibmenpushto: (optional) If platforms or tags or user_ids is used
               then do not use fcm_devices / apns_devices / chrome_devices /
               firefox_devices / safari_devices with it. Value should be stringified.
        :param str ibmenfcmbody: (optional) Payload describing a notification FCM
               body. Value should be stringified.
        :param str ibmenapnsbody: (optional) Payload describing a notification APNs
               body. Value should be stringified.
        :param str ibmenapnsheaders: (optional) Headers for iOS notification. Value
               should be stringified.
        :param str ibmenchromebody: (optional) Notification payload for Chrome.
               Value should be stringified.
        :param str ibmenchromeheaders: (optional) Headers for a Chrome
               notification. Value should be stringified.
        :param str ibmenfirefoxbody: (optional) Notification payload for Firefox.
               Value should be stringified.
        :param str ibmenfirefoxheaders: (optional) Headers for a Firefox
               notification. Value should be stringified.
        :param str ibmensafaribody: (optional) Payload describing a notification
               Safari body. Value should be stringified.
        :param **kwargs: (optional) Any additional properties.
        """
        self.specversion = specversion
        self.time = time
        self.id = id
        self.source = source
        self.type = type
        self.ibmenseverity = ibmenseverity
        self.ibmensourceid = ibmensourceid
        self.ibmendefaultshort = ibmendefaultshort
        self.ibmendefaultlong = ibmendefaultlong
        self.subject = subject
        self.data = data
        self.datacontenttype = datacontenttype
        self.ibmenpushto = ibmenpushto
        self.ibmenfcmbody = ibmenfcmbody
        self.ibmenapnsbody = ibmenapnsbody
        self.ibmenapnsheaders = ibmenapnsheaders
        self.ibmenchromebody = ibmenchromebody
        self.ibmenchromeheaders = ibmenchromeheaders
        self.ibmenfirefoxbody = ibmenfirefoxbody
        self.ibmenfirefoxheaders = ibmenfirefoxheaders
        self.ibmensafaribody = ibmensafaribody
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'NotificationCreate':
        """Initialize a NotificationCreate object from a json dictionary."""
        args = {}
        if 'specversion' in _dict:
            args['specversion'] = _dict.get('specversion')
        else:
            raise ValueError('Required property \'specversion\' not present in NotificationCreate JSON')
        if 'time' in _dict:
            args['time'] = string_to_datetime(_dict.get('time'))
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in NotificationCreate JSON')
        if 'source' in _dict:
            args['source'] = _dict.get('source')
        else:
            raise ValueError('Required property \'source\' not present in NotificationCreate JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in NotificationCreate JSON')
        if 'ibmenseverity' in _dict:
            args['ibmenseverity'] = _dict.get('ibmenseverity')
        if 'ibmensourceid' in _dict:
            args['ibmensourceid'] = _dict.get('ibmensourceid')
        else:
            raise ValueError('Required property \'ibmensourceid\' not present in NotificationCreate JSON')
        if 'ibmendefaultshort' in _dict:
            args['ibmendefaultshort'] = _dict.get('ibmendefaultshort')
        else:
            raise ValueError('Required property \'ibmendefaultshort\' not present in NotificationCreate JSON')
        if 'ibmendefaultlong' in _dict:
            args['ibmendefaultlong'] = _dict.get('ibmendefaultlong')
        else:
            raise ValueError('Required property \'ibmendefaultlong\' not present in NotificationCreate JSON')
        if 'subject' in _dict:
            args['subject'] = _dict.get('subject')
        if 'data' in _dict:
            args['data'] = _dict.get('data')
        if 'datacontenttype' in _dict:
            args['datacontenttype'] = _dict.get('datacontenttype')
        if 'ibmenpushto' in _dict:
            args['ibmenpushto'] = _dict.get('ibmenpushto')
        if 'ibmenfcmbody' in _dict:
            args['ibmenfcmbody'] = _dict.get('ibmenfcmbody')
        if 'ibmenapnsbody' in _dict:
            args['ibmenapnsbody'] = _dict.get('ibmenapnsbody')
        if 'ibmenapnsheaders' in _dict:
            args['ibmenapnsheaders'] = _dict.get('ibmenapnsheaders')
        if 'ibmenchromebody' in _dict:
            args['ibmenchromebody'] = _dict.get('ibmenchromebody')
        if 'ibmenchromeheaders' in _dict:
            args['ibmenchromeheaders'] = _dict.get('ibmenchromeheaders')
        if 'ibmenfirefoxbody' in _dict:
            args['ibmenfirefoxbody'] = _dict.get('ibmenfirefoxbody')
        if 'ibmenfirefoxheaders' in _dict:
            args['ibmenfirefoxheaders'] = _dict.get('ibmenfirefoxheaders')
        if 'ibmensafaribody' in _dict:
            args['ibmensafaribody'] = _dict.get('ibmensafaribody')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a NotificationCreate object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'specversion') and self.specversion is not None:
            _dict['specversion'] = self.specversion
        if hasattr(self, 'time') and self.time is not None:
            _dict['time'] = datetime_to_string(self.time)
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'source') and self.source is not None:
            _dict['source'] = self.source
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'ibmenseverity') and self.ibmenseverity is not None:
            _dict['ibmenseverity'] = self.ibmenseverity
        if hasattr(self, 'ibmensourceid') and self.ibmensourceid is not None:
            _dict['ibmensourceid'] = self.ibmensourceid
        if hasattr(self, 'ibmendefaultshort') and self.ibmendefaultshort is not None:
            _dict['ibmendefaultshort'] = self.ibmendefaultshort
        if hasattr(self, 'ibmendefaultlong') and self.ibmendefaultlong is not None:
            _dict['ibmendefaultlong'] = self.ibmendefaultlong
        if hasattr(self, 'subject') and self.subject is not None:
            _dict['subject'] = self.subject
        if hasattr(self, 'data') and self.data is not None:
            _dict['data'] = self.data
        if hasattr(self, 'datacontenttype') and self.datacontenttype is not None:
            _dict['datacontenttype'] = self.datacontenttype
        if hasattr(self, 'ibmenpushto') and self.ibmenpushto is not None:
            _dict['ibmenpushto'] = self.ibmenpushto
        if hasattr(self, 'ibmenfcmbody') and self.ibmenfcmbody is not None:
            _dict['ibmenfcmbody'] = self.ibmenfcmbody
        if hasattr(self, 'ibmenapnsbody') and self.ibmenapnsbody is not None:
            _dict['ibmenapnsbody'] = self.ibmenapnsbody
        if hasattr(self, 'ibmenapnsheaders') and self.ibmenapnsheaders is not None:
            _dict['ibmenapnsheaders'] = self.ibmenapnsheaders
        if hasattr(self, 'ibmenchromebody') and self.ibmenchromebody is not None:
            _dict['ibmenchromebody'] = self.ibmenchromebody
        if hasattr(self, 'ibmenchromeheaders') and self.ibmenchromeheaders is not None:
            _dict['ibmenchromeheaders'] = self.ibmenchromeheaders
        if hasattr(self, 'ibmenfirefoxbody') and self.ibmenfirefoxbody is not None:
            _dict['ibmenfirefoxbody'] = self.ibmenfirefoxbody
        if hasattr(self, 'ibmenfirefoxheaders') and self.ibmenfirefoxheaders is not None:
            _dict['ibmenfirefoxheaders'] = self.ibmenfirefoxheaders
        if hasattr(self, 'ibmensafaribody') and self.ibmensafaribody is not None:
            _dict['ibmensafaribody'] = self.ibmensafaribody
        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of NotificationCreate"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of NotificationCreate"""
        for _key in [k for k in vars(self).keys() if k not in NotificationCreate._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in NotificationCreate._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this NotificationCreate object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'NotificationCreate') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'NotificationCreate') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class NotificationResponse():
    """
    Payload describing a notifications response.

    :attr str notification_id: (optional) Notification ID.
    """

    def __init__(self,
                 *,
                 notification_id: str = None) -> None:
        """
        Initialize a NotificationResponse object.

        :param str notification_id: (optional) Notification ID.
        """
        self.notification_id = notification_id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'NotificationResponse':
        """Initialize a NotificationResponse object from a json dictionary."""
        args = {}
        if 'notification_id' in _dict:
            args['notification_id'] = _dict.get('notification_id')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a NotificationResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'notification_id') and self.notification_id is not None:
            _dict['notification_id'] = self.notification_id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this NotificationResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'NotificationResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'NotificationResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class PageHrefResponse():
    """
    Response having URL of the page.

    :attr str href: URL to the page.
    """

    def __init__(self,
                 href: str) -> None:
        """
        Initialize a PageHrefResponse object.

        :param str href: URL to the page.
        """
        self.href = href

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'PageHrefResponse':
        """Initialize a PageHrefResponse object from a json dictionary."""
        args = {}
        if 'href' in _dict:
            args['href'] = _dict.get('href')
        else:
            raise ValueError('Required property \'href\' not present in PageHrefResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a PageHrefResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'href') and self.href is not None:
            _dict['href'] = self.href
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this PageHrefResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'PageHrefResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'PageHrefResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Rules():
    """
    Rule object.

    :attr bool enabled: (optional) Whether the rule is enabled or not.
    :attr str event_type_filter: Event type filter.
    :attr str notification_filter: (optional) Notification filter.
    """

    def __init__(self,
                 event_type_filter: str,
                 *,
                 enabled: bool = None,
                 notification_filter: str = None) -> None:
        """
        Initialize a Rules object.

        :param str event_type_filter: Event type filter.
        :param bool enabled: (optional) Whether the rule is enabled or not.
        :param str notification_filter: (optional) Notification filter.
        """
        self.enabled = enabled
        self.event_type_filter = event_type_filter
        self.notification_filter = notification_filter

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Rules':
        """Initialize a Rules object from a json dictionary."""
        args = {}
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        if 'event_type_filter' in _dict:
            args['event_type_filter'] = _dict.get('event_type_filter')
        else:
            raise ValueError('Required property \'event_type_filter\' not present in Rules JSON')
        if 'notification_filter' in _dict:
            args['notification_filter'] = _dict.get('notification_filter')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Rules object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'event_type_filter') and self.event_type_filter is not None:
            _dict['event_type_filter'] = self.event_type_filter
        if hasattr(self, 'notification_filter') and self.notification_filter is not None:
            _dict['notification_filter'] = self.notification_filter
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Rules object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Rules') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Rules') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class RulesGet():
    """
    Rule object.

    :attr bool enabled: Whether the rule is enabled or not.
    :attr str event_type_filter: Event type filter.
    :attr str notification_filter: Notification filter.
    :attr str updated_at: Last time the topic was updated.
    :attr str id: Autogenerated rule ID.
    """

    def __init__(self,
                 enabled: bool,
                 event_type_filter: str,
                 notification_filter: str,
                 updated_at: str,
                 id: str) -> None:
        """
        Initialize a RulesGet object.

        :param bool enabled: Whether the rule is enabled or not.
        :param str event_type_filter: Event type filter.
        :param str notification_filter: Notification filter.
        :param str updated_at: Last time the topic was updated.
        :param str id: Autogenerated rule ID.
        """
        self.enabled = enabled
        self.event_type_filter = event_type_filter
        self.notification_filter = notification_filter
        self.updated_at = updated_at
        self.id = id

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'RulesGet':
        """Initialize a RulesGet object from a json dictionary."""
        args = {}
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in RulesGet JSON')
        if 'event_type_filter' in _dict:
            args['event_type_filter'] = _dict.get('event_type_filter')
        else:
            raise ValueError('Required property \'event_type_filter\' not present in RulesGet JSON')
        if 'notification_filter' in _dict:
            args['notification_filter'] = _dict.get('notification_filter')
        else:
            raise ValueError('Required property \'notification_filter\' not present in RulesGet JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in RulesGet JSON')
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in RulesGet JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a RulesGet object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'event_type_filter') and self.event_type_filter is not None:
            _dict['event_type_filter'] = self.event_type_filter
        if hasattr(self, 'notification_filter') and self.notification_filter is not None:
            _dict['notification_filter'] = self.notification_filter
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this RulesGet object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'RulesGet') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'RulesGet') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SMSAttributesItems():
    """
    The sms attributes.

    :attr str phone_number: (optional) Phone number.
    :attr datetime updated_at: (optional) last updated time.
    """

    def __init__(self,
                 *,
                 phone_number: str = None,
                 updated_at: datetime = None) -> None:
        """
        Initialize a SMSAttributesItems object.

        :param str phone_number: (optional) Phone number.
        :param datetime updated_at: (optional) last updated time.
        """
        self.phone_number = phone_number
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SMSAttributesItems':
        """Initialize a SMSAttributesItems object from a json dictionary."""
        args = {}
        if 'phone_number' in _dict:
            args['phone_number'] = _dict.get('phone_number')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SMSAttributesItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'phone_number') and self.phone_number is not None:
            _dict['phone_number'] = self.phone_number
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SMSAttributesItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SMSAttributesItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SMSAttributesItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SMSInviteAttributesItems():
    """
    The sms attributes.

    :attr str phone_number: (optional) Phone number.
    :attr datetime updated_at: (optional) last updated time.
    :attr datetime expires_at: (optional) time of expiration.
    """

    def __init__(self,
                 *,
                 phone_number: str = None,
                 updated_at: datetime = None,
                 expires_at: datetime = None) -> None:
        """
        Initialize a SMSInviteAttributesItems object.

        :param str phone_number: (optional) Phone number.
        :param datetime updated_at: (optional) last updated time.
        :param datetime expires_at: (optional) time of expiration.
        """
        self.phone_number = phone_number
        self.updated_at = updated_at
        self.expires_at = expires_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SMSInviteAttributesItems':
        """Initialize a SMSInviteAttributesItems object from a json dictionary."""
        args = {}
        if 'phone_number' in _dict:
            args['phone_number'] = _dict.get('phone_number')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        if 'expires_at' in _dict:
            args['expires_at'] = string_to_datetime(_dict.get('expires_at'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SMSInviteAttributesItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'phone_number') and self.phone_number is not None:
            _dict['phone_number'] = self.phone_number
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'expires_at') and self.expires_at is not None:
            _dict['expires_at'] = datetime_to_string(self.expires_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SMSInviteAttributesItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SMSInviteAttributesItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SMSInviteAttributesItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Source():
    """
    Payload describing a source generate request.

    :attr str id: The id of the source.
    :attr str name: The name of the source.
    :attr str description: The description of the source.
    :attr bool enabled: The status of the source.
    :attr str type: Type of the source.
    :attr datetime updated_at: The last updated time of the source.
    :attr int topic_count: The number of topics.
    :attr List[str] topic_names: The names of the topics.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 enabled: bool,
                 type: str,
                 updated_at: datetime,
                 topic_count: int,
                 topic_names: List[str]) -> None:
        """
        Initialize a Source object.

        :param str id: The id of the source.
        :param str name: The name of the source.
        :param str description: The description of the source.
        :param bool enabled: The status of the source.
        :param str type: Type of the source.
        :param datetime updated_at: The last updated time of the source.
        :param int topic_count: The number of topics.
        :param List[str] topic_names: The names of the topics.
        """
        self.id = id
        self.name = name
        self.description = description
        self.enabled = enabled
        self.type = type
        self.updated_at = updated_at
        self.topic_count = topic_count
        self.topic_names = topic_names

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Source':
        """Initialize a Source object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Source JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Source JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Source JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in Source JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in Source JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in Source JSON')
        if 'topic_count' in _dict:
            args['topic_count'] = _dict.get('topic_count')
        else:
            raise ValueError('Required property \'topic_count\' not present in Source JSON')
        if 'topic_names' in _dict:
            args['topic_names'] = _dict.get('topic_names')
        else:
            raise ValueError('Required property \'topic_names\' not present in Source JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Source object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'topic_count') and self.topic_count is not None:
            _dict['topic_count'] = self.topic_count
        if hasattr(self, 'topic_names') and self.topic_names is not None:
            _dict['topic_names'] = self.topic_names
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Source object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Source') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Source') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceList():
    """
    Payload describing a source list request.

    :attr int total_count: Number of sources.
    :attr int offset: Current offset.
    :attr int limit: limit to show sources.
    :attr List[SourceListItem] sources: List of sources.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 sources: List['SourceListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a SourceList object.

        :param int total_count: Number of sources.
        :param int offset: Current offset.
        :param int limit: limit to show sources.
        :param List[SourceListItem] sources: List of sources.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.sources = sources
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceList':
        """Initialize a SourceList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in SourceList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in SourceList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in SourceList JSON')
        if 'sources' in _dict:
            args['sources'] = [SourceListItem.from_dict(x) for x in _dict.get('sources')]
        else:
            raise ValueError('Required property \'sources\' not present in SourceList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'sources') and self.sources is not None:
            _dict['sources'] = [x.to_dict() for x in self.sources]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceListItem():
    """
    Payload describing a source list item.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr str description: Description of the source.
    :attr str type: Type of the source.
    :attr bool enabled: Whether the source is enabled or not.
    :attr datetime updated_at: Time of the last update.
    :attr int topic_count: Number of topics.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 type: str,
                 enabled: bool,
                 updated_at: datetime,
                 topic_count: int) -> None:
        """
        Initialize a SourceListItem object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param str type: Type of the source.
        :param bool enabled: Whether the source is enabled or not.
        :param datetime updated_at: Time of the last update.
        :param int topic_count: Number of topics.
        """
        self.id = id
        self.name = name
        self.description = description
        self.type = type
        self.enabled = enabled
        self.updated_at = updated_at
        self.topic_count = topic_count

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceListItem':
        """Initialize a SourceListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourceListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourceListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SourceListItem JSON')
        if 'type' in _dict:
            args['type'] = _dict.get('type')
        else:
            raise ValueError('Required property \'type\' not present in SourceListItem JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in SourceListItem JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in SourceListItem JSON')
        if 'topic_count' in _dict:
            args['topic_count'] = _dict.get('topic_count')
        else:
            raise ValueError('Required property \'topic_count\' not present in SourceListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'type') and self.type is not None:
            _dict['type'] = self.type
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        if hasattr(self, 'topic_count') and self.topic_count is not None:
            _dict['topic_count'] = self.topic_count
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourceResponse():
    """
    Payload describing a source.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr str description: Description of the source.
    :attr bool enabled: Whether the source is enabled or not.
    :attr datetime created_at: Time of the created.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 enabled: bool,
                 created_at: datetime) -> None:
        """
        Initialize a SourceResponse object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param str description: Description of the source.
        :param bool enabled: Whether the source is enabled or not.
        :param datetime created_at: Time of the created.
        """
        self.id = id
        self.name = name
        self.description = description
        self.enabled = enabled
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourceResponse':
        """Initialize a SourceResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourceResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourceResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SourceResponse JSON')
        if 'enabled' in _dict:
            args['enabled'] = _dict.get('enabled')
        else:
            raise ValueError('Required property \'enabled\' not present in SourceResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = string_to_datetime(_dict.get('created_at'))
        else:
            raise ValueError('Required property \'created_at\' not present in SourceResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourceResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'enabled') and self.enabled is not None:
            _dict['enabled'] = self.enabled
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = datetime_to_string(self.created_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourceResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourceResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourceResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourcesItems():
    """
    SourcesItems.

    :attr str id: ID of the source.
    :attr List[Rules] rules: List of rules.
    """

    def __init__(self,
                 id: str,
                 rules: List['Rules']) -> None:
        """
        Initialize a SourcesItems object.

        :param str id: ID of the source.
        :param List[Rules] rules: List of rules.
        """
        self.id = id
        self.rules = rules

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourcesItems':
        """Initialize a SourcesItems object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourcesItems JSON')
        if 'rules' in _dict:
            args['rules'] = [Rules.from_dict(x) for x in _dict.get('rules')]
        else:
            raise ValueError('Required property \'rules\' not present in SourcesItems JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourcesItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'rules') and self.rules is not None:
            _dict['rules'] = [x.to_dict() for x in self.rules]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourcesItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourcesItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourcesItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SourcesListItems():
    """
    Payload describing a source list item.

    :attr str id: ID of the source.
    :attr str name: Name of the source.
    :attr List[RulesGet] rules: (optional) List of rules.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 *,
                 rules: List['RulesGet'] = None) -> None:
        """
        Initialize a SourcesListItems object.

        :param str id: ID of the source.
        :param str name: Name of the source.
        :param List[RulesGet] rules: (optional) List of rules.
        """
        self.id = id
        self.name = name
        self.rules = rules

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SourcesListItems':
        """Initialize a SourcesListItems object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SourcesListItems JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SourcesListItems JSON')
        if 'rules' in _dict:
            args['rules'] = [RulesGet.from_dict(x) for x in _dict.get('rules')]
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SourcesListItems object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'rules') and self.rules is not None:
            _dict['rules'] = [x.to_dict() for x in self.rules]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SourcesListItems object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SourcesListItems') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SourcesListItems') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Subscription():
    """
    Subscription object.

    :attr str id: Subscription ID.
    :attr str name: Subscription name.
    :attr str description: Subscription description.
    :attr str updated_at: Last updated time.
    :attr str from_: (optional) From Email ID (it will be displayed only in case of
          smtp_ibm destination type).
    :attr str destination_type: The type of destination.
    :attr str destination_id: The destination ID.
    :attr str destination_name: The destination name.
    :attr str topic_id: Topic ID.
    :attr str topic_name: Topic name.
    :attr SubscriptionAttributes attributes: (optional)
    """

    # The set of defined properties for the class
    _properties = frozenset(['id', 'name', 'description', 'updated_at', 'from_', 'from', 'destination_type', 'destination_id', 'destination_name', 'topic_id', 'topic_name', 'attributes'])

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 updated_at: str,
                 destination_type: str,
                 destination_id: str,
                 destination_name: str,
                 topic_id: str,
                 topic_name: str,
                 *,
                 from_: str = None,
                 attributes: 'SubscriptionAttributes' = None,
                 **kwargs) -> None:
        """
        Initialize a Subscription object.

        :param str id: Subscription ID.
        :param str name: Subscription name.
        :param str description: Subscription description.
        :param str updated_at: Last updated time.
        :param str destination_type: The type of destination.
        :param str destination_id: The destination ID.
        :param str destination_name: The destination name.
        :param str topic_id: Topic ID.
        :param str topic_name: Topic name.
        :param str from_: (optional) From Email ID (it will be displayed only in
               case of smtp_ibm destination type).
        :param SubscriptionAttributes attributes: (optional)
        :param **kwargs: (optional) Any additional properties.
        """
        self.id = id
        self.name = name
        self.description = description
        self.updated_at = updated_at
        self.from_ = from_
        self.destination_type = destination_type
        self.destination_id = destination_id
        self.destination_name = destination_name
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.attributes = attributes
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Subscription':
        """Initialize a Subscription object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Subscription JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Subscription JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Subscription JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in Subscription JSON')
        if 'from' in _dict:
            args['from_'] = _dict.get('from')
        if 'destination_type' in _dict:
            args['destination_type'] = _dict.get('destination_type')
        else:
            raise ValueError('Required property \'destination_type\' not present in Subscription JSON')
        if 'destination_id' in _dict:
            args['destination_id'] = _dict.get('destination_id')
        else:
            raise ValueError('Required property \'destination_id\' not present in Subscription JSON')
        if 'destination_name' in _dict:
            args['destination_name'] = _dict.get('destination_name')
        else:
            raise ValueError('Required property \'destination_name\' not present in Subscription JSON')
        if 'topic_id' in _dict:
            args['topic_id'] = _dict.get('topic_id')
        else:
            raise ValueError('Required property \'topic_id\' not present in Subscription JSON')
        if 'topic_name' in _dict:
            args['topic_name'] = _dict.get('topic_name')
        else:
            raise ValueError('Required property \'topic_name\' not present in Subscription JSON')
        if 'attributes' in _dict:
            args['attributes'] = _dict.get('attributes')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Subscription object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'from_') and self.from_ is not None:
            _dict['from'] = self.from_
        if hasattr(self, 'destination_type') and self.destination_type is not None:
            _dict['destination_type'] = self.destination_type
        if hasattr(self, 'destination_id') and self.destination_id is not None:
            _dict['destination_id'] = self.destination_id
        if hasattr(self, 'destination_name') and self.destination_name is not None:
            _dict['destination_name'] = self.destination_name
        if hasattr(self, 'topic_id') and self.topic_id is not None:
            _dict['topic_id'] = self.topic_id
        if hasattr(self, 'topic_name') and self.topic_name is not None:
            _dict['topic_name'] = self.topic_name
        if hasattr(self, 'attributes') and self.attributes is not None:
            if isinstance(self.attributes, dict):
                _dict['attributes'] = self.attributes
            else:
                _dict['attributes'] = self.attributes.to_dict()
        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of Subscription"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of Subscription"""
        for _key in [k for k in vars(self).keys() if k not in Subscription._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in Subscription._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this Subscription object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Subscription') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Subscription') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class DestinationTypeEnum(str, Enum):
        """
        The type of destination.
        """
        SMS_IBM = 'sms_ibm'
        SMTP_IBM = 'smtp_ibm'
        WEBHOOK = 'webhook'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        PUSH_CHROME = 'push_chrome'
        PUSH_FIREFOX = 'push_firefox'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


class SubscriptionAttributes():
    """
    SubscriptionAttributes.

    """

    def __init__(self,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributes object.

        :param **kwargs: (optional) Any additional properties.
        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionAttributesSMSAttributesResponse', 'SubscriptionAttributesEmailAttributesResponse', 'SubscriptionAttributesWebhookAttributesResponse', 'SubscriptionAttributesSlackAttributesResponse', 'SubscriptionAttributesServiceNowAttributesResponse']))
        raise Exception(msg)

class SubscriptionCreateAttributes():
    """
    SubscriptionCreateAttributes.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionCreateAttributes object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionCreateAttributesSMSAttributes', 'SubscriptionCreateAttributesEmailAttributes', 'SubscriptionCreateAttributesWebhookAttributes', 'SubscriptionCreateAttributesFCMAttributes', 'SubscriptionCreateAttributesSlackAttributes', 'SubscriptionCreateAttributesServiceNowAttributes']))
        raise Exception(msg)

class SubscriptionList():
    """
    Subscription list object.

    :attr int total_count: Number of subscriptions.
    :attr int offset: Current offset.
    :attr int limit: limit to show subscriptions.
    :attr List[SubscriptionListItem] subscriptions: List of subscriptions.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 subscriptions: List['SubscriptionListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a SubscriptionList object.

        :param int total_count: Number of subscriptions.
        :param int offset: Current offset.
        :param int limit: limit to show subscriptions.
        :param List[SubscriptionListItem] subscriptions: List of subscriptions.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.subscriptions = subscriptions
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionList':
        """Initialize a SubscriptionList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in SubscriptionList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in SubscriptionList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in SubscriptionList JSON')
        if 'subscriptions' in _dict:
            args['subscriptions'] = [SubscriptionListItem.from_dict(x) for x in _dict.get('subscriptions')]
        else:
            raise ValueError('Required property \'subscriptions\' not present in SubscriptionList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'subscriptions') and self.subscriptions is not None:
            _dict['subscriptions'] = [x.to_dict() for x in self.subscriptions]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionListItem():
    """
    Subscription list item.

    :attr str id: ID of the subscription.
    :attr str name: Name of the subscription.
    :attr str description: Description of the subscription.
    :attr str destination_id: ID of the destination.
    :attr str destination_name: (optional) Name of the destination.
    :attr str destination_type: The type of destination.
    :attr str topic_id: ID of the topic.
    :attr str topic_name: (optional) Name of the topic.
    :attr datetime updated_at: Last updated time of the subscription.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 destination_id: str,
                 destination_type: str,
                 topic_id: str,
                 updated_at: datetime,
                 *,
                 destination_name: str = None,
                 topic_name: str = None) -> None:
        """
        Initialize a SubscriptionListItem object.

        :param str id: ID of the subscription.
        :param str name: Name of the subscription.
        :param str description: Description of the subscription.
        :param str destination_id: ID of the destination.
        :param str destination_type: The type of destination.
        :param str topic_id: ID of the topic.
        :param datetime updated_at: Last updated time of the subscription.
        :param str destination_name: (optional) Name of the destination.
        :param str topic_name: (optional) Name of the topic.
        """
        self.id = id
        self.name = name
        self.description = description
        self.destination_id = destination_id
        self.destination_name = destination_name
        self.destination_type = destination_type
        self.topic_id = topic_id
        self.topic_name = topic_name
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionListItem':
        """Initialize a SubscriptionListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in SubscriptionListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in SubscriptionListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in SubscriptionListItem JSON')
        if 'destination_id' in _dict:
            args['destination_id'] = _dict.get('destination_id')
        else:
            raise ValueError('Required property \'destination_id\' not present in SubscriptionListItem JSON')
        if 'destination_name' in _dict:
            args['destination_name'] = _dict.get('destination_name')
        if 'destination_type' in _dict:
            args['destination_type'] = _dict.get('destination_type')
        else:
            raise ValueError('Required property \'destination_type\' not present in SubscriptionListItem JSON')
        if 'topic_id' in _dict:
            args['topic_id'] = _dict.get('topic_id')
        else:
            raise ValueError('Required property \'topic_id\' not present in SubscriptionListItem JSON')
        if 'topic_name' in _dict:
            args['topic_name'] = _dict.get('topic_name')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in SubscriptionListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'destination_id') and self.destination_id is not None:
            _dict['destination_id'] = self.destination_id
        if hasattr(self, 'destination_name') and self.destination_name is not None:
            _dict['destination_name'] = self.destination_name
        if hasattr(self, 'destination_type') and self.destination_type is not None:
            _dict['destination_type'] = self.destination_type
        if hasattr(self, 'topic_id') and self.topic_id is not None:
            _dict['topic_id'] = self.topic_id
        if hasattr(self, 'topic_name') and self.topic_name is not None:
            _dict['topic_name'] = self.topic_name
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class DestinationTypeEnum(str, Enum):
        """
        The type of destination.
        """
        SMS_IBM = 'sms_ibm'
        SMTP_IBM = 'smtp_ibm'
        WEBHOOK = 'webhook'
        PUSH_ANDROID = 'push_android'
        PUSH_IOS = 'push_ios'
        PUSH_CHROME = 'push_chrome'
        PUSH_FIREFOX = 'push_firefox'
        SLACK = 'slack'
        IBMCF = 'ibmcf'
        PAGERDUTY = 'pagerduty'
        PUSH_SAFARI = 'push_safari'
        MSTEAMS = 'msteams'
        SERVICENOW = 'servicenow'


class SubscriptionUpdateAttributes():
    """
    SubscriptionUpdateAttributes.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionUpdateAttributes object.

        """
        msg = "Cannot instantiate base class. Instead, instantiate one of the defined subclasses: {0}".format(
                  ", ".join(['SubscriptionUpdateAttributesSMSUpdateAttributes', 'SubscriptionUpdateAttributesEmailUpdateAttributes', 'SubscriptionUpdateAttributesWebhookAttributes', 'SubscriptionUpdateAttributesSlackAttributes', 'SubscriptionUpdateAttributesServiceNowAttributes']))
        raise Exception(msg)

class TagsSubscriptionList():
    """
    Payload describing a tags list request.

    :attr int total_count: Total number of tags.
    :attr int offset: Current offset.
    :attr int limit: limit to show tags.
    :attr List[TagsSubscriptionListItem] tag_subscriptions: List of tags.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 tag_subscriptions: List['TagsSubscriptionListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a TagsSubscriptionList object.

        :param int total_count: Total number of tags.
        :param int offset: Current offset.
        :param int limit: limit to show tags.
        :param List[TagsSubscriptionListItem] tag_subscriptions: List of tags.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.tag_subscriptions = tag_subscriptions
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TagsSubscriptionList':
        """Initialize a TagsSubscriptionList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in TagsSubscriptionList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in TagsSubscriptionList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in TagsSubscriptionList JSON')
        if 'tag_subscriptions' in _dict:
            args['tag_subscriptions'] = [TagsSubscriptionListItem.from_dict(x) for x in _dict.get('tag_subscriptions')]
        else:
            raise ValueError('Required property \'tag_subscriptions\' not present in TagsSubscriptionList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TagsSubscriptionList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'tag_subscriptions') and self.tag_subscriptions is not None:
            _dict['tag_subscriptions'] = [x.to_dict() for x in self.tag_subscriptions]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TagsSubscriptionList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TagsSubscriptionList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TagsSubscriptionList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TagsSubscriptionListItem():
    """
    Tags subscription object.

    :attr str id: Subscription Tag ID.
    :attr str device_id: Unique identifier of the device.
    :attr str tag_name: The name of the tag its subscribed.
    :attr str user_id: (optional) The user identifier for the device registration.
    :attr datetime updated_at: Updated at.
    """

    def __init__(self,
                 id: str,
                 device_id: str,
                 tag_name: str,
                 updated_at: datetime,
                 *,
                 user_id: str = None) -> None:
        """
        Initialize a TagsSubscriptionListItem object.

        :param str id: Subscription Tag ID.
        :param str device_id: Unique identifier of the device.
        :param str tag_name: The name of the tag its subscribed.
        :param datetime updated_at: Updated at.
        :param str user_id: (optional) The user identifier for the device
               registration.
        """
        self.id = id
        self.device_id = device_id
        self.tag_name = tag_name
        self.user_id = user_id
        self.updated_at = updated_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TagsSubscriptionListItem':
        """Initialize a TagsSubscriptionListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TagsSubscriptionListItem JSON')
        if 'device_id' in _dict:
            args['device_id'] = _dict.get('device_id')
        else:
            raise ValueError('Required property \'device_id\' not present in TagsSubscriptionListItem JSON')
        if 'tag_name' in _dict:
            args['tag_name'] = _dict.get('tag_name')
        else:
            raise ValueError('Required property \'tag_name\' not present in TagsSubscriptionListItem JSON')
        if 'user_id' in _dict:
            args['user_id'] = _dict.get('user_id')
        if 'updated_at' in _dict:
            args['updated_at'] = string_to_datetime(_dict.get('updated_at'))
        else:
            raise ValueError('Required property \'updated_at\' not present in TagsSubscriptionListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TagsSubscriptionListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'device_id') and self.device_id is not None:
            _dict['device_id'] = self.device_id
        if hasattr(self, 'tag_name') and self.tag_name is not None:
            _dict['tag_name'] = self.tag_name
        if hasattr(self, 'user_id') and self.user_id is not None:
            _dict['user_id'] = self.user_id
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = datetime_to_string(self.updated_at)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TagsSubscriptionListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TagsSubscriptionListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TagsSubscriptionListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class Topic():
    """
    Topic object.

    :attr str id: Autogenerated topic ID.
    :attr str description: Description of the topic.
    :attr str name: Name of the topic.
    :attr str updated_at: Last time the topic was updated.
    :attr int source_count: Number of sources.
    :attr List[SourcesListItems] sources: List of sources.
    :attr int subscription_count: Number of subscriptions.
    :attr List[SubscriptionListItem] subscriptions: List of subscriptions.
    """

    def __init__(self,
                 id: str,
                 description: str,
                 name: str,
                 updated_at: str,
                 source_count: int,
                 sources: List['SourcesListItems'],
                 subscription_count: int,
                 subscriptions: List['SubscriptionListItem']) -> None:
        """
        Initialize a Topic object.

        :param str id: Autogenerated topic ID.
        :param str description: Description of the topic.
        :param str name: Name of the topic.
        :param str updated_at: Last time the topic was updated.
        :param int source_count: Number of sources.
        :param List[SourcesListItems] sources: List of sources.
        :param int subscription_count: Number of subscriptions.
        :param List[SubscriptionListItem] subscriptions: List of subscriptions.
        """
        self.id = id
        self.description = description
        self.name = name
        self.updated_at = updated_at
        self.source_count = source_count
        self.sources = sources
        self.subscription_count = subscription_count
        self.subscriptions = subscriptions

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'Topic':
        """Initialize a Topic object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in Topic JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in Topic JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in Topic JSON')
        if 'updated_at' in _dict:
            args['updated_at'] = _dict.get('updated_at')
        else:
            raise ValueError('Required property \'updated_at\' not present in Topic JSON')
        if 'source_count' in _dict:
            args['source_count'] = _dict.get('source_count')
        else:
            raise ValueError('Required property \'source_count\' not present in Topic JSON')
        if 'sources' in _dict:
            args['sources'] = [SourcesListItems.from_dict(x) for x in _dict.get('sources')]
        else:
            raise ValueError('Required property \'sources\' not present in Topic JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in Topic JSON')
        if 'subscriptions' in _dict:
            args['subscriptions'] = [SubscriptionListItem.from_dict(x) for x in _dict.get('subscriptions')]
        else:
            raise ValueError('Required property \'subscriptions\' not present in Topic JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a Topic object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'updated_at') and self.updated_at is not None:
            _dict['updated_at'] = self.updated_at
        if hasattr(self, 'source_count') and self.source_count is not None:
            _dict['source_count'] = self.source_count
        if hasattr(self, 'sources') and self.sources is not None:
            _dict['sources'] = [x.to_dict() for x in self.sources]
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        if hasattr(self, 'subscriptions') and self.subscriptions is not None:
            _dict['subscriptions'] = [x.to_dict() for x in self.subscriptions]
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this Topic object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'Topic') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'Topic') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicList():
    """
    Topic list object.

    :attr int total_count: Number of topics.
    :attr int offset: Current offset.
    :attr int limit: limit to show subscriptions.
    :attr List[TopicsListItem] topics: List of topics.
    :attr PageHrefResponse first: (optional) Response having URL of the page.
    :attr PageHrefResponse previous: (optional) Response having URL of the page.
    :attr PageHrefResponse next: (optional) Response having URL of the page.
    """

    def __init__(self,
                 total_count: int,
                 offset: int,
                 limit: int,
                 topics: List['TopicsListItem'],
                 *,
                 first: 'PageHrefResponse' = None,
                 previous: 'PageHrefResponse' = None,
                 next: 'PageHrefResponse' = None) -> None:
        """
        Initialize a TopicList object.

        :param int total_count: Number of topics.
        :param int offset: Current offset.
        :param int limit: limit to show subscriptions.
        :param List[TopicsListItem] topics: List of topics.
        :param PageHrefResponse first: (optional) Response having URL of the page.
        :param PageHrefResponse previous: (optional) Response having URL of the
               page.
        :param PageHrefResponse next: (optional) Response having URL of the page.
        """
        self.total_count = total_count
        self.offset = offset
        self.limit = limit
        self.topics = topics
        self.first = first
        self.previous = previous
        self.next = next

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicList':
        """Initialize a TopicList object from a json dictionary."""
        args = {}
        if 'total_count' in _dict:
            args['total_count'] = _dict.get('total_count')
        else:
            raise ValueError('Required property \'total_count\' not present in TopicList JSON')
        if 'offset' in _dict:
            args['offset'] = _dict.get('offset')
        else:
            raise ValueError('Required property \'offset\' not present in TopicList JSON')
        if 'limit' in _dict:
            args['limit'] = _dict.get('limit')
        else:
            raise ValueError('Required property \'limit\' not present in TopicList JSON')
        if 'topics' in _dict:
            args['topics'] = [TopicsListItem.from_dict(x) for x in _dict.get('topics')]
        else:
            raise ValueError('Required property \'topics\' not present in TopicList JSON')
        if 'first' in _dict:
            args['first'] = PageHrefResponse.from_dict(_dict.get('first'))
        if 'previous' in _dict:
            args['previous'] = PageHrefResponse.from_dict(_dict.get('previous'))
        if 'next' in _dict:
            args['next'] = PageHrefResponse.from_dict(_dict.get('next'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicList object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'total_count') and self.total_count is not None:
            _dict['total_count'] = self.total_count
        if hasattr(self, 'offset') and self.offset is not None:
            _dict['offset'] = self.offset
        if hasattr(self, 'limit') and self.limit is not None:
            _dict['limit'] = self.limit
        if hasattr(self, 'topics') and self.topics is not None:
            _dict['topics'] = [x.to_dict() for x in self.topics]
        if hasattr(self, 'first') and self.first is not None:
            _dict['first'] = self.first.to_dict()
        if hasattr(self, 'previous') and self.previous is not None:
            _dict['previous'] = self.previous.to_dict()
        if hasattr(self, 'next') and self.next is not None:
            _dict['next'] = self.next.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicList object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicList') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicList') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicResponse():
    """
    Topic object.

    :attr str id: Autogenerated topic ID.
    :attr str name: Name of the topic.
    :attr str description: Description of the topic.
    :attr str created_at: Last time the topic was updated.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 created_at: str) -> None:
        """
        Initialize a TopicResponse object.

        :param str id: Autogenerated topic ID.
        :param str name: Name of the topic.
        :param str description: Description of the topic.
        :param str created_at: Last time the topic was updated.
        """
        self.id = id
        self.name = name
        self.description = description
        self.created_at = created_at

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicResponse':
        """Initialize a TopicResponse object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TopicResponse JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TopicResponse JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in TopicResponse JSON')
        if 'created_at' in _dict:
            args['created_at'] = _dict.get('created_at')
        else:
            raise ValueError('Required property \'created_at\' not present in TopicResponse JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'created_at') and self.created_at is not None:
            _dict['created_at'] = self.created_at
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class TopicsListItem():
    """
    Topic list item object.

    :attr str id: Autogenerated topic ID.
    :attr str name: Name of the topic.
    :attr str description: Description of the topic.
    :attr int source_count: Number of sources.
    :attr List[str] sources_names: List of source names.
    :attr int subscription_count: Number of subscriptions.
    """

    def __init__(self,
                 id: str,
                 name: str,
                 description: str,
                 source_count: int,
                 sources_names: List[str],
                 subscription_count: int) -> None:
        """
        Initialize a TopicsListItem object.

        :param str id: Autogenerated topic ID.
        :param str name: Name of the topic.
        :param str description: Description of the topic.
        :param int source_count: Number of sources.
        :param List[str] sources_names: List of source names.
        :param int subscription_count: Number of subscriptions.
        """
        self.id = id
        self.name = name
        self.description = description
        self.source_count = source_count
        self.sources_names = sources_names
        self.subscription_count = subscription_count

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'TopicsListItem':
        """Initialize a TopicsListItem object from a json dictionary."""
        args = {}
        if 'id' in _dict:
            args['id'] = _dict.get('id')
        else:
            raise ValueError('Required property \'id\' not present in TopicsListItem JSON')
        if 'name' in _dict:
            args['name'] = _dict.get('name')
        else:
            raise ValueError('Required property \'name\' not present in TopicsListItem JSON')
        if 'description' in _dict:
            args['description'] = _dict.get('description')
        else:
            raise ValueError('Required property \'description\' not present in TopicsListItem JSON')
        if 'source_count' in _dict:
            args['source_count'] = _dict.get('source_count')
        else:
            raise ValueError('Required property \'source_count\' not present in TopicsListItem JSON')
        if 'sources_names' in _dict:
            args['sources_names'] = _dict.get('sources_names')
        else:
            raise ValueError('Required property \'sources_names\' not present in TopicsListItem JSON')
        if 'subscription_count' in _dict:
            args['subscription_count'] = _dict.get('subscription_count')
        else:
            raise ValueError('Required property \'subscription_count\' not present in TopicsListItem JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a TopicsListItem object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'id') and self.id is not None:
            _dict['id'] = self.id
        if hasattr(self, 'name') and self.name is not None:
            _dict['name'] = self.name
        if hasattr(self, 'description') and self.description is not None:
            _dict['description'] = self.description
        if hasattr(self, 'source_count') and self.source_count is not None:
            _dict['source_count'] = self.source_count
        if hasattr(self, 'sources_names') and self.sources_names is not None:
            _dict['sources_names'] = self.sources_names
        if hasattr(self, 'subscription_count') and self.subscription_count is not None:
            _dict['subscription_count'] = self.subscription_count
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this TopicsListItem object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'TopicsListItem') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'TopicsListItem') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class UpdateAttributesInvited():
    """
    The email ids or phone numbers.

    :attr List[str] add: (optional) The email ids or phone numbers to be invited.
    :attr List[str] remove: (optional) The email ids or phone numbers for removal.
    """

    def __init__(self,
                 *,
                 add: List[str] = None,
                 remove: List[str] = None) -> None:
        """
        Initialize a UpdateAttributesInvited object.

        :param List[str] add: (optional) The email ids or phone numbers to be
               invited.
        :param List[str] remove: (optional) The email ids or phone numbers for
               removal.
        """
        self.add = add
        self.remove = remove

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'UpdateAttributesInvited':
        """Initialize a UpdateAttributesInvited object from a json dictionary."""
        args = {}
        if 'add' in _dict:
            args['add'] = _dict.get('add')
        if 'remove' in _dict:
            args['remove'] = _dict.get('remove')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a UpdateAttributesInvited object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'add') and self.add is not None:
            _dict['add'] = self.add
        if hasattr(self, 'remove') and self.remove is not None:
            _dict['remove'] = self.remove
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this UpdateAttributesInvited object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'UpdateAttributesInvited') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'UpdateAttributesInvited') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class UpdateAttributesSubscribed():
    """
    The email ids or phone numbers.

    :attr List[str] remove: (optional) The email ids or phone numbers to be
          unsubscribed.
    """

    def __init__(self,
                 *,
                 remove: List[str] = None) -> None:
        """
        Initialize a UpdateAttributesSubscribed object.

        :param List[str] remove: (optional) The email ids or phone numbers to be
               unsubscribed.
        """
        self.remove = remove

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'UpdateAttributesSubscribed':
        """Initialize a UpdateAttributesSubscribed object from a json dictionary."""
        args = {}
        if 'remove' in _dict:
            args['remove'] = _dict.get('remove')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a UpdateAttributesSubscribed object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'remove') and self.remove is not None:
            _dict['remove'] = self.remove
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this UpdateAttributesSubscribed object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'UpdateAttributesSubscribed') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'UpdateAttributesSubscribed') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class UpdateAttributesUnsubscribed():
    """
    The email ids or phone numbers.

    :attr List[str] remove: (optional) The email ids or phone numbers to be
          unsubscribed.
    """

    def __init__(self,
                 *,
                 remove: List[str] = None) -> None:
        """
        Initialize a UpdateAttributesUnsubscribed object.

        :param List[str] remove: (optional) The email ids or phone numbers to be
               unsubscribed.
        """
        self.remove = remove

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'UpdateAttributesUnsubscribed':
        """Initialize a UpdateAttributesUnsubscribed object from a json dictionary."""
        args = {}
        if 'remove' in _dict:
            args['remove'] = _dict.get('remove')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a UpdateAttributesUnsubscribed object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'remove') and self.remove is not None:
            _dict['remove'] = self.remove
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this UpdateAttributesUnsubscribed object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'UpdateAttributesUnsubscribed') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'UpdateAttributesUnsubscribed') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfChromeDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a Chrome destination configuration.

    :attr str api_key: FCM api_key.
    :attr str website_url: Website url.
    :attr str public_key: (optional) Chrome VAPID public key.
    :attr bool pre_prod: (optional) If pre prod enabled.
    """

    def __init__(self,
                 api_key: str,
                 website_url: str,
                 *,
                 public_key: str = None,
                 pre_prod: bool = None) -> None:
        """
        Initialize a DestinationConfigOneOfChromeDestinationConfig object.

        :param str api_key: FCM api_key.
        :param str website_url: Website url.
        :param str public_key: (optional) Chrome VAPID public key.
        :param bool pre_prod: (optional) If pre prod enabled.
        """
        # pylint: disable=super-init-not-called
        self.api_key = api_key
        self.website_url = website_url
        self.public_key = public_key
        self.pre_prod = pre_prod

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfChromeDestinationConfig':
        """Initialize a DestinationConfigOneOfChromeDestinationConfig object from a json dictionary."""
        args = {}
        if 'api_key' in _dict:
            args['api_key'] = _dict.get('api_key')
        else:
            raise ValueError('Required property \'api_key\' not present in DestinationConfigOneOfChromeDestinationConfig JSON')
        if 'website_url' in _dict:
            args['website_url'] = _dict.get('website_url')
        else:
            raise ValueError('Required property \'website_url\' not present in DestinationConfigOneOfChromeDestinationConfig JSON')
        if 'public_key' in _dict:
            args['public_key'] = _dict.get('public_key')
        if 'pre_prod' in _dict:
            args['pre_prod'] = _dict.get('pre_prod')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfChromeDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'api_key') and self.api_key is not None:
            _dict['api_key'] = self.api_key
        if hasattr(self, 'website_url') and self.website_url is not None:
            _dict['website_url'] = self.website_url
        if hasattr(self, 'public_key') and self.public_key is not None:
            _dict['public_key'] = self.public_key
        if hasattr(self, 'pre_prod') and self.pre_prod is not None:
            _dict['pre_prod'] = self.pre_prod
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfChromeDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfChromeDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfChromeDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfFCMDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing an FCM destination configuration. project_id, private_key and
    client_email for FCM HTTP v1 APIs.

    :attr str server_key: (optional) FCM server_key.
    :attr str sender_id: (optional) FCM sender_id.
    :attr bool pre_prod: (optional) If pre prod enabled.
    :attr str project_id: (optional) FCM project_id.
    :attr str private_key: (optional) FCM private_key.
    :attr str client_email: (optional) FCM client_email.
    """

    def __init__(self,
                 *,
                 server_key: str = None,
                 sender_id: str = None,
                 pre_prod: bool = None,
                 project_id: str = None,
                 private_key: str = None,
                 client_email: str = None) -> None:
        """
        Initialize a DestinationConfigOneOfFCMDestinationConfig object.

        :param str server_key: (optional) FCM server_key.
        :param str sender_id: (optional) FCM sender_id.
        :param bool pre_prod: (optional) If pre prod enabled.
        :param str project_id: (optional) FCM project_id.
        :param str private_key: (optional) FCM private_key.
        :param str client_email: (optional) FCM client_email.
        """
        # pylint: disable=super-init-not-called
        self.server_key = server_key
        self.sender_id = sender_id
        self.pre_prod = pre_prod
        self.project_id = project_id
        self.private_key = private_key
        self.client_email = client_email

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfFCMDestinationConfig':
        """Initialize a DestinationConfigOneOfFCMDestinationConfig object from a json dictionary."""
        args = {}
        if 'server_key' in _dict:
            args['server_key'] = _dict.get('server_key')
        if 'sender_id' in _dict:
            args['sender_id'] = _dict.get('sender_id')
        if 'pre_prod' in _dict:
            args['pre_prod'] = _dict.get('pre_prod')
        if 'project_id' in _dict:
            args['project_id'] = _dict.get('project_id')
        if 'private_key' in _dict:
            args['private_key'] = _dict.get('private_key')
        if 'client_email' in _dict:
            args['client_email'] = _dict.get('client_email')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfFCMDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'server_key') and self.server_key is not None:
            _dict['server_key'] = self.server_key
        if hasattr(self, 'sender_id') and self.sender_id is not None:
            _dict['sender_id'] = self.sender_id
        if hasattr(self, 'pre_prod') and self.pre_prod is not None:
            _dict['pre_prod'] = self.pre_prod
        if hasattr(self, 'project_id') and self.project_id is not None:
            _dict['project_id'] = self.project_id
        if hasattr(self, 'private_key') and self.private_key is not None:
            _dict['private_key'] = self.private_key
        if hasattr(self, 'client_email') and self.client_email is not None:
            _dict['client_email'] = self.client_email
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfFCMDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfFCMDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfFCMDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfFirefoxDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a Firefox destination configuration.

    :attr str website_url: Website url.
    :attr str public_key: (optional) Chrome VAPID public key.
    :attr bool pre_prod: (optional) If pre prod enabled.
    """

    def __init__(self,
                 website_url: str,
                 *,
                 public_key: str = None,
                 pre_prod: bool = None) -> None:
        """
        Initialize a DestinationConfigOneOfFirefoxDestinationConfig object.

        :param str website_url: Website url.
        :param str public_key: (optional) Chrome VAPID public key.
        :param bool pre_prod: (optional) If pre prod enabled.
        """
        # pylint: disable=super-init-not-called
        self.website_url = website_url
        self.public_key = public_key
        self.pre_prod = pre_prod

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfFirefoxDestinationConfig':
        """Initialize a DestinationConfigOneOfFirefoxDestinationConfig object from a json dictionary."""
        args = {}
        if 'website_url' in _dict:
            args['website_url'] = _dict.get('website_url')
        else:
            raise ValueError('Required property \'website_url\' not present in DestinationConfigOneOfFirefoxDestinationConfig JSON')
        if 'public_key' in _dict:
            args['public_key'] = _dict.get('public_key')
        if 'pre_prod' in _dict:
            args['pre_prod'] = _dict.get('pre_prod')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfFirefoxDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'website_url') and self.website_url is not None:
            _dict['website_url'] = self.website_url
        if hasattr(self, 'public_key') and self.public_key is not None:
            _dict['public_key'] = self.public_key
        if hasattr(self, 'pre_prod') and self.pre_prod is not None:
            _dict['pre_prod'] = self.pre_prod
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfFirefoxDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfFirefoxDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfFirefoxDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfIBMCloudFunctionsDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing an IBM Cloud Functions destination configuration.

    :attr str url: URL of IBM Cloud Functions Trigger EndPoint.
    :attr str api_key: (optional) API Key with access of IBM Cloud Functions IAM
          Namespace.
    """

    def __init__(self,
                 url: str,
                 *,
                 api_key: str = None) -> None:
        """
        Initialize a DestinationConfigOneOfIBMCloudFunctionsDestinationConfig object.

        :param str url: URL of IBM Cloud Functions Trigger EndPoint.
        :param str api_key: (optional) API Key with access of IBM Cloud Functions
               IAM Namespace.
        """
        # pylint: disable=super-init-not-called
        self.url = url
        self.api_key = api_key

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfIBMCloudFunctionsDestinationConfig':
        """Initialize a DestinationConfigOneOfIBMCloudFunctionsDestinationConfig object from a json dictionary."""
        args = {}
        if 'url' in _dict:
            args['url'] = _dict.get('url')
        else:
            raise ValueError('Required property \'url\' not present in DestinationConfigOneOfIBMCloudFunctionsDestinationConfig JSON')
        if 'api_key' in _dict:
            args['api_key'] = _dict.get('api_key')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfIBMCloudFunctionsDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        if hasattr(self, 'api_key') and self.api_key is not None:
            _dict['api_key'] = self.api_key
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfIBMCloudFunctionsDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfIBMCloudFunctionsDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfIBMCloudFunctionsDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfIOSDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing an iOS destination configuration.

    :attr str cert_type: Authentication type (p8 or p12).
    :attr bool is_sandbox: Sandbox mode for iOS destinations.
    :attr str password: (optional) Password for certificate (Required when cert_type
          is p12).
    :attr str key_id: (optional) Key ID for token (Required when cert_type is p8).
    :attr str team_id: (optional) Team ID for token (Required when cert_type is p8).
    :attr str bundle_id: (optional) Bundle ID for token (Required when cert_type is
          p8).
    :attr bool pre_prod: (optional) If pre prod enabled.
    """

    def __init__(self,
                 cert_type: str,
                 is_sandbox: bool,
                 *,
                 password: str = None,
                 key_id: str = None,
                 team_id: str = None,
                 bundle_id: str = None,
                 pre_prod: bool = None) -> None:
        """
        Initialize a DestinationConfigOneOfIOSDestinationConfig object.

        :param str cert_type: Authentication type (p8 or p12).
        :param bool is_sandbox: Sandbox mode for iOS destinations.
        :param str password: (optional) Password for certificate (Required when
               cert_type is p12).
        :param str key_id: (optional) Key ID for token (Required when cert_type is
               p8).
        :param str team_id: (optional) Team ID for token (Required when cert_type
               is p8).
        :param str bundle_id: (optional) Bundle ID for token (Required when
               cert_type is p8).
        :param bool pre_prod: (optional) If pre prod enabled.
        """
        # pylint: disable=super-init-not-called
        self.cert_type = cert_type
        self.is_sandbox = is_sandbox
        self.password = password
        self.key_id = key_id
        self.team_id = team_id
        self.bundle_id = bundle_id
        self.pre_prod = pre_prod

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfIOSDestinationConfig':
        """Initialize a DestinationConfigOneOfIOSDestinationConfig object from a json dictionary."""
        args = {}
        if 'cert_type' in _dict:
            args['cert_type'] = _dict.get('cert_type')
        else:
            raise ValueError('Required property \'cert_type\' not present in DestinationConfigOneOfIOSDestinationConfig JSON')
        if 'is_sandbox' in _dict:
            args['is_sandbox'] = _dict.get('is_sandbox')
        else:
            raise ValueError('Required property \'is_sandbox\' not present in DestinationConfigOneOfIOSDestinationConfig JSON')
        if 'password' in _dict:
            args['password'] = _dict.get('password')
        if 'key_id' in _dict:
            args['key_id'] = _dict.get('key_id')
        if 'team_id' in _dict:
            args['team_id'] = _dict.get('team_id')
        if 'bundle_id' in _dict:
            args['bundle_id'] = _dict.get('bundle_id')
        if 'pre_prod' in _dict:
            args['pre_prod'] = _dict.get('pre_prod')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfIOSDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'cert_type') and self.cert_type is not None:
            _dict['cert_type'] = self.cert_type
        if hasattr(self, 'is_sandbox') and self.is_sandbox is not None:
            _dict['is_sandbox'] = self.is_sandbox
        if hasattr(self, 'password') and self.password is not None:
            _dict['password'] = self.password
        if hasattr(self, 'key_id') and self.key_id is not None:
            _dict['key_id'] = self.key_id
        if hasattr(self, 'team_id') and self.team_id is not None:
            _dict['team_id'] = self.team_id
        if hasattr(self, 'bundle_id') and self.bundle_id is not None:
            _dict['bundle_id'] = self.bundle_id
        if hasattr(self, 'pre_prod') and self.pre_prod is not None:
            _dict['pre_prod'] = self.pre_prod
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfIOSDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfIOSDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfIOSDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfMSTeamsDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a MS Teams destination configuration.

    :attr str url: URL of MS Teams Incoming Webhook.
    """

    def __init__(self,
                 url: str) -> None:
        """
        Initialize a DestinationConfigOneOfMSTeamsDestinationConfig object.

        :param str url: URL of MS Teams Incoming Webhook.
        """
        # pylint: disable=super-init-not-called
        self.url = url

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfMSTeamsDestinationConfig':
        """Initialize a DestinationConfigOneOfMSTeamsDestinationConfig object from a json dictionary."""
        args = {}
        if 'url' in _dict:
            args['url'] = _dict.get('url')
        else:
            raise ValueError('Required property \'url\' not present in DestinationConfigOneOfMSTeamsDestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfMSTeamsDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfMSTeamsDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfMSTeamsDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfMSTeamsDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfPagerDutyDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a PagerDuty destination configuration.

    :attr str api_key: API Key for the PagerDuty account.
    :attr str routing_key: Routing Key (Integration Key) for the team in PagerDuty
          account.
    """

    def __init__(self,
                 api_key: str,
                 routing_key: str) -> None:
        """
        Initialize a DestinationConfigOneOfPagerDutyDestinationConfig object.

        :param str api_key: API Key for the PagerDuty account.
        :param str routing_key: Routing Key (Integration Key) for the team in
               PagerDuty account.
        """
        # pylint: disable=super-init-not-called
        self.api_key = api_key
        self.routing_key = routing_key

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfPagerDutyDestinationConfig':
        """Initialize a DestinationConfigOneOfPagerDutyDestinationConfig object from a json dictionary."""
        args = {}
        if 'api_key' in _dict:
            args['api_key'] = _dict.get('api_key')
        else:
            raise ValueError('Required property \'api_key\' not present in DestinationConfigOneOfPagerDutyDestinationConfig JSON')
        if 'routing_key' in _dict:
            args['routing_key'] = _dict.get('routing_key')
        else:
            raise ValueError('Required property \'routing_key\' not present in DestinationConfigOneOfPagerDutyDestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfPagerDutyDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'api_key') and self.api_key is not None:
            _dict['api_key'] = self.api_key
        if hasattr(self, 'routing_key') and self.routing_key is not None:
            _dict['routing_key'] = self.routing_key
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfPagerDutyDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfPagerDutyDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfPagerDutyDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfSafariDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a Safari destination configuration.

    :attr str cert_type: Authentication type p12.
    :attr str password: Password for certificate (Required when cert_type is p12).
    :attr str website_url: Website url.
    :attr str website_name: Website url.
    :attr str url_format_string: Website url.
    :attr str website_push_id: Website url.
    :attr bool pre_prod: (optional) If pre prod enabled.
    """

    def __init__(self,
                 cert_type: str,
                 password: str,
                 website_url: str,
                 website_name: str,
                 url_format_string: str,
                 website_push_id: str,
                 *,
                 pre_prod: bool = None) -> None:
        """
        Initialize a DestinationConfigOneOfSafariDestinationConfig object.

        :param str cert_type: Authentication type p12.
        :param str password: Password for certificate (Required when cert_type is
               p12).
        :param str website_url: Website url.
        :param str website_name: Website url.
        :param str url_format_string: Website url.
        :param str website_push_id: Website url.
        :param bool pre_prod: (optional) If pre prod enabled.
        """
        # pylint: disable=super-init-not-called
        self.cert_type = cert_type
        self.password = password
        self.website_url = website_url
        self.website_name = website_name
        self.url_format_string = url_format_string
        self.website_push_id = website_push_id
        self.pre_prod = pre_prod

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfSafariDestinationConfig':
        """Initialize a DestinationConfigOneOfSafariDestinationConfig object from a json dictionary."""
        args = {}
        if 'cert_type' in _dict:
            args['cert_type'] = _dict.get('cert_type')
        else:
            raise ValueError('Required property \'cert_type\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'password' in _dict:
            args['password'] = _dict.get('password')
        else:
            raise ValueError('Required property \'password\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'website_url' in _dict:
            args['website_url'] = _dict.get('website_url')
        else:
            raise ValueError('Required property \'website_url\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'website_name' in _dict:
            args['website_name'] = _dict.get('website_name')
        else:
            raise ValueError('Required property \'website_name\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'url_format_string' in _dict:
            args['url_format_string'] = _dict.get('url_format_string')
        else:
            raise ValueError('Required property \'url_format_string\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'website_push_id' in _dict:
            args['website_push_id'] = _dict.get('website_push_id')
        else:
            raise ValueError('Required property \'website_push_id\' not present in DestinationConfigOneOfSafariDestinationConfig JSON')
        if 'pre_prod' in _dict:
            args['pre_prod'] = _dict.get('pre_prod')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfSafariDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'cert_type') and self.cert_type is not None:
            _dict['cert_type'] = self.cert_type
        if hasattr(self, 'password') and self.password is not None:
            _dict['password'] = self.password
        if hasattr(self, 'website_url') and self.website_url is not None:
            _dict['website_url'] = self.website_url
        if hasattr(self, 'website_name') and self.website_name is not None:
            _dict['website_name'] = self.website_name
        if hasattr(self, 'url_format_string') and self.url_format_string is not None:
            _dict['url_format_string'] = self.url_format_string
        if hasattr(self, 'website_push_id') and self.website_push_id is not None:
            _dict['website_push_id'] = self.website_push_id
        if hasattr(self, 'pre_prod') and self.pre_prod is not None:
            _dict['pre_prod'] = self.pre_prod
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfSafariDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfSafariDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfSafariDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfServiceNowDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a ServiceNow destination configuration.

    :attr str client_id: ClientID for the ServiceNow account oauth.
    :attr str client_secret: ClientSecret for the ServiceNow account oauth.
    :attr str username: Username for ServiceNow account REST API.
    :attr str password: Password for ServiceNow account REST API.
    :attr str instance_name: Instance name for ServiceNow account.
    """

    def __init__(self,
                 client_id: str,
                 client_secret: str,
                 username: str,
                 password: str,
                 instance_name: str) -> None:
        """
        Initialize a DestinationConfigOneOfServiceNowDestinationConfig object.

        :param str client_id: ClientID for the ServiceNow account oauth.
        :param str client_secret: ClientSecret for the ServiceNow account oauth.
        :param str username: Username for ServiceNow account REST API.
        :param str password: Password for ServiceNow account REST API.
        :param str instance_name: Instance name for ServiceNow account.
        """
        # pylint: disable=super-init-not-called
        self.client_id = client_id
        self.client_secret = client_secret
        self.username = username
        self.password = password
        self.instance_name = instance_name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfServiceNowDestinationConfig':
        """Initialize a DestinationConfigOneOfServiceNowDestinationConfig object from a json dictionary."""
        args = {}
        if 'client_id' in _dict:
            args['client_id'] = _dict.get('client_id')
        else:
            raise ValueError('Required property \'client_id\' not present in DestinationConfigOneOfServiceNowDestinationConfig JSON')
        if 'client_secret' in _dict:
            args['client_secret'] = _dict.get('client_secret')
        else:
            raise ValueError('Required property \'client_secret\' not present in DestinationConfigOneOfServiceNowDestinationConfig JSON')
        if 'username' in _dict:
            args['username'] = _dict.get('username')
        else:
            raise ValueError('Required property \'username\' not present in DestinationConfigOneOfServiceNowDestinationConfig JSON')
        if 'password' in _dict:
            args['password'] = _dict.get('password')
        else:
            raise ValueError('Required property \'password\' not present in DestinationConfigOneOfServiceNowDestinationConfig JSON')
        if 'instance_name' in _dict:
            args['instance_name'] = _dict.get('instance_name')
        else:
            raise ValueError('Required property \'instance_name\' not present in DestinationConfigOneOfServiceNowDestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfServiceNowDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'client_id') and self.client_id is not None:
            _dict['client_id'] = self.client_id
        if hasattr(self, 'client_secret') and self.client_secret is not None:
            _dict['client_secret'] = self.client_secret
        if hasattr(self, 'username') and self.username is not None:
            _dict['username'] = self.username
        if hasattr(self, 'password') and self.password is not None:
            _dict['password'] = self.password
        if hasattr(self, 'instance_name') and self.instance_name is not None:
            _dict['instance_name'] = self.instance_name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfServiceNowDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfServiceNowDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfServiceNowDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfSlackDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a Slack destination configuration.

    :attr str url: URL of Slack Incoming Webhook.
    """

    def __init__(self,
                 url: str) -> None:
        """
        Initialize a DestinationConfigOneOfSlackDestinationConfig object.

        :param str url: URL of Slack Incoming Webhook.
        """
        # pylint: disable=super-init-not-called
        self.url = url

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfSlackDestinationConfig':
        """Initialize a DestinationConfigOneOfSlackDestinationConfig object from a json dictionary."""
        args = {}
        if 'url' in _dict:
            args['url'] = _dict.get('url')
        else:
            raise ValueError('Required property \'url\' not present in DestinationConfigOneOfSlackDestinationConfig JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfSlackDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfSlackDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfSlackDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfSlackDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class DestinationConfigOneOfWebhookDestinationConfig(DestinationConfigOneOf):
    """
    Payload describing a webhook destination configuration.

    :attr str url: URL of webhook.
    :attr str verb: HTTP method of webhook.
    :attr dict custom_headers: (optional) Custom headers (Key-Value pair) for
          webhook call.
    :attr List[str] sensitive_headers: (optional) List of sensitive headers from
          custom headers.
    """

    def __init__(self,
                 url: str,
                 verb: str,
                 *,
                 custom_headers: dict = None,
                 sensitive_headers: List[str] = None) -> None:
        """
        Initialize a DestinationConfigOneOfWebhookDestinationConfig object.

        :param str url: URL of webhook.
        :param str verb: HTTP method of webhook.
        :param dict custom_headers: (optional) Custom headers (Key-Value pair) for
               webhook call.
        :param List[str] sensitive_headers: (optional) List of sensitive headers
               from custom headers.
        """
        # pylint: disable=super-init-not-called
        self.url = url
        self.verb = verb
        self.custom_headers = custom_headers
        self.sensitive_headers = sensitive_headers

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'DestinationConfigOneOfWebhookDestinationConfig':
        """Initialize a DestinationConfigOneOfWebhookDestinationConfig object from a json dictionary."""
        args = {}
        if 'url' in _dict:
            args['url'] = _dict.get('url')
        else:
            raise ValueError('Required property \'url\' not present in DestinationConfigOneOfWebhookDestinationConfig JSON')
        if 'verb' in _dict:
            args['verb'] = _dict.get('verb')
        else:
            raise ValueError('Required property \'verb\' not present in DestinationConfigOneOfWebhookDestinationConfig JSON')
        if 'custom_headers' in _dict:
            args['custom_headers'] = _dict.get('custom_headers')
        if 'sensitive_headers' in _dict:
            args['sensitive_headers'] = _dict.get('sensitive_headers')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a DestinationConfigOneOfWebhookDestinationConfig object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'url') and self.url is not None:
            _dict['url'] = self.url
        if hasattr(self, 'verb') and self.verb is not None:
            _dict['verb'] = self.verb
        if hasattr(self, 'custom_headers') and self.custom_headers is not None:
            _dict['custom_headers'] = self.custom_headers
        if hasattr(self, 'sensitive_headers') and self.sensitive_headers is not None:
            _dict['sensitive_headers'] = self.sensitive_headers
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this DestinationConfigOneOfWebhookDestinationConfig object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'DestinationConfigOneOfWebhookDestinationConfig') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'DestinationConfigOneOfWebhookDestinationConfig') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

    class VerbEnum(str, Enum):
        """
        HTTP method of webhook.
        """
        GET = 'get'
        POST = 'post'


class SubscriptionAttributesEmailAttributesResponse(SubscriptionAttributes):
    """
    The attributes reponse for an email destination.

    :attr List[EmailAttributesResponseInvitedItems] invited: (optional) The email id
          string.
    :attr List[EmailAttributesResponseSubscribedUnsubscribedItems] subscribed:
          (optional) The unsubscribe list.
    :attr List[EmailAttributesResponseSubscribedUnsubscribedItems] unsubscribed:
          (optional) The subscribed list.
    :attr bool add_notification_payload: Whether to add the notification payload to
          the email.
    :attr str reply_to_mail: The email address to reply to.
    :attr str reply_to_name: The email name to reply to.
    :attr str from_name: The email name of From.
    """

    # The set of defined properties for the class
    _properties = frozenset(['invited', 'subscribed', 'unsubscribed', 'add_notification_payload', 'reply_to_mail', 'reply_to_name', 'from_name'])

    def __init__(self,
                 add_notification_payload: bool,
                 reply_to_mail: str,
                 reply_to_name: str,
                 from_name: str,
                 *,
                 invited: List['EmailAttributesResponseInvitedItems'] = None,
                 subscribed: List['EmailAttributesResponseSubscribedUnsubscribedItems'] = None,
                 unsubscribed: List['EmailAttributesResponseSubscribedUnsubscribedItems'] = None,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesEmailAttributesResponse object.

        :param bool add_notification_payload: Whether to add the notification
               payload to the email.
        :param str reply_to_mail: The email address to reply to.
        :param str reply_to_name: The email name to reply to.
        :param str from_name: The email name of From.
        :param List[EmailAttributesResponseInvitedItems] invited: (optional) The
               email id string.
        :param List[EmailAttributesResponseSubscribedUnsubscribedItems] subscribed:
               (optional) The unsubscribe list.
        :param List[EmailAttributesResponseSubscribedUnsubscribedItems]
               unsubscribed: (optional) The subscribed list.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.invited = invited
        self.subscribed = subscribed
        self.unsubscribed = unsubscribed
        self.add_notification_payload = add_notification_payload
        self.reply_to_mail = reply_to_mail
        self.reply_to_name = reply_to_name
        self.from_name = from_name
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesEmailAttributesResponse':
        """Initialize a SubscriptionAttributesEmailAttributesResponse object from a json dictionary."""
        args = {}
        if 'invited' in _dict:
            args['invited'] = [EmailAttributesResponseInvitedItems.from_dict(x) for x in _dict.get('invited')]
        if 'subscribed' in _dict:
            args['subscribed'] = [EmailAttributesResponseSubscribedUnsubscribedItems.from_dict(x) for x in _dict.get('subscribed')]
        if 'unsubscribed' in _dict:
            args['unsubscribed'] = [EmailAttributesResponseSubscribedUnsubscribedItems.from_dict(x) for x in _dict.get('unsubscribed')]
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionAttributesEmailAttributesResponse JSON')
        if 'reply_to_mail' in _dict:
            args['reply_to_mail'] = _dict.get('reply_to_mail')
        else:
            raise ValueError('Required property \'reply_to_mail\' not present in SubscriptionAttributesEmailAttributesResponse JSON')
        if 'reply_to_name' in _dict:
            args['reply_to_name'] = _dict.get('reply_to_name')
        else:
            raise ValueError('Required property \'reply_to_name\' not present in SubscriptionAttributesEmailAttributesResponse JSON')
        if 'from_name' in _dict:
            args['from_name'] = _dict.get('from_name')
        else:
            raise ValueError('Required property \'from_name\' not present in SubscriptionAttributesEmailAttributesResponse JSON')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesEmailAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = [x.to_dict() for x in self.invited]
        if hasattr(self, 'subscribed') and self.subscribed is not None:
            _dict['subscribed'] = [x.to_dict() for x in self.subscribed]
        if hasattr(self, 'unsubscribed') and self.unsubscribed is not None:
            _dict['unsubscribed'] = [x.to_dict() for x in self.unsubscribed]
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        if hasattr(self, 'reply_to_mail') and self.reply_to_mail is not None:
            _dict['reply_to_mail'] = self.reply_to_mail
        if hasattr(self, 'reply_to_name') and self.reply_to_name is not None:
            _dict['reply_to_name'] = self.reply_to_name
        if hasattr(self, 'from_name') and self.from_name is not None:
            _dict['from_name'] = self.from_name
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesEmailAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesEmailAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesEmailAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesEmailAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesEmailAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesEmailAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesEmailAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesEmailAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesEmailAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesSMSAttributesResponse(SubscriptionAttributes):
    """
    SMS attributes object.

    :attr List[SMSAttributesItems] subscribed: (optional) The subscribed list.
    :attr List[SMSAttributesItems] unsubscribed: (optional) The unsubscribe list.
    :attr List[SMSInviteAttributesItems] invited: (optional) The email id string.
    """

    # The set of defined properties for the class
    _properties = frozenset(['subscribed', 'unsubscribed', 'invited'])

    def __init__(self,
                 *,
                 subscribed: List['SMSAttributesItems'] = None,
                 unsubscribed: List['SMSAttributesItems'] = None,
                 invited: List['SMSInviteAttributesItems'] = None,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesSMSAttributesResponse object.

        :param List[SMSAttributesItems] subscribed: (optional) The subscribed list.
        :param List[SMSAttributesItems] unsubscribed: (optional) The unsubscribe
               list.
        :param List[SMSInviteAttributesItems] invited: (optional) The email id
               string.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.subscribed = subscribed
        self.unsubscribed = unsubscribed
        self.invited = invited
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesSMSAttributesResponse':
        """Initialize a SubscriptionAttributesSMSAttributesResponse object from a json dictionary."""
        args = {}
        if 'subscribed' in _dict:
            args['subscribed'] = [SMSAttributesItems.from_dict(x) for x in _dict.get('subscribed')]
        if 'unsubscribed' in _dict:
            args['unsubscribed'] = [SMSAttributesItems.from_dict(x) for x in _dict.get('unsubscribed')]
        if 'invited' in _dict:
            args['invited'] = [SMSInviteAttributesItems.from_dict(x) for x in _dict.get('invited')]
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesSMSAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'subscribed') and self.subscribed is not None:
            _dict['subscribed'] = [x.to_dict() for x in self.subscribed]
        if hasattr(self, 'unsubscribed') and self.unsubscribed is not None:
            _dict['unsubscribed'] = [x.to_dict() for x in self.unsubscribed]
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = [x.to_dict() for x in self.invited]
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSMSAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesSMSAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSMSAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesSMSAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSMSAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesSMSAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesSMSAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesSMSAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesSMSAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesServiceNowAttributesResponse(SubscriptionAttributes):
    """
    The attributes for a ServiceNow notification.

    :attr str assigned_to: (optional) Assigned name from ServiceNow account.
    :attr str assignment_group: (optional) Assigned group name from ServiceNow
          account.
    """

    # The set of defined properties for the class
    _properties = frozenset(['assigned_to', 'assignment_group'])

    def __init__(self,
                 *,
                 assigned_to: str = None,
                 assignment_group: str = None,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesServiceNowAttributesResponse object.

        :param str assigned_to: (optional) Assigned name from ServiceNow account.
        :param str assignment_group: (optional) Assigned group name from ServiceNow
               account.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.assigned_to = assigned_to
        self.assignment_group = assignment_group
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesServiceNowAttributesResponse':
        """Initialize a SubscriptionAttributesServiceNowAttributesResponse object from a json dictionary."""
        args = {}
        if 'assigned_to' in _dict:
            args['assigned_to'] = _dict.get('assigned_to')
        if 'assignment_group' in _dict:
            args['assignment_group'] = _dict.get('assignment_group')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesServiceNowAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'assigned_to') and self.assigned_to is not None:
            _dict['assigned_to'] = self.assigned_to
        if hasattr(self, 'assignment_group') and self.assignment_group is not None:
            _dict['assignment_group'] = self.assignment_group
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesServiceNowAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesServiceNowAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesServiceNowAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesServiceNowAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesServiceNowAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesServiceNowAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesServiceNowAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesServiceNowAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesServiceNowAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesSlackAttributesResponse(SubscriptionAttributes):
    """
    The attributes for a Slack notification.

    :attr str attachment_color: Attachment Color for Slack Notification.
    """

    # The set of defined properties for the class
    _properties = frozenset(['attachment_color'])

    def __init__(self,
                 attachment_color: str,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesSlackAttributesResponse object.

        :param str attachment_color: Attachment Color for Slack Notification.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.attachment_color = attachment_color
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesSlackAttributesResponse':
        """Initialize a SubscriptionAttributesSlackAttributesResponse object from a json dictionary."""
        args = {}
        if 'attachment_color' in _dict:
            args['attachment_color'] = _dict.get('attachment_color')
        else:
            raise ValueError('Required property \'attachment_color\' not present in SubscriptionAttributesSlackAttributesResponse JSON')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesSlackAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'attachment_color') and self.attachment_color is not None:
            _dict['attachment_color'] = self.attachment_color
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSlackAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesSlackAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSlackAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesSlackAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesSlackAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesSlackAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesSlackAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesSlackAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesSlackAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionAttributesWebhookAttributesResponse(SubscriptionAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    :attr bool add_notification_payload: Decision for Notification Payload to be
          added.
    """

    # The set of defined properties for the class
    _properties = frozenset(['signing_enabled', 'add_notification_payload'])

    def __init__(self,
                 signing_enabled: bool,
                 add_notification_payload: bool,
                 **kwargs) -> None:
        """
        Initialize a SubscriptionAttributesWebhookAttributesResponse object.

        :param bool signing_enabled: Signing webhook attributes.
        :param bool add_notification_payload: Decision for Notification Payload to
               be added.
        :param **kwargs: (optional) Any additional properties.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled
        self.add_notification_payload = add_notification_payload
        for _key, _value in kwargs.items():
            setattr(self, _key, _value)

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionAttributesWebhookAttributesResponse':
        """Initialize a SubscriptionAttributesWebhookAttributesResponse object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionAttributesWebhookAttributesResponse JSON')
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionAttributesWebhookAttributesResponse JSON')
        args.update({k:v for (k, v) in _dict.items() if k not in cls._properties})
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionAttributesWebhookAttributesResponse object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            if getattr(self, _key, None) is not None:
                _dict[_key] = getattr(self, _key)
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def get_properties(self) -> Dict:
        """Return a dictionary of arbitrary properties from this instance of SubscriptionAttributesWebhookAttributesResponse"""
        _dict = {}

        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            _dict[_key] = getattr(self, _key)
        return _dict

    def set_properties(self, _dict: dict):
        """Set a dictionary of arbitrary properties to this instance of SubscriptionAttributesWebhookAttributesResponse"""
        for _key in [k for k in vars(self).keys() if k not in SubscriptionAttributesWebhookAttributesResponse._properties]:
            delattr(self, _key)

        for _key, _value in _dict.items():
            if _key not in SubscriptionAttributesWebhookAttributesResponse._properties:
                setattr(self, _key, _value)

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionAttributesWebhookAttributesResponse object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionAttributesWebhookAttributesResponse') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionAttributesWebhookAttributesResponse') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesEmailAttributes(SubscriptionCreateAttributes):
    """
    The attributes for an email notification.

    :attr List[str] invited: The email id string.
    :attr bool add_notification_payload: Whether to add the notification payload to
          the email.
    :attr str reply_to_mail: The email address to reply to.
    :attr str reply_to_name: The email name to reply to.
    :attr str from_name: The email name of From.
    """

    def __init__(self,
                 invited: List[str],
                 add_notification_payload: bool,
                 reply_to_mail: str,
                 reply_to_name: str,
                 from_name: str) -> None:
        """
        Initialize a SubscriptionCreateAttributesEmailAttributes object.

        :param List[str] invited: The email id string.
        :param bool add_notification_payload: Whether to add the notification
               payload to the email.
        :param str reply_to_mail: The email address to reply to.
        :param str reply_to_name: The email name to reply to.
        :param str from_name: The email name of From.
        """
        # pylint: disable=super-init-not-called
        self.invited = invited
        self.add_notification_payload = add_notification_payload
        self.reply_to_mail = reply_to_mail
        self.reply_to_name = reply_to_name
        self.from_name = from_name

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesEmailAttributes':
        """Initialize a SubscriptionCreateAttributesEmailAttributes object from a json dictionary."""
        args = {}
        if 'invited' in _dict:
            args['invited'] = _dict.get('invited')
        else:
            raise ValueError('Required property \'invited\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'reply_to_mail' in _dict:
            args['reply_to_mail'] = _dict.get('reply_to_mail')
        else:
            raise ValueError('Required property \'reply_to_mail\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'reply_to_name' in _dict:
            args['reply_to_name'] = _dict.get('reply_to_name')
        else:
            raise ValueError('Required property \'reply_to_name\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        if 'from_name' in _dict:
            args['from_name'] = _dict.get('from_name')
        else:
            raise ValueError('Required property \'from_name\' not present in SubscriptionCreateAttributesEmailAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesEmailAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = self.invited
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        if hasattr(self, 'reply_to_mail') and self.reply_to_mail is not None:
            _dict['reply_to_mail'] = self.reply_to_mail
        if hasattr(self, 'reply_to_name') and self.reply_to_name is not None:
            _dict['reply_to_name'] = self.reply_to_name
        if hasattr(self, 'from_name') and self.from_name is not None:
            _dict['from_name'] = self.from_name
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesEmailAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesEmailAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesEmailAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesFCMAttributes(SubscriptionCreateAttributes):
    """
    The attributes for an FCM notification.

    """

    def __init__(self) -> None:
        """
        Initialize a SubscriptionCreateAttributesFCMAttributes object.

        """
        # pylint: disable=super-init-not-called

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesFCMAttributes':
        """Initialize a SubscriptionCreateAttributesFCMAttributes object from a json dictionary."""
        return cls(**_dict)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesFCMAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        return vars(self)

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesFCMAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesFCMAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesFCMAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesSMSAttributes(SubscriptionCreateAttributes):
    """
    The attributes for an sms notification.

    :attr List[str] invited: The sms id string.
    """

    def __init__(self,
                 invited: List[str]) -> None:
        """
        Initialize a SubscriptionCreateAttributesSMSAttributes object.

        :param List[str] invited: The sms id string.
        """
        # pylint: disable=super-init-not-called
        self.invited = invited

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesSMSAttributes':
        """Initialize a SubscriptionCreateAttributesSMSAttributes object from a json dictionary."""
        args = {}
        if 'invited' in _dict:
            args['invited'] = _dict.get('invited')
        else:
            raise ValueError('Required property \'invited\' not present in SubscriptionCreateAttributesSMSAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesSMSAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = self.invited
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesSMSAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesSMSAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesServiceNowAttributes(SubscriptionCreateAttributes):
    """
    The attributes for a ServiceNow notification.

    :attr str assigned_to: (optional) Name of user ServiceNow incident will be
          assigned to.
    :attr str assignment_group: (optional) Group Name to which incident will be
          assigned to.
    """

    def __init__(self,
                 *,
                 assigned_to: str = None,
                 assignment_group: str = None) -> None:
        """
        Initialize a SubscriptionCreateAttributesServiceNowAttributes object.

        :param str assigned_to: (optional) Name of user ServiceNow incident will be
               assigned to.
        :param str assignment_group: (optional) Group Name to which incident will
               be assigned to.
        """
        # pylint: disable=super-init-not-called
        self.assigned_to = assigned_to
        self.assignment_group = assignment_group

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesServiceNowAttributes':
        """Initialize a SubscriptionCreateAttributesServiceNowAttributes object from a json dictionary."""
        args = {}
        if 'assigned_to' in _dict:
            args['assigned_to'] = _dict.get('assigned_to')
        if 'assignment_group' in _dict:
            args['assignment_group'] = _dict.get('assignment_group')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesServiceNowAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'assigned_to') and self.assigned_to is not None:
            _dict['assigned_to'] = self.assigned_to
        if hasattr(self, 'assignment_group') and self.assignment_group is not None:
            _dict['assignment_group'] = self.assignment_group
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesServiceNowAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesServiceNowAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesServiceNowAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesSlackAttributes(SubscriptionCreateAttributes):
    """
    The attributes for a slack notification.

    :attr str attachment_color: Attachment Color for the slack message.
    """

    def __init__(self,
                 attachment_color: str) -> None:
        """
        Initialize a SubscriptionCreateAttributesSlackAttributes object.

        :param str attachment_color: Attachment Color for the slack message.
        """
        # pylint: disable=super-init-not-called
        self.attachment_color = attachment_color

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesSlackAttributes':
        """Initialize a SubscriptionCreateAttributesSlackAttributes object from a json dictionary."""
        args = {}
        if 'attachment_color' in _dict:
            args['attachment_color'] = _dict.get('attachment_color')
        else:
            raise ValueError('Required property \'attachment_color\' not present in SubscriptionCreateAttributesSlackAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesSlackAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'attachment_color') and self.attachment_color is not None:
            _dict['attachment_color'] = self.attachment_color
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesSlackAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesSlackAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesSlackAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionCreateAttributesWebhookAttributes(SubscriptionCreateAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    """

    def __init__(self,
                 signing_enabled: bool) -> None:
        """
        Initialize a SubscriptionCreateAttributesWebhookAttributes object.

        :param bool signing_enabled: Signing webhook attributes.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionCreateAttributesWebhookAttributes':
        """Initialize a SubscriptionCreateAttributesWebhookAttributes object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionCreateAttributesWebhookAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionCreateAttributesWebhookAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionCreateAttributesWebhookAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionCreateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionCreateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesEmailUpdateAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for an email notification.

    :attr UpdateAttributesInvited invited: (optional) The email ids or phone
          numbers.
    :attr bool add_notification_payload: Whether to add the notification payload to
          the email.
    :attr str reply_to_mail: The email address to reply to.
    :attr str reply_to_name: The email name to reply to.
    :attr str from_name: The email name of From.
    :attr UpdateAttributesSubscribed subscribed: (optional) The email ids or phone
          numbers.
    :attr UpdateAttributesUnsubscribed unsubscribed: (optional) The email ids or
          phone numbers.
    """

    def __init__(self,
                 add_notification_payload: bool,
                 reply_to_mail: str,
                 reply_to_name: str,
                 from_name: str,
                 *,
                 invited: 'UpdateAttributesInvited' = None,
                 subscribed: 'UpdateAttributesSubscribed' = None,
                 unsubscribed: 'UpdateAttributesUnsubscribed' = None) -> None:
        """
        Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object.

        :param bool add_notification_payload: Whether to add the notification
               payload to the email.
        :param str reply_to_mail: The email address to reply to.
        :param str reply_to_name: The email name to reply to.
        :param str from_name: The email name of From.
        :param UpdateAttributesInvited invited: (optional) The email ids or phone
               numbers.
        :param UpdateAttributesSubscribed subscribed: (optional) The email ids or
               phone numbers.
        :param UpdateAttributesUnsubscribed unsubscribed: (optional) The email ids
               or phone numbers.
        """
        # pylint: disable=super-init-not-called
        self.invited = invited
        self.add_notification_payload = add_notification_payload
        self.reply_to_mail = reply_to_mail
        self.reply_to_name = reply_to_name
        self.from_name = from_name
        self.subscribed = subscribed
        self.unsubscribed = unsubscribed

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesEmailUpdateAttributes':
        """Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object from a json dictionary."""
        args = {}
        if 'invited' in _dict:
            args['invited'] = UpdateAttributesInvited.from_dict(_dict.get('invited'))
        if 'add_notification_payload' in _dict:
            args['add_notification_payload'] = _dict.get('add_notification_payload')
        else:
            raise ValueError('Required property \'add_notification_payload\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'reply_to_mail' in _dict:
            args['reply_to_mail'] = _dict.get('reply_to_mail')
        else:
            raise ValueError('Required property \'reply_to_mail\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'reply_to_name' in _dict:
            args['reply_to_name'] = _dict.get('reply_to_name')
        else:
            raise ValueError('Required property \'reply_to_name\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'from_name' in _dict:
            args['from_name'] = _dict.get('from_name')
        else:
            raise ValueError('Required property \'from_name\' not present in SubscriptionUpdateAttributesEmailUpdateAttributes JSON')
        if 'subscribed' in _dict:
            args['subscribed'] = UpdateAttributesSubscribed.from_dict(_dict.get('subscribed'))
        if 'unsubscribed' in _dict:
            args['unsubscribed'] = UpdateAttributesUnsubscribed.from_dict(_dict.get('unsubscribed'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesEmailUpdateAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = self.invited.to_dict()
        if hasattr(self, 'add_notification_payload') and self.add_notification_payload is not None:
            _dict['add_notification_payload'] = self.add_notification_payload
        if hasattr(self, 'reply_to_mail') and self.reply_to_mail is not None:
            _dict['reply_to_mail'] = self.reply_to_mail
        if hasattr(self, 'reply_to_name') and self.reply_to_name is not None:
            _dict['reply_to_name'] = self.reply_to_name
        if hasattr(self, 'from_name') and self.from_name is not None:
            _dict['from_name'] = self.from_name
        if hasattr(self, 'subscribed') and self.subscribed is not None:
            _dict['subscribed'] = self.subscribed.to_dict()
        if hasattr(self, 'unsubscribed') and self.unsubscribed is not None:
            _dict['unsubscribed'] = self.unsubscribed.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesEmailUpdateAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesEmailUpdateAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesEmailUpdateAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesSMSUpdateAttributes(SubscriptionUpdateAttributes):
    """
    SMS attributes object.

    :attr UpdateAttributesInvited invited: (optional) The email ids or phone
          numbers.
    :attr UpdateAttributesSubscribed subscribed: (optional) The email ids or phone
          numbers.
    :attr UpdateAttributesUnsubscribed unsubscribed: (optional) The email ids or
          phone numbers.
    """

    def __init__(self,
                 *,
                 invited: 'UpdateAttributesInvited' = None,
                 subscribed: 'UpdateAttributesSubscribed' = None,
                 unsubscribed: 'UpdateAttributesUnsubscribed' = None) -> None:
        """
        Initialize a SubscriptionUpdateAttributesSMSUpdateAttributes object.

        :param UpdateAttributesInvited invited: (optional) The email ids or phone
               numbers.
        :param UpdateAttributesSubscribed subscribed: (optional) The email ids or
               phone numbers.
        :param UpdateAttributesUnsubscribed unsubscribed: (optional) The email ids
               or phone numbers.
        """
        # pylint: disable=super-init-not-called
        self.invited = invited
        self.subscribed = subscribed
        self.unsubscribed = unsubscribed

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesSMSUpdateAttributes':
        """Initialize a SubscriptionUpdateAttributesSMSUpdateAttributes object from a json dictionary."""
        args = {}
        if 'invited' in _dict:
            args['invited'] = UpdateAttributesInvited.from_dict(_dict.get('invited'))
        if 'subscribed' in _dict:
            args['subscribed'] = UpdateAttributesSubscribed.from_dict(_dict.get('subscribed'))
        if 'unsubscribed' in _dict:
            args['unsubscribed'] = UpdateAttributesUnsubscribed.from_dict(_dict.get('unsubscribed'))
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesSMSUpdateAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'invited') and self.invited is not None:
            _dict['invited'] = self.invited.to_dict()
        if hasattr(self, 'subscribed') and self.subscribed is not None:
            _dict['subscribed'] = self.subscribed.to_dict()
        if hasattr(self, 'unsubscribed') and self.unsubscribed is not None:
            _dict['unsubscribed'] = self.unsubscribed.to_dict()
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesSMSUpdateAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesSMSUpdateAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesSMSUpdateAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesServiceNowAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for a ServiceNow notification.

    :attr str assigned_to: (optional) Name of user ServiceNow incident will be
          assigned to.
    :attr str assignment_group: (optional) Group Name to which incident will be
          assigned to.
    """

    def __init__(self,
                 *,
                 assigned_to: str = None,
                 assignment_group: str = None) -> None:
        """
        Initialize a SubscriptionUpdateAttributesServiceNowAttributes object.

        :param str assigned_to: (optional) Name of user ServiceNow incident will be
               assigned to.
        :param str assignment_group: (optional) Group Name to which incident will
               be assigned to.
        """
        # pylint: disable=super-init-not-called
        self.assigned_to = assigned_to
        self.assignment_group = assignment_group

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesServiceNowAttributes':
        """Initialize a SubscriptionUpdateAttributesServiceNowAttributes object from a json dictionary."""
        args = {}
        if 'assigned_to' in _dict:
            args['assigned_to'] = _dict.get('assigned_to')
        if 'assignment_group' in _dict:
            args['assignment_group'] = _dict.get('assignment_group')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesServiceNowAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'assigned_to') and self.assigned_to is not None:
            _dict['assigned_to'] = self.assigned_to
        if hasattr(self, 'assignment_group') and self.assignment_group is not None:
            _dict['assignment_group'] = self.assignment_group
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesServiceNowAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesServiceNowAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesServiceNowAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesSlackAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for a slack notification.

    :attr str attachment_color: Attachment Color for the slack message.
    """

    def __init__(self,
                 attachment_color: str) -> None:
        """
        Initialize a SubscriptionUpdateAttributesSlackAttributes object.

        :param str attachment_color: Attachment Color for the slack message.
        """
        # pylint: disable=super-init-not-called
        self.attachment_color = attachment_color

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesSlackAttributes':
        """Initialize a SubscriptionUpdateAttributesSlackAttributes object from a json dictionary."""
        args = {}
        if 'attachment_color' in _dict:
            args['attachment_color'] = _dict.get('attachment_color')
        else:
            raise ValueError('Required property \'attachment_color\' not present in SubscriptionUpdateAttributesSlackAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesSlackAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'attachment_color') and self.attachment_color is not None:
            _dict['attachment_color'] = self.attachment_color
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesSlackAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesSlackAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesSlackAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

class SubscriptionUpdateAttributesWebhookAttributes(SubscriptionUpdateAttributes):
    """
    The attributes for a webhook notification.

    :attr bool signing_enabled: Signing webhook attributes.
    """

    def __init__(self,
                 signing_enabled: bool) -> None:
        """
        Initialize a SubscriptionUpdateAttributesWebhookAttributes object.

        :param bool signing_enabled: Signing webhook attributes.
        """
        # pylint: disable=super-init-not-called
        self.signing_enabled = signing_enabled

    @classmethod
    def from_dict(cls, _dict: Dict) -> 'SubscriptionUpdateAttributesWebhookAttributes':
        """Initialize a SubscriptionUpdateAttributesWebhookAttributes object from a json dictionary."""
        args = {}
        if 'signing_enabled' in _dict:
            args['signing_enabled'] = _dict.get('signing_enabled')
        else:
            raise ValueError('Required property \'signing_enabled\' not present in SubscriptionUpdateAttributesWebhookAttributes JSON')
        return cls(**args)

    @classmethod
    def _from_dict(cls, _dict):
        """Initialize a SubscriptionUpdateAttributesWebhookAttributes object from a json dictionary."""
        return cls.from_dict(_dict)

    def to_dict(self) -> Dict:
        """Return a json dictionary representing this model."""
        _dict = {}
        if hasattr(self, 'signing_enabled') and self.signing_enabled is not None:
            _dict['signing_enabled'] = self.signing_enabled
        return _dict

    def _to_dict(self):
        """Return a json dictionary representing this model."""
        return self.to_dict()

    def __str__(self) -> str:
        """Return a `str` version of this SubscriptionUpdateAttributesWebhookAttributes object."""
        return json.dumps(self.to_dict(), indent=2)

    def __eq__(self, other: 'SubscriptionUpdateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are equal, false otherwise."""
        if not isinstance(other, self.__class__):
            return False
        return self.__dict__ == other.__dict__

    def __ne__(self, other: 'SubscriptionUpdateAttributesWebhookAttributes') -> bool:
        """Return `true` when self and other are not equal, false otherwise."""
        return not self == other

##############################################################################
# Pagers
##############################################################################

class SourcesPager():
    """
    SourcesPager can be used to simplify the use of the "list_sources" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a SourcesPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of SourceListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_sources(
            instance_id=self._instance_id,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('sources')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of SourceListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results

class TopicsPager():
    """
    TopicsPager can be used to simplify the use of the "list_topics" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a TopicsPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of TopicsListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_topics(
            instance_id=self._instance_id,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('topics')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of TopicsListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results

class DestinationsPager():
    """
    DestinationsPager can be used to simplify the use of the "list_destinations" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a DestinationsPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of DestinationListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_destinations(
            instance_id=self._instance_id,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('destinations')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of DestinationListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results

class TagsSubscriptionPager():
    """
    TagsSubscriptionPager can be used to simplify the use of the "list_tags_subscription" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 id: str,
                 device_id: str = None,
                 user_id: str = None,
                 tag_name: str = None,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a TagsSubscriptionPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param str id: Unique identifier for Destination.
        :param str device_id: (optional) Device ID of the destination
               tagsubscription.
        :param str user_id: (optional) UserID of the destination.
        :param str tag_name: (optional) TagName of the subscription.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._id = id
        self._device_id = device_id
        self._user_id = user_id
        self._tag_name = tag_name
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of TagsSubscriptionListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_tags_subscription(
            instance_id=self._instance_id,
            id=self._id,
            device_id=self._device_id,
            user_id=self._user_id,
            tag_name=self._tag_name,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('tag_subscriptions')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of TagsSubscriptionListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results

class SubscriptionsPager():
    """
    SubscriptionsPager can be used to simplify the use of the "list_subscriptions" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a SubscriptionsPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of SubscriptionListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_subscriptions(
            instance_id=self._instance_id,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('subscriptions')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of SubscriptionListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results

class IntegrationsPager():
    """
    IntegrationsPager can be used to simplify the use of the "list_integrations" method.
    """

    def __init__(self,
                 *,
                 client: EventNotificationsV1,
                 instance_id: str,
                 limit: int = None,
                 search: str = None,
    ) -> None:
        """
        Initialize a IntegrationsPager object.
        :param str instance_id: Unique identifier for IBM Cloud Event Notifications
               instance.
        :param int limit: (optional) Page limit for paginated results.
        :param str search: (optional) Search string for filtering results.
        """
        self._has_next = True
        self._client = client
        self._page_context = { 'next': None }
        self._instance_id = instance_id
        self._limit = limit
        self._search = search

    def has_next(self) -> bool:
        """
        Returns true if there are potentially more results to be retrieved.
        """
        return self._has_next

    def get_next(self) -> List[dict]:
        """
        Returns the next page of results.
        :return: A List[dict], where each element is a dict that represents an instance of IntegrationListItem.
        :rtype: List[dict]
        """
        if not self.has_next():
            raise StopIteration(message='No more results available')

        result = self._client.list_integrations(
            instance_id=self._instance_id,
            limit=self._limit,
            search=self._search,
            offset=self._page_context.get('next'),
        ).get_result()

        next = None
        next_page_link = result.get('next')
        if next_page_link is not None:
            next = get_query_param(next_page_link.get('href'), 'offset')
        self._page_context['next'] = next
        if next is None:
            self._has_next = False

        return result.get('integrations')

    def get_all(self) -> List[dict]:
        """
        Returns all results by invoking get_next() repeatedly
        until all pages of results have been retrieved.
        :return: A List[dict], where each element is a dict that represents an instance of IntegrationListItem.
        :rtype: List[dict]
        """
        results = []
        while self.has_next():
            next_page = self.get_next()
            results.extend(next_page)
        return results
