"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentfulWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ContentfulWebhook extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const accessToken = typeof props.accessToken === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.accessToken) : props.accessToken;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '91f2075f-b950-4743-a66b-ee0f6febf50d',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'contentful-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::ContentfulWebhook',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        if (accessToken.grantRead) {
            accessToken.grantRead(handler);
        }
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::ContentfulWebhook',
            pascalCaseProperties: true,
            properties: {
                accessTokenString: accessToken.serialize(),
                spaceId: props.spaceId,
                name: props.name,
                url: props.url,
                topics: props.topics,
                logLevel: props.logLevel,
            },
        });
    }
}
exports.ContentfulWebhook = ContentfulWebhook;
_a = JSII_RTTI_SYMBOL_1;
ContentfulWebhook[_a] = { fqn: "@cloudcomponents/cdk-contentful-webhook.ContentfulWebhook", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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