# pyargon2

Simultaneously the simplest and most powerful implementation of Argon2 in Python.

## Installation 

```bash
pip install pyargon2
```

## Basic Usage

The hash function supports basic password hashing using the Argon2id variant and mandates password and salt strings. The resulting hash returned is hex encoded.

```python
from pyargon2 import hash

password = 'a strong password'
salt = 'a unique salt'
hex_encoded_hash = hash(password, salt)
```

## Advanced Usage

### Function Parameters

The hash function takes in the following parameters:

##### Positional

- **password** : A string representing a password.
- **salt** : A string representing a unique salt.

##### Keyword

- **pepper** : A secret string to fold into the hash of the password.
- **hash_len** : The length in bytes of the resulting hash.
- **time_cost** : The number of iterations to perform.
- **memory_cost** : The number of kibibytes in memory to utilise.
- **parallelism** : The number of independent computations chains (lanes) to run.
- **flags** : Flags to determine which fields are securely wiped.
- **variant** : Argon2 algorithm variant ('i', 'd', or 'id').
- **version** : Argon2 algorithm version number.
- **encoding** : Encoding for the returned hash type ('raw', 'hex' or 'b64').

### Function Exceptions

Exceptions generated by the underlying Argon2 hashing function are raised under the `Argon2Error` class which can be imported as follows:

```python
from pyargon2 import Argon2Error
```