# Generated by ariadne-codegen
# Source: ../../schema.graphql

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ExponentModels,
    ModelName,
    ReasoningLevel,
    ToolPermissionStatus,
    UseToolsMode,
)


class AttachmentInput(BaseModel):
    file_attachment: Optional["FileAttachmentInput"] = Field(
        alias="fileAttachment", default=None
    )
    url_attachment: Optional["URLAttachmentInput"] = Field(
        alias="urlAttachment", default=None
    )
    table_schema_attachment: Optional["TableSchemaAttachmentInput"] = Field(
        alias="tableSchemaAttachment", default=None
    )
    prompt_attachment: Optional["PromptAttachmentInput"] = Field(
        alias="promptAttachment", default=None
    )
    sql_attachment: Optional["SQLAttachmentInput"] = Field(
        alias="sqlAttachment", default=None
    )


class ChatConfig(BaseModel):
    chat_uuid: str = Field(alias="chatUuid")
    model: Optional[ModelName] = None
    exponent_model: Optional[ExponentModels] = Field(
        alias="exponentModel", default=None
    )
    use_tools_config: UseToolsMode = Field(
        alias="useToolsConfig", default=UseToolsMode.read_only
    )
    require_confirmation: Optional[bool] = Field(
        alias="requireConfirmation", default=False
    )
    read_only: Optional[bool] = Field(alias="readOnly", default=False)
    depth_limit: int = Field(alias="depthLimit", default=6)
    reasoning_level: ReasoningLevel = Field(
        alias="reasoningLevel", default=ReasoningLevel.LOW
    )
    enable_thinking: bool = Field(alias="enableThinking", default=False)
    internal_settings: Optional[Any] = Field(alias="internalSettings", default=None)


class ChatInput(BaseModel):
    prompt: Optional["Prompt"] = None
    client_sourced_event_uuid: Optional[str] = Field(
        alias="clientSourcedEventUuid", default=None
    )
    permission_status: Optional[ToolPermissionStatus] = Field(
        alias="permissionStatus", default=None
    )
    table_filter_config_uuid: Optional[str] = Field(
        alias="tableFilterConfigUuid", default=None
    )
    planning_required: Optional[bool] = Field(alias="planningRequired", default=None)
    timezone: Optional[str] = None


class FileAttachmentInput(BaseModel):
    file: "FileInput"
    content: str


class FileInput(BaseModel):
    file_path: str = Field(alias="filePath")
    working_directory: str = Field(alias="workingDirectory")


class Prompt(BaseModel):
    message: str
    attachments: List["AttachmentInput"]


class PromptAttachmentInput(BaseModel):
    prompt_name: str = Field(alias="promptName")
    prompt_content: str = Field(alias="promptContent")


class SQLAttachmentInput(BaseModel):
    query_content: str = Field(alias="queryContent")


class TableSchemaAttachmentInput(BaseModel):
    table_name: str = Field(alias="tableName")
    table_schema: Any = Field(alias="tableSchema")


class URLAttachmentInput(BaseModel):
    url: str
    content: str


AttachmentInput.model_rebuild()
ChatInput.model_rebuild()
FileAttachmentInput.model_rebuild()
Prompt.model_rebuild()
