# Generated by ariadne-codegen
# Source: exponent/core/graphql/operations

from typing import Any, Dict, Optional, Union

from .base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .chats import Chats
from .create_cloud_chat_from_repository import CreateCloudChatFromRepository
from .enable_cloud_repository import EnableCloudRepository
from .enums import SandboxProvider
from .github_repositories import GithubRepositories
from .halt_chat_stream import HaltChatStream
from .input_types import ChatConfig, ChatInput
from .rebuild_cloud_repository import RebuildCloudRepository
from .refresh_api_key import RefreshApiKey
from .report_sandbox_info import ReportSandboxInfo
from .set_login_complete import SetLoginComplete
from .start_chat_turn import StartChatTurn


def gql(q: str) -> str:
    return q


class IndentGraphQLClient(AsyncBaseClient):
    async def chats(self, **kwargs: Any) -> Chats:
        query = gql(
            """
            query Chats {
              chats {
                __typename
                ... on UnauthenticatedError {
                  message
                }
                ... on Chats {
                  chats {
                    id
                    chatUuid
                    name
                    subtitle
                    isShared
                    isStarted
                    updatedAt
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="Chats", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Chats.model_validate(data)

    async def create_cloud_chat_from_repository(
        self,
        repository_id: str,
        provider: Union[Optional[SandboxProvider], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CreateCloudChatFromRepository:
        query = gql(
            """
            mutation CreateCloudChatFromRepository($repositoryId: String!, $provider: SandboxProvider) {
              createCloudChat(repositoryId: $repositoryId, provider: $provider) {
                __typename
                ... on Chat {
                  chatUuid
                }
                ... on UnauthenticatedError {
                  message
                }
                ... on ChatNotFoundError {
                  message
                }
                ... on CloudConfigNotFoundError {
                  message
                }
                ... on GithubConfigNotFoundError {
                  message
                }
                ... on CloudSessionError {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "repositoryId": repository_id,
            "provider": provider,
        }
        response = await self.execute(
            query=query,
            operation_name="CreateCloudChatFromRepository",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateCloudChatFromRepository.model_validate(data)

    async def enable_cloud_repository(
        self, org_name: str, repo_name: str, **kwargs: Any
    ) -> EnableCloudRepository:
        query = gql(
            """
            mutation EnableCloudRepository($orgName: String!, $repoName: String!) {
              enableCloudRepository(orgName: $orgName, repoName: $repoName) {
                __typename
                ... on ContainerImages {
                  images {
                    buildRef
                    createdAt
                    updatedAt
                  }
                }
                ... on UnauthenticatedError {
                  message
                }
                ... on CloudConfigNotFoundError {
                  message
                }
                ... on GithubConfigNotFoundError {
                  message
                }
                ... on CloudSessionError {
                  message
                }
                ... on Error {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"orgName": org_name, "repoName": repo_name}
        response = await self.execute(
            query=query,
            operation_name="EnableCloudRepository",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return EnableCloudRepository.model_validate(data)

    async def github_repositories(self, **kwargs: Any) -> GithubRepositories:
        query = gql(
            """
            query GithubRepositories {
              githubRepositories {
                __typename
                ... on Repositories {
                  repositories {
                    id
                    githubOrgName
                    githubRepoName
                    createdAt
                    updatedAt
                  }
                }
                ... on Error {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="GithubRepositories",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GithubRepositories.model_validate(data)

    async def halt_chat_stream(self, chat_uuid: Any, **kwargs: Any) -> HaltChatStream:
        query = gql(
            """
            mutation HaltChatStream($chatUuid: UUID!) {
              haltChatStream(chatUuid: $chatUuid) {
                __typename
                ... on Chat {
                  chatUuid
                }
                ... on UnauthenticatedError {
                  message
                }
                ... on ChatNotFoundError {
                  message
                }
                ... on RemoteExecutionError {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"chatUuid": chat_uuid}
        response = await self.execute(
            query=query, operation_name="HaltChatStream", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return HaltChatStream.model_validate(data)

    async def rebuild_cloud_repository(
        self, org_name: str, repo_name: str, **kwargs: Any
    ) -> RebuildCloudRepository:
        query = gql(
            """
            mutation RebuildCloudRepository($orgName: String!, $repoName: String!) {
              rebuildCloudRepository(orgName: $orgName, repoName: $repoName) {
                __typename
                ... on ContainerImages {
                  images {
                    buildRef
                    createdAt
                    updatedAt
                  }
                }
                ... on UnauthenticatedError {
                  message
                }
                ... on CloudConfigNotFoundError {
                  message
                }
                ... on GithubConfigNotFoundError {
                  message
                }
                ... on CloudSessionError {
                  message
                }
                ... on Error {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"orgName": org_name, "repoName": repo_name}
        response = await self.execute(
            query=query,
            operation_name="RebuildCloudRepository",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RebuildCloudRepository.model_validate(data)

    async def refresh_api_key(self, **kwargs: Any) -> RefreshApiKey:
        query = gql(
            """
            mutation RefreshApiKey {
              refreshApiKey {
                __typename
                ... on User {
                  userApiKey
                }
                ... on UnauthenticatedError {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="RefreshApiKey", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return RefreshApiKey.model_validate(data)

    async def report_sandbox_info(
        self,
        sandbox_id: str,
        disk_usage_gb: Union[Optional[float], UnsetType] = UNSET,
        indent_log_file: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> ReportSandboxInfo:
        query = gql(
            """
            mutation ReportSandboxInfo($sandboxId: String!, $diskUsageGb: Float, $indentLogFile: String) {
              reportSandboxInfo(
                sandboxId: $sandboxId
                diskUsageGb: $diskUsageGb
                indentLogFile: $indentLogFile
              ) {
                __typename
                ... on SandboxInfoResponse {
                  success
                  message
                }
                ... on UnauthenticatedError {
                  message
                }
                ... on Error {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "sandboxId": sandbox_id,
            "diskUsageGb": disk_usage_gb,
            "indentLogFile": indent_log_file,
        }
        response = await self.execute(
            query=query,
            operation_name="ReportSandboxInfo",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return ReportSandboxInfo.model_validate(data)

    async def set_login_complete(self, **kwargs: Any) -> SetLoginComplete:
        query = gql(
            """
            mutation SetLoginComplete {
              setLoginComplete {
                __typename
                ... on User {
                  userApiKey
                }
                ... on UnauthenticatedError {
                  message
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query,
            operation_name="SetLoginComplete",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SetLoginComplete.model_validate(data)

    async def start_chat_turn(
        self,
        chat_input: ChatInput,
        chat_config: ChatConfig,
        parent_uuid: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> StartChatTurn:
        query = gql(
            """
            mutation StartChatTurn($chatInput: ChatInput!, $parentUuid: String, $chatConfig: ChatConfig!) {
              startChatReply(
                chatInput: $chatInput
                parentUuid: $parentUuid
                chatConfig: $chatConfig
              ) {
                __typename
                ... on UnauthenticatedError {
                  message
                }
                ... on ChatNotFoundError {
                  message
                }
                ... on Chat {
                  chatUuid
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "chatInput": chat_input,
            "parentUuid": parent_uuid,
            "chatConfig": chat_config,
        }
        response = await self.execute(
            query=query, operation_name="StartChatTurn", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return StartChatTurn.model_validate(data)
