
# * Licensed to the Apache Software Foundation (ASF) under one or more
# * contributor license agreements.  See the NOTICE file distributed with
# * this work for additional information regarding copyright ownership.
# * The ASF licenses this file to You under the Apache License, Version 2.0
# * (the "License"); you may not use this file except in compliance with
# * the License.  You may obtain a copy of the License at
# *
# *    http://www.apache.org/licenses/LICENSE-2.0
# *
# * Unless required by applicable law or agreed to in writing, software
# * distributed under the License is distributed on an "AS IS" BASIS,
# * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# * See the License for the specific language governing permissions and
# * limitations under the License.

echo "Building Disdat-KFP package locally"
rm -rf disdat_kfp.egg-info
rm -rf dist

python3 -m build


echo "upload to TestPyPi"
python3 -m twine upload --repository testpypi dist/*

echo "Create a new venv for testing"
rm -rf .testenv
python3 -m venv .testenv
source .testenv/bin/activate
pip install -i https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple disdat-kfp

python3 -c "
from  disdat_kfp.caching_wrapper import Caching
print('Test Done')"

deactivate
echo "Clean up testing env"
rm -rf .testenv


if false;  then
  echo "upload to PyPi for real!"
fi