# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03a_multi_core.torch_compat.ipynb (unless otherwise specified).

__all__ = ['TfmdTorchDS', 'to_list', 'has_setup', 'run_setups', 'TorchDatasetBuilder', 'VocabularyMapper',
           'make_torch_dataloaders', 'FileNamePatternLabeller']

# Internal Cell
from ..utils import xla_imported
from .base import *
from ..misc_utils import *


# Internal Cell
try:
    import torch_xla
except ImportError:
    pass

# Internal Cell
if xla_imported():
    import torch_xla.core.xla_model as xm
    import torch_xla.distributed.xla_multiprocessing as xmp

# Internal Cell
from fastcore.basics import patch_to
import torch
import torch.utils.data as th_data
from fastcore.foundation import L
from pathlib import Path
from fastcore.transform import Pipeline
from fastai.data.core import DataLoaders
from pathlib import Path
from fastai.torch_core import find_bs, TensorBase
from fastai.torch_core import TensorBase
from fastcore.xtras import is_listy
import torch.utils.hooks
import torch.utils.data.distributed as th_distrib

# Cell
class TfmdTorchDS(th_data.Dataset):
    "A torch dataset compatible holder for items with x and y transforms"
    def __init__(self, items, x_tfm=None, y_tfm=None):
        self.items = items
        self.x_tfm = x_tfm
        self.y_tfm = y_tfm

    def __len__(self):
        return len(self.items)

    def __getitem__(self, index):
        item = self.items[index]
        x = self.x_tfm(item) if self.x_tfm is not None else item
        y = self.y_tfm(item) if self.y_tfm is not None else item
        return (x,y)

# Internal Cell
import torchvision as thv
from operator import itemgetter
from fastcore.imports import noop

# Cell
def to_list(o):
    "return item o as a list (unchanged if o is already a list and empty list if o is None)"
    return [] if o is None else [o] if not is_listy(o) else o

def has_setup(tfms):
    """returns last index if at least 1 `tfm` in `tfms` has a method `setup` else return -1"""
    setups = L(tfms).attrgot('setup',None).argwhere(noop) # get indexes where tfm has `setup` attribute
    return -1 if len(setups) == 0 else setups[-1]

def run_setups(tfms, items):
    """run tfm setups including tfm for all items"""
    indx = has_setup(tfms)
    if indx == -1: # no setup found
        return

    for i,tfm in enumerate(tfms):
        if hasattr(tfm,'setup'):
            tfm.setup(items)
        if i < indx:
            # tfm items to be fed into next tfm
            items = [tfm(item) for item in items]

# Cell
class TorchDatasetBuilder:
    "build torch compatible train and test datasets with transforms"
    def __init__(self, source, get_items, splitter,
                x_tfms, y_tfms,
                x_type_tfms=None,
                x_train_tfms=None, x_test_tfms=None,
                do_setup=False):
        self.source = source
        self.get_items = get_items
        self.splitter = splitter
        self.do_setup = do_setup
        self.x_tfms = to_list(x_tfms)
        self.y_tfms = to_list(y_tfms)
        self.x_type_tfms = to_list(x_type_tfms)
        self.x_train_tfms = to_list(x_train_tfms)
        self.x_test_tfms = to_list(x_test_tfms)

    def setup(self, items, do_setup=None, setup_x=False):
        self.do_setup = do_setup if do_setup is not None else self.do_setup
        if self.do_setup:
            all_x_tfms = [*self.x_type_tfms, *self.x_train_tfms, *self.x_tfms]
            if setup_x:
                run_setups(all_x_tfms, items)
            run_setups(self.y_tfms, items)
            self.do_setup = False

    def get_datasets(self, do_setup=None):
        self.do_setup = do_setup if do_setup is not None else self.do_setup

        items = self.get_items(self.source) if self.get_items is not None else self.source

        train_idxs, test_idxs = self.splitter(items)

        train_items = itemgetter(*train_idxs)(items)
        test_items = itemgetter(*test_idxs)(items)
        self.setup(train_items)
        allx_test_tfms = [*self.x_type_tfms, *self.x_test_tfms, *self.x_tfms]
        allx_train_tfms = [*self.x_type_tfms, *self.x_train_tfms, *self.x_tfms]
        train_x_tfm = thv.transforms.Compose(allx_train_tfms)
        test_x_tfm = thv.transforms.Compose(allx_test_tfms)
        y_tfm = thv.transforms.Compose(self.y_tfms)
        train_ds = TfmdTorchDS(train_items, x_tfm=train_x_tfm, y_tfm=y_tfm)
        test_ds = TfmdTorchDS(test_items, x_tfm=test_x_tfm, y_tfm=y_tfm)
        return train_ds, test_ds

# Cell
from fastai.data.transforms import CategoryMap

class VocabularyMapper:
    """A simplified version of the fastai Categorize Transform"""
    def __init__(self, vocab=None):
        self.vocab = vocab
        self.c = 0
    def setup(self, items):
        self.vocab = CategoryMap(items)
        self.c = len(self.vocab)
    def __call__(self, o):
        if self.vocab is None: return o
        try:
            return torch.tensor(self.vocab.o2i[o])
        except KeyError as e:
            raise KeyError(f"Label '{o}' was not included in the training dataset") from e

# Cell
def make_torch_dataloaders(train_dataset, test_dataset,
                     rank,
                     world_size,
                     bs,
                     num_workers=4,
                     distrib=True,
                     sync_valid=False):
    "make torch-based distributed dataloaders from torch compatible datasets"
    if distrib:
        train_sampler = th_distrib.DistributedSampler(
            train_dataset,
            num_replicas=world_size,
            rank=rank,
            shuffle=True)
        train_loader = th_data.DataLoader(
            train_dataset,
            batch_size=bs,
            sampler=train_sampler,
            # shuffle=True,
            num_workers=num_workers,
            drop_last=True)

        if sync_valid:
            test_sampler = th_distrib.DistributedSampler(
                test_dataset,
                num_replicas=world_size,
                rank=rank,
                shuffle=False)

            test_loader = th_data.DataLoader(
                test_dataset,
                batch_size=bs,
                sampler=test_sampler,
                # shuffle=False,
                num_workers=num_workers,
                drop_last=True)
        else:
            test_loader = th_data.DataLoader(
                test_dataset,
                batch_size=bs,
                shuffle=False,
                num_workers=num_workers,
                drop_last=True)

    else:
        train_loader = th_data.DataLoader(
            train_dataset,
            batch_size=bs,
            # sampler=train_sampler,
            shuffle=True,
            num_workers=num_workers,
            drop_last=True)

        test_loader = th_data.DataLoader(
            test_dataset,
            batch_size=bs,
            shuffle=False,
            num_workers=num_workers,
            drop_last=True)
    dataloaders = DataLoaders(train_loader, test_loader, device=None)
    return dataloaders

# Internal Cell
import re

# Cell
class FileNamePatternLabeller:
    "Delayed action version of fastai RegexLabeller with file name selection"
    def __init__(self, pat_str, match=False):
        self.pat_str = pat_str
        self.match = match
        self.matcher = None
        self.pat = None
    def __call__(self, f):
        if isinstance(f,str):
            f = Path(f)
        o = f.name
        if self.pat is None:
            self.pat = re.compile(self.pat_str)
            self.matcher = self.pat.match if self.match else self.pat.search
        res  = self.matcher(o)
        assert res, f'Failed to find "{self.pat}" in {o}'
        return res.group(1)