from typing import Optional

from amqp import ConnectionError

class KombuError(Exception): ...
class OperationalError(KombuError): ...
class SerializationError(KombuError): ...
class EncodeError(SerializationError): ...
class DecodeError(SerializationError): ...
class NotBoundError(KombuError): ...
class MessageStateError(KombuError): ...
class LimitExceeded(KombuError): ...
class ConnectionLimitExceeded(LimitExceeded): ...
class ChannelLimitExceeded(LimitExceeded): ...
class VersionMismatch(KombuError): ...
class SerializerNotInstalled(KombuError): ...
class ContentDisallowed(SerializerNotInstalled): ...
class InconsistencyError(ConnectionError): ...

class HttpError(Exception):
    def __init__(
        self, code: int, message: Optional[str] = ..., response: Optional[object] = ...
    ) -> None: ...
