from collections import Mapping, MutableMapping, OrderedDict as _OrderedDict
from django.utils.functional import LazyObject
from typing import Any

class LazyObject: ...
LazySettings = LazyObject

def force_mapping(m: Any) -> Mapping: ...
def lpmerge(L: Mapping, R: Mapping) -> Mapping: ...

class OrderedDict(_OrderedDict):
    def move_to_end(self, key: Any, last: bool=...) -> None: ...
    def move_to_end(self, key: Any, last: bool=...) -> None: ...

class AttributeDictMixin:
    def __getattr__(self, k: str) -> Any: ...
    def __setattr__(self, key: str, value: Any) -> None: ...

class AttributeDict(dict, AttributeDictMixin): ...

class DictAttribute:
    obj: Any = ...
    def __init__(self, obj: Any) -> None: ...
    def __getattr__(self, key: Any) -> Any: ...
    def __setattr__(self, key: Any, value: Any) -> None: ...
    def get(self, key: Any, default: Any=...) -> Any: ...
    def setdefault(self, key: Any, default: Any=...) -> None: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> Any: ...
    def __contains__(self, key: Any) -> bool: ...
    iterkeys: Any = ...
    def __iter__(self) -> Iterable: ...
    iteritems: Any = ...
    itervalues: Any = ...
    items: Any = ...
    keys: Any = ...
    values: Any = ...

class ChainMap(MutableMapping):
    key_t: Any = ...
    changes: Any = ...
    defaults: Any = ...
    maps: Any = ...
    def __init__(self, *maps: Mapping, **kwargs: Any) -> None: ...
    def add_defaults(self, d: Mapping) -> None: ...
    def pop(self, key: Any, *default: Any) -> Any: ...
    def __missing__(self, key: Any) -> Any: ...
    def __getitem__(self, key: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any) -> None: ...
    def __delitem__(self, key: Any) -> None: ...
    def clear(self) -> None: ...
    def get(self, key: Any, default: Any=...) -> Any: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Any: ...
    def __contains__(self, key: Any) -> bool: ...
    def __bool__(self) -> bool: ...
    __nonzero__: Any = ...
    def setdefault(self, key: Any, default: Any=...) -> None: ...
    def update(self, *args: Any, **kwargs: Any) -> Any: ...
    @classmethod
    def fromkeys(cls: type, iterable: Iterable, *args: Any) -> ChainMap: ...
    def copy(self) -> ChainMap: ...
    __copy__: Any = ...
    iterkeys: Any = ...
    iteritems: Any = ...
    itervalues: Any = ...
    def bind_to(self, callback: Any) -> None: ...
    keys: Any = ...
    items: Any = ...
    values: Any = ...

class ConfigurationView(ChainMap, AttributeDictMixin):
    def __init__(self, changes: Mapping, defaults: Mapping=..., keys: List[str]=..., prefix: str=...) -> None: ...
    def __getitem__(self, key: str) -> Any: ...
    def __setitem__(self, key: str, value: Any) -> Any: ...
    def first(self, *keys: str) -> Any: ...
    def get(self, key: str, default: Any=...) -> Any: ...
    def clear(self) -> None: ...
    def __contains__(self, key: str) -> bool: ...
    def swap_with(self, other: ConfigurationView) -> None: ...

class LimitedSet:
    max_heap_percent_overload: int = ...
    maxlen: Any = ...
    minlen: Any = ...
    expires: Any = ...
    def __init__(self, maxlen: int=..., expires: float=..., data: Mapping=..., minlen: int=...) -> None: ...
    def clear(self) -> None: ...
    def add(self, item: Any, now: float=...) -> None: ...
    def update(self, other: Iterable) -> None: ...
    def discard(self, item: Any) -> None: ...
    pop_value: Any = ...
    def purge(self, now: float=...) -> None: ...
    def pop(self, default: Any=...) -> Any: ...
    def as_dict(self) -> Dict: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __iter__(self) -> Iterable: ...
    def __len__(self) -> int: ...
    def __contains__(self, key: Any) -> bool: ...
    def __reduce__(self) -> Any: ...
    def __bool__(self) -> bool: ...
    __nonzero__: Any = ...

class Evictable:
    Empty: Any = ...
    def evict(self) -> None: ...

class Messagebuffer(Evictable):
    Empty: Any = ...
    maxsize: Any = ...
    data: Any = ...
    def __init__(self, maxsize: int, iterable: Iterable=..., deque: Any=...) -> None: ...
    def put(self, item: Any) -> None: ...
    def extend(self, it: Iterable) -> None: ...
    def take(self, *default: Any) -> Any: ...
    def __iter__(self) -> Iterable: ...
    def __len__(self) -> int: ...
    def __contains__(self, item: Any): ...
    def __reversed__(self) -> Iterable: ...
    def __getitem__(self, index: Any) -> Any: ...

class BufferMap(OrderedDict, Evictable):
    Buffer: Any = ...
    Empty: Any = ...
    maxsize: Any = ...
    total: int = ...
    bufmaxsize: Any = ...
    def __init__(self, maxsize: int, iterable: Iterable=..., bufmaxsize: int=...) -> None: ...
    def put(self, key: Any, item: Any) -> None: ...
    def extend(self, key: Any, it: Iterable) -> None: ...
    def take(self, key: Any, *default: Any) -> Any: ...
