from collections import namedtuple
from typing import Any, Optional

schedstate = namedtuple('schedstate', ['is_due', 'next'])

class ParseException(Exception): ...

class BaseSchedule:
    nowfun: Any = ...
    def __init__(self, nowfun: Optional[Any] = ..., app: Optional[Any] = ...) -> None: ...
    def now(self): ...
    def remaining_estimate(self, last_run_at: Any) -> None: ...
    def is_due(self, last_run_at: Any) -> None: ...
    def maybe_make_aware(self, dt: Any): ...
    @property
    def app(self): ...
    @app.setter
    def app(self, app: Any) -> None: ...
    def tz(self): ...
    def utc_enabled(self): ...
    def to_local(self, dt: Any): ...
    def __eq__(self, other: Any) -> Any: ...

class schedule(BaseSchedule):
    relative: bool = ...
    run_every: Any = ...
    def __init__(self, run_every: Optional[Any] = ..., relative: bool = ..., nowfun: Optional[Any] = ..., app: Optional[Any] = ...) -> None: ...
    def remaining_estimate(self, last_run_at: Any): ...
    def is_due(self, last_run_at: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __reduce__(self): ...
    @property
    def seconds(self): ...
    @property
    def human_seconds(self): ...

class crontab_parser:
    ParseException: Any = ...
    max_: Any = ...
    min_: Any = ...
    pats: Any = ...
    def __init__(self, max_: int = ..., min_: int = ...) -> None: ...
    def parse(self, spec: Any): ...

class crontab(BaseSchedule):
    hour: Any = ...
    minute: Any = ...
    day_of_week: Any = ...
    day_of_month: Any = ...
    month_of_year: Any = ...
    def __init__(self, minute: str = ..., hour: str = ..., day_of_week: str = ..., day_of_month: str = ..., month_of_year: str = ..., **kwargs: Any) -> None: ...
    def __reduce__(self): ...
    def remaining_delta(self, last_run_at: Any, tz: Optional[Any] = ..., ffwd: Any = ...): ...
    def remaining_estimate(self, last_run_at: Any, ffwd: Any = ...): ...
    def is_due(self, last_run_at: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

def maybe_schedule(s: Any, relative: bool = ..., app: Optional[Any] = ...): ...

class solar(BaseSchedule):
    ephem: Any = ...
    event: Any = ...
    lat: Any = ...
    lon: Any = ...
    cal: Any = ...
    method: Any = ...
    use_center: Any = ...
    def __init__(self, event: Any, lat: Any, lon: Any, **kwargs: Any) -> None: ...
    def __reduce__(self): ...
    def remaining_estimate(self, last_run_at: Any): ...
    def is_due(self, last_run_at: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
