from typing import Any, Optional

class ResultBase:
    parent: Any = ...

class AsyncResult(ResultBase):
    app: Any = ...
    TimeoutError: Any = ...
    id: Any = ...
    backend: Any = ...
    parent: Any = ...
    on_ready: Any = ...
    def __init__(self, id: Any, backend: Optional[Any] = ..., task_name: Optional[Any] = ..., app: Optional[Any] = ..., parent: Optional[Any] = ...) -> None: ...
    @property
    def ignored(self): ...
    @ignored.setter
    def ignored(self, value: Any) -> None: ...
    def then(self, callback: Any, on_error: Optional[Any] = ..., weak: bool = ...): ...
    def as_tuple(self): ...
    def forget(self) -> None: ...
    def revoke(self, connection: Optional[Any] = ..., terminate: bool = ..., signal: Optional[Any] = ..., wait: bool = ..., timeout: Optional[Any] = ...) -> None: ...
    def get(self, timeout: Optional[Any] = ..., propagate: bool = ..., interval: float = ..., no_ack: bool = ..., follow_parents: bool = ..., callback: Optional[Any] = ..., on_message: Optional[Any] = ..., on_interval: Optional[Any] = ..., disable_sync_subtasks: bool = ..., EXCEPTION_STATES: Any = ..., PROPAGATE_STATES: Any = ...): ...
    wait: Any = ...
    def collect(self, intermediate: bool = ..., **kwargs: Any) -> None: ...
    def get_leaf(self): ...
    def iterdeps(self, intermediate: bool = ...) -> None: ...
    def ready(self): ...
    def successful(self): ...
    def failed(self): ...
    def throw(self, *args: Any, **kwargs: Any) -> None: ...
    def maybe_throw(self, propagate: bool = ..., callback: Optional[Any] = ...): ...
    maybe_reraise: Any = ...
    def build_graph(self, intermediate: bool = ..., formatter: Optional[Any] = ...): ...
    def __hash__(self) -> Any: ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __copy__(self): ...
    def __reduce__(self): ...
    def __reduce_args__(self): ...
    def __del__(self) -> None: ...
    def graph(self): ...
    @property
    def supports_native_join(self): ...
    @property
    def children(self): ...
    @property
    def result(self): ...
    info: Any = ...
    @property
    def traceback(self): ...
    @property
    def state(self): ...
    status: Any = ...
    @property
    def task_id(self): ...
    @task_id.setter
    def task_id(self, id: Any) -> None: ...
    @property
    def name(self): ...
    @property
    def args(self): ...
    @property
    def kwargs(self): ...
    @property
    def worker(self): ...
    @property
    def date_done(self): ...
    @property
    def retries(self): ...
    @property
    def queue(self): ...

class ResultSet(ResultBase):
    results: Any = ...
    on_ready: Any = ...
    def __init__(self, results: Any, app: Optional[Any] = ..., ready_barrier: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def add(self, result: Any) -> None: ...
    def remove(self, result: Any) -> None: ...
    def discard(self, result: Any) -> None: ...
    def update(self, results: Any) -> None: ...
    def clear(self) -> None: ...
    def successful(self): ...
    def failed(self): ...
    def maybe_throw(self, callback: Optional[Any] = ..., propagate: bool = ...) -> None: ...
    maybe_reraise: Any = ...
    def waiting(self): ...
    def ready(self): ...
    def completed_count(self): ...
    def forget(self) -> None: ...
    def revoke(self, connection: Optional[Any] = ..., terminate: bool = ..., signal: Optional[Any] = ..., wait: bool = ..., timeout: Optional[Any] = ...) -> None: ...
    def __iter__(self) -> Any: ...
    def __getitem__(self, index: Any): ...
    def iterate(self, timeout: Optional[Any] = ..., propagate: bool = ..., interval: float = ...) -> None: ...
    def get(self, timeout: Optional[Any] = ..., propagate: bool = ..., interval: float = ..., callback: Optional[Any] = ..., no_ack: bool = ..., on_message: Optional[Any] = ..., disable_sync_subtasks: bool = ..., on_interval: Optional[Any] = ...): ...
    def join(self, timeout: Optional[Any] = ..., propagate: bool = ..., interval: float = ..., callback: Optional[Any] = ..., no_ack: bool = ..., on_message: Optional[Any] = ..., disable_sync_subtasks: bool = ..., on_interval: Optional[Any] = ...): ...
    def then(self, callback: Any, on_error: Optional[Any] = ..., weak: bool = ...): ...
    def iter_native(self, timeout: Optional[Any] = ..., interval: float = ..., no_ack: bool = ..., on_message: Optional[Any] = ..., on_interval: Optional[Any] = ...): ...
    def join_native(self, timeout: Optional[Any] = ..., propagate: bool = ..., interval: float = ..., callback: Optional[Any] = ..., no_ack: bool = ..., on_message: Optional[Any] = ..., on_interval: Optional[Any] = ..., disable_sync_subtasks: bool = ...): ...
    def __len__(self): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    @property
    def supports_native_join(self): ...
    @property
    def app(self): ...
    @app.setter
    def app(self, app: Any) -> None: ...
    @property
    def backend(self): ...

class GroupResult(ResultSet):
    id: Any = ...
    results: Any = ...
    parent: Any = ...
    def __init__(self, id: Optional[Any] = ..., results: Optional[Any] = ..., parent: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def save(self, backend: Optional[Any] = ...): ...
    def delete(self, backend: Optional[Any] = ...) -> None: ...
    def __reduce__(self): ...
    def __reduce_args__(self): ...
    def __bool__(self): ...
    __nonzero__: Any = ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...
    def __hash__(self) -> Any: ...
    def as_tuple(self): ...
    @property
    def children(self): ...
    @classmethod
    def restore(cls, id: Any, backend: Optional[Any] = ..., app: Optional[Any] = ...): ...

class EagerResult(AsyncResult):
    id: Any = ...
    on_ready: Any = ...
    def __init__(self, id: Any, ret_value: Any, state: Any, traceback: Optional[Any] = ...) -> None: ...
    def then(self, callback: Any, on_error: Optional[Any] = ..., weak: bool = ...): ...
    def __reduce__(self): ...
    def __reduce_args__(self): ...
    def __copy__(self): ...
    def ready(self): ...
    def get(self, timeout: Optional[Any] = ..., propagate: bool = ..., disable_sync_subtasks: bool = ..., **kwargs: Any): ...
    wait: Any = ...
    def forget(self) -> None: ...
    def revoke(self, *args: Any, **kwargs: Any) -> None: ...
    @property
    def result(self): ...
    @property
    def state(self): ...
    status: Any = ...
    @property
    def traceback(self): ...
    @property
    def supports_native_join(self): ...

def result_from_tuple(r: Any, app: Optional[Any] = ...): ...
