from billiard.exceptions import SoftTimeLimitExceeded as SoftTimeLimitExceeded, Terminated as Terminated, TimeLimitExceeded as TimeLimitExceeded, WorkerLostError as WorkerLostError
from kombu.exceptions import OperationalError as OperationalError
from typing import Any, Optional

class CeleryWarning(UserWarning): ...
class AlwaysEagerIgnored(CeleryWarning): ...
class DuplicateNodenameWarning(CeleryWarning): ...
class FixupWarning(CeleryWarning): ...
class NotConfigured(CeleryWarning): ...
class CeleryError(Exception): ...
class TaskPredicate(CeleryError): ...

class Retry(TaskPredicate):
    message: Any = ...
    exc: Any = ...
    when: Any = ...
    def __init__(self, message: Optional[Any] = ..., exc: Optional[Any] = ..., when: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def humanize(self): ...
    def __reduce__(self): ...
RetryTaskError = Retry

class Ignore(TaskPredicate): ...

class Reject(TaskPredicate):
    reason: Any = ...
    requeue: Any = ...
    def __init__(self, reason: Optional[Any] = ..., requeue: bool = ...) -> None: ...

class ImproperlyConfigured(CeleryError): ...
class SecurityError(CeleryError): ...
class TaskError(CeleryError): ...
class QueueNotFound(KeyError, TaskError): ...
class IncompleteStream(TaskError): ...
class NotRegistered(KeyError, TaskError): ...
class AlreadyRegistered(TaskError): ...
class TimeoutError(TaskError): ...

class MaxRetriesExceededError(TaskError):
    task_args: Any = ...
    task_kwargs: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...

class TaskRevokedError(TaskError): ...
class InvalidTaskError(TaskError): ...
class ChordError(TaskError): ...
class CPendingDeprecationWarning(PendingDeprecationWarning): ...
class CDeprecationWarning(DeprecationWarning): ...
class WorkerTerminate(SystemExit): ...
SystemTerminate = WorkerTerminate

class WorkerShutdown(SystemExit): ...
