from collections import defaultdict
from typing import Any, Optional

class CallableDefaultdict(defaultdict):
    fun: Any = ...
    def __init__(self, fun: Any, *args: Any, **kwargs: Any) -> None: ...
    def __call__(self, *args: Any, **kwargs: Any): ...

def heartbeat_expires(timestamp: Any, freq: int = ..., expire_window: Any = ..., Decimal: Any = ..., float: Any = ..., isinstance: Any = ...): ...

class Worker:
    heartbeat_max: int = ...
    expire_window: Any = ...
    hostname: Any = ...
    pid: Any = ...
    freq: Any = ...
    heartbeats: Any = ...
    clock: Any = ...
    active: Any = ...
    processed: Any = ...
    loadavg: Any = ...
    sw_ident: Any = ...
    sw_ver: Any = ...
    sw_sys: Any = ...
    event: Any = ...
    def __init__(self, hostname: Optional[Any] = ..., pid: Optional[Any] = ..., freq: int = ..., heartbeats: Optional[Any] = ..., clock: int = ..., active: Optional[Any] = ..., processed: Optional[Any] = ..., loadavg: Optional[Any] = ..., sw_ident: Optional[Any] = ..., sw_ver: Optional[Any] = ..., sw_sys: Optional[Any] = ...) -> None: ...
    def __reduce__(self): ...
    def update(self, f: Any, **kw: Any) -> None: ...
    @property
    def status_string(self): ...
    @property
    def heartbeat_expires(self): ...
    @property
    def alive(self, nowfun: Any = ...): ...
    @property
    def id(self): ...

class Task:
    name: Any = ...
    received: Any = ...
    sent: Any = ...
    started: Any = ...
    succeeded: Any = ...
    failed: Any = ...
    retried: Any = ...
    revoked: Any = ...
    rejected: Any = ...
    args: Any = ...
    kwargs: Any = ...
    eta: Any = ...
    expires: Any = ...
    retries: Any = ...
    worker: Any = ...
    result: Any = ...
    exception: Any = ...
    timestamp: Any = ...
    runtime: Any = ...
    traceback: Any = ...
    exchange: Any = ...
    routing_key: Any = ...
    root_id: Any = ...
    parent_id: Any = ...
    client: Any = ...
    state: Any = ...
    clock: int = ...
    merge_rules: Any = ...
    uuid: Any = ...
    cluster_state: Any = ...
    children: Any = ...
    def __init__(self, uuid: Optional[Any] = ..., cluster_state: Optional[Any] = ..., children: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def event(self, type_: Any, timestamp: Optional[Any] = ..., local_received: Optional[Any] = ..., fields: Optional[Any] = ..., precedence: Any = ..., items: Any = ..., setattr: Any = ..., task_event_to_state: Any = ..., RETRY: Any = ...) -> None: ...
    def info(self, fields: Optional[Any] = ..., extra: Optional[Any] = ...): ...
    def as_dict(self): ...
    def __reduce__(self): ...
    @property
    def id(self): ...
    @property
    def origin(self): ...
    @property
    def ready(self): ...
    def parent(self): ...
    def root(self): ...

class State:
    Worker: Any = ...
    Task: Any = ...
    event_count: int = ...
    task_count: int = ...
    heap_multiplier: int = ...
    event_callback: Any = ...
    workers: Any = ...
    tasks: Any = ...
    max_workers_in_memory: Any = ...
    max_tasks_in_memory: Any = ...
    on_node_join: Any = ...
    on_node_leave: Any = ...
    handlers: Any = ...
    tasks_by_type: Any = ...
    tasks_by_worker: Any = ...
    def __init__(self, callback: Optional[Any] = ..., workers: Optional[Any] = ..., tasks: Optional[Any] = ..., taskheap: Optional[Any] = ..., max_workers_in_memory: int = ..., max_tasks_in_memory: int = ..., on_node_join: Optional[Any] = ..., on_node_leave: Optional[Any] = ..., tasks_by_type: Optional[Any] = ..., tasks_by_worker: Optional[Any] = ...) -> None: ...
    def freeze_while(self, fun: Any, *args: Any, **kwargs: Any): ...
    def clear_tasks(self, ready: bool = ...): ...
    def clear(self, ready: bool = ...): ...
    def get_or_create_worker(self, hostname: Any, **kwargs: Any): ...
    def get_or_create_task(self, uuid: Any): ...
    def event(self, event: Any): ...
    def task_event(self, type_: Any, fields: Any): ...
    def worker_event(self, type_: Any, fields: Any): ...
    def rebuild_taskheap(self, timetuple: Any = ...) -> None: ...
    def itertasks(self, limit: Optional[Any] = ...) -> None: ...
    def tasks_by_time(self, limit: Optional[Any] = ..., reverse: bool = ...) -> None: ...
    tasks_by_timestamp: Any = ...
    def task_types(self): ...
    def alive_workers(self): ...
    def __reduce__(self): ...
