from .utils.graph import GraphFormatter
from typing import Any, Optional

class StepFormatter(GraphFormatter):
    blueprint_prefix: str = ...
    conditional_prefix: str = ...
    blueprint_scheme: Any = ...
    def label(self, step: Any): ...
    def node(self, obj: Any, **attrs: Any): ...
    def edge(self, a: Any, b: Any, **attrs: Any): ...

class Blueprint:
    GraphFormatter: Any = ...
    name: Any = ...
    state: Any = ...
    started: int = ...
    default_steps: Any = ...
    state_to_name: Any = ...
    types: Any = ...
    on_start: Any = ...
    on_close: Any = ...
    on_stopped: Any = ...
    shutdown_complete: Any = ...
    steps: Any = ...
    def __init__(self, steps: Optional[Any] = ..., name: Optional[Any] = ..., on_start: Optional[Any] = ..., on_close: Optional[Any] = ..., on_stopped: Optional[Any] = ...) -> None: ...
    def start(self, parent: Any) -> None: ...
    def human_state(self): ...
    def info(self, parent: Any): ...
    def close(self, parent: Any) -> None: ...
    def restart(self, parent: Any, method: str = ..., description: str = ..., propagate: bool = ...) -> None: ...
    def send_all(self, parent: Any, method: Any, description: Optional[Any] = ..., reverse: bool = ..., propagate: bool = ..., args: Any = ...) -> None: ...
    def stop(self, parent: Any, close: bool = ..., terminate: bool = ...) -> None: ...
    def join(self, timeout: Optional[Any] = ...) -> None: ...
    def apply(self, parent: Any, **kwargs: Any): ...
    def connect_with(self, other: Any) -> None: ...
    def __getitem__(self, name: Any): ...
    def claim_steps(self): ...
    def load_step(self, step: Any): ...
    @property
    def alias(self): ...

class StepType(type):
    name: Any = ...
    requires: Any = ...
    def __new__(cls, name: Any, bases: Any, attrs: Any): ...

class Step:
    name: Any = ...
    label: Any = ...
    conditional: bool = ...
    requires: Any = ...
    last: bool = ...
    enabled: bool = ...
    def __init__(self, parent: Any, **kwargs: Any) -> None: ...
    def include_if(self, parent: Any): ...
    def instantiate(self, name: Any, *args: Any, **kwargs: Any): ...
    def include(self, parent: Any): ...
    def create(self, parent: Any) -> None: ...
    @property
    def alias(self): ...
    def info(self, obj: Any) -> None: ...

class StartStopStep(Step):
    obj: Any = ...
    def start(self, parent: Any): ...
    def stop(self, parent: Any): ...
    def close(self, parent: Any) -> None: ...
    def terminate(self, parent: Any): ...
    def include(self, parent: Any): ...

class ConsumerStep(StartStopStep):
    requires: Any = ...
    consumers: Any = ...
    def get_consumers(self, channel: Any) -> None: ...
    def start(self, c: Any) -> None: ...
    def stop(self, c: Any) -> None: ...
    def shutdown(self, c: Any) -> None: ...
