from billiard.context import Process
from collections import namedtuple
from threading import Thread
from typing import Any, Optional

event_t = namedtuple('event_t', ['time', 'priority', 'entry'])

class SchedulingError(Exception): ...

class BeatLazyFunc:
    def __init__(self, func: Any, *args: Any, **kwargs: Any) -> None: ...
    def __call__(self): ...
    def delay(self): ...

class ScheduleEntry:
    name: Any = ...
    schedule: Any = ...
    args: Any = ...
    kwargs: Any = ...
    options: Any = ...
    last_run_at: Any = ...
    total_run_count: int = ...
    app: Any = ...
    task: Any = ...
    def __init__(self, name: Optional[Any] = ..., task: Optional[Any] = ..., last_run_at: Optional[Any] = ..., total_run_count: Optional[Any] = ..., schedule: Optional[Any] = ..., args: Any = ..., kwargs: Optional[Any] = ..., options: Optional[Any] = ..., relative: bool = ..., app: Optional[Any] = ...) -> None: ...
    def default_now(self): ...
    __next__: Any = ...
    next: Any = ...
    def __reduce__(self): ...
    def update(self, other: Any) -> None: ...
    def is_due(self): ...
    def __iter__(self) -> Any: ...
    def __lt__(self, other: Any) -> Any: ...
    def editable_fields_equal(self, other: Any): ...
    def __eq__(self, other: Any) -> Any: ...
    def __ne__(self, other: Any) -> Any: ...

class Scheduler:
    Entry: Any = ...
    schedule: Any = ...
    max_interval: Any = ...
    sync_every: Any = ...
    sync_every_tasks: Any = ...
    logger: Any = ...
    app: Any = ...
    data: Any = ...
    Producer: Any = ...
    old_schedulers: Any = ...
    def __init__(self, app: Any, schedule: Optional[Any] = ..., max_interval: Optional[Any] = ..., Producer: Optional[Any] = ..., lazy: bool = ..., sync_every_tasks: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def install_default_entries(self, data: Any) -> None: ...
    def apply_entry(self, entry: Any, producer: Optional[Any] = ...) -> None: ...
    def adjust(self, n: Any, drift: Any = ...): ...
    def is_due(self, entry: Any): ...
    def populate_heap(self, event_t: Any = ..., heapify: Any = ...) -> None: ...
    def tick(self, event_t: Any = ..., min: Any = ..., heappop: Any = ..., heappush: Any = ...): ...
    def schedules_equal(self, old_schedules: Any, new_schedules: Any): ...
    def should_sync(self): ...
    def reserve(self, entry: Any): ...
    def apply_async(self, entry: Any, producer: Optional[Any] = ..., advance: bool = ..., **kwargs: Any): ...
    def send_task(self, *args: Any, **kwargs: Any): ...
    def setup_schedule(self) -> None: ...
    def sync(self) -> None: ...
    def close(self) -> None: ...
    def add(self, **kwargs: Any): ...
    def update_from_dict(self, dict_: Any) -> None: ...
    def merge_inplace(self, b: Any) -> None: ...
    def get_schedule(self): ...
    def set_schedule(self, schedule: Any) -> None: ...
    def connection(self): ...
    def producer(self): ...
    @property
    def info(self): ...

class PersistentScheduler(Scheduler):
    persistence: Any = ...
    known_suffixes: Any = ...
    schedule_filename: Any = ...
    def __init__(self, *args: Any, **kwargs: Any) -> None: ...
    def setup_schedule(self) -> None: ...
    def get_schedule(self): ...
    def set_schedule(self, schedule: Any) -> None: ...
    schedule: Any = ...
    def sync(self) -> None: ...
    def close(self) -> None: ...
    @property
    def info(self): ...

class Service:
    scheduler_cls: Any = ...
    app: Any = ...
    max_interval: Any = ...
    schedule_filename: Any = ...
    def __init__(self, app: Any, max_interval: Optional[Any] = ..., schedule_filename: Optional[Any] = ..., scheduler_cls: Optional[Any] = ...) -> None: ...
    def __reduce__(self): ...
    def start(self, embedded_process: bool = ...) -> None: ...
    def sync(self) -> None: ...
    def stop(self, wait: bool = ...) -> None: ...
    def get_scheduler(self, lazy: bool = ..., extension_namespace: str = ...): ...
    def scheduler(self): ...

class _Threaded(Thread):
    app: Any = ...
    service: Any = ...
    daemon: bool = ...
    name: str = ...
    def __init__(self, app: Any, **kwargs: Any) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...

class _Process(Process):
    app: Any = ...
    service: Any = ...
    name: str = ...
    def __init__(self, app: Any, **kwargs: Any) -> None: ...
    def run(self) -> None: ...
    def stop(self) -> None: ...

def EmbeddedService(app: Any, max_interval: Optional[Any] = ..., **kwargs: Any): ...
