"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUserPoolUserToGroupAttachment = exports.CfnUserPoolUser = exports.CfnUserPoolUICustomizationAttachment = exports.CfnUserPoolRiskConfigurationAttachment = exports.CfnUserPoolResourceServer = exports.CfnUserPoolIdentityProvider = exports.CfnUserPoolGroup = exports.CfnUserPoolDomain = exports.CfnUserPoolClient = exports.CfnUserPool = exports.CfnIdentityPoolRoleAttachment = exports.CfnIdentityPool = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-04-22T08:42:11.196Z","fingerprint":"5uOlavhaCwo2RWRapCsvtzbyU0dcI2Dgc7tZG/uglCs="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnIdentityPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowClassicFlow', cdk.validateBoolean)(properties.allowClassicFlow));
    errors.collect(cdk.propertyValidator('allowUnauthenticatedIdentities', cdk.requiredValidator)(properties.allowUnauthenticatedIdentities));
    errors.collect(cdk.propertyValidator('allowUnauthenticatedIdentities', cdk.validateBoolean)(properties.allowUnauthenticatedIdentities));
    errors.collect(cdk.propertyValidator('cognitoEvents', cdk.validateObject)(properties.cognitoEvents));
    errors.collect(cdk.propertyValidator('cognitoIdentityProviders', cdk.listValidator(CfnIdentityPool_CognitoIdentityProviderPropertyValidator))(properties.cognitoIdentityProviders));
    errors.collect(cdk.propertyValidator('cognitoStreams', CfnIdentityPool_CognitoStreamsPropertyValidator)(properties.cognitoStreams));
    errors.collect(cdk.propertyValidator('developerProviderName', cdk.validateString)(properties.developerProviderName));
    errors.collect(cdk.propertyValidator('identityPoolName', cdk.validateString)(properties.identityPoolName));
    errors.collect(cdk.propertyValidator('openIdConnectProviderArns', cdk.listValidator(cdk.validateString))(properties.openIdConnectProviderArns));
    errors.collect(cdk.propertyValidator('pushSync', CfnIdentityPool_PushSyncPropertyValidator)(properties.pushSync));
    errors.collect(cdk.propertyValidator('samlProviderArns', cdk.listValidator(cdk.validateString))(properties.samlProviderArns));
    errors.collect(cdk.propertyValidator('supportedLoginProviders', cdk.validateObject)(properties.supportedLoginProviders));
    return errors.wrap('supplied properties not correct for "CfnIdentityPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolPropsValidator(properties).assertSuccess();
    return {
        AllowUnauthenticatedIdentities: cdk.booleanToCloudFormation(properties.allowUnauthenticatedIdentities),
        AllowClassicFlow: cdk.booleanToCloudFormation(properties.allowClassicFlow),
        CognitoEvents: cdk.objectToCloudFormation(properties.cognitoEvents),
        CognitoIdentityProviders: cdk.listMapper(cfnIdentityPoolCognitoIdentityProviderPropertyToCloudFormation)(properties.cognitoIdentityProviders),
        CognitoStreams: cfnIdentityPoolCognitoStreamsPropertyToCloudFormation(properties.cognitoStreams),
        DeveloperProviderName: cdk.stringToCloudFormation(properties.developerProviderName),
        IdentityPoolName: cdk.stringToCloudFormation(properties.identityPoolName),
        OpenIdConnectProviderARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.openIdConnectProviderArns),
        PushSync: cfnIdentityPoolPushSyncPropertyToCloudFormation(properties.pushSync),
        SamlProviderARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.samlProviderArns),
        SupportedLoginProviders: cdk.objectToCloudFormation(properties.supportedLoginProviders),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowUnauthenticatedIdentities', 'AllowUnauthenticatedIdentities', cfn_parse.FromCloudFormation.getBoolean(properties.AllowUnauthenticatedIdentities));
    ret.addPropertyResult('allowClassicFlow', 'AllowClassicFlow', properties.AllowClassicFlow != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowClassicFlow) : undefined);
    ret.addPropertyResult('cognitoEvents', 'CognitoEvents', properties.CognitoEvents != null ? cfn_parse.FromCloudFormation.getAny(properties.CognitoEvents) : undefined);
    ret.addPropertyResult('cognitoIdentityProviders', 'CognitoIdentityProviders', properties.CognitoIdentityProviders != null ? cfn_parse.FromCloudFormation.getArray(CfnIdentityPoolCognitoIdentityProviderPropertyFromCloudFormation)(properties.CognitoIdentityProviders) : undefined);
    ret.addPropertyResult('cognitoStreams', 'CognitoStreams', properties.CognitoStreams != null ? CfnIdentityPoolCognitoStreamsPropertyFromCloudFormation(properties.CognitoStreams) : undefined);
    ret.addPropertyResult('developerProviderName', 'DeveloperProviderName', properties.DeveloperProviderName != null ? cfn_parse.FromCloudFormation.getString(properties.DeveloperProviderName) : undefined);
    ret.addPropertyResult('identityPoolName', 'IdentityPoolName', properties.IdentityPoolName != null ? cfn_parse.FromCloudFormation.getString(properties.IdentityPoolName) : undefined);
    ret.addPropertyResult('openIdConnectProviderArns', 'OpenIdConnectProviderARNs', properties.OpenIdConnectProviderARNs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.OpenIdConnectProviderARNs) : undefined);
    ret.addPropertyResult('pushSync', 'PushSync', properties.PushSync != null ? CfnIdentityPoolPushSyncPropertyFromCloudFormation(properties.PushSync) : undefined);
    ret.addPropertyResult('samlProviderArns', 'SamlProviderARNs', properties.SamlProviderARNs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SamlProviderARNs) : undefined);
    ret.addPropertyResult('supportedLoginProviders', 'SupportedLoginProviders', properties.SupportedLoginProviders != null ? cfn_parse.FromCloudFormation.getAny(properties.SupportedLoginProviders) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPool`
 *
 * The `AWS::Cognito::IdentityPool` resource creates an Amazon Cognito identity pool.
 *
 * To avoid deleting the resource accidentally from AWS CloudFormation , use [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) and the [UpdateReplacePolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html) to retain the resource on deletion or replacement.
 *
 * @cloudformationResource AWS::Cognito::IdentityPool
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html
 */
class CfnIdentityPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::IdentityPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIdentityPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnIdentityPoolProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'allowUnauthenticatedIdentities', this);
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.allowUnauthenticatedIdentities = props.allowUnauthenticatedIdentities;
        this.allowClassicFlow = props.allowClassicFlow;
        this.cognitoEvents = props.cognitoEvents;
        this.cognitoIdentityProviders = props.cognitoIdentityProviders;
        this.cognitoStreams = props.cognitoStreams;
        this.developerProviderName = props.developerProviderName;
        this.identityPoolName = props.identityPoolName;
        this.openIdConnectProviderArns = props.openIdConnectProviderArns;
        this.pushSync = props.pushSync;
        this.samlProviderArns = props.samlProviderArns;
        this.supportedLoginProviders = props.supportedLoginProviders;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnIdentityPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnIdentityPool(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIdentityPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            allowUnauthenticatedIdentities: this.allowUnauthenticatedIdentities,
            allowClassicFlow: this.allowClassicFlow,
            cognitoEvents: this.cognitoEvents,
            cognitoIdentityProviders: this.cognitoIdentityProviders,
            cognitoStreams: this.cognitoStreams,
            developerProviderName: this.developerProviderName,
            identityPoolName: this.identityPoolName,
            openIdConnectProviderArns: this.openIdConnectProviderArns,
            pushSync: this.pushSync,
            samlProviderArns: this.samlProviderArns,
            supportedLoginProviders: this.supportedLoginProviders,
        };
    }
    renderProperties(props) {
        return cfnIdentityPoolPropsToCloudFormation(props);
    }
}
exports.CfnIdentityPool = CfnIdentityPool;
_a = JSII_RTTI_SYMBOL_1;
CfnIdentityPool[_a] = { fqn: "@aws-cdk/aws-cognito.CfnIdentityPool", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIdentityPool.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPool";
/**
 * Determine whether the given properties match those of a `CognitoIdentityProviderProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoIdentityProviderProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_CognitoIdentityProviderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('providerName', cdk.validateString)(properties.providerName));
    errors.collect(cdk.propertyValidator('serverSideTokenCheck', cdk.validateBoolean)(properties.serverSideTokenCheck));
    return errors.wrap('supplied properties not correct for "CognitoIdentityProviderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoIdentityProvider` resource
 *
 * @param properties - the TypeScript properties of a `CognitoIdentityProviderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoIdentityProvider` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolCognitoIdentityProviderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_CognitoIdentityProviderPropertyValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        ProviderName: cdk.stringToCloudFormation(properties.providerName),
        ServerSideTokenCheck: cdk.booleanToCloudFormation(properties.serverSideTokenCheck),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolCognitoIdentityProviderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientId', 'ClientId', properties.ClientId != null ? cfn_parse.FromCloudFormation.getString(properties.ClientId) : undefined);
    ret.addPropertyResult('providerName', 'ProviderName', properties.ProviderName != null ? cfn_parse.FromCloudFormation.getString(properties.ProviderName) : undefined);
    ret.addPropertyResult('serverSideTokenCheck', 'ServerSideTokenCheck', properties.ServerSideTokenCheck != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ServerSideTokenCheck) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CognitoStreamsProperty`
 *
 * @param properties - the TypeScript properties of a `CognitoStreamsProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_CognitoStreamsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('streamName', cdk.validateString)(properties.streamName));
    errors.collect(cdk.propertyValidator('streamingStatus', cdk.validateString)(properties.streamingStatus));
    return errors.wrap('supplied properties not correct for "CognitoStreamsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoStreams` resource
 *
 * @param properties - the TypeScript properties of a `CognitoStreamsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.CognitoStreams` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolCognitoStreamsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_CognitoStreamsPropertyValidator(properties).assertSuccess();
    return {
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        StreamName: cdk.stringToCloudFormation(properties.streamName),
        StreamingStatus: cdk.stringToCloudFormation(properties.streamingStatus),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolCognitoStreamsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addPropertyResult('streamName', 'StreamName', properties.StreamName != null ? cfn_parse.FromCloudFormation.getString(properties.StreamName) : undefined);
    ret.addPropertyResult('streamingStatus', 'StreamingStatus', properties.StreamingStatus != null ? cfn_parse.FromCloudFormation.getString(properties.StreamingStatus) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PushSyncProperty`
 *
 * @param properties - the TypeScript properties of a `PushSyncProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPool_PushSyncPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('applicationArns', cdk.listValidator(cdk.validateString))(properties.applicationArns));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "PushSyncProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.PushSync` resource
 *
 * @param properties - the TypeScript properties of a `PushSyncProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPool.PushSync` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolPushSyncPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPool_PushSyncPropertyValidator(properties).assertSuccess();
    return {
        ApplicationArns: cdk.listMapper(cdk.stringToCloudFormation)(properties.applicationArns),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolPushSyncPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('applicationArns', 'ApplicationArns', properties.ApplicationArns != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ApplicationArns) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.requiredValidator)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('identityPoolId', cdk.validateString)(properties.identityPoolId));
    errors.collect(cdk.propertyValidator('roleMappings', cdk.hashValidator(CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator))(properties.roleMappings));
    errors.collect(cdk.propertyValidator('roles', cdk.validateObject)(properties.roles));
    return errors.wrap('supplied properties not correct for "CfnIdentityPoolRoleAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnIdentityPoolRoleAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachmentPropsValidator(properties).assertSuccess();
    return {
        IdentityPoolId: cdk.stringToCloudFormation(properties.identityPoolId),
        RoleMappings: cdk.hashMapper(cfnIdentityPoolRoleAttachmentRoleMappingPropertyToCloudFormation)(properties.roleMappings),
        Roles: cdk.objectToCloudFormation(properties.roles),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('identityPoolId', 'IdentityPoolId', cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId));
    ret.addPropertyResult('roleMappings', 'RoleMappings', properties.RoleMappings != null ? cfn_parse.FromCloudFormation.getMap(CfnIdentityPoolRoleAttachmentRoleMappingPropertyFromCloudFormation)(properties.RoleMappings) : undefined);
    ret.addPropertyResult('roles', 'Roles', properties.Roles != null ? cfn_parse.FromCloudFormation.getAny(properties.Roles) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`
 *
 * The `AWS::Cognito::IdentityPoolRoleAttachment` resource manages the role configuration for an Amazon Cognito identity pool.
 *
 * @cloudformationResource AWS::Cognito::IdentityPoolRoleAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html
 */
class CfnIdentityPoolRoleAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::IdentityPoolRoleAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnIdentityPoolRoleAttachmentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'identityPoolId', this);
        this.identityPoolId = props.identityPoolId;
        this.roleMappings = props.roleMappings;
        this.roles = props.roles;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnIdentityPoolRoleAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnIdentityPoolRoleAttachment(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            identityPoolId: this.identityPoolId,
            roleMappings: this.roleMappings,
            roles: this.roles,
        };
    }
    renderProperties(props) {
        return cfnIdentityPoolRoleAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnIdentityPoolRoleAttachment = CfnIdentityPoolRoleAttachment;
_b = JSII_RTTI_SYMBOL_1;
CfnIdentityPoolRoleAttachment[_b] = { fqn: "@aws-cdk/aws-cognito.CfnIdentityPoolRoleAttachment", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnIdentityPoolRoleAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::IdentityPoolRoleAttachment";
/**
 * Determine whether the given properties match those of a `MappingRuleProperty`
 *
 * @param properties - the TypeScript properties of a `MappingRuleProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('claim', cdk.requiredValidator)(properties.claim));
    errors.collect(cdk.propertyValidator('claim', cdk.validateString)(properties.claim));
    errors.collect(cdk.propertyValidator('matchType', cdk.requiredValidator)(properties.matchType));
    errors.collect(cdk.propertyValidator('matchType', cdk.validateString)(properties.matchType));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MappingRuleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.MappingRule` resource
 *
 * @param properties - the TypeScript properties of a `MappingRuleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.MappingRule` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentMappingRulePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator(properties).assertSuccess();
    return {
        Claim: cdk.stringToCloudFormation(properties.claim),
        MatchType: cdk.stringToCloudFormation(properties.matchType),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentMappingRulePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('claim', 'Claim', cfn_parse.FromCloudFormation.getString(properties.Claim));
    ret.addPropertyResult('matchType', 'MatchType', cfn_parse.FromCloudFormation.getString(properties.MatchType));
    ret.addPropertyResult('roleArn', 'RoleARN', cfn_parse.FromCloudFormation.getString(properties.RoleARN));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RoleMappingProperty`
 *
 * @param properties - the TypeScript properties of a `RoleMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('ambiguousRoleResolution', cdk.validateString)(properties.ambiguousRoleResolution));
    errors.collect(cdk.propertyValidator('identityProvider', cdk.validateString)(properties.identityProvider));
    errors.collect(cdk.propertyValidator('rulesConfiguration', CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator)(properties.rulesConfiguration));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "RoleMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping` resource
 *
 * @param properties - the TypeScript properties of a `RoleMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RoleMapping` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentRoleMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_RoleMappingPropertyValidator(properties).assertSuccess();
    return {
        AmbiguousRoleResolution: cdk.stringToCloudFormation(properties.ambiguousRoleResolution),
        IdentityProvider: cdk.stringToCloudFormation(properties.identityProvider),
        RulesConfiguration: cfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyToCloudFormation(properties.rulesConfiguration),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentRoleMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('ambiguousRoleResolution', 'AmbiguousRoleResolution', properties.AmbiguousRoleResolution != null ? cfn_parse.FromCloudFormation.getString(properties.AmbiguousRoleResolution) : undefined);
    ret.addPropertyResult('identityProvider', 'IdentityProvider', properties.IdentityProvider != null ? cfn_parse.FromCloudFormation.getString(properties.IdentityProvider) : undefined);
    ret.addPropertyResult('rulesConfiguration', 'RulesConfiguration', properties.RulesConfiguration != null ? CfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyFromCloudFormation(properties.RulesConfiguration) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RulesConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `RulesConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('rules', cdk.requiredValidator)(properties.rules));
    errors.collect(cdk.propertyValidator('rules', cdk.listValidator(CfnIdentityPoolRoleAttachment_MappingRulePropertyValidator))(properties.rules));
    return errors.wrap('supplied properties not correct for "RulesConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `RulesConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::IdentityPoolRoleAttachment.RulesConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnIdentityPoolRoleAttachment_RulesConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Rules: cdk.listMapper(cfnIdentityPoolRoleAttachmentMappingRulePropertyToCloudFormation)(properties.rules),
    };
}
// @ts-ignore TS6133
function CfnIdentityPoolRoleAttachmentRulesConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('rules', 'Rules', cfn_parse.FromCloudFormation.getArray(CfnIdentityPoolRoleAttachmentMappingRulePropertyFromCloudFormation)(properties.Rules));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accountRecoverySetting', CfnUserPool_AccountRecoverySettingPropertyValidator)(properties.accountRecoverySetting));
    errors.collect(cdk.propertyValidator('adminCreateUserConfig', CfnUserPool_AdminCreateUserConfigPropertyValidator)(properties.adminCreateUserConfig));
    errors.collect(cdk.propertyValidator('aliasAttributes', cdk.listValidator(cdk.validateString))(properties.aliasAttributes));
    errors.collect(cdk.propertyValidator('autoVerifiedAttributes', cdk.listValidator(cdk.validateString))(properties.autoVerifiedAttributes));
    errors.collect(cdk.propertyValidator('deviceConfiguration', CfnUserPool_DeviceConfigurationPropertyValidator)(properties.deviceConfiguration));
    errors.collect(cdk.propertyValidator('emailConfiguration', CfnUserPool_EmailConfigurationPropertyValidator)(properties.emailConfiguration));
    errors.collect(cdk.propertyValidator('emailVerificationMessage', cdk.validateString)(properties.emailVerificationMessage));
    errors.collect(cdk.propertyValidator('emailVerificationSubject', cdk.validateString)(properties.emailVerificationSubject));
    errors.collect(cdk.propertyValidator('enabledMfas', cdk.listValidator(cdk.validateString))(properties.enabledMfas));
    errors.collect(cdk.propertyValidator('lambdaConfig', CfnUserPool_LambdaConfigPropertyValidator)(properties.lambdaConfig));
    errors.collect(cdk.propertyValidator('mfaConfiguration', cdk.validateString)(properties.mfaConfiguration));
    errors.collect(cdk.propertyValidator('policies', CfnUserPool_PoliciesPropertyValidator)(properties.policies));
    errors.collect(cdk.propertyValidator('schema', cdk.listValidator(CfnUserPool_SchemaAttributePropertyValidator))(properties.schema));
    errors.collect(cdk.propertyValidator('smsAuthenticationMessage', cdk.validateString)(properties.smsAuthenticationMessage));
    errors.collect(cdk.propertyValidator('smsConfiguration', CfnUserPool_SmsConfigurationPropertyValidator)(properties.smsConfiguration));
    errors.collect(cdk.propertyValidator('smsVerificationMessage', cdk.validateString)(properties.smsVerificationMessage));
    errors.collect(cdk.propertyValidator('userPoolAddOns', CfnUserPool_UserPoolAddOnsPropertyValidator)(properties.userPoolAddOns));
    errors.collect(cdk.propertyValidator('userPoolName', cdk.validateString)(properties.userPoolName));
    errors.collect(cdk.propertyValidator('userPoolTags', cdk.validateObject)(properties.userPoolTags));
    errors.collect(cdk.propertyValidator('usernameAttributes', cdk.listValidator(cdk.validateString))(properties.usernameAttributes));
    errors.collect(cdk.propertyValidator('usernameConfiguration', CfnUserPool_UsernameConfigurationPropertyValidator)(properties.usernameConfiguration));
    errors.collect(cdk.propertyValidator('verificationMessageTemplate', CfnUserPool_VerificationMessageTemplatePropertyValidator)(properties.verificationMessageTemplate));
    return errors.wrap('supplied properties not correct for "CfnUserPoolProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolPropsValidator(properties).assertSuccess();
    return {
        AccountRecoverySetting: cfnUserPoolAccountRecoverySettingPropertyToCloudFormation(properties.accountRecoverySetting),
        AdminCreateUserConfig: cfnUserPoolAdminCreateUserConfigPropertyToCloudFormation(properties.adminCreateUserConfig),
        AliasAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.aliasAttributes),
        AutoVerifiedAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.autoVerifiedAttributes),
        DeviceConfiguration: cfnUserPoolDeviceConfigurationPropertyToCloudFormation(properties.deviceConfiguration),
        EmailConfiguration: cfnUserPoolEmailConfigurationPropertyToCloudFormation(properties.emailConfiguration),
        EmailVerificationMessage: cdk.stringToCloudFormation(properties.emailVerificationMessage),
        EmailVerificationSubject: cdk.stringToCloudFormation(properties.emailVerificationSubject),
        EnabledMfas: cdk.listMapper(cdk.stringToCloudFormation)(properties.enabledMfas),
        LambdaConfig: cfnUserPoolLambdaConfigPropertyToCloudFormation(properties.lambdaConfig),
        MfaConfiguration: cdk.stringToCloudFormation(properties.mfaConfiguration),
        Policies: cfnUserPoolPoliciesPropertyToCloudFormation(properties.policies),
        Schema: cdk.listMapper(cfnUserPoolSchemaAttributePropertyToCloudFormation)(properties.schema),
        SmsAuthenticationMessage: cdk.stringToCloudFormation(properties.smsAuthenticationMessage),
        SmsConfiguration: cfnUserPoolSmsConfigurationPropertyToCloudFormation(properties.smsConfiguration),
        SmsVerificationMessage: cdk.stringToCloudFormation(properties.smsVerificationMessage),
        UsernameAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.usernameAttributes),
        UsernameConfiguration: cfnUserPoolUsernameConfigurationPropertyToCloudFormation(properties.usernameConfiguration),
        UserPoolAddOns: cfnUserPoolUserPoolAddOnsPropertyToCloudFormation(properties.userPoolAddOns),
        UserPoolName: cdk.stringToCloudFormation(properties.userPoolName),
        UserPoolTags: cdk.objectToCloudFormation(properties.userPoolTags),
        VerificationMessageTemplate: cfnUserPoolVerificationMessageTemplatePropertyToCloudFormation(properties.verificationMessageTemplate),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accountRecoverySetting', 'AccountRecoverySetting', properties.AccountRecoverySetting != null ? CfnUserPoolAccountRecoverySettingPropertyFromCloudFormation(properties.AccountRecoverySetting) : undefined);
    ret.addPropertyResult('adminCreateUserConfig', 'AdminCreateUserConfig', properties.AdminCreateUserConfig != null ? CfnUserPoolAdminCreateUserConfigPropertyFromCloudFormation(properties.AdminCreateUserConfig) : undefined);
    ret.addPropertyResult('aliasAttributes', 'AliasAttributes', properties.AliasAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AliasAttributes) : undefined);
    ret.addPropertyResult('autoVerifiedAttributes', 'AutoVerifiedAttributes', properties.AutoVerifiedAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AutoVerifiedAttributes) : undefined);
    ret.addPropertyResult('deviceConfiguration', 'DeviceConfiguration', properties.DeviceConfiguration != null ? CfnUserPoolDeviceConfigurationPropertyFromCloudFormation(properties.DeviceConfiguration) : undefined);
    ret.addPropertyResult('emailConfiguration', 'EmailConfiguration', properties.EmailConfiguration != null ? CfnUserPoolEmailConfigurationPropertyFromCloudFormation(properties.EmailConfiguration) : undefined);
    ret.addPropertyResult('emailVerificationMessage', 'EmailVerificationMessage', properties.EmailVerificationMessage != null ? cfn_parse.FromCloudFormation.getString(properties.EmailVerificationMessage) : undefined);
    ret.addPropertyResult('emailVerificationSubject', 'EmailVerificationSubject', properties.EmailVerificationSubject != null ? cfn_parse.FromCloudFormation.getString(properties.EmailVerificationSubject) : undefined);
    ret.addPropertyResult('enabledMfas', 'EnabledMfas', properties.EnabledMfas != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnabledMfas) : undefined);
    ret.addPropertyResult('lambdaConfig', 'LambdaConfig', properties.LambdaConfig != null ? CfnUserPoolLambdaConfigPropertyFromCloudFormation(properties.LambdaConfig) : undefined);
    ret.addPropertyResult('mfaConfiguration', 'MfaConfiguration', properties.MfaConfiguration != null ? cfn_parse.FromCloudFormation.getString(properties.MfaConfiguration) : undefined);
    ret.addPropertyResult('policies', 'Policies', properties.Policies != null ? CfnUserPoolPoliciesPropertyFromCloudFormation(properties.Policies) : undefined);
    ret.addPropertyResult('schema', 'Schema', properties.Schema != null ? cfn_parse.FromCloudFormation.getArray(CfnUserPoolSchemaAttributePropertyFromCloudFormation)(properties.Schema) : undefined);
    ret.addPropertyResult('smsAuthenticationMessage', 'SmsAuthenticationMessage', properties.SmsAuthenticationMessage != null ? cfn_parse.FromCloudFormation.getString(properties.SmsAuthenticationMessage) : undefined);
    ret.addPropertyResult('smsConfiguration', 'SmsConfiguration', properties.SmsConfiguration != null ? CfnUserPoolSmsConfigurationPropertyFromCloudFormation(properties.SmsConfiguration) : undefined);
    ret.addPropertyResult('smsVerificationMessage', 'SmsVerificationMessage', properties.SmsVerificationMessage != null ? cfn_parse.FromCloudFormation.getString(properties.SmsVerificationMessage) : undefined);
    ret.addPropertyResult('usernameAttributes', 'UsernameAttributes', properties.UsernameAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.UsernameAttributes) : undefined);
    ret.addPropertyResult('usernameConfiguration', 'UsernameConfiguration', properties.UsernameConfiguration != null ? CfnUserPoolUsernameConfigurationPropertyFromCloudFormation(properties.UsernameConfiguration) : undefined);
    ret.addPropertyResult('userPoolAddOns', 'UserPoolAddOns', properties.UserPoolAddOns != null ? CfnUserPoolUserPoolAddOnsPropertyFromCloudFormation(properties.UserPoolAddOns) : undefined);
    ret.addPropertyResult('userPoolName', 'UserPoolName', properties.UserPoolName != null ? cfn_parse.FromCloudFormation.getString(properties.UserPoolName) : undefined);
    ret.addPropertyResult('userPoolTags', 'UserPoolTags', properties.UserPoolTags != null ? cfn_parse.FromCloudFormation.getAny(properties.UserPoolTags) : undefined);
    ret.addPropertyResult('verificationMessageTemplate', 'VerificationMessageTemplate', properties.VerificationMessageTemplate != null ? CfnUserPoolVerificationMessageTemplatePropertyFromCloudFormation(properties.VerificationMessageTemplate) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPool`
 *
 * The `AWS::Cognito::UserPool` resource creates an Amazon Cognito user pool. For more information on working with Amazon Cognito user pools, see [Amazon Cognito User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html) and [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) .
 *
 * > If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 *
 * @cloudformationResource AWS::Cognito::UserPool
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpool.html
 */
class CfnUserPool extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPool`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnUserPool.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrProviderName = cdk.Token.asString(this.getAtt('ProviderName'));
        this.attrProviderUrl = cdk.Token.asString(this.getAtt('ProviderURL'));
        this.accountRecoverySetting = props.accountRecoverySetting;
        this.adminCreateUserConfig = props.adminCreateUserConfig;
        this.aliasAttributes = props.aliasAttributes;
        this.autoVerifiedAttributes = props.autoVerifiedAttributes;
        this.deviceConfiguration = props.deviceConfiguration;
        this.emailConfiguration = props.emailConfiguration;
        this.emailVerificationMessage = props.emailVerificationMessage;
        this.emailVerificationSubject = props.emailVerificationSubject;
        this.enabledMfas = props.enabledMfas;
        this.lambdaConfig = props.lambdaConfig;
        this.mfaConfiguration = props.mfaConfiguration;
        this.policies = props.policies;
        this.schema = props.schema;
        this.smsAuthenticationMessage = props.smsAuthenticationMessage;
        this.smsConfiguration = props.smsConfiguration;
        this.smsVerificationMessage = props.smsVerificationMessage;
        this.usernameAttributes = props.usernameAttributes;
        this.usernameConfiguration = props.usernameConfiguration;
        this.userPoolAddOns = props.userPoolAddOns;
        this.userPoolName = props.userPoolName;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::Cognito::UserPool", props.userPoolTags, { tagPropertyName: 'userPoolTags' });
        this.verificationMessageTemplate = props.verificationMessageTemplate;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::Cognito::UserPool\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPool(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPool.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            accountRecoverySetting: this.accountRecoverySetting,
            adminCreateUserConfig: this.adminCreateUserConfig,
            aliasAttributes: this.aliasAttributes,
            autoVerifiedAttributes: this.autoVerifiedAttributes,
            deviceConfiguration: this.deviceConfiguration,
            emailConfiguration: this.emailConfiguration,
            emailVerificationMessage: this.emailVerificationMessage,
            emailVerificationSubject: this.emailVerificationSubject,
            enabledMfas: this.enabledMfas,
            lambdaConfig: this.lambdaConfig,
            mfaConfiguration: this.mfaConfiguration,
            policies: this.policies,
            schema: this.schema,
            smsAuthenticationMessage: this.smsAuthenticationMessage,
            smsConfiguration: this.smsConfiguration,
            smsVerificationMessage: this.smsVerificationMessage,
            usernameAttributes: this.usernameAttributes,
            usernameConfiguration: this.usernameConfiguration,
            userPoolAddOns: this.userPoolAddOns,
            userPoolName: this.userPoolName,
            userPoolTags: this.tags.renderTags(),
            verificationMessageTemplate: this.verificationMessageTemplate,
        };
    }
    renderProperties(props) {
        return cfnUserPoolPropsToCloudFormation(props);
    }
}
exports.CfnUserPool = CfnUserPool;
_c = JSII_RTTI_SYMBOL_1;
CfnUserPool[_c] = { fqn: "@aws-cdk/aws-cognito.CfnUserPool", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPool.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPool";
/**
 * Determine whether the given properties match those of a `AccountRecoverySettingProperty`
 *
 * @param properties - the TypeScript properties of a `AccountRecoverySettingProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_AccountRecoverySettingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('recoveryMechanisms', cdk.listValidator(CfnUserPool_RecoveryOptionPropertyValidator))(properties.recoveryMechanisms));
    return errors.wrap('supplied properties not correct for "AccountRecoverySettingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AccountRecoverySetting` resource
 *
 * @param properties - the TypeScript properties of a `AccountRecoverySettingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AccountRecoverySetting` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolAccountRecoverySettingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_AccountRecoverySettingPropertyValidator(properties).assertSuccess();
    return {
        RecoveryMechanisms: cdk.listMapper(cfnUserPoolRecoveryOptionPropertyToCloudFormation)(properties.recoveryMechanisms),
    };
}
// @ts-ignore TS6133
function CfnUserPoolAccountRecoverySettingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('recoveryMechanisms', 'RecoveryMechanisms', properties.RecoveryMechanisms != null ? cfn_parse.FromCloudFormation.getArray(CfnUserPoolRecoveryOptionPropertyFromCloudFormation)(properties.RecoveryMechanisms) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AdminCreateUserConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AdminCreateUserConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_AdminCreateUserConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allowAdminCreateUserOnly', cdk.validateBoolean)(properties.allowAdminCreateUserOnly));
    errors.collect(cdk.propertyValidator('inviteMessageTemplate', CfnUserPool_InviteMessageTemplatePropertyValidator)(properties.inviteMessageTemplate));
    errors.collect(cdk.propertyValidator('unusedAccountValidityDays', cdk.validateNumber)(properties.unusedAccountValidityDays));
    return errors.wrap('supplied properties not correct for "AdminCreateUserConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AdminCreateUserConfig` resource
 *
 * @param properties - the TypeScript properties of a `AdminCreateUserConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.AdminCreateUserConfig` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolAdminCreateUserConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_AdminCreateUserConfigPropertyValidator(properties).assertSuccess();
    return {
        AllowAdminCreateUserOnly: cdk.booleanToCloudFormation(properties.allowAdminCreateUserOnly),
        InviteMessageTemplate: cfnUserPoolInviteMessageTemplatePropertyToCloudFormation(properties.inviteMessageTemplate),
        UnusedAccountValidityDays: cdk.numberToCloudFormation(properties.unusedAccountValidityDays),
    };
}
// @ts-ignore TS6133
function CfnUserPoolAdminCreateUserConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('allowAdminCreateUserOnly', 'AllowAdminCreateUserOnly', properties.AllowAdminCreateUserOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowAdminCreateUserOnly) : undefined);
    ret.addPropertyResult('inviteMessageTemplate', 'InviteMessageTemplate', properties.InviteMessageTemplate != null ? CfnUserPoolInviteMessageTemplatePropertyFromCloudFormation(properties.InviteMessageTemplate) : undefined);
    ret.addPropertyResult('unusedAccountValidityDays', 'UnusedAccountValidityDays', properties.UnusedAccountValidityDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.UnusedAccountValidityDays) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomEmailSenderProperty`
 *
 * @param properties - the TypeScript properties of a `CustomEmailSenderProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_CustomEmailSenderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lambdaArn', cdk.validateString)(properties.lambdaArn));
    errors.collect(cdk.propertyValidator('lambdaVersion', cdk.validateString)(properties.lambdaVersion));
    return errors.wrap('supplied properties not correct for "CustomEmailSenderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.CustomEmailSender` resource
 *
 * @param properties - the TypeScript properties of a `CustomEmailSenderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.CustomEmailSender` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolCustomEmailSenderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_CustomEmailSenderPropertyValidator(properties).assertSuccess();
    return {
        LambdaArn: cdk.stringToCloudFormation(properties.lambdaArn),
        LambdaVersion: cdk.stringToCloudFormation(properties.lambdaVersion),
    };
}
// @ts-ignore TS6133
function CfnUserPoolCustomEmailSenderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lambdaArn', 'LambdaArn', properties.LambdaArn != null ? cfn_parse.FromCloudFormation.getString(properties.LambdaArn) : undefined);
    ret.addPropertyResult('lambdaVersion', 'LambdaVersion', properties.LambdaVersion != null ? cfn_parse.FromCloudFormation.getString(properties.LambdaVersion) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CustomSMSSenderProperty`
 *
 * @param properties - the TypeScript properties of a `CustomSMSSenderProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_CustomSMSSenderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lambdaArn', cdk.validateString)(properties.lambdaArn));
    errors.collect(cdk.propertyValidator('lambdaVersion', cdk.validateString)(properties.lambdaVersion));
    return errors.wrap('supplied properties not correct for "CustomSMSSenderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.CustomSMSSender` resource
 *
 * @param properties - the TypeScript properties of a `CustomSMSSenderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.CustomSMSSender` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolCustomSMSSenderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_CustomSMSSenderPropertyValidator(properties).assertSuccess();
    return {
        LambdaArn: cdk.stringToCloudFormation(properties.lambdaArn),
        LambdaVersion: cdk.stringToCloudFormation(properties.lambdaVersion),
    };
}
// @ts-ignore TS6133
function CfnUserPoolCustomSMSSenderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lambdaArn', 'LambdaArn', properties.LambdaArn != null ? cfn_parse.FromCloudFormation.getString(properties.LambdaArn) : undefined);
    ret.addPropertyResult('lambdaVersion', 'LambdaVersion', properties.LambdaVersion != null ? cfn_parse.FromCloudFormation.getString(properties.LambdaVersion) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeviceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_DeviceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('challengeRequiredOnNewDevice', cdk.validateBoolean)(properties.challengeRequiredOnNewDevice));
    errors.collect(cdk.propertyValidator('deviceOnlyRememberedOnUserPrompt', cdk.validateBoolean)(properties.deviceOnlyRememberedOnUserPrompt));
    return errors.wrap('supplied properties not correct for "DeviceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.DeviceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DeviceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.DeviceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDeviceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_DeviceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ChallengeRequiredOnNewDevice: cdk.booleanToCloudFormation(properties.challengeRequiredOnNewDevice),
        DeviceOnlyRememberedOnUserPrompt: cdk.booleanToCloudFormation(properties.deviceOnlyRememberedOnUserPrompt),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDeviceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('challengeRequiredOnNewDevice', 'ChallengeRequiredOnNewDevice', properties.ChallengeRequiredOnNewDevice != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ChallengeRequiredOnNewDevice) : undefined);
    ret.addPropertyResult('deviceOnlyRememberedOnUserPrompt', 'DeviceOnlyRememberedOnUserPrompt', properties.DeviceOnlyRememberedOnUserPrompt != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeviceOnlyRememberedOnUserPrompt) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EmailConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EmailConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_EmailConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('configurationSet', cdk.validateString)(properties.configurationSet));
    errors.collect(cdk.propertyValidator('emailSendingAccount', cdk.validateString)(properties.emailSendingAccount));
    errors.collect(cdk.propertyValidator('from', cdk.validateString)(properties.from));
    errors.collect(cdk.propertyValidator('replyToEmailAddress', cdk.validateString)(properties.replyToEmailAddress));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.validateString)(properties.sourceArn));
    return errors.wrap('supplied properties not correct for "EmailConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.EmailConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EmailConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.EmailConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolEmailConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_EmailConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ConfigurationSet: cdk.stringToCloudFormation(properties.configurationSet),
        EmailSendingAccount: cdk.stringToCloudFormation(properties.emailSendingAccount),
        From: cdk.stringToCloudFormation(properties.from),
        ReplyToEmailAddress: cdk.stringToCloudFormation(properties.replyToEmailAddress),
        SourceArn: cdk.stringToCloudFormation(properties.sourceArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolEmailConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('configurationSet', 'ConfigurationSet', properties.ConfigurationSet != null ? cfn_parse.FromCloudFormation.getString(properties.ConfigurationSet) : undefined);
    ret.addPropertyResult('emailSendingAccount', 'EmailSendingAccount', properties.EmailSendingAccount != null ? cfn_parse.FromCloudFormation.getString(properties.EmailSendingAccount) : undefined);
    ret.addPropertyResult('from', 'From', properties.From != null ? cfn_parse.FromCloudFormation.getString(properties.From) : undefined);
    ret.addPropertyResult('replyToEmailAddress', 'ReplyToEmailAddress', properties.ReplyToEmailAddress != null ? cfn_parse.FromCloudFormation.getString(properties.ReplyToEmailAddress) : undefined);
    ret.addPropertyResult('sourceArn', 'SourceArn', properties.SourceArn != null ? cfn_parse.FromCloudFormation.getString(properties.SourceArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InviteMessageTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `InviteMessageTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_InviteMessageTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('emailMessage', cdk.validateString)(properties.emailMessage));
    errors.collect(cdk.propertyValidator('emailSubject', cdk.validateString)(properties.emailSubject));
    errors.collect(cdk.propertyValidator('smsMessage', cdk.validateString)(properties.smsMessage));
    return errors.wrap('supplied properties not correct for "InviteMessageTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.InviteMessageTemplate` resource
 *
 * @param properties - the TypeScript properties of a `InviteMessageTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.InviteMessageTemplate` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolInviteMessageTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_InviteMessageTemplatePropertyValidator(properties).assertSuccess();
    return {
        EmailMessage: cdk.stringToCloudFormation(properties.emailMessage),
        EmailSubject: cdk.stringToCloudFormation(properties.emailSubject),
        SMSMessage: cdk.stringToCloudFormation(properties.smsMessage),
    };
}
// @ts-ignore TS6133
function CfnUserPoolInviteMessageTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('emailMessage', 'EmailMessage', properties.EmailMessage != null ? cfn_parse.FromCloudFormation.getString(properties.EmailMessage) : undefined);
    ret.addPropertyResult('emailSubject', 'EmailSubject', properties.EmailSubject != null ? cfn_parse.FromCloudFormation.getString(properties.EmailSubject) : undefined);
    ret.addPropertyResult('smsMessage', 'SMSMessage', properties.SMSMessage != null ? cfn_parse.FromCloudFormation.getString(properties.SMSMessage) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LambdaConfigProperty`
 *
 * @param properties - the TypeScript properties of a `LambdaConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_LambdaConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('createAuthChallenge', cdk.validateString)(properties.createAuthChallenge));
    errors.collect(cdk.propertyValidator('customEmailSender', CfnUserPool_CustomEmailSenderPropertyValidator)(properties.customEmailSender));
    errors.collect(cdk.propertyValidator('customMessage', cdk.validateString)(properties.customMessage));
    errors.collect(cdk.propertyValidator('customSmsSender', CfnUserPool_CustomSMSSenderPropertyValidator)(properties.customSmsSender));
    errors.collect(cdk.propertyValidator('defineAuthChallenge', cdk.validateString)(properties.defineAuthChallenge));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('postAuthentication', cdk.validateString)(properties.postAuthentication));
    errors.collect(cdk.propertyValidator('postConfirmation', cdk.validateString)(properties.postConfirmation));
    errors.collect(cdk.propertyValidator('preAuthentication', cdk.validateString)(properties.preAuthentication));
    errors.collect(cdk.propertyValidator('preSignUp', cdk.validateString)(properties.preSignUp));
    errors.collect(cdk.propertyValidator('preTokenGeneration', cdk.validateString)(properties.preTokenGeneration));
    errors.collect(cdk.propertyValidator('userMigration', cdk.validateString)(properties.userMigration));
    errors.collect(cdk.propertyValidator('verifyAuthChallengeResponse', cdk.validateString)(properties.verifyAuthChallengeResponse));
    return errors.wrap('supplied properties not correct for "LambdaConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.LambdaConfig` resource
 *
 * @param properties - the TypeScript properties of a `LambdaConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.LambdaConfig` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolLambdaConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_LambdaConfigPropertyValidator(properties).assertSuccess();
    return {
        CreateAuthChallenge: cdk.stringToCloudFormation(properties.createAuthChallenge),
        CustomEmailSender: cfnUserPoolCustomEmailSenderPropertyToCloudFormation(properties.customEmailSender),
        CustomMessage: cdk.stringToCloudFormation(properties.customMessage),
        CustomSMSSender: cfnUserPoolCustomSMSSenderPropertyToCloudFormation(properties.customSmsSender),
        DefineAuthChallenge: cdk.stringToCloudFormation(properties.defineAuthChallenge),
        KMSKeyID: cdk.stringToCloudFormation(properties.kmsKeyId),
        PostAuthentication: cdk.stringToCloudFormation(properties.postAuthentication),
        PostConfirmation: cdk.stringToCloudFormation(properties.postConfirmation),
        PreAuthentication: cdk.stringToCloudFormation(properties.preAuthentication),
        PreSignUp: cdk.stringToCloudFormation(properties.preSignUp),
        PreTokenGeneration: cdk.stringToCloudFormation(properties.preTokenGeneration),
        UserMigration: cdk.stringToCloudFormation(properties.userMigration),
        VerifyAuthChallengeResponse: cdk.stringToCloudFormation(properties.verifyAuthChallengeResponse),
    };
}
// @ts-ignore TS6133
function CfnUserPoolLambdaConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('createAuthChallenge', 'CreateAuthChallenge', properties.CreateAuthChallenge != null ? cfn_parse.FromCloudFormation.getString(properties.CreateAuthChallenge) : undefined);
    ret.addPropertyResult('customEmailSender', 'CustomEmailSender', properties.CustomEmailSender != null ? CfnUserPoolCustomEmailSenderPropertyFromCloudFormation(properties.CustomEmailSender) : undefined);
    ret.addPropertyResult('customMessage', 'CustomMessage', properties.CustomMessage != null ? cfn_parse.FromCloudFormation.getString(properties.CustomMessage) : undefined);
    ret.addPropertyResult('customSmsSender', 'CustomSMSSender', properties.CustomSMSSender != null ? CfnUserPoolCustomSMSSenderPropertyFromCloudFormation(properties.CustomSMSSender) : undefined);
    ret.addPropertyResult('defineAuthChallenge', 'DefineAuthChallenge', properties.DefineAuthChallenge != null ? cfn_parse.FromCloudFormation.getString(properties.DefineAuthChallenge) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KMSKeyID', properties.KMSKeyID != null ? cfn_parse.FromCloudFormation.getString(properties.KMSKeyID) : undefined);
    ret.addPropertyResult('postAuthentication', 'PostAuthentication', properties.PostAuthentication != null ? cfn_parse.FromCloudFormation.getString(properties.PostAuthentication) : undefined);
    ret.addPropertyResult('postConfirmation', 'PostConfirmation', properties.PostConfirmation != null ? cfn_parse.FromCloudFormation.getString(properties.PostConfirmation) : undefined);
    ret.addPropertyResult('preAuthentication', 'PreAuthentication', properties.PreAuthentication != null ? cfn_parse.FromCloudFormation.getString(properties.PreAuthentication) : undefined);
    ret.addPropertyResult('preSignUp', 'PreSignUp', properties.PreSignUp != null ? cfn_parse.FromCloudFormation.getString(properties.PreSignUp) : undefined);
    ret.addPropertyResult('preTokenGeneration', 'PreTokenGeneration', properties.PreTokenGeneration != null ? cfn_parse.FromCloudFormation.getString(properties.PreTokenGeneration) : undefined);
    ret.addPropertyResult('userMigration', 'UserMigration', properties.UserMigration != null ? cfn_parse.FromCloudFormation.getString(properties.UserMigration) : undefined);
    ret.addPropertyResult('verifyAuthChallengeResponse', 'VerifyAuthChallengeResponse', properties.VerifyAuthChallengeResponse != null ? cfn_parse.FromCloudFormation.getString(properties.VerifyAuthChallengeResponse) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumberAttributeConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `NumberAttributeConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_NumberAttributeConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxValue', cdk.validateString)(properties.maxValue));
    errors.collect(cdk.propertyValidator('minValue', cdk.validateString)(properties.minValue));
    return errors.wrap('supplied properties not correct for "NumberAttributeConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.NumberAttributeConstraints` resource
 *
 * @param properties - the TypeScript properties of a `NumberAttributeConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.NumberAttributeConstraints` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolNumberAttributeConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_NumberAttributeConstraintsPropertyValidator(properties).assertSuccess();
    return {
        MaxValue: cdk.stringToCloudFormation(properties.maxValue),
        MinValue: cdk.stringToCloudFormation(properties.minValue),
    };
}
// @ts-ignore TS6133
function CfnUserPoolNumberAttributeConstraintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxValue', 'MaxValue', properties.MaxValue != null ? cfn_parse.FromCloudFormation.getString(properties.MaxValue) : undefined);
    ret.addPropertyResult('minValue', 'MinValue', properties.MinValue != null ? cfn_parse.FromCloudFormation.getString(properties.MinValue) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PasswordPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `PasswordPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_PasswordPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('minimumLength', cdk.validateNumber)(properties.minimumLength));
    errors.collect(cdk.propertyValidator('requireLowercase', cdk.validateBoolean)(properties.requireLowercase));
    errors.collect(cdk.propertyValidator('requireNumbers', cdk.validateBoolean)(properties.requireNumbers));
    errors.collect(cdk.propertyValidator('requireSymbols', cdk.validateBoolean)(properties.requireSymbols));
    errors.collect(cdk.propertyValidator('requireUppercase', cdk.validateBoolean)(properties.requireUppercase));
    errors.collect(cdk.propertyValidator('temporaryPasswordValidityDays', cdk.validateNumber)(properties.temporaryPasswordValidityDays));
    return errors.wrap('supplied properties not correct for "PasswordPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.PasswordPolicy` resource
 *
 * @param properties - the TypeScript properties of a `PasswordPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.PasswordPolicy` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPasswordPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_PasswordPolicyPropertyValidator(properties).assertSuccess();
    return {
        MinimumLength: cdk.numberToCloudFormation(properties.minimumLength),
        RequireLowercase: cdk.booleanToCloudFormation(properties.requireLowercase),
        RequireNumbers: cdk.booleanToCloudFormation(properties.requireNumbers),
        RequireSymbols: cdk.booleanToCloudFormation(properties.requireSymbols),
        RequireUppercase: cdk.booleanToCloudFormation(properties.requireUppercase),
        TemporaryPasswordValidityDays: cdk.numberToCloudFormation(properties.temporaryPasswordValidityDays),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPasswordPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('minimumLength', 'MinimumLength', properties.MinimumLength != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinimumLength) : undefined);
    ret.addPropertyResult('requireLowercase', 'RequireLowercase', properties.RequireLowercase != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireLowercase) : undefined);
    ret.addPropertyResult('requireNumbers', 'RequireNumbers', properties.RequireNumbers != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireNumbers) : undefined);
    ret.addPropertyResult('requireSymbols', 'RequireSymbols', properties.RequireSymbols != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireSymbols) : undefined);
    ret.addPropertyResult('requireUppercase', 'RequireUppercase', properties.RequireUppercase != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireUppercase) : undefined);
    ret.addPropertyResult('temporaryPasswordValidityDays', 'TemporaryPasswordValidityDays', properties.TemporaryPasswordValidityDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.TemporaryPasswordValidityDays) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PoliciesProperty`
 *
 * @param properties - the TypeScript properties of a `PoliciesProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_PoliciesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('passwordPolicy', CfnUserPool_PasswordPolicyPropertyValidator)(properties.passwordPolicy));
    return errors.wrap('supplied properties not correct for "PoliciesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.Policies` resource
 *
 * @param properties - the TypeScript properties of a `PoliciesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.Policies` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolPoliciesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_PoliciesPropertyValidator(properties).assertSuccess();
    return {
        PasswordPolicy: cfnUserPoolPasswordPolicyPropertyToCloudFormation(properties.passwordPolicy),
    };
}
// @ts-ignore TS6133
function CfnUserPoolPoliciesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('passwordPolicy', 'PasswordPolicy', properties.PasswordPolicy != null ? CfnUserPoolPasswordPolicyPropertyFromCloudFormation(properties.PasswordPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RecoveryOptionProperty`
 *
 * @param properties - the TypeScript properties of a `RecoveryOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_RecoveryOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('priority', cdk.validateNumber)(properties.priority));
    return errors.wrap('supplied properties not correct for "RecoveryOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.RecoveryOption` resource
 *
 * @param properties - the TypeScript properties of a `RecoveryOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.RecoveryOption` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRecoveryOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_RecoveryOptionPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Priority: cdk.numberToCloudFormation(properties.priority),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRecoveryOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('priority', 'Priority', properties.Priority != null ? cfn_parse.FromCloudFormation.getNumber(properties.Priority) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SchemaAttributeProperty`
 *
 * @param properties - the TypeScript properties of a `SchemaAttributeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_SchemaAttributePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeDataType', cdk.validateString)(properties.attributeDataType));
    errors.collect(cdk.propertyValidator('developerOnlyAttribute', cdk.validateBoolean)(properties.developerOnlyAttribute));
    errors.collect(cdk.propertyValidator('mutable', cdk.validateBoolean)(properties.mutable));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('numberAttributeConstraints', CfnUserPool_NumberAttributeConstraintsPropertyValidator)(properties.numberAttributeConstraints));
    errors.collect(cdk.propertyValidator('required', cdk.validateBoolean)(properties.required));
    errors.collect(cdk.propertyValidator('stringAttributeConstraints', CfnUserPool_StringAttributeConstraintsPropertyValidator)(properties.stringAttributeConstraints));
    return errors.wrap('supplied properties not correct for "SchemaAttributeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SchemaAttribute` resource
 *
 * @param properties - the TypeScript properties of a `SchemaAttributeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SchemaAttribute` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolSchemaAttributePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_SchemaAttributePropertyValidator(properties).assertSuccess();
    return {
        AttributeDataType: cdk.stringToCloudFormation(properties.attributeDataType),
        DeveloperOnlyAttribute: cdk.booleanToCloudFormation(properties.developerOnlyAttribute),
        Mutable: cdk.booleanToCloudFormation(properties.mutable),
        Name: cdk.stringToCloudFormation(properties.name),
        NumberAttributeConstraints: cfnUserPoolNumberAttributeConstraintsPropertyToCloudFormation(properties.numberAttributeConstraints),
        Required: cdk.booleanToCloudFormation(properties.required),
        StringAttributeConstraints: cfnUserPoolStringAttributeConstraintsPropertyToCloudFormation(properties.stringAttributeConstraints),
    };
}
// @ts-ignore TS6133
function CfnUserPoolSchemaAttributePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('attributeDataType', 'AttributeDataType', properties.AttributeDataType != null ? cfn_parse.FromCloudFormation.getString(properties.AttributeDataType) : undefined);
    ret.addPropertyResult('developerOnlyAttribute', 'DeveloperOnlyAttribute', properties.DeveloperOnlyAttribute != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeveloperOnlyAttribute) : undefined);
    ret.addPropertyResult('mutable', 'Mutable', properties.Mutable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Mutable) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('numberAttributeConstraints', 'NumberAttributeConstraints', properties.NumberAttributeConstraints != null ? CfnUserPoolNumberAttributeConstraintsPropertyFromCloudFormation(properties.NumberAttributeConstraints) : undefined);
    ret.addPropertyResult('required', 'Required', properties.Required != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Required) : undefined);
    ret.addPropertyResult('stringAttributeConstraints', 'StringAttributeConstraints', properties.StringAttributeConstraints != null ? CfnUserPoolStringAttributeConstraintsPropertyFromCloudFormation(properties.StringAttributeConstraints) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SmsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SmsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_SmsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('externalId', cdk.validateString)(properties.externalId));
    errors.collect(cdk.propertyValidator('snsCallerArn', cdk.validateString)(properties.snsCallerArn));
    errors.collect(cdk.propertyValidator('snsRegion', cdk.validateString)(properties.snsRegion));
    return errors.wrap('supplied properties not correct for "SmsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SmsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SmsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.SmsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolSmsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_SmsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ExternalId: cdk.stringToCloudFormation(properties.externalId),
        SnsCallerArn: cdk.stringToCloudFormation(properties.snsCallerArn),
        SnsRegion: cdk.stringToCloudFormation(properties.snsRegion),
    };
}
// @ts-ignore TS6133
function CfnUserPoolSmsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('externalId', 'ExternalId', properties.ExternalId != null ? cfn_parse.FromCloudFormation.getString(properties.ExternalId) : undefined);
    ret.addPropertyResult('snsCallerArn', 'SnsCallerArn', properties.SnsCallerArn != null ? cfn_parse.FromCloudFormation.getString(properties.SnsCallerArn) : undefined);
    ret.addPropertyResult('snsRegion', 'SnsRegion', properties.SnsRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SnsRegion) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StringAttributeConstraintsProperty`
 *
 * @param properties - the TypeScript properties of a `StringAttributeConstraintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_StringAttributeConstraintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxLength', cdk.validateString)(properties.maxLength));
    errors.collect(cdk.propertyValidator('minLength', cdk.validateString)(properties.minLength));
    return errors.wrap('supplied properties not correct for "StringAttributeConstraintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.StringAttributeConstraints` resource
 *
 * @param properties - the TypeScript properties of a `StringAttributeConstraintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.StringAttributeConstraints` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolStringAttributeConstraintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_StringAttributeConstraintsPropertyValidator(properties).assertSuccess();
    return {
        MaxLength: cdk.stringToCloudFormation(properties.maxLength),
        MinLength: cdk.stringToCloudFormation(properties.minLength),
    };
}
// @ts-ignore TS6133
function CfnUserPoolStringAttributeConstraintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxLength', 'MaxLength', properties.MaxLength != null ? cfn_parse.FromCloudFormation.getString(properties.MaxLength) : undefined);
    ret.addPropertyResult('minLength', 'MinLength', properties.MinLength != null ? cfn_parse.FromCloudFormation.getString(properties.MinLength) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UserPoolAddOnsProperty`
 *
 * @param properties - the TypeScript properties of a `UserPoolAddOnsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_UserPoolAddOnsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('advancedSecurityMode', cdk.validateString)(properties.advancedSecurityMode));
    return errors.wrap('supplied properties not correct for "UserPoolAddOnsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UserPoolAddOns` resource
 *
 * @param properties - the TypeScript properties of a `UserPoolAddOnsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UserPoolAddOns` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserPoolAddOnsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_UserPoolAddOnsPropertyValidator(properties).assertSuccess();
    return {
        AdvancedSecurityMode: cdk.stringToCloudFormation(properties.advancedSecurityMode),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserPoolAddOnsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('advancedSecurityMode', 'AdvancedSecurityMode', properties.AdvancedSecurityMode != null ? cfn_parse.FromCloudFormation.getString(properties.AdvancedSecurityMode) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UsernameConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `UsernameConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_UsernameConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('caseSensitive', cdk.validateBoolean)(properties.caseSensitive));
    return errors.wrap('supplied properties not correct for "UsernameConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UsernameConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `UsernameConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.UsernameConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUsernameConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_UsernameConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CaseSensitive: cdk.booleanToCloudFormation(properties.caseSensitive),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUsernameConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('caseSensitive', 'CaseSensitive', properties.CaseSensitive != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CaseSensitive) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VerificationMessageTemplateProperty`
 *
 * @param properties - the TypeScript properties of a `VerificationMessageTemplateProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPool_VerificationMessageTemplatePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('defaultEmailOption', cdk.validateString)(properties.defaultEmailOption));
    errors.collect(cdk.propertyValidator('emailMessage', cdk.validateString)(properties.emailMessage));
    errors.collect(cdk.propertyValidator('emailMessageByLink', cdk.validateString)(properties.emailMessageByLink));
    errors.collect(cdk.propertyValidator('emailSubject', cdk.validateString)(properties.emailSubject));
    errors.collect(cdk.propertyValidator('emailSubjectByLink', cdk.validateString)(properties.emailSubjectByLink));
    errors.collect(cdk.propertyValidator('smsMessage', cdk.validateString)(properties.smsMessage));
    return errors.wrap('supplied properties not correct for "VerificationMessageTemplateProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPool.VerificationMessageTemplate` resource
 *
 * @param properties - the TypeScript properties of a `VerificationMessageTemplateProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPool.VerificationMessageTemplate` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolVerificationMessageTemplatePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPool_VerificationMessageTemplatePropertyValidator(properties).assertSuccess();
    return {
        DefaultEmailOption: cdk.stringToCloudFormation(properties.defaultEmailOption),
        EmailMessage: cdk.stringToCloudFormation(properties.emailMessage),
        EmailMessageByLink: cdk.stringToCloudFormation(properties.emailMessageByLink),
        EmailSubject: cdk.stringToCloudFormation(properties.emailSubject),
        EmailSubjectByLink: cdk.stringToCloudFormation(properties.emailSubjectByLink),
        SmsMessage: cdk.stringToCloudFormation(properties.smsMessage),
    };
}
// @ts-ignore TS6133
function CfnUserPoolVerificationMessageTemplatePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('defaultEmailOption', 'DefaultEmailOption', properties.DefaultEmailOption != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultEmailOption) : undefined);
    ret.addPropertyResult('emailMessage', 'EmailMessage', properties.EmailMessage != null ? cfn_parse.FromCloudFormation.getString(properties.EmailMessage) : undefined);
    ret.addPropertyResult('emailMessageByLink', 'EmailMessageByLink', properties.EmailMessageByLink != null ? cfn_parse.FromCloudFormation.getString(properties.EmailMessageByLink) : undefined);
    ret.addPropertyResult('emailSubject', 'EmailSubject', properties.EmailSubject != null ? cfn_parse.FromCloudFormation.getString(properties.EmailSubject) : undefined);
    ret.addPropertyResult('emailSubjectByLink', 'EmailSubjectByLink', properties.EmailSubjectByLink != null ? cfn_parse.FromCloudFormation.getString(properties.EmailSubjectByLink) : undefined);
    ret.addPropertyResult('smsMessage', 'SmsMessage', properties.SmsMessage != null ? cfn_parse.FromCloudFormation.getString(properties.SmsMessage) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolClientProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolClientProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolClientPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessTokenValidity', cdk.validateNumber)(properties.accessTokenValidity));
    errors.collect(cdk.propertyValidator('allowedOAuthFlows', cdk.listValidator(cdk.validateString))(properties.allowedOAuthFlows));
    errors.collect(cdk.propertyValidator('allowedOAuthFlowsUserPoolClient', cdk.validateBoolean)(properties.allowedOAuthFlowsUserPoolClient));
    errors.collect(cdk.propertyValidator('allowedOAuthScopes', cdk.listValidator(cdk.validateString))(properties.allowedOAuthScopes));
    errors.collect(cdk.propertyValidator('analyticsConfiguration', CfnUserPoolClient_AnalyticsConfigurationPropertyValidator)(properties.analyticsConfiguration));
    errors.collect(cdk.propertyValidator('callbackUrLs', cdk.listValidator(cdk.validateString))(properties.callbackUrLs));
    errors.collect(cdk.propertyValidator('clientName', cdk.validateString)(properties.clientName));
    errors.collect(cdk.propertyValidator('defaultRedirectUri', cdk.validateString)(properties.defaultRedirectUri));
    errors.collect(cdk.propertyValidator('enableTokenRevocation', cdk.validateBoolean)(properties.enableTokenRevocation));
    errors.collect(cdk.propertyValidator('explicitAuthFlows', cdk.listValidator(cdk.validateString))(properties.explicitAuthFlows));
    errors.collect(cdk.propertyValidator('generateSecret', cdk.validateBoolean)(properties.generateSecret));
    errors.collect(cdk.propertyValidator('idTokenValidity', cdk.validateNumber)(properties.idTokenValidity));
    errors.collect(cdk.propertyValidator('logoutUrLs', cdk.listValidator(cdk.validateString))(properties.logoutUrLs));
    errors.collect(cdk.propertyValidator('preventUserExistenceErrors', cdk.validateString)(properties.preventUserExistenceErrors));
    errors.collect(cdk.propertyValidator('readAttributes', cdk.listValidator(cdk.validateString))(properties.readAttributes));
    errors.collect(cdk.propertyValidator('refreshTokenValidity', cdk.validateNumber)(properties.refreshTokenValidity));
    errors.collect(cdk.propertyValidator('supportedIdentityProviders', cdk.listValidator(cdk.validateString))(properties.supportedIdentityProviders));
    errors.collect(cdk.propertyValidator('tokenValidityUnits', CfnUserPoolClient_TokenValidityUnitsPropertyValidator)(properties.tokenValidityUnits));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('writeAttributes', cdk.listValidator(cdk.validateString))(properties.writeAttributes));
    return errors.wrap('supplied properties not correct for "CfnUserPoolClientProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolClientProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolClientPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolClientPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AccessTokenValidity: cdk.numberToCloudFormation(properties.accessTokenValidity),
        AllowedOAuthFlows: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedOAuthFlows),
        AllowedOAuthFlowsUserPoolClient: cdk.booleanToCloudFormation(properties.allowedOAuthFlowsUserPoolClient),
        AllowedOAuthScopes: cdk.listMapper(cdk.stringToCloudFormation)(properties.allowedOAuthScopes),
        AnalyticsConfiguration: cfnUserPoolClientAnalyticsConfigurationPropertyToCloudFormation(properties.analyticsConfiguration),
        CallbackURLs: cdk.listMapper(cdk.stringToCloudFormation)(properties.callbackUrLs),
        ClientName: cdk.stringToCloudFormation(properties.clientName),
        DefaultRedirectURI: cdk.stringToCloudFormation(properties.defaultRedirectUri),
        EnableTokenRevocation: cdk.booleanToCloudFormation(properties.enableTokenRevocation),
        ExplicitAuthFlows: cdk.listMapper(cdk.stringToCloudFormation)(properties.explicitAuthFlows),
        GenerateSecret: cdk.booleanToCloudFormation(properties.generateSecret),
        IdTokenValidity: cdk.numberToCloudFormation(properties.idTokenValidity),
        LogoutURLs: cdk.listMapper(cdk.stringToCloudFormation)(properties.logoutUrLs),
        PreventUserExistenceErrors: cdk.stringToCloudFormation(properties.preventUserExistenceErrors),
        ReadAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.readAttributes),
        RefreshTokenValidity: cdk.numberToCloudFormation(properties.refreshTokenValidity),
        SupportedIdentityProviders: cdk.listMapper(cdk.stringToCloudFormation)(properties.supportedIdentityProviders),
        TokenValidityUnits: cfnUserPoolClientTokenValidityUnitsPropertyToCloudFormation(properties.tokenValidityUnits),
        WriteAttributes: cdk.listMapper(cdk.stringToCloudFormation)(properties.writeAttributes),
    };
}
// @ts-ignore TS6133
function CfnUserPoolClientPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('accessTokenValidity', 'AccessTokenValidity', properties.AccessTokenValidity != null ? cfn_parse.FromCloudFormation.getNumber(properties.AccessTokenValidity) : undefined);
    ret.addPropertyResult('allowedOAuthFlows', 'AllowedOAuthFlows', properties.AllowedOAuthFlows != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AllowedOAuthFlows) : undefined);
    ret.addPropertyResult('allowedOAuthFlowsUserPoolClient', 'AllowedOAuthFlowsUserPoolClient', properties.AllowedOAuthFlowsUserPoolClient != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowedOAuthFlowsUserPoolClient) : undefined);
    ret.addPropertyResult('allowedOAuthScopes', 'AllowedOAuthScopes', properties.AllowedOAuthScopes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AllowedOAuthScopes) : undefined);
    ret.addPropertyResult('analyticsConfiguration', 'AnalyticsConfiguration', properties.AnalyticsConfiguration != null ? CfnUserPoolClientAnalyticsConfigurationPropertyFromCloudFormation(properties.AnalyticsConfiguration) : undefined);
    ret.addPropertyResult('callbackUrLs', 'CallbackURLs', properties.CallbackURLs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CallbackURLs) : undefined);
    ret.addPropertyResult('clientName', 'ClientName', properties.ClientName != null ? cfn_parse.FromCloudFormation.getString(properties.ClientName) : undefined);
    ret.addPropertyResult('defaultRedirectUri', 'DefaultRedirectURI', properties.DefaultRedirectURI != null ? cfn_parse.FromCloudFormation.getString(properties.DefaultRedirectURI) : undefined);
    ret.addPropertyResult('enableTokenRevocation', 'EnableTokenRevocation', properties.EnableTokenRevocation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableTokenRevocation) : undefined);
    ret.addPropertyResult('explicitAuthFlows', 'ExplicitAuthFlows', properties.ExplicitAuthFlows != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ExplicitAuthFlows) : undefined);
    ret.addPropertyResult('generateSecret', 'GenerateSecret', properties.GenerateSecret != null ? cfn_parse.FromCloudFormation.getBoolean(properties.GenerateSecret) : undefined);
    ret.addPropertyResult('idTokenValidity', 'IdTokenValidity', properties.IdTokenValidity != null ? cfn_parse.FromCloudFormation.getNumber(properties.IdTokenValidity) : undefined);
    ret.addPropertyResult('logoutUrLs', 'LogoutURLs', properties.LogoutURLs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.LogoutURLs) : undefined);
    ret.addPropertyResult('preventUserExistenceErrors', 'PreventUserExistenceErrors', properties.PreventUserExistenceErrors != null ? cfn_parse.FromCloudFormation.getString(properties.PreventUserExistenceErrors) : undefined);
    ret.addPropertyResult('readAttributes', 'ReadAttributes', properties.ReadAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ReadAttributes) : undefined);
    ret.addPropertyResult('refreshTokenValidity', 'RefreshTokenValidity', properties.RefreshTokenValidity != null ? cfn_parse.FromCloudFormation.getNumber(properties.RefreshTokenValidity) : undefined);
    ret.addPropertyResult('supportedIdentityProviders', 'SupportedIdentityProviders', properties.SupportedIdentityProviders != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SupportedIdentityProviders) : undefined);
    ret.addPropertyResult('tokenValidityUnits', 'TokenValidityUnits', properties.TokenValidityUnits != null ? CfnUserPoolClientTokenValidityUnitsPropertyFromCloudFormation(properties.TokenValidityUnits) : undefined);
    ret.addPropertyResult('writeAttributes', 'WriteAttributes', properties.WriteAttributes != null ? cfn_parse.FromCloudFormation.getStringArray(properties.WriteAttributes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolClient`
 *
 * The `AWS::Cognito::UserPoolClient` resource specifies an Amazon Cognito user pool client.
 *
 * > If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 *
 * @cloudformationResource AWS::Cognito::UserPoolClient
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolclient.html
 */
class CfnUserPoolClient extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolClient`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolClientProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'userPoolId', this);
        this.attrClientSecret = cdk.Token.asString(this.getAtt('ClientSecret'));
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.userPoolId = props.userPoolId;
        this.accessTokenValidity = props.accessTokenValidity;
        this.allowedOAuthFlows = props.allowedOAuthFlows;
        this.allowedOAuthFlowsUserPoolClient = props.allowedOAuthFlowsUserPoolClient;
        this.allowedOAuthScopes = props.allowedOAuthScopes;
        this.analyticsConfiguration = props.analyticsConfiguration;
        this.callbackUrLs = props.callbackUrLs;
        this.clientName = props.clientName;
        this.defaultRedirectUri = props.defaultRedirectUri;
        this.enableTokenRevocation = props.enableTokenRevocation;
        this.explicitAuthFlows = props.explicitAuthFlows;
        this.generateSecret = props.generateSecret;
        this.idTokenValidity = props.idTokenValidity;
        this.logoutUrLs = props.logoutUrLs;
        this.preventUserExistenceErrors = props.preventUserExistenceErrors;
        this.readAttributes = props.readAttributes;
        this.refreshTokenValidity = props.refreshTokenValidity;
        this.supportedIdentityProviders = props.supportedIdentityProviders;
        this.tokenValidityUnits = props.tokenValidityUnits;
        this.writeAttributes = props.writeAttributes;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolClientPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolClient(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            accessTokenValidity: this.accessTokenValidity,
            allowedOAuthFlows: this.allowedOAuthFlows,
            allowedOAuthFlowsUserPoolClient: this.allowedOAuthFlowsUserPoolClient,
            allowedOAuthScopes: this.allowedOAuthScopes,
            analyticsConfiguration: this.analyticsConfiguration,
            callbackUrLs: this.callbackUrLs,
            clientName: this.clientName,
            defaultRedirectUri: this.defaultRedirectUri,
            enableTokenRevocation: this.enableTokenRevocation,
            explicitAuthFlows: this.explicitAuthFlows,
            generateSecret: this.generateSecret,
            idTokenValidity: this.idTokenValidity,
            logoutUrLs: this.logoutUrLs,
            preventUserExistenceErrors: this.preventUserExistenceErrors,
            readAttributes: this.readAttributes,
            refreshTokenValidity: this.refreshTokenValidity,
            supportedIdentityProviders: this.supportedIdentityProviders,
            tokenValidityUnits: this.tokenValidityUnits,
            writeAttributes: this.writeAttributes,
        };
    }
    renderProperties(props) {
        return cfnUserPoolClientPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolClient = CfnUserPoolClient;
_d = JSII_RTTI_SYMBOL_1;
CfnUserPoolClient[_d] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolClient", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolClient.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolClient";
/**
 * Determine whether the given properties match those of a `AnalyticsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AnalyticsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolClient_AnalyticsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('applicationArn', cdk.validateString)(properties.applicationArn));
    errors.collect(cdk.propertyValidator('applicationId', cdk.validateString)(properties.applicationId));
    errors.collect(cdk.propertyValidator('externalId', cdk.validateString)(properties.externalId));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('userDataShared', cdk.validateBoolean)(properties.userDataShared));
    return errors.wrap('supplied properties not correct for "AnalyticsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.AnalyticsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AnalyticsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.AnalyticsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolClientAnalyticsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolClient_AnalyticsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ApplicationArn: cdk.stringToCloudFormation(properties.applicationArn),
        ApplicationId: cdk.stringToCloudFormation(properties.applicationId),
        ExternalId: cdk.stringToCloudFormation(properties.externalId),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        UserDataShared: cdk.booleanToCloudFormation(properties.userDataShared),
    };
}
// @ts-ignore TS6133
function CfnUserPoolClientAnalyticsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('applicationArn', 'ApplicationArn', properties.ApplicationArn != null ? cfn_parse.FromCloudFormation.getString(properties.ApplicationArn) : undefined);
    ret.addPropertyResult('applicationId', 'ApplicationId', properties.ApplicationId != null ? cfn_parse.FromCloudFormation.getString(properties.ApplicationId) : undefined);
    ret.addPropertyResult('externalId', 'ExternalId', properties.ExternalId != null ? cfn_parse.FromCloudFormation.getString(properties.ExternalId) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addPropertyResult('userDataShared', 'UserDataShared', properties.UserDataShared != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UserDataShared) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TokenValidityUnitsProperty`
 *
 * @param properties - the TypeScript properties of a `TokenValidityUnitsProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolClient_TokenValidityUnitsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessToken', cdk.validateString)(properties.accessToken));
    errors.collect(cdk.propertyValidator('idToken', cdk.validateString)(properties.idToken));
    errors.collect(cdk.propertyValidator('refreshToken', cdk.validateString)(properties.refreshToken));
    return errors.wrap('supplied properties not correct for "TokenValidityUnitsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.TokenValidityUnits` resource
 *
 * @param properties - the TypeScript properties of a `TokenValidityUnitsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolClient.TokenValidityUnits` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolClientTokenValidityUnitsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolClient_TokenValidityUnitsPropertyValidator(properties).assertSuccess();
    return {
        AccessToken: cdk.stringToCloudFormation(properties.accessToken),
        IdToken: cdk.stringToCloudFormation(properties.idToken),
        RefreshToken: cdk.stringToCloudFormation(properties.refreshToken),
    };
}
// @ts-ignore TS6133
function CfnUserPoolClientTokenValidityUnitsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessToken', 'AccessToken', properties.AccessToken != null ? cfn_parse.FromCloudFormation.getString(properties.AccessToken) : undefined);
    ret.addPropertyResult('idToken', 'IdToken', properties.IdToken != null ? cfn_parse.FromCloudFormation.getString(properties.IdToken) : undefined);
    ret.addPropertyResult('refreshToken', 'RefreshToken', properties.RefreshToken != null ? cfn_parse.FromCloudFormation.getString(properties.RefreshToken) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolDomainProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolDomainProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolDomainPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('customDomainConfig', CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator)(properties.customDomainConfig));
    errors.collect(cdk.propertyValidator('domain', cdk.requiredValidator)(properties.domain));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolDomainProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolDomainProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDomainPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolDomainPropsValidator(properties).assertSuccess();
    return {
        Domain: cdk.stringToCloudFormation(properties.domain),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        CustomDomainConfig: cfnUserPoolDomainCustomDomainConfigTypePropertyToCloudFormation(properties.customDomainConfig),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDomainPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('domain', 'Domain', cfn_parse.FromCloudFormation.getString(properties.Domain));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('customDomainConfig', 'CustomDomainConfig', properties.CustomDomainConfig != null ? CfnUserPoolDomainCustomDomainConfigTypePropertyFromCloudFormation(properties.CustomDomainConfig) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolDomain`
 *
 * The AWS::Cognito::UserPoolDomain resource creates a new domain for a user pool.
 *
 * @cloudformationResource AWS::Cognito::UserPoolDomain
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooldomain.html
 */
class CfnUserPoolDomain extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolDomain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolDomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'domain', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.domain = props.domain;
        this.userPoolId = props.userPoolId;
        this.customDomainConfig = props.customDomainConfig;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolDomainPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolDomain(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            domain: this.domain,
            userPoolId: this.userPoolId,
            customDomainConfig: this.customDomainConfig,
        };
    }
    renderProperties(props) {
        return cfnUserPoolDomainPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolDomain = CfnUserPoolDomain;
_e = JSII_RTTI_SYMBOL_1;
CfnUserPoolDomain[_e] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolDomain", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolDomain.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolDomain";
/**
 * Determine whether the given properties match those of a `CustomDomainConfigTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CustomDomainConfigTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    return errors.wrap('supplied properties not correct for "CustomDomainConfigTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain.CustomDomainConfigType` resource
 *
 * @param properties - the TypeScript properties of a `CustomDomainConfigTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolDomain.CustomDomainConfigType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolDomainCustomDomainConfigTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolDomain_CustomDomainConfigTypePropertyValidator(properties).assertSuccess();
    return {
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolDomainCustomDomainConfigTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateArn', 'CertificateArn', properties.CertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('groupName', cdk.validateString)(properties.groupName));
    errors.collect(cdk.propertyValidator('precedence', cdk.validateNumber)(properties.precedence));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolGroup` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolGroupPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        Description: cdk.stringToCloudFormation(properties.description),
        GroupName: cdk.stringToCloudFormation(properties.groupName),
        Precedence: cdk.numberToCloudFormation(properties.precedence),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('groupName', 'GroupName', properties.GroupName != null ? cfn_parse.FromCloudFormation.getString(properties.GroupName) : undefined);
    ret.addPropertyResult('precedence', 'Precedence', properties.Precedence != null ? cfn_parse.FromCloudFormation.getNumber(properties.Precedence) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', properties.RoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.RoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolGroup`
 *
 * Specifies a new group in the identified user pool.
 *
 * Calling this action requires developer credentials.
 *
 * > If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 *
 * @cloudformationResource AWS::Cognito::UserPoolGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html
 */
class CfnUserPoolGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'userPoolId', this);
        this.userPoolId = props.userPoolId;
        this.description = props.description;
        this.groupName = props.groupName;
        this.precedence = props.precedence;
        this.roleArn = props.roleArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            description: this.description,
            groupName: this.groupName,
            precedence: this.precedence,
            roleArn: this.roleArn,
        };
    }
    renderProperties(props) {
        return cfnUserPoolGroupPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolGroup = CfnUserPoolGroup;
_f = JSII_RTTI_SYMBOL_1;
CfnUserPoolGroup[_f] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolGroup", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolGroup.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolGroup";
/**
 * Determine whether the given properties match those of a `CfnUserPoolIdentityProviderProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolIdentityProviderProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolIdentityProviderPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('attributeMapping', cdk.validateObject)(properties.attributeMapping));
    errors.collect(cdk.propertyValidator('idpIdentifiers', cdk.listValidator(cdk.validateString))(properties.idpIdentifiers));
    errors.collect(cdk.propertyValidator('providerDetails', cdk.validateObject)(properties.providerDetails));
    errors.collect(cdk.propertyValidator('providerName', cdk.requiredValidator)(properties.providerName));
    errors.collect(cdk.propertyValidator('providerName', cdk.validateString)(properties.providerName));
    errors.collect(cdk.propertyValidator('providerType', cdk.requiredValidator)(properties.providerType));
    errors.collect(cdk.propertyValidator('providerType', cdk.validateString)(properties.providerType));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolIdentityProviderProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolIdentityProvider` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolIdentityProviderProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolIdentityProvider` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolIdentityProviderPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolIdentityProviderPropsValidator(properties).assertSuccess();
    return {
        ProviderName: cdk.stringToCloudFormation(properties.providerName),
        ProviderType: cdk.stringToCloudFormation(properties.providerType),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AttributeMapping: cdk.objectToCloudFormation(properties.attributeMapping),
        IdpIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.idpIdentifiers),
        ProviderDetails: cdk.objectToCloudFormation(properties.providerDetails),
    };
}
// @ts-ignore TS6133
function CfnUserPoolIdentityProviderPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('providerName', 'ProviderName', cfn_parse.FromCloudFormation.getString(properties.ProviderName));
    ret.addPropertyResult('providerType', 'ProviderType', cfn_parse.FromCloudFormation.getString(properties.ProviderType));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('attributeMapping', 'AttributeMapping', properties.AttributeMapping != null ? cfn_parse.FromCloudFormation.getAny(properties.AttributeMapping) : undefined);
    ret.addPropertyResult('idpIdentifiers', 'IdpIdentifiers', properties.IdpIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.IdpIdentifiers) : undefined);
    ret.addPropertyResult('providerDetails', 'ProviderDetails', properties.ProviderDetails != null ? cfn_parse.FromCloudFormation.getAny(properties.ProviderDetails) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolIdentityProvider`
 *
 * The `AWS::Cognito::UserPoolIdentityProvider` resource creates an identity provider for a user pool.
 *
 * @cloudformationResource AWS::Cognito::UserPoolIdentityProvider
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolidentityprovider.html
 */
class CfnUserPoolIdentityProvider extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolIdentityProvider`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolIdentityProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'providerName', this);
        cdk.requireProperty(props, 'providerType', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.providerName = props.providerName;
        this.providerType = props.providerType;
        this.userPoolId = props.userPoolId;
        this.attributeMapping = props.attributeMapping;
        this.idpIdentifiers = props.idpIdentifiers;
        this.providerDetails = props.providerDetails;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolIdentityProviderPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolIdentityProvider(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            providerName: this.providerName,
            providerType: this.providerType,
            userPoolId: this.userPoolId,
            attributeMapping: this.attributeMapping,
            idpIdentifiers: this.idpIdentifiers,
            providerDetails: this.providerDetails,
        };
    }
    renderProperties(props) {
        return cfnUserPoolIdentityProviderPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolIdentityProvider = CfnUserPoolIdentityProvider;
_g = JSII_RTTI_SYMBOL_1;
CfnUserPoolIdentityProvider[_g] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolIdentityProvider", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolIdentityProvider.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolIdentityProvider";
/**
 * Determine whether the given properties match those of a `CfnUserPoolResourceServerProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolResourceServerProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolResourceServerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('identifier', cdk.requiredValidator)(properties.identifier));
    errors.collect(cdk.propertyValidator('identifier', cdk.validateString)(properties.identifier));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('scopes', cdk.listValidator(CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator))(properties.scopes));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolResourceServerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolResourceServerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolResourceServerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolResourceServerPropsValidator(properties).assertSuccess();
    return {
        Identifier: cdk.stringToCloudFormation(properties.identifier),
        Name: cdk.stringToCloudFormation(properties.name),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        Scopes: cdk.listMapper(cfnUserPoolResourceServerResourceServerScopeTypePropertyToCloudFormation)(properties.scopes),
    };
}
// @ts-ignore TS6133
function CfnUserPoolResourceServerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('identifier', 'Identifier', cfn_parse.FromCloudFormation.getString(properties.Identifier));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('scopes', 'Scopes', properties.Scopes != null ? cfn_parse.FromCloudFormation.getArray(CfnUserPoolResourceServerResourceServerScopeTypePropertyFromCloudFormation)(properties.Scopes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolResourceServer`
 *
 * The `AWS::Cognito::UserPoolResourceServer` resource creates a new OAuth2.0 resource server and defines custom scopes in it.
 *
 * > If you don't specify a value for a parameter, Amazon Cognito sets it to a default value.
 *
 * @cloudformationResource AWS::Cognito::UserPoolResourceServer
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolresourceserver.html
 */
class CfnUserPoolResourceServer extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolResourceServer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolResourceServerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'identifier', this);
        cdk.requireProperty(props, 'name', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.identifier = props.identifier;
        this.name = props.name;
        this.userPoolId = props.userPoolId;
        this.scopes = props.scopes;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolResourceServerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolResourceServer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            identifier: this.identifier,
            name: this.name,
            userPoolId: this.userPoolId,
            scopes: this.scopes,
        };
    }
    renderProperties(props) {
        return cfnUserPoolResourceServerPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolResourceServer = CfnUserPoolResourceServer;
_h = JSII_RTTI_SYMBOL_1;
CfnUserPoolResourceServer[_h] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolResourceServer", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolResourceServer.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolResourceServer";
/**
 * Determine whether the given properties match those of a `ResourceServerScopeTypeProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceServerScopeTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('scopeDescription', cdk.requiredValidator)(properties.scopeDescription));
    errors.collect(cdk.propertyValidator('scopeDescription', cdk.validateString)(properties.scopeDescription));
    errors.collect(cdk.propertyValidator('scopeName', cdk.requiredValidator)(properties.scopeName));
    errors.collect(cdk.propertyValidator('scopeName', cdk.validateString)(properties.scopeName));
    return errors.wrap('supplied properties not correct for "ResourceServerScopeTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType` resource
 *
 * @param properties - the TypeScript properties of a `ResourceServerScopeTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolResourceServer.ResourceServerScopeType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolResourceServerResourceServerScopeTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolResourceServer_ResourceServerScopeTypePropertyValidator(properties).assertSuccess();
    return {
        ScopeDescription: cdk.stringToCloudFormation(properties.scopeDescription),
        ScopeName: cdk.stringToCloudFormation(properties.scopeName),
    };
}
// @ts-ignore TS6133
function CfnUserPoolResourceServerResourceServerScopeTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('scopeDescription', 'ScopeDescription', cfn_parse.FromCloudFormation.getString(properties.ScopeDescription));
    ret.addPropertyResult('scopeName', 'ScopeName', cfn_parse.FromCloudFormation.getString(properties.ScopeName));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accountTakeoverRiskConfiguration', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator)(properties.accountTakeoverRiskConfiguration));
    errors.collect(cdk.propertyValidator('clientId', cdk.requiredValidator)(properties.clientId));
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('compromisedCredentialsRiskConfiguration', CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator)(properties.compromisedCredentialsRiskConfiguration));
    errors.collect(cdk.propertyValidator('riskExceptionConfiguration', CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator)(properties.riskExceptionConfiguration));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolRiskConfigurationAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolRiskConfigurationAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachmentPropsValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        AccountTakeoverRiskConfiguration: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyToCloudFormation(properties.accountTakeoverRiskConfiguration),
        CompromisedCredentialsRiskConfiguration: cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyToCloudFormation(properties.compromisedCredentialsRiskConfiguration),
        RiskExceptionConfiguration: cfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyToCloudFormation(properties.riskExceptionConfiguration),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientId', 'ClientId', cfn_parse.FromCloudFormation.getString(properties.ClientId));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('accountTakeoverRiskConfiguration', 'AccountTakeoverRiskConfiguration', properties.AccountTakeoverRiskConfiguration != null ? CfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyFromCloudFormation(properties.AccountTakeoverRiskConfiguration) : undefined);
    ret.addPropertyResult('compromisedCredentialsRiskConfiguration', 'CompromisedCredentialsRiskConfiguration', properties.CompromisedCredentialsRiskConfiguration != null ? CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyFromCloudFormation(properties.CompromisedCredentialsRiskConfiguration) : undefined);
    ret.addPropertyResult('riskExceptionConfiguration', 'RiskExceptionConfiguration', properties.RiskExceptionConfiguration != null ? CfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyFromCloudFormation(properties.RiskExceptionConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolRiskConfigurationAttachment`
 *
 * The `AWS::Cognito::UserPoolRiskConfigurationAttachment` resource sets the risk configuration that is used for Amazon Cognito advanced security features.
 *
 * You can specify risk configuration for a single client (with a specific `clientId` ) or for all clients (by setting the `clientId` to `ALL` ). If you specify `ALL` , the default configuration is used for every client that has had no risk configuration set previously. If you specify risk configuration for a particular client, it no longer falls back to the `ALL` configuration.
 *
 * @cloudformationResource AWS::Cognito::UserPoolRiskConfigurationAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolriskconfigurationattachment.html
 */
class CfnUserPoolRiskConfigurationAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolRiskConfigurationAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolRiskConfigurationAttachmentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'clientId', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.clientId = props.clientId;
        this.userPoolId = props.userPoolId;
        this.accountTakeoverRiskConfiguration = props.accountTakeoverRiskConfiguration;
        this.compromisedCredentialsRiskConfiguration = props.compromisedCredentialsRiskConfiguration;
        this.riskExceptionConfiguration = props.riskExceptionConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolRiskConfigurationAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolRiskConfigurationAttachment(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            clientId: this.clientId,
            userPoolId: this.userPoolId,
            accountTakeoverRiskConfiguration: this.accountTakeoverRiskConfiguration,
            compromisedCredentialsRiskConfiguration: this.compromisedCredentialsRiskConfiguration,
            riskExceptionConfiguration: this.riskExceptionConfiguration,
        };
    }
    renderProperties(props) {
        return cfnUserPoolRiskConfigurationAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolRiskConfigurationAttachment = CfnUserPoolRiskConfigurationAttachment;
_j = JSII_RTTI_SYMBOL_1;
CfnUserPoolRiskConfigurationAttachment[_j] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolRiskConfigurationAttachment", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolRiskConfigurationAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolRiskConfigurationAttachment";
/**
 * Determine whether the given properties match those of a `AccountTakeoverActionTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('eventAction', cdk.requiredValidator)(properties.eventAction));
    errors.collect(cdk.propertyValidator('eventAction', cdk.validateString)(properties.eventAction));
    errors.collect(cdk.propertyValidator('notify', cdk.requiredValidator)(properties.notify));
    errors.collect(cdk.propertyValidator('notify', cdk.validateBoolean)(properties.notify));
    return errors.wrap('supplied properties not correct for "AccountTakeoverActionTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator(properties).assertSuccess();
    return {
        EventAction: cdk.stringToCloudFormation(properties.eventAction),
        Notify: cdk.booleanToCloudFormation(properties.notify),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('eventAction', 'EventAction', cfn_parse.FromCloudFormation.getString(properties.EventAction));
    ret.addPropertyResult('notify', 'Notify', cfn_parse.FromCloudFormation.getBoolean(properties.Notify));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AccountTakeoverActionsTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionsTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('highAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.highAction));
    errors.collect(cdk.propertyValidator('lowAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.lowAction));
    errors.collect(cdk.propertyValidator('mediumAction', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionTypePropertyValidator)(properties.mediumAction));
    return errors.wrap('supplied properties not correct for "AccountTakeoverActionsTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverActionsTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverActionsType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator(properties).assertSuccess();
    return {
        HighAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.highAction),
        LowAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.lowAction),
        MediumAction: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyToCloudFormation(properties.mediumAction),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('highAction', 'HighAction', properties.HighAction != null ? CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.HighAction) : undefined);
    ret.addPropertyResult('lowAction', 'LowAction', properties.LowAction != null ? CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.LowAction) : undefined);
    ret.addPropertyResult('mediumAction', 'MediumAction', properties.MediumAction != null ? CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionTypePropertyFromCloudFormation(properties.MediumAction) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.requiredValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('actions', CfnUserPoolRiskConfigurationAttachment_AccountTakeoverActionsTypePropertyValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('notifyConfiguration', CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator)(properties.notifyConfiguration));
    return errors.wrap('supplied properties not correct for "AccountTakeoverRiskConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `AccountTakeoverRiskConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.AccountTakeoverRiskConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_AccountTakeoverRiskConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Actions: cfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyToCloudFormation(properties.actions),
        NotifyConfiguration: cfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyToCloudFormation(properties.notifyConfiguration),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentAccountTakeoverRiskConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', CfnUserPoolRiskConfigurationAttachmentAccountTakeoverActionsTypePropertyFromCloudFormation(properties.Actions));
    ret.addPropertyResult('notifyConfiguration', 'NotifyConfiguration', properties.NotifyConfiguration != null ? CfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyFromCloudFormation(properties.NotifyConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('eventAction', cdk.requiredValidator)(properties.eventAction));
    errors.collect(cdk.propertyValidator('eventAction', cdk.validateString)(properties.eventAction));
    return errors.wrap('supplied properties not correct for "CompromisedCredentialsActionsTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType` resource
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsActionsTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsActionsType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator(properties).assertSuccess();
    return {
        EventAction: cdk.stringToCloudFormation(properties.eventAction),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('eventAction', 'EventAction', cfn_parse.FromCloudFormation.getString(properties.EventAction));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('actions', cdk.requiredValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('actions', CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsActionsTypePropertyValidator)(properties.actions));
    errors.collect(cdk.propertyValidator('eventFilter', cdk.listValidator(cdk.validateString))(properties.eventFilter));
    return errors.wrap('supplied properties not correct for "CompromisedCredentialsRiskConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `CompromisedCredentialsRiskConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.CompromisedCredentialsRiskConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_CompromisedCredentialsRiskConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        Actions: cfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyToCloudFormation(properties.actions),
        EventFilter: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventFilter),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsRiskConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('actions', 'Actions', CfnUserPoolRiskConfigurationAttachmentCompromisedCredentialsActionsTypePropertyFromCloudFormation(properties.Actions));
    ret.addPropertyResult('eventFilter', 'EventFilter', properties.EventFilter != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventFilter) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotifyConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `NotifyConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('blockEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.blockEmail));
    errors.collect(cdk.propertyValidator('from', cdk.validateString)(properties.from));
    errors.collect(cdk.propertyValidator('mfaEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.mfaEmail));
    errors.collect(cdk.propertyValidator('noActionEmail', CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator)(properties.noActionEmail));
    errors.collect(cdk.propertyValidator('replyTo', cdk.validateString)(properties.replyTo));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.requiredValidator)(properties.sourceArn));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.validateString)(properties.sourceArn));
    return errors.wrap('supplied properties not correct for "NotifyConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `NotifyConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_NotifyConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        BlockEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.blockEmail),
        From: cdk.stringToCloudFormation(properties.from),
        MfaEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.mfaEmail),
        NoActionEmail: cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties.noActionEmail),
        ReplyTo: cdk.stringToCloudFormation(properties.replyTo),
        SourceArn: cdk.stringToCloudFormation(properties.sourceArn),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentNotifyConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('blockEmail', 'BlockEmail', properties.BlockEmail != null ? CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.BlockEmail) : undefined);
    ret.addPropertyResult('from', 'From', properties.From != null ? cfn_parse.FromCloudFormation.getString(properties.From) : undefined);
    ret.addPropertyResult('mfaEmail', 'MfaEmail', properties.MfaEmail != null ? CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.MfaEmail) : undefined);
    ret.addPropertyResult('noActionEmail', 'NoActionEmail', properties.NoActionEmail != null ? CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties.NoActionEmail) : undefined);
    ret.addPropertyResult('replyTo', 'ReplyTo', properties.ReplyTo != null ? cfn_parse.FromCloudFormation.getString(properties.ReplyTo) : undefined);
    ret.addPropertyResult('sourceArn', 'SourceArn', cfn_parse.FromCloudFormation.getString(properties.SourceArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NotifyEmailTypeProperty`
 *
 * @param properties - the TypeScript properties of a `NotifyEmailTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('htmlBody', cdk.validateString)(properties.htmlBody));
    errors.collect(cdk.propertyValidator('subject', cdk.requiredValidator)(properties.subject));
    errors.collect(cdk.propertyValidator('subject', cdk.validateString)(properties.subject));
    errors.collect(cdk.propertyValidator('textBody', cdk.validateString)(properties.textBody));
    return errors.wrap('supplied properties not correct for "NotifyEmailTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType` resource
 *
 * @param properties - the TypeScript properties of a `NotifyEmailTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.NotifyEmailType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_NotifyEmailTypePropertyValidator(properties).assertSuccess();
    return {
        HtmlBody: cdk.stringToCloudFormation(properties.htmlBody),
        Subject: cdk.stringToCloudFormation(properties.subject),
        TextBody: cdk.stringToCloudFormation(properties.textBody),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentNotifyEmailTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('htmlBody', 'HtmlBody', properties.HtmlBody != null ? cfn_parse.FromCloudFormation.getString(properties.HtmlBody) : undefined);
    ret.addPropertyResult('subject', 'Subject', cfn_parse.FromCloudFormation.getString(properties.Subject));
    ret.addPropertyResult('textBody', 'TextBody', properties.TextBody != null ? cfn_parse.FromCloudFormation.getString(properties.TextBody) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RiskExceptionConfigurationTypeProperty`
 *
 * @param properties - the TypeScript properties of a `RiskExceptionConfigurationTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('blockedIpRangeList', cdk.listValidator(cdk.validateString))(properties.blockedIpRangeList));
    errors.collect(cdk.propertyValidator('skippedIpRangeList', cdk.listValidator(cdk.validateString))(properties.skippedIpRangeList));
    return errors.wrap('supplied properties not correct for "RiskExceptionConfigurationTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType` resource
 *
 * @param properties - the TypeScript properties of a `RiskExceptionConfigurationTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolRiskConfigurationAttachment.RiskExceptionConfigurationType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolRiskConfigurationAttachment_RiskExceptionConfigurationTypePropertyValidator(properties).assertSuccess();
    return {
        BlockedIPRangeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.blockedIpRangeList),
        SkippedIPRangeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.skippedIpRangeList),
    };
}
// @ts-ignore TS6133
function CfnUserPoolRiskConfigurationAttachmentRiskExceptionConfigurationTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('blockedIpRangeList', 'BlockedIPRangeList', properties.BlockedIPRangeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.BlockedIPRangeList) : undefined);
    ret.addPropertyResult('skippedIpRangeList', 'SkippedIPRangeList', properties.SkippedIPRangeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SkippedIPRangeList) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUICustomizationAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('css', cdk.validateString)(properties.css));
    errors.collect(cdk.propertyValidator('clientId', cdk.requiredValidator)(properties.clientId));
    errors.collect(cdk.propertyValidator('clientId', cdk.validateString)(properties.clientId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUICustomizationAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUICustomizationAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUICustomizationAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUICustomizationAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUICustomizationAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUICustomizationAttachmentPropsValidator(properties).assertSuccess();
    return {
        ClientId: cdk.stringToCloudFormation(properties.clientId),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        CSS: cdk.stringToCloudFormation(properties.css),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUICustomizationAttachmentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('clientId', 'ClientId', cfn_parse.FromCloudFormation.getString(properties.ClientId));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('css', 'CSS', properties.CSS != null ? cfn_parse.FromCloudFormation.getString(properties.CSS) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUICustomizationAttachment`
 *
 * The `AWS::Cognito::UserPoolUICustomizationAttachment` resource sets the UI customization information for a user pool's built-in app UI.
 *
 * You can specify app UI customization settings for a single client (with a specific `clientId` ) or for all clients (by setting the `clientId` to `ALL` ). If you specify `ALL` , the default configuration is used for every client that has had no UI customization set previously. If you specify UI customization settings for a particular client, it no longer falls back to the `ALL` configuration.
 *
 * > Before you create this resource, your user pool must have a domain associated with it. You can create an `AWS::Cognito::UserPoolDomain` resource first in this user pool.
 *
 * Setting a logo image isn't supported from AWS CloudFormation . Use the Amazon Cognito [SetUICustomization](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUICustomization.html#API_SetUICustomization_RequestSyntax) API operation to set the image.
 *
 * @cloudformationResource AWS::Cognito::UserPoolUICustomizationAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluicustomizationattachment.html
 */
class CfnUserPoolUICustomizationAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUICustomizationAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolUICustomizationAttachmentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'clientId', this);
        cdk.requireProperty(props, 'userPoolId', this);
        this.clientId = props.clientId;
        this.userPoolId = props.userPoolId;
        this.css = props.css;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolUICustomizationAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUICustomizationAttachment(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            clientId: this.clientId,
            userPoolId: this.userPoolId,
            css: this.css,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUICustomizationAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUICustomizationAttachment = CfnUserPoolUICustomizationAttachment;
_k = JSII_RTTI_SYMBOL_1;
CfnUserPoolUICustomizationAttachment[_k] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolUICustomizationAttachment", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUICustomizationAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUICustomizationAttachment";
/**
 * Determine whether the given properties match those of a `CfnUserPoolUserProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUserPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('clientMetadata', cdk.validateObject)(properties.clientMetadata));
    errors.collect(cdk.propertyValidator('desiredDeliveryMediums', cdk.listValidator(cdk.validateString))(properties.desiredDeliveryMediums));
    errors.collect(cdk.propertyValidator('forceAliasCreation', cdk.validateBoolean)(properties.forceAliasCreation));
    errors.collect(cdk.propertyValidator('messageAction', cdk.validateString)(properties.messageAction));
    errors.collect(cdk.propertyValidator('userAttributes', cdk.listValidator(CfnUserPoolUser_AttributeTypePropertyValidator))(properties.userAttributes));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    errors.collect(cdk.propertyValidator('validationData', cdk.listValidator(CfnUserPoolUser_AttributeTypePropertyValidator))(properties.validationData));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUserProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUserPropsValidator(properties).assertSuccess();
    return {
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
        ClientMetadata: cdk.objectToCloudFormation(properties.clientMetadata),
        DesiredDeliveryMediums: cdk.listMapper(cdk.stringToCloudFormation)(properties.desiredDeliveryMediums),
        ForceAliasCreation: cdk.booleanToCloudFormation(properties.forceAliasCreation),
        MessageAction: cdk.stringToCloudFormation(properties.messageAction),
        UserAttributes: cdk.listMapper(cfnUserPoolUserAttributeTypePropertyToCloudFormation)(properties.userAttributes),
        Username: cdk.stringToCloudFormation(properties.username),
        ValidationData: cdk.listMapper(cfnUserPoolUserAttributeTypePropertyToCloudFormation)(properties.validationData),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addPropertyResult('clientMetadata', 'ClientMetadata', properties.ClientMetadata != null ? cfn_parse.FromCloudFormation.getAny(properties.ClientMetadata) : undefined);
    ret.addPropertyResult('desiredDeliveryMediums', 'DesiredDeliveryMediums', properties.DesiredDeliveryMediums != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DesiredDeliveryMediums) : undefined);
    ret.addPropertyResult('forceAliasCreation', 'ForceAliasCreation', properties.ForceAliasCreation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ForceAliasCreation) : undefined);
    ret.addPropertyResult('messageAction', 'MessageAction', properties.MessageAction != null ? cfn_parse.FromCloudFormation.getString(properties.MessageAction) : undefined);
    ret.addPropertyResult('userAttributes', 'UserAttributes', properties.UserAttributes != null ? cfn_parse.FromCloudFormation.getArray(CfnUserPoolUserAttributeTypePropertyFromCloudFormation)(properties.UserAttributes) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addPropertyResult('validationData', 'ValidationData', properties.ValidationData != null ? cfn_parse.FromCloudFormation.getArray(CfnUserPoolUserAttributeTypePropertyFromCloudFormation)(properties.ValidationData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUser`
 *
 * The `AWS::Cognito::UserPoolUser` resource creates an Amazon Cognito user pool user.
 *
 * @cloudformationResource AWS::Cognito::UserPoolUser
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpooluser.html
 */
class CfnUserPoolUser extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUser`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolUserProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'userPoolId', this);
        this.userPoolId = props.userPoolId;
        this.clientMetadata = props.clientMetadata;
        this.desiredDeliveryMediums = props.desiredDeliveryMediums;
        this.forceAliasCreation = props.forceAliasCreation;
        this.messageAction = props.messageAction;
        this.userAttributes = props.userAttributes;
        this.username = props.username;
        this.validationData = props.validationData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolUserPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUser(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            userPoolId: this.userPoolId,
            clientMetadata: this.clientMetadata,
            desiredDeliveryMediums: this.desiredDeliveryMediums,
            forceAliasCreation: this.forceAliasCreation,
            messageAction: this.messageAction,
            userAttributes: this.userAttributes,
            username: this.username,
            validationData: this.validationData,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUserPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUser = CfnUserPoolUser;
_l = JSII_RTTI_SYMBOL_1;
CfnUserPoolUser[_l] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolUser", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUser.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUser";
/**
 * Determine whether the given properties match those of a `AttributeTypeProperty`
 *
 * @param properties - the TypeScript properties of a `AttributeTypeProperty`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUser_AttributeTypePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "AttributeTypeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser.AttributeType` resource
 *
 * @param properties - the TypeScript properties of a `AttributeTypeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUser.AttributeType` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserAttributeTypePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUser_AttributeTypePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserAttributeTypePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @returns the result of the validation.
 */
function CfnUserPoolUserToGroupAttachmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('groupName', cdk.requiredValidator)(properties.groupName));
    errors.collect(cdk.propertyValidator('groupName', cdk.validateString)(properties.groupName));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.requiredValidator)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('userPoolId', cdk.validateString)(properties.userPoolId));
    errors.collect(cdk.propertyValidator('username', cdk.requiredValidator)(properties.username));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "CfnUserPoolUserToGroupAttachmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUserToGroupAttachment` resource
 *
 * @param properties - the TypeScript properties of a `CfnUserPoolUserToGroupAttachmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::Cognito::UserPoolUserToGroupAttachment` resource.
 */
// @ts-ignore TS6133
function cfnUserPoolUserToGroupAttachmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnUserPoolUserToGroupAttachmentPropsValidator(properties).assertSuccess();
    return {
        GroupName: cdk.stringToCloudFormation(properties.groupName),
        Username: cdk.stringToCloudFormation(properties.username),
        UserPoolId: cdk.stringToCloudFormation(properties.userPoolId),
    };
}
// @ts-ignore TS6133
function CfnUserPoolUserToGroupAttachmentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('groupName', 'GroupName', cfn_parse.FromCloudFormation.getString(properties.GroupName));
    ret.addPropertyResult('username', 'Username', cfn_parse.FromCloudFormation.getString(properties.Username));
    ret.addPropertyResult('userPoolId', 'UserPoolId', cfn_parse.FromCloudFormation.getString(properties.UserPoolId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::Cognito::UserPoolUserToGroupAttachment`
 *
 * Adds the specified user to the specified group.
 *
 * Calling this action requires developer credentials.
 *
 * @cloudformationResource AWS::Cognito::UserPoolUserToGroupAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolusertogroupattachment.html
 */
class CfnUserPoolUserToGroupAttachment extends cdk.CfnResource {
    /**
     * Create a new `AWS::Cognito::UserPoolUserToGroupAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cognito_CfnUserPoolUserToGroupAttachmentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        cdk.requireProperty(props, 'groupName', this);
        cdk.requireProperty(props, 'userPoolId', this);
        cdk.requireProperty(props, 'username', this);
        this.groupName = props.groupName;
        this.username = props.username;
        this.userPoolId = props.userPoolId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnUserPoolUserToGroupAttachmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnUserPoolUserToGroupAttachment(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            groupName: this.groupName,
            username: this.username,
            userPoolId: this.userPoolId,
        };
    }
    renderProperties(props) {
        return cfnUserPoolUserToGroupAttachmentPropsToCloudFormation(props);
    }
}
exports.CfnUserPoolUserToGroupAttachment = CfnUserPoolUserToGroupAttachment;
_m = JSII_RTTI_SYMBOL_1;
CfnUserPoolUserToGroupAttachment[_m] = { fqn: "@aws-cdk/aws-cognito.CfnUserPoolUserToGroupAttachment", version: "1.153.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnUserPoolUserToGroupAttachment.CFN_RESOURCE_TYPE_NAME = "AWS::Cognito::UserPoolUserToGroupAttachment";
//# sourceMappingURL=data:application/json;base64,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