"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = void 0;
/**
 * (experimental) Provides the Service Discovery method a VirtualNode uses.
 *
 * @experimental
 */
class ServiceDiscovery {
    /**
     * (experimental) Returns DNS based service discovery.
     *
     * @experimental
     */
    static dns(hostname) {
        return new DnsServiceDiscovery(hostname);
    }
    /**
     * (experimental) Returns Cloud Map based service discovery.
     *
     * @experimental
     */
    static cloudMap(options) {
        return new CloudMapServiceDiscovery(options);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname) {
        super();
        this.hostname = hostname;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(options) {
        super();
        this.service = options.service;
        this.instanceAttributes = options.instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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