"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientPolicy = void 0;
var CertificateType;
(function (CertificateType) {
    CertificateType["ACMPCA"] = "acm";
    CertificateType["FILE"] = "file";
})(CertificateType || (CertificateType = {}));
/**
 * (experimental) Defines the TLS validation context trust.
 *
 * @experimental
 */
class ClientPolicy {
    /**
     * (experimental) Tells envoy where to fetch the validation context from.
     *
     * @experimental
     */
    static fileTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.FILE, props.certificateChain, undefined);
    }
    /**
     * (experimental) TLS validation context trust for ACM Private Certificate Authority (CA).
     *
     * @experimental
     */
    static acmTrust(props) {
        return new ClientPolicyImpl(props.ports, CertificateType.ACMPCA, undefined, props.certificateAuthorities);
    }
}
exports.ClientPolicy = ClientPolicy;
class ClientPolicyImpl extends ClientPolicy {
    constructor(ports, certificateType, certificateChain, certificateAuthorityArns) {
        super();
        this.ports = ports;
        this.certificateType = certificateType;
        this.certificateChain = certificateChain;
        this.certificateAuthorityArns = certificateAuthorityArns;
    }
    bind(_scope) {
        var _a, _b;
        if (this.certificateType === CertificateType.ACMPCA && ((_a = this.certificateAuthorityArns) === null || _a === void 0 ? void 0 : _a.map(certificateArn => certificateArn.certificateAuthorityArn).length) === 0) {
            throw new Error('You must provide at least one Certificate Authority when creating an ACM Trust ClientPolicy');
        }
        else {
            return {
                clientPolicy: {
                    tls: {
                        ports: this.ports,
                        validation: {
                            trust: {
                                [this.certificateType]: this.certificateType === CertificateType.FILE
                                    ? {
                                        certificateChain: this.certificateChain,
                                    }
                                    : {
                                        certificateAuthorityArns: (_b = this.certificateAuthorityArns) === null || _b === void 0 ? void 0 : _b.map(certificateArn => certificateArn.certificateAuthorityArn),
                                    },
                            },
                        },
                    },
                },
            };
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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